/*
 * Decompiled with CFR 0.152.
 */
class PipeOut
extends GimmickObject {
    public int direction;
    public AnimationDrawer drawer;
    public static final int[] TRANS = new int[]{0, 3, 6, 5};
    public boolean touching;

    protected PipeOut(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (PipeIn.pipeAnimation == null) {
            PipeIn.pipeAnimation = new Animation("/animation/pipe_in");
        }
        this.direction = this.iLeft > 0 ? 2 : 3;
        this.posY -= 256;
        this.drawer = PipeIn.pipeAnimation.getDrawer(1, true, TRANS[this.direction]);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        switch (this.direction) {
            case 0: {
                this.collisionRect.setRect(n - 1152, n2, 2304, 2560);
                break;
            }
            case 1: {
                this.collisionRect.setRect(n - 1152, n2 - 2560, 2304, 2560);
                break;
            }
            case 2: {
                this.collisionRect.setRect(n, n2 - 1152, 2560, 2304);
                break;
            }
            case 3: {
                this.collisionRect.setRect(n - 2560, n2 - 1152, 2560, 2304);
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.firstTouch && GameObject.player.piping) {
            this.touching = true;
            if (GameObject.player.velY != 0) {
                GameObject.player.pipeSet(this.posX, this.posY, this.iLeft, 0);
            } else {
                GameObject.player.velX = this.iLeft << 6;
                GameObject.player.velY = 0;
            }
            if (this.iLeft > 0) {
                GameObject.player.faceDirection = true;
            }
            if (this.iLeft < 0) {
                GameObject.player.faceDirection = false;
            }
        }
        if (!GameObject.player.piping) {
            playerObject.beStop(0, this.direction, this);
        }
    }

    public void doWhileNoCollision() {
        if (this.touching && GameObject.player.piping) {
            GameObject.player.pipeOut();
            GameObject.player.changeVisible(true);
            this.touching = false;
            GameObject.player.setVelY(640);
        }
    }

    public void close() {
        this.drawer = null;
    }

    public int getPaintLayer() {
        return 2;
    }
}

