/*
 * Decompiled with CFR 0.152.
 */
class RollPlatform
extends GimmickObject {
    public static int degree;
    public int radius;
    public int centerX;
    public int centerY;
    public boolean direction;

    protected RollPlatform(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (this.mWidth > this.mHeight) {
            this.radius = this.mWidth;
            this.direction = false;
        } else {
            this.radius = this.mHeight;
            this.direction = true;
        }
        this.centerX = this.posX;
        this.centerY = this.posY;
        if (GimmickObject.platformImage == null) {
            try {
                GimmickObject.platformImage = MFImage.createImage("/gimmick/platform" + StageManager.getCurrentZoneId() + ".png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    GimmickObject.platformImage = MFImage.createImage("/gimmick/platform0.png");
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
    }

    public static void staticLogic() {
        degree += 320;
        degree %= 23040;
    }

    public void logic() {
        int n = degree + this.iLeft * 23040 / 16;
        int n2 = this.posX;
        int n3 = this.posY;
        n += 23040;
        n %= 23040;
        if (!this.direction) {
            n = -n;
            n += 23040;
            n %= 23040;
        }
        this.posX = (this.centerX * 100 + this.radius * MyAPI.dCos(n >> 6)) / 100;
        this.posY = (this.centerY * 100 + this.radius * MyAPI.dSin(n >> 6)) / 100;
        this.checkWithPlayer(n2, n3, this.posX, this.posY);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (GameObject.player.isFootOnObject(this)) {
            return;
        }
        switch (n) {
            case 1: {
                playerObject.beStop(this.collisionRect.y0, 1, this);
                this.used = true;
                break;
            }
            case 4: {
                if (playerObject.getMoveDistance().y <= 0 || playerObject.getCollisionRect().y1 >= this.collisionRect.y1) break;
                playerObject.beStop(this.collisionRect.y0, 1, this);
                this.used = true;
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, GimmickObject.platformImage, this.posX, this.posY, 3);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 1536, n2 + 256 - 768, 3072, 960);
    }

    public int getPaintLayer() {
        return 0;
    }
}

