/*
 * Decompiled with CFR 0.152.
 */
class SteamPlatform
extends GimmickObject {
    public static int velocity;
    public static int sPosY;
    public static boolean moving;
    public int originalPosY;
    public static int endCount;
    public static MFImage image;
    public SteamBase sb;

    protected SteamPlatform(int n, int n2, SteamBase steamBase) {
        super(0, n, n2, 0, 0, 0, 0);
        this.originalPosY = this.posY;
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/steam_platform.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.sb = steamBase;
    }

    public static void staticLogic() {
        if (moving && (sPosY += (velocity += GameObject.GRAVITY)) >= 0) {
            sPosY = 0;
            if (--endCount <= 0) {
                moving = false;
            } else {
                velocity = -velocity / 3;
            }
        }
    }

    public static void shot() {
        moving = true;
        velocity = -1400;
        endCount = 3;
    }

    public static boolean isShotting() {
        return moving && endCount == 3;
    }

    public void logic() {
        int n = this.posY;
        this.posY = this.originalPosY + sPosY;
        this.checkWithPlayer(this.posX, n, this.posX, this.posY);
        this.sb.sh.refreshCollisionRect(this.posX, this.posY);
    }

    public void drawPlatform(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, image, 33);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 640, n2 - 448, 1280, 448);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (n == 1 || n == 4 && playerObject.getVelY() > 0) {
            playerObject.beStop(0, 1, this);
        }
    }

    public void close() {
        this.sb = null;
    }

    public static void releaseAllResource() {
        image = null;
    }

    public boolean collisionChkWithObject(PlayerObject playerObject) {
        CollisionRect collisionRect = playerObject.getCollisionRect();
        CollisionRect collisionRect2 = this.getCollisionRect();
        GameObject.rectV.setRect(collisionRect.x0 + 192, collisionRect.y0, collisionRect.getWidth() - 384, collisionRect.getHeight());
        return collisionRect2.collisionChk(GameObject.rectV);
    }
}

