/*
 * Decompiled with CFR 0.152.
 */
class TeaCup
extends GimmickObject {
    public byte state;
    public static MFImage teacupImage;
    public byte drawCount;
    public int changeTime;
    public int changeTimeCount;
    public int playerX;
    public int playerDegree;
    public int degreeSpeed;
    public int prePosY;
    public int count;

    protected TeaCup(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (teacupImage == null) {
            try {
                teacupImage = MFImage.createImage("/gimmick/teacup_" + StageManager.getCurrentZoneId() + ".png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.changeTime = 0;
        this.state = 0;
        this.degreeSpeed = 30;
    }

    public void logic() {
        if (this.changeTime > 0) {
            ++this.changeTimeCount;
            if (this.changeTimeCount >= this.changeTime) {
                this.drawCount = (byte)((this.drawCount + 1) % 2);
                this.changeTimeCount = 0;
            }
        }
        if (this.count > 0) {
            --this.count;
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                GameObject.player.setNoKey();
                GameObject.player.setAnimationId(4);
                this.playerDegree += this.degreeSpeed;
                this.playerDegree %= 360;
                GameObject.player.setFootPositionX(this.posX + (2240 - 1920 * (this.posY - this.prePosY) / 7168) * MyAPI.dSin(this.playerDegree) / 100);
                this.checkWithPlayer(this.posX, this.posY, this.posX, this.posY + 192);
                this.posY += 192;
                if (this.posY < this.prePosY + 7168) break;
                this.posY = this.prePosY + 7168;
                GameObject.player.setFootPositionX(this.posX);
                this.state = (byte)2;
                this.count = 16;
                this.changeTime = 1;
                break;
            }
            case 2: {
                GameObject.player.setNoKey();
                GameObject.player.setAnimationId(4);
                this.playerDegree += this.degreeSpeed * 2;
                this.playerDegree %= 360;
                GameObject.player.setFootPositionX(this.posX + 320 * MyAPI.dSin(this.playerDegree) / 100);
                this.checkWithPlayer(this.posX, this.posY, this.posX, this.posY);
                if (this.count != 0) break;
                GameObject.player.setFootPositionX(this.posX);
                this.state = (byte)3;
                this.changeTime = 2;
                GameObject.player.beSpring(600, 0);
                GameObject.player.collisionState = 1;
                GameObject.player.setAnimationId(4);
                break;
            }
            case 3: {
                if (this.changeTime <= 0 || this.changeTimeCount != 0) break;
                ++this.changeTime;
                if (this.changeTime <= 6) break;
                this.changeTime = 0;
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject == GameObject.player) {
            switch (this.state) {
                case 0: {
                    this.playerX = GameObject.player.getFootPositionX() - this.posX;
                    if (this.playerX > 2240) {
                        this.playerX = 2240;
                    } else if (this.playerX < -2240) {
                        this.playerX = -2240;
                    }
                    int n2 = crlFP32.sqrt(5017600 - this.playerX * this.playerX) >> 3;
                    this.playerDegree = crlFP32.actTanDegree(this.playerX, n2);
                    playerObject.beStop(this.collisionRect.y0, 1, this);
                    playerObject.setNoKey();
                    this.prePosY = this.posY;
                    this.state = 1;
                    this.changeTime = 2;
                }
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, teacupImage, 0, this.drawCount * 40, 96, 40, 0, this.posX, this.posY + -1536, 17);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 3072, n2 - 768, 6144, 1024);
    }

    public void close() {
    }

    public static void releaseAllResource() {
        teacupImage = null;
    }
}

