/*
 * Decompiled with CFR 0.152.
 */
class WaterFall
extends GimmickObject {
    public static AnimationDrawer waterFallDrawer1;
    public static AnimationDrawer waterFallDrawer2;
    public static AnimationDrawer waterFallDrawer3;
    public static AnimationDrawer waterFallDrawer4;
    public AnimationDrawer drawer;
    public int drawSpace;

    protected WaterFall(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        GameObject.player.initWaterFall();
        if (StageManager.getCurrentZoneId() == 1) {
            if (n6 == 4) {
                if (waterFallDrawer1 == null) {
                    waterFallDrawer1 = new Animation("/animation/water_fall_01").getDrawer(0, true, 0);
                    waterFallDrawer1.setPause(true);
                }
                this.drawer = waterFallDrawer1;
                this.drawSpace = 1024;
            } else {
                if (waterFallDrawer2 == null) {
                    waterFallDrawer2 = new Animation("/animation/water_fall_03").getDrawer(0, true, 0);
                    waterFallDrawer2.setPause(true);
                }
                this.drawer = waterFallDrawer2;
                this.drawSpace = 2048;
            }
        } else if (StageManager.getCurrentZoneId() == 5) {
            if (n6 == 12) {
                if (waterFallDrawer4 == null) {
                    waterFallDrawer4 = new Animation("/animation/sand_01").getDrawer(0, true, 0);
                    waterFallDrawer4.setPause(true);
                }
                this.drawer = waterFallDrawer4;
            } else {
                if (waterFallDrawer3 == null) {
                    waterFallDrawer3 = new Animation("/animation/sand_03").getDrawer(0, true, 0);
                    waterFallDrawer3.setPause(true);
                }
                this.drawer = waterFallDrawer3;
            }
            this.drawSpace = 6144;
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject == GameObject.player && this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) {
            if (StageManager.getCurrentZoneId() == 5 && GameObject.player.collisionState == 1) {
                GameObject.player.collisionState = (byte)3;
            }
            GameObject.player.beWaterFall();
        }
    }

    public void draw(MFGraphics mFGraphics) {
        MyAPI.setClip(mFGraphics, (this.collisionRect.x0 >> 6) - GameObject.camera.x, (this.collisionRect.y0 >> 6) - GameObject.camera.y, this.collisionRect.getWidth() >> 6, this.collisionRect.getHeight() >> 6);
        for (int i = this.collisionRect.y0; i < this.collisionRect.y1; i += this.drawSpace) {
            this.drawInMap(mFGraphics, this.drawer, this.posX, i);
        }
        MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
    }

    public static void releaseAllResource() {
        waterFallDrawer1 = null;
        waterFallDrawer2 = null;
        waterFallDrawer3 = null;
        waterFallDrawer4 = null;
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n, n2 + this.iTop * 512, this.mWidth, this.mHeight);
    }

    public static void staticLogic() {
        if (waterFallDrawer1 != null) {
            waterFallDrawer1.moveOn();
        }
        if (waterFallDrawer2 != null) {
            waterFallDrawer2.moveOn();
        }
        if (waterFallDrawer3 != null) {
            waterFallDrawer3.moveOn();
        }
        if (waterFallDrawer4 != null) {
            waterFallDrawer4.moveOn();
        }
    }

    public void close() {
        this.drawer = null;
    }

    public int getPaintLayer() {
        return 2;
    }
}

