/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

final class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    private int curFlags;
    ASprite sprite;
    int curAnim;
    int curFrame;
    private int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private static int k_animBaseFrameTime = 1000 / GLLibConfig.sprite_animFPS;
    private int palette;
    private static int k_AnimNone = -1;
    private static final int k_snd_nbChannel = GLLibConfig.sound_numberOfChannels;
    private static int s_snd_masterVolume;
    private static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    private static int[] s_snd_requestBuffer;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    private static int[] s_TilesetInfo;
    static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static ASprite[] s_TilesetSprite;

    GLLibPlayer() {
        this.Reset();
    }

    GLLibPlayer(ASprite aSprite, int n, int n2) {
        this.Reset();
        this.posX = n;
        this.posY = n2;
        this.SetSprite(aSprite);
    }

    private void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = k_AnimNone;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.palette = -1;
        this.animIsOver = true;
    }

    final void SetSprite(ASprite aSprite) {
        this.sprite = aSprite;
        this.SetAnim(k_AnimNone, -1);
    }

    final void SetAnim(int n, int n2) {
        if (this.animIsOver || n != this.curAnim) {
            int n3;
            this.curAnim = n;
            GLLibPlayer gLLibPlayer = this;
            if (gLLibPlayer.curAnim < 0) {
                n3 = -1;
            } else {
                int n4;
                int n5;
                GLLibPlayer gLLibPlayer2 = gLLibPlayer;
                int n6 = n5 = gLLibPlayer2.curAnim >= 0 ? gLLibPlayer2.sprite.GetAFrames(gLLibPlayer2.curAnim) : -1;
                for (n4 = 0; n4 > n5; n4 -= n5) {
                }
                gLLibPlayer.curFrame = n4;
                gLLibPlayer.curTime = 0;
                n3 = n4;
            }
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    final int GetAnimFrame() {
        if (this.sprite == null || this.curAnim == k_AnimNone) {
            return -1;
        }
        return this.sprite.GetAnimFrame(this.curAnim, this.curFrame);
    }

    final void SetTransform(int n) {
        switch (n) {
            case 0: {
                this.curFlags = 0;
                return;
            }
            case 2: {
                this.curFlags = 1;
                return;
            }
            case 1: {
                this.curFlags = 2;
                return;
            }
            case 3: {
                this.curFlags = 3;
                return;
            }
            case 5: {
                this.curFlags = 4;
                return;
            }
            case 6: {
                this.curFlags = 7;
                return;
            }
            case 7: {
                this.curFlags = 6;
                return;
            }
            case 4: {
                this.curFlags = 5;
            }
        }
    }

    private int GetDuration() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    final boolean IsAnimOver() {
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    final void Render() {
        if (this.curAnim < 0) {
            return;
        }
        if (this.animIsOver) {
            return;
        }
        if (this.palette != -1) {
            int n = this.sprite.GetCurrentPalette();
            this.sprite.SetCurrentPalette(this.palette);
            this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
            this.sprite.SetCurrentPalette(n);
            return;
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
    }

    final void Update(int n) {
        if (this.animIsOver || this.curAnim < 0) {
            return;
        }
        int n2 = this.GetDuration();
        if (GLLibConfig.sprite_animDurationZeroAsInfinite && n2 == 0) {
            return;
        }
        while (this.curTime >= n2) {
            this.curTime -= n2;
            if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                ++this.curFrame;
            } else {
                if (this.nbLoop == 0) {
                    this.animIsOver = true;
                    break;
                }
                if (this.nbLoop > 0) {
                    --this.nbLoop;
                }
                this.curFrame = 0;
            }
            n2 = this.GetDuration();
            if (!GLLibConfig.sprite_animDurationZeroAsInfinite || n2 != 0) continue;
        }
        this.curTime += n;
    }

    private static final int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static void SndQueue_Push_Normal(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        n8 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n8 - i - 1);
            if (s_snd_queue[n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n8);
        GLLibPlayer.s_snd_queue[n7] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n10 = n;
        s_snd_queue_size[n10] = s_snd_queue_size[n10] + 1;
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        GLLibPlayer.SndQueue_Push_Normal(n, n2, n3, n4, n5, n6);
    }

    private static void SndQueue_Pop_Normal(int n, int[] nArray) {
        nArray[5] = s_snd_queue_size[n];
        if (s_snd_queue_size[n] > 0) {
            int n2 = GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]);
            System.arraycopy(s_snd_queue, n2, nArray, 0, 5);
            GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
            int n3 = n;
            s_snd_queue_size[n3] = s_snd_queue_size[n3] - 1;
        }
    }

    static void Snd_Init(int n) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        s_snd_Player = new Player[k_snd_nbChannel];
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        s_snd_requestBuffer = new int[6];
        for (n = 0; n < k_snd_nbChannel; ++n) {
            GLLibPlayer.s_snd_index[n] = -1;
            GLLibPlayer.s_snd_queue_pointer[n] = 0;
            GLLibPlayer.s_snd_queue_size[n] = 0;
        }
        s_snd_maxNbSoundSlot = 11;
        s_snd_sndSlot = new byte[11][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
    }

    static void Snd_Quit() throws Exception {
        int n;
        if (!GLLibConfig.sound_enable) {
            return;
        }
        GLLibPlayer.Snd_StopAllSounds();
        for (n = 0; n < k_snd_nbChannel; ++n) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        s_snd_Player = null;
        s_snd_isSoundEngineInitialized = false;
        for (n = 0; n < s_snd_maxNbSoundSlot; ++n) {
            GLLibPlayer.s_snd_sndSlot[n] = null;
        }
        s_snd_sndSlot = null;
        s_snd_sndType = null;
        s_snd_index = null;
        s_snd_priority = null;
        s_snd_state = null;
        s_snd_volume = null;
        s_snd_loop = null;
        s_pThread = null;
        s_snd_queue = null;
        s_snd_queue_pointer = null;
        s_snd_queue_size = null;
        s_snd_requestBuffer = null;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    static void Snd_LoadSound(String object, int n, boolean bl) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n < 0) {
            return;
        }
        GLLib.Pack_Open((String)object);
        byte[] byArray = GLLib.Pack_ReadData(n);
        object = byArray;
        boolean bl2 = bl;
        int n2 = n;
        n = GLLib.s_pack_lastDataReadMimeType;
        byte[] byArray2 = byArray;
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        GLLibPlayer.s_snd_sndSlot[n2] = byArray2;
        GLLibPlayer.s_snd_sndType[n2] = n;
    }

    static void Snd_UnLoadSound(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n < 0) {
            return;
        }
        GLLibPlayer.s_snd_sndSlot[n] = null;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    static void Snd_Play(int n, int n2, int n3, int n4, int n5) {
        if (GLLibConfig.sound_enable) {
            if (n2 < 0 || n4 == 0) {
                return;
            }
            GLLibPlayer.SndQueue_Push(0, 3, n2, n5, n4, n3);
        }
    }

    static final void Snd_Stop(int n) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        int n2 = n;
        n = 4;
        n = n2;
        GLLibPlayer.SndQueue_Push(n2, 4, -1, -1, -1, -1);
    }

    private static void Snd_PrepareExec(int n, int n2, int n3) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        GLLibPlayer.Snd_FreeChannelExec(n);
        if (s_snd_Player[n] == null) {
            if (s_snd_sndSlot[n2] == null) {
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].realize();
        s_snd_Player[n].prefetch();
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
    }

    static void Snd_Update() {
        GLLibPlayer.Snd_Update_Exec();
    }

    private static void Snd_Update_Exec() {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            int[] nArray = s_snd_requestBuffer;
            int n = i;
            GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
            if (s_snd_requestBuffer[5] <= 0) continue;
            if (s_snd_state[i] == 2) {
                try {
                    n = GLLibPlayer.Snd_IsPlaying(i) ? 1 : 0;
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n == 0) {
                    GLLibPlayer.s_snd_state[i] = 1;
                }
            }
            while (s_snd_requestBuffer[5] > 0) {
                try {
                    switch (s_snd_requestBuffer[0]) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(i, s_snd_requestBuffer[1], s_snd_requestBuffer[2]);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(i);
                            break;
                        }
                        case 3: {
                            int n2 = s_snd_requestBuffer[3];
                            int n3 = s_snd_requestBuffer[4];
                            int n4 = s_snd_requestBuffer[2];
                            int n5 = s_snd_requestBuffer[1];
                            n = i;
                            if (GLLibConfig.sound_enable) {
                                if (GLLib.s_game_isPaused) break;
                                GLLibPlayer.Snd_PrepareExec(n, n5, n4);
                                if (!GLLib.s_game_isPaused && s_snd_state[n] == 1) {
                                    if (s_snd_Player[n] == null) break;
                                    if (n3 == 0) {
                                        s_snd_Player[n].setLoopCount(-1);
                                    } else {
                                        s_snd_Player[n].setLoopCount(n3);
                                    }
                                    if (GLLibConfig.sound_useSetLevel) {
                                        ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n2 * s_snd_masterVolume * 100 / 10000);
                                    }
                                    s_snd_Player[n].start();
                                    GLLibPlayer.s_snd_state[n] = 2;
                                    GLLibPlayer.s_snd_volume[n] = n2;
                                    GLLibPlayer.s_snd_loop[n] = n3;
                                    GLLibPlayer.s_snd_priority[n] = n4;
                                    GLLibPlayer.s_snd_index[n] = n5;
                                }
                            }
                            break;
                        }
                        case 4: {
                            n = i;
                            if (s_snd_Player[n] != null) {
                                s_snd_Player[n].stop();
                                GLLibPlayer.s_snd_state[n] = 1;
                                if (GLLibConfig.sound_useFreeChannelOnStop) {
                                    GLLibPlayer.Snd_FreeChannelExec(n);
                                }
                            }
                            break;
                        }
                        case 5: {
                            n = i;
                            if (s_snd_state[n] == 2 && s_snd_Player[n] != null) {
                                s_snd_Player[n].stop();
                                GLLibPlayer.s_snd_state[n] = 3;
                            }
                            break;
                        }
                        case 6: {
                            n = i;
                            if (s_snd_state[n] == 3 && s_snd_Player[n] != null) {
                                s_snd_Player[n].start();
                                GLLibPlayer.s_snd_state[n] = 2;
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {}
                nArray = s_snd_requestBuffer;
                n = i;
                GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
            }
        }
    }

    public final void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                Thread.sleep(1000 / GLLibConfig.FPSLimiter);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (n >= k_snd_nbChannel || s_snd_Player[n] == null) {
            return false;
        }
        return s_snd_Player[n].getState() == 400;
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            s_snd_Player[n].deallocate();
            s_snd_Player[n].close();
            GLLibPlayer.s_snd_Player[n] = null;
            if (GLLibConfig.useSystemGc) {
                System.gc();
            }
        }
        GLLibPlayer.s_snd_state[n] = 0;
        GLLibPlayer.s_snd_index[n] = -1;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        GLLibPlayer.Snd_Update_Exec();
    }

    static int Snd_GetCurrentSoundIndex(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[n];
        }
        return -1;
    }

    static void Snd_PauseNotify() {
        if (GLLibConfig.sound_useStopSoundsOnInterrupt) {
            try {
                GLLibPlayer.Snd_StopAllSounds();
                return;
            }
            catch (Exception exception) {}
        }
    }

    static void Tileset_Init(int n, int n2, int n3, int n4) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][15];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        GLLibPlayer.s_TilesetInfo[0] = n;
        GLLibPlayer.s_TilesetInfo[1] = n2;
        GLLibPlayer.s_TilesetInfo[2] = n3;
        GLLibPlayer.s_TilesetInfo[4] = 0;
        GLLibPlayer.s_TilesetInfo[5] = n4;
        GLLibPlayer.s_TilesetInfo[7] = 0;
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][14] & n2) != 0;
    }

    private static final void setFlag(int n, int n2, boolean bl) {
        if (bl) {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[14] = nArray[14] | n2;
            return;
        }
        int[] nArray = s_TilesetLayerInfo[n];
        nArray[14] = nArray[14] & ~n2;
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, boolean n2, int n3, int n4, int n5) {
        n5 = 0;
        n4 = 0;
        n3 = 16;
        n2 = n;
        if (s_bTilesetPlayerInitialized) {
            GLLibPlayer.Tileset_Destroy(n, false);
            GLLibPlayer.s_TilesetLayerData[n][0] = byArray2;
            GLLibPlayer.s_TilesetLayerData[n][1] = byArray3;
            GLLibPlayer.s_TilesetLayerInfo[n][2] = GLLib.Mem_GetShort(byArray, 0);
            GLLibPlayer.s_TilesetLayerInfo[n][3] = GLLib.Mem_GetShort(byArray, 2);
            GLLibPlayer.s_TilesetLayerInfo[n][4] = s_TilesetLayerInfo[n][2] * s_TilesetInfo[2];
            GLLibPlayer.s_TilesetLayerInfo[n][5] = s_TilesetLayerInfo[n][3] * s_TilesetInfo[5];
            GLLibPlayer.s_TilesetSprite[n] = aSprite;
            if (n2 > -1) {
                try {
                    int n6 = s_TilesetInfo[0] % s_TilesetInfo[2];
                    int n7 = 1 + (n6 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][6] = s_TilesetInfo[0] - n6 + n7 * s_TilesetInfo[2];
                    n6 = s_TilesetInfo[1] % s_TilesetInfo[5];
                    n7 = 1 + (n6 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][7] = s_TilesetInfo[1] - n6 + n7 * s_TilesetInfo[5];
                    if (n2 == n) {
                        if (s_TilesetLayerImage[n][0] == null || s_TilesetLayerImage[n][0].getWidth() != s_TilesetLayerInfo[n][6] || s_TilesetLayerImage[n][0].getHeight() != s_TilesetLayerInfo[n][7]) {
                            GLLibPlayer.s_TilesetLayerImage[n][0] = Image.createImage((int)s_TilesetLayerInfo[n][6], (int)s_TilesetLayerInfo[n][7]);
                            GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerImage[n][0].getGraphics();
                        }
                    } else {
                        GLLibPlayer.s_TilesetLayerImage[n][0] = s_TilesetLayerImage[n2][0];
                        GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerGraphics[n2][0];
                    }
                    GLLibPlayer.setFlag(n, 4, true);
                }
                catch (Exception exception) {}
            }
            GLLibPlayer.s_TilesetLayerInfo[n][8] = -1;
            GLLibPlayer.s_TilesetLayerInfo[n][9] = -1;
            GLLibPlayer.s_TilesetLayerInfo[n][10] = -1;
            GLLibPlayer.s_TilesetLayerInfo[n][11] = -1;
            GLLibPlayer.s_TilesetLayerInfo[n][0] = 1;
            GLLibPlayer.s_TilesetLayerInfo[n][1] = 1;
            GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
            GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
            GLLibPlayer.setFlag(n, 1, n4 == 1);
            GLLibPlayer.setFlag(n, 16, n4 == 0);
            GLLibPlayer.setFlag(n, 2, n5 == 1);
            GLLibPlayer.setFlag(n, 32, n5 == 0);
            GLLibPlayer.setFlag(n, 8, n3 == 32);
        }
    }

    static void Tileset_Destroy(int n) {
        GLLibPlayer.Tileset_Destroy(0, true);
    }

    private static void Tileset_Destroy(int n, boolean bl) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n] = new int[15];
        if (bl) {
            GLLibPlayer.s_TilesetLayerImage[n] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[n] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[n] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[n] = null;
    }

    /*
     * WARNING - void declaration
     */
    static void Tileset_Draw(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        block39: {
            block40: {
                void var21_41;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int[] nArray;
                block46: {
                    block44: {
                        block45: {
                            block43: {
                                block41: {
                                    block42: {
                                        if (!s_bTilesetPlayerInitialized) {
                                            return;
                                        }
                                        n7 = s_TilesetInfo[0];
                                        n6 = s_TilesetInfo[1];
                                        if (n3 == -1) {
                                            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                                                GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                            }
                                            return;
                                        }
                                        nArray = s_TilesetLayerInfo[n3];
                                        if (nArray[0] != 1 || nArray[1] != 1) {
                                            return;
                                        }
                                        n5 = nArray[12];
                                        n4 = nArray[13];
                                        if (!GLLibPlayer.isFlag(n3, 4)) break block39;
                                        n13 = 0;
                                        n12 = 0;
                                        n11 = 0;
                                        n10 = 0;
                                        if (GLLib.IsClipValid(graphics)) {
                                            n13 = GLLib.GetClipX(graphics);
                                            n12 = GLLib.GetClipY(graphics);
                                            n11 = GLLib.GetClipWidth(graphics);
                                            n10 = GLLib.GetClipHeight(graphics);
                                        }
                                        int n14 = n5;
                                        int n15 = n4;
                                        if (n5 < 0) {
                                            n14 = n5 - s_TilesetInfo[2];
                                        }
                                        if (n4 < 0) {
                                            n15 = n4 - s_TilesetInfo[5];
                                        }
                                        n9 = n14 / s_TilesetInfo[2];
                                        int n16 = n15 / s_TilesetInfo[5];
                                        int n17 = n9 + nArray[6] / s_TilesetInfo[2] - 1;
                                        int n18 = n16 + nArray[7] / s_TilesetInfo[5] - 1;
                                        int n19 = 0;
                                        int n20 = 0;
                                        if (nArray[9] != n16 || nArray[11] != n18) {
                                            if (nArray[9] < n16 || nArray[11] < n18) {
                                                if (nArray[11] < n16) {
                                                    n19 = n16;
                                                    n20 = n18;
                                                } else {
                                                    n19 = nArray[11] + 1;
                                                    n20 = n18;
                                                }
                                            } else if (nArray[9] > n18) {
                                                n19 = n16;
                                                n20 = n18;
                                            } else {
                                                n19 = n16;
                                                n20 = nArray[9] - 1;
                                            }
                                        }
                                        if (nArray[8] != n9 || nArray[10] != n17) {
                                            void var21_34;
                                            if (nArray[8] < n9 || nArray[10] < n17) {
                                                if (nArray[10] < n9) {
                                                    n14 = n9;
                                                    n15 = n17;
                                                } else {
                                                    n14 = nArray[10] + 1;
                                                    n15 = n17;
                                                }
                                            } else if (nArray[8] > n17) {
                                                n14 = n9;
                                                n15 = n17;
                                            } else {
                                                n14 = n9;
                                                n15 = nArray[8] - 1;
                                            }
                                            int bl = n18 - n16;
                                            n8 = n16;
                                            if (nArray[9] != n16 || nArray[11] != n18) {
                                                if (nArray[9] < n16 || nArray[11] < n18) {
                                                    int n21 = bl - (n20 - n19 + 1);
                                                } else {
                                                    int n22 = bl - (n20 - n19 + 1);
                                                    n8 += n20 - n19 + 1;
                                                }
                                            }
                                            if (var21_34 >= 0) {
                                                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n14, n8, n15 - n14, (int)var21_34, 0, 0);
                                            }
                                            nArray[8] = n9;
                                            nArray[10] = n17;
                                        }
                                        if (nArray[9] != n16 || nArray[11] != n18) {
                                            GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n9, n19, n17 - n9, n20 - n19, 0, 0);
                                            nArray[9] = n16;
                                            nArray[11] = n18;
                                        }
                                        if (graphics == null) break block40;
                                        boolean bl = false;
                                        if (GLLibPlayer.isFlag(n3, 17)) break block41;
                                        if (n5 >= 0) break block42;
                                        n -= n5;
                                        n5 = 0;
                                        boolean bl2 = true;
                                        break block43;
                                    }
                                    if (n5 <= nArray[4] - n7) break block43;
                                    n -= n5 - (nArray[4] - n7);
                                    n5 = nArray[4] - n7;
                                    boolean bl = true;
                                    break block43;
                                }
                                while (n5 < 0) {
                                    n5 += nArray[6];
                                }
                            }
                            if (GLLibPlayer.isFlag(n3, 34)) break block44;
                            if (n4 >= 0) break block45;
                            n2 -= n4;
                            n4 = 0;
                            boolean bl = true;
                            break block46;
                        }
                        if (n4 <= nArray[5] - n6) break block46;
                        n2 -= n4 - (nArray[5] - n6);
                        n4 = nArray[5] - n6;
                        boolean bl = true;
                        break block46;
                    }
                    while (n4 < 0) {
                        n4 += nArray[7];
                    }
                }
                n8 = n5 % nArray[6];
                n9 = n4 % nArray[7];
                n5 = (n5 + n7) % nArray[6];
                int n21 = (n4 + n6) % nArray[7];
                GLLib.SetClip(graphics, n13, n12, n11, n10);
                if (n5 > n8) {
                    if (n21 > n9) {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7, n6, n + 0, n2 + 0, (boolean)var21_41);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7, n6 - n21, n + 0, n2 + 0, (boolean)var21_41);
                        GLLib.SetClip(graphics, n13, n12, n11, n10);
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7, n21, n + 0, n6 - n21 + n2, (boolean)var21_41);
                    }
                } else if (n21 > n9) {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7 - n5, n6, n + 0, n2 + 0, (boolean)var21_41);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n9, n5, n6, n7 - n5 + n, n2 + 0, (boolean)var21_41);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7 - n5, n6 - n21, n + 0, n2 + 0, (boolean)var21_41);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7 - n5, n21, n + 0, n6 - n21 + n2, (boolean)var21_41);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n9, n5, n6 - n21, n7 - n5 + n, n2 + 0, (boolean)var21_41);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, 0, n5, n21, n7 - n5 + n, n6 - n21 + n2, (boolean)var21_41);
                }
                GLLib.SetClip(graphics, n13, n12, n11, n10);
            }
            return;
        }
        if (graphics != null) {
            int n22;
            int n23 = n5;
            int n24 = n4;
            if (n5 < 0) {
                n23 = n5 - s_TilesetInfo[2];
            }
            if (n4 < 0) {
                n24 = n4 - s_TilesetInfo[5];
            }
            int n25 = n23 / s_TilesetInfo[2];
            int n26 = n24 / s_TilesetInfo[5];
            int n27 = n7 / s_TilesetInfo[2];
            if (n27 * s_TilesetInfo[2] < n7) {
                ++n27;
            }
            if ((n22 = n6 / s_TilesetInfo[5]) * s_TilesetInfo[5] < n6) {
                ++n22;
            }
            int n28 = n25 * s_TilesetInfo[2] - n5;
            int n29 = n26 * s_TilesetInfo[5] - n4;
            GLLibPlayer.Tileset_UpdateBuffer(graphics, n3, n25, n26, n27, n22, n28 + n, n29 + n2);
        }
    }

    private static void Tileset_Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (bl) {
            if (n6 > GLLib.s_screenWidth || n7 > GLLib.s_screenHeight || n6 + n4 < 0 || n7 + n5 < 0) {
                return;
            }
            GLLib.ClipRect(graphics, n6, n7, n4, n5);
            GLLib.ClipRect(graphics, 0, 0, GLLib.s_screenWidth, GLLib.s_screenHeight);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
            return;
        }
        GLLib.ClipRect(graphics, n6, n7, n4, n5);
        graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
    }

    private static void Tileset_UpdateBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = GLLibPlayer.isFlag(n, 4);
        boolean bl2 = GLLibPlayer.isFlag(n, 1);
        boolean bl3 = GLLibPlayer.isFlag(n, 2);
        int n8 = s_TilesetLayerInfo[n][2];
        int n9 = s_TilesetLayerInfo[n][3];
        byte[] byArray = s_TilesetLayerData[n][0];
        byte[] byArray2 = s_TilesetLayerData[n][1];
        int n10 = s_TilesetInfo[2];
        int n11 = s_TilesetInfo[5];
        if (bl) {
            n6 = n2 * s_TilesetInfo[2] % s_TilesetLayerInfo[n][6] + n6;
            n7 = n3 * s_TilesetInfo[5] % s_TilesetLayerInfo[n][7] + n7;
            if (n6 < 0) {
                n6 += s_TilesetLayerInfo[n][6];
            }
            if (n7 < 0) {
                n7 += s_TilesetLayerInfo[n][7];
            }
        }
        if (bl2) {
            while (n2 < 0) {
                n2 += n8;
            }
            while (n2 >= n8) {
                n2 -= n8;
            }
        } else if (!GLLibPlayer.isFlag(n, 16)) {
            if (n2 < 0) {
                n6 -= n2 * n10;
                n4 += n2;
                n2 = 0;
                if (bl && n6 >= s_TilesetLayerInfo[n][6]) {
                    n6 = 0;
                }
            }
            if (n2 + n4 >= n8) {
                n4 = n8 - n2 - 1;
            }
            if (n4 < 0) {
                return;
            }
        }
        if (bl3) {
            while (n3 < 0) {
                n3 += n9;
            }
            while (n3 >= n9) {
                n3 -= n9;
            }
        } else if (!GLLibPlayer.isFlag(n, 32)) {
            if (n3 < 0) {
                n7 -= n3 * n11;
                n5 += n3;
                n3 = 0;
                if (bl && n7 >= s_TilesetLayerInfo[n][7]) {
                    n7 = 0;
                }
            }
            if (n3 + n5 >= n9) {
                n5 = n9 - n3 - 1;
            }
            if (n5 < 0) {
                return;
            }
        }
        int n12 = n7;
        while (n5-- >= 0) {
            n7 = n6;
            int n13 = n4;
            int n14 = n2;
            while (n13-- >= 0) {
                int n15;
                int n16;
                int n17 = n14 + n3 * n8;
                if (n17 < byArray.length && (n16 = (n15 = byArray[n17] & 0xFF) == 255 ? 1 : 0) == 0) {
                    n17 = byArray2 == null ? 0 : byArray2[n17] & 0xFF;
                    if (s_TilesetSprite[n].GetFrameCount() == 0) {
                        s_TilesetSprite[n].PaintModule(graphics, n15, n7, n12, n17);
                    } else {
                        n16 = n7;
                        int n18 = n12;
                        if (GLLibConfig.sprite_useTransfFlip) {
                            if ((n17 & 1) != 0) {
                                n16 += n10;
                            }
                            if ((n17 & 2) != 0) {
                                n18 += n11;
                            }
                        }
                        int n19 = n17;
                        int n20 = n18;
                        n18 = n16;
                        n16 = n15;
                        Graphics graphics2 = graphics;
                        ASprite aSprite = s_TilesetSprite[n];
                        aSprite.PaintFrame(graphics2, n16, n18, n20, n19, 0, 0);
                    }
                }
                n7 += n10;
                if (++n14 >= n8) {
                    if (!bl2) break;
                    n14 = 0;
                }
                if (!bl || n7 < s_TilesetLayerInfo[n][6]) continue;
                n7 = 0;
            }
            n12 += n11;
            if (++n3 >= n9) {
                if (!bl3) break;
                n3 = 0;
            }
            if (!bl || n12 < s_TilesetLayerInfo[n][7]) continue;
            n12 = 0;
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][5] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final void Tileset_SetCamera(int n, int n2, int n3) {
        GLLibPlayer.s_TilesetLayerInfo[n][12] = n2;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (GLLibPlayer.isFlag(n, 16)) {
            if (s_TilesetLayerInfo[n][12] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
            } else if (s_TilesetLayerInfo[n][12] + s_TilesetInfo[0] > s_TilesetLayerInfo[n][4]) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = s_TilesetLayerInfo[n][4] - s_TilesetInfo[0];
            }
        }
        if (GLLibPlayer.isFlag(n, 32)) {
            if (s_TilesetLayerInfo[n][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
                return;
            }
            if (s_TilesetLayerInfo[n][13] + s_TilesetInfo[1] > s_TilesetLayerInfo[n][5]) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = s_TilesetLayerInfo[n][5] - s_TilesetInfo[1];
            }
        }
    }

    static final int Tileset_GetTile(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(0, n3);
        return s_TilesetLayerData[0][0][n3 * s_TilesetLayerInfo[0][2] + n2] & 0xFF;
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = GLLibConfig.tileset_maxLayerCount;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

