/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Debug;
import STH2P1_S40P1.Engine;
import STH2P1_S40P1.Resources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ResourceMaster
implements Debug {
    private static DataInputStream dis;
    private static int[] fileOffset;
    private static int[] fileLength;
    private static int disPosition;
    private static int currentPak;
    private static Hashtable resourceCache;
    private static int lastFileId;

    public static byte[] getResourceAsBytes(int n) {
        return ResourceMaster.getResourceFromJar(Resources.FILENAMES[n], false);
    }

    public static short[] getResourceAsUnsignedBytes(int n) {
        byte[] byArray = ResourceMaster.getResourceFromJar(Resources.FILENAMES[n], false);
        short[] sArray = new short[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            sArray[i] = byArray[i] < 0 ? (short)(byArray[i] + 256) : (short)byArray[i];
        }
        return sArray;
    }

    public static short[] getResourceAsShorts(int n) {
        byte[] byArray = ResourceMaster.getResourceFromJar(Resources.FILENAMES[n], false);
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            sArray[i / 2] = (short)((byArray[i] & 0xFF) << 8 | byArray[i + 1] & 0xFF);
        }
        return sArray;
    }

    public static boolean isCached(int n) {
        return false;
    }

    public static DataInputStream getResourceAsStream(int n) {
        return new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResourceAsBytes(n)));
    }

    public static byte[] getResourceFromJar(String string) {
        return ResourceMaster.getResourceFromJar(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceFromJar(String string, boolean bl) {
        InputStream inputStream = null;
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            inputStream = ((Object)((Object)Engine.parent)).getClass().getResourceAsStream(string);
            if (bl) {
                inputStream.skip(4L);
            }
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            byArray = null;
        }
        finally {
            try {
                byteArrayOutputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static void closeResource() {
        currentPak = -1;
        fileOffset = null;
        fileLength = null;
        try {
            if (dis != null) {
                dis.close();
                dis = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    private static void initPak(int n) {
        if (currentPak != -1) {
            ResourceMaster.closeResource();
        }
        currentPak = n;
        dis = new DataInputStream(((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + n + ".pak"));
        try {
            int n2 = dis.readShort();
            fileOffset = new int[n2];
            fileLength = new int[n2];
            for (int i = 0; i < n2; ++i) {
                dis.readInt();
                ResourceMaster.fileOffset[i] = dis.readInt();
                ResourceMaster.fileLength[i] = dis.readInt();
            }
            disPosition = n2 * 12 + 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        currentPak = -1;
    }
}

