/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.DeviceConstants;
import STH2P1_S40P1.DeviceSound;
import STH2P1_S40P1.Engine;
import STH2P1_S40P1.GameWorld;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class Device
extends GameCanvas
implements DeviceConstants {
    public static final int DEVICE_ID = 1;
    public static final boolean USE_ALTERNATE_RMS_METHOD = false;
    public static final boolean USE_COMMANDS = false;
    public static final boolean SUPPORTS_SOUND = true;
    public static final boolean SUPPORTS_VIBRATION = true;
    public static final int THREAD_PRIORITY = 5;
    public static final short REFRESH_DELAY = 60;
    public static final boolean AGGRESSIVE_GC = true;
    public static final boolean FAKE_SERVICE_REPAINTS = false;
    public static final int MINIMUM_SLEEP = 50;
    public static final boolean CACHE_RESOURCES = false;
    public static final boolean SYSTEM_GC_IN_PAINT_THREAD = false;
    public static final boolean CACHE_METATILES = false;
    public static final int BACKGROUND_TYPE = 2;
    public static final boolean CACHE_HUD_BACKGROUND = false;
    public static final boolean ALWAYS_PAINT_HUD = true;
    public static final Font FONT = Font.getFont((int)0, (int)1, (int)8);
    public static final Font FONT_NB = Font.getFont((int)0, (int)0, (int)8);
    public static final int FONT_HEIGHT = 13;
    public static final int FONT_OFFSET = 0;
    public static final int FONT_SPACING = 17;
    public static final boolean USE_BITMAP_FONTS = false;
    public static int[] FONT_TYPE = new int[]{1, 1};
    private static final int MIDP_FONT_FACE_SMALL = 0;
    private static final int MIDP_FONT_FACE_MEDIUM = 1;
    public static final Font[] MIDP_FONT_FACES = new Font[]{Font.getFont((int)0, (int)1, (int)8), Font.getFont((int)0, (int)0, (int)0)};
    public static final int[] MIDP_FONT_PROPS = new int[]{9, 3, 2, 0, 12, 3, 2, 0};
    public static final int[] MIDP_FONT_COMPOSITIONS = new int[]{1, 0xFFFFFF, 1, -1};
    private static final int BMP_FONT_FACE_BLOCK = 0;
    public static final int[] BMP_FONT_FACES = new int[0];
    public static final int[] BMP_FONT_COMPOSITIONS = new int[]{0, -1};
    public static final int HANDLE_EVENT_DELAY = 0;
    public static final int EVENT = 2;
    private static final int KEY_UP_MAPPING = 50;
    private static final int KEY_DOWN_MAPPING = 56;
    private static final int KEY_LEFT_MAPPING = 52;
    private static final int KEY_RIGHT_MAPPING = 54;
    private static final int KEY_UL_MAPPING = 49;
    private static final int KEY_UR_MAPPING = 51;
    private static final int KEY_DL_MAPPING = 55;
    private static final int KEY_DR_MAPPING = 57;
    private static final int KEY_FIRE_MAPPING = 53;
    private static final int KEY_FIRE2_MAPPING = 48;
    private static final int KEY_STAR_MAPPING = 42;
    private static final int KEY_HASH_MAPPING = 35;
    private static final int VENDOR_UKY = -1;
    private static final int VENDOR_DKY = -6;
    private static final int VENDOR_LKY = -2;
    private static final int VENDOR_RKY = -5;
    private static final int VENDOR_FKY = -20;
    private static final int KEY_SOFTLEFT = -21;
    private static final int KEY_SOFTRIGHT = -22;
    public static final String[] STRING_8WAY = new String[]{"2", "8", "4", "6", "1", "3", "7", "9"};
    private boolean wasInterruption = false;

    public Device() {
        super(false);
        this.setFullScreenMode(true);
    }

    public static int soundFunction(int n) {
        return Device.soundFunction(n, 0);
    }

    public static void deviceTick() {
    }

    public static int deviceFunction(int n, String string) throws Exception {
        switch (n) {
            default: 
        }
        return 0;
    }

    public static int soundFunction(int n, int n2) {
        switch (n) {
            case 0: {
                DeviceSound.init();
                break;
            }
            case 3: {
                DeviceSound.play(n2);
                break;
            }
            case 1: {
                DeviceSound.stop();
            }
        }
        return 0;
    }

    public static void vibrate(int n) {
        if (Engine.vibrateOn) {
            Engine.display.vibrate(n);
        }
    }

    public void setBackLight(boolean bl) {
    }

    public void hideNotify() {
        Engine.loadingInterrupted = GameWorld.loading || GameWorld.gameState == 6 || GameWorld.gameState == 0 || GameWorld.gameState == 5 && GameWorld.whileLoading;
        DeviceSound.stop();
        Engine.handleEvent = true;
        Engine.hideNotify = true;
    }

    public void showNotify() {
        Engine.hideNotify = false;
        Thread.yield();
    }

    public int getKeyMap(int n) {
        if (n == 53 || n == -20) {
            return 16;
        }
        if (n == -21) {
            return Engine.reverseTooltips ? 128 : 64;
        }
        if (n == -22) {
            return Engine.reverseTooltips ? 64 : 128;
        }
        if (n == 50 || n == -1) {
            return 1;
        }
        if (n == 56 || n == -6) {
            return 2;
        }
        if (n == 52 || n == -2) {
            return 4;
        }
        if (n == 54 || n == -5) {
            return 8;
        }
        if (n == 49) {
            return 256;
        }
        if (n == 51) {
            return 512;
        }
        if (n == 55) {
            return 1024;
        }
        if (n == 57) {
            return 2048;
        }
        if (Engine.state == 100 && n == 42) {
            return 1;
        }
        if (Engine.state == 100 && n == 35) {
            return 1;
        }
        return 8192;
    }

    public void paint(Graphics graphics) {
    }
}

