/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import javax.microedition.lcdui.Graphics;
import zed.rollNRun.helper.util.ZedAnimation;

public class PWAnimPlayer {
    public static int NOT_START = -1;
    public long startTime;
    public ZedAnimation anim;
    public int currentIndex;
    public int frameIndex;

    public PWAnimPlayer(ZedAnimation anim) {
        this.anim = anim;
        this.startTime = NOT_START;
    }

    public PWAnimPlayer(ZedAnimation anim, long time) {
        this.anim = anim;
        this.startTime = time;
    }

    public PWAnimPlayer(PWAnimPlayer player) {
        this.anim = player.anim;
        this.startTime = NOT_START;
    }

    public int drawAnimation(Graphics g, int animID, long time, int x, int y, boolean cyclical) {
        if (animID != -1) {
            return this.drawAnimation(g, animID, time, x, y, 0, cyclical);
        }
        return -1;
    }

    public int drawAnimation(Graphics g, int animID, long time, int x, int y, int trans, boolean cyclical) {
        if (this.startTime == (long)NOT_START) {
            this.startTime = time;
        }
        this.currentIndex = this.anim.GetGolFramePos(animID, time - this.startTime, cyclical);
        this.frameIndex = this.anim.drawAnimation(g, animID, time - this.startTime, x, y, trans, cyclical);
        if (this.frameIndex == -1 && cyclical) {
            this.resetAnim();
        }
        return this.frameIndex;
    }

    public void resetAnim() {
        this.startTime = NOT_START;
        this.currentIndex = 0;
        this.frameIndex = 0;
    }

    public boolean isFinish() {
        return this.frameIndex == -1;
    }

    public int GetWid(int ani_id, long time, boolean loop) {
        return this.anim.getFrameWidth(this.anim.GetGolFramePos(ani_id, time - this.startTime, loop));
    }

    public int GetHei(int ani_id, long time, boolean loop) {
        return this.anim.getFrameHeight(this.anim.GetGolFramePos(ani_id, time - this.startTime, loop));
    }

    public short[] GetColBox(long game_time, int ani_id, boolean loop) {
        return this.anim.colBoxes[this.anim.GetGolFramePos(ani_id, game_time - this.startTime, loop)];
    }

    public short[] GetAttBox(long game_time, int ani_id, boolean loop) {
        return this.anim.attBoxes[this.anim.GetGolFramePos(ani_id, game_time - this.startTime, loop)];
    }

    public int GetAnimLength(int ani_id) {
        if (this.anim != null) {
            return this.anim.animationsTimeLengths[ani_id] * 10;
        }
        return 0;
    }
}

