/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gladiatorescape.ui;

import com.appon.gladiatorescape.adapter.GameEventListener;
import com.appon.gtantra.GFont;
import com.appon.util.Util;
import com.indiagames.runnergame.Constant;
import com.indiagames.runnergame.TempleRunCanvas;
import javax.microedition.lcdui.Graphics;

public abstract class CustomCanvas {
    public GFont gfont;
    public String lsk;
    public String title;
    public String rsk;
    public GameEventListener listener;
    public int gameState;
    public static int rskWidth;
    public static int rskHeight;

    public CustomCanvas(GFont gfont, String lsk, String rsk, String title) {
        this.gfont = gfont;
        this.lsk = lsk;
        this.title = title;
        this.rsk = rsk;
    }

    public void init() {
        Constant.LSK_X = 1;
        if (this.rsk != null) {
            Constant.RSK_X = Constant.SCREEN_WIDTH - Constant.SMALLFONT.getStringWidth(this.rsk);
        }
        Constant.SOFT_KEY_Y = Constant.SCREEN_HEIGHT - (Constant.SMALLFONT.getFontHeight() + Constant.HERO_POS);
    }

    protected abstract void paint(Graphics var1);

    protected abstract void keyPressed(int var1, int var2);

    public final void paintUi(Graphics g) {
        Constant.SMALLFONT.setColor(1);
        this.paint(g);
        this.paintSoftKey(g);
    }

    public void unload() {
    }

    public void paintSoftKey(Graphics g) {
        Constant.SMALLFONT.setColor(0);
        if (this.lsk != null) {
            g.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), Constant.LSK_X, Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight(), 0);
            Constant.SMALLFONT.drawString(g, this.lsk, Constant.LSK_X + (Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.SMALLFONT.getStringWidth(this.lsk) >> 1), Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight() + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.SMALLFONT.getFontHeight() >> 1), 20);
        }
        if (this.rsk != null && !Util.equalsIgnoreCase(this.rsk, "Pause")) {
            if (this.rsk != null) {
                g.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), Constant.SCREEN_WIDTH - Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight(), 0);
                Constant.SMALLFONT.drawString(g, this.rsk, Constant.SCREEN_WIDTH - Constant.IMG_CHALLENGE_BOX.getWidth() + (Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.SMALLFONT.getStringWidth(this.rsk) >> 1), Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight() + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.SMALLFONT.getFontHeight() >> 1), 20);
            }
        } else if (this.rsk != null && Util.equalsIgnoreCase(this.rsk, "Pause")) {
            g.drawImage(Constant.IMAGE_PAUSE_BUTTON.getImage(), Constant.SCREEN_WIDTH - 2, Constant.SCREEN_HEIGHT - Constant.IMAGE_PAUSE_BUTTON.getHeight(), 24);
        }
    }

    public int getSoftKeyHeight() {
        return Constant.SCREEN_HEIGHT - (Constant.SMALLFONT.getFontHeight() + 2);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void keyRelease(int keyCode, int gameKey) {
    }

    public void callKeyPress(int keyCode, int gameKey) {
        if (this.listener != null) {
            if (this.lsk != null && Util.isLeftSoftkeyPressed(keyCode)) {
                this.listener.listenSoftKeys(0);
            } else if (this.rsk != null && Util.isRightSoftkeyPressed(keyCode)) {
                this.listener.listenSoftKeys(1);
            }
        }
        this.keyPressed(keyCode, gameKey);
    }

    public int getWidth() {
        return TempleRunCanvas.getInstance().getWidth();
    }

    public int getHeight() {
        return TempleRunCanvas.getInstance().getHeight();
    }

    public void setListener(GameEventListener listener) {
        this.listener = listener;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (this.lsk != null && Util.isInRect(Constant.LSK_X, Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight(), Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.IMG_CHALLENGE_BOX.getHeight(), x, y) && this.listener != null) {
            this.listener.listenSoftKeys(0);
            return true;
        }
        if (this.rsk != null && Util.isInRect(Constant.SCREEN_WIDTH - Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.SCREEN_HEIGHT - Constant.IMG_CHALLENGE_BOX.getHeight(), Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.IMG_CHALLENGE_BOX.getHeight(), x, y) && this.listener != null) {
            this.listener.listenSoftKeys(1);
            return true;
        }
        return false;
    }

    public void update() {
    }

    public void callPointerDragged(int x, int y) {
    }

    public void handlePointerDragged(int x, int y) {
    }

    public void hideNotify() {
    }
}

