/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner.model;

import com.appon.runner.RunnerManager;
import com.appon.runner.model.Shape;
import com.appon.runner.model.ShapeGroup;
import com.appon.runner.util.CustomSerilizable;
import com.appon.runner.util.Util;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class AddedShape
implements CustomSerilizable {
    int x;
    int y;
    Shape shape;
    private String userData;
    private int additionalX;
    private int additionalY;
    ShapeGroup parent;
    private int id;
    private boolean collisionOccured = false;
    private boolean isVisible = true;
    private int jointInfo;
    private boolean isJointInfoThere;
    private int resetX;
    private int resetY;
    private int originaalX;
    private int orignalY;

    public void reset() {
        this.x = this.resetX;
        this.y = this.resetY;
    }

    public AddedShape clone() {
        AddedShape addedshape = new AddedShape();
        addedshape.x = this.x;
        addedshape.y = this.y;
        addedshape.shape = this.shape;
        addedshape.userData = this.userData;
        addedshape.id = this.id;
        addedshape.additionalX = this.additionalX;
        addedshape.additionalY = this.additionalY;
        addedshape.parent = this.parent;
        addedshape.collisionOccured = this.collisionOccured;
        addedshape.isVisible = this.isVisible;
        return addedshape;
    }

    public boolean isIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isCollisionOccured() {
        return this.collisionOccured;
    }

    public void setCollisionOccured(boolean collisionOccured) {
        this.collisionOccured = collisionOccured;
    }

    public void setParent(ShapeGroup parent) {
        this.parent = parent;
    }

    public ShapeGroup getParent() {
        return this.parent;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void paint(Graphics g, int camY) {
        this.shape.paintUi(g, this.x + this.additionalX, this.y + this.additionalY - camY);
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setAdditionalX(int additionalX) {
        this.additionalX = additionalX;
    }

    public void setAdditionalY(int additionalY) {
        this.additionalY = additionalY;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void deserilize(InputStream bis) throws Exception {
        this.resetX = this.x = Util.bytesToIntWithSign(bis, 4);
        this.resetY = this.y = Util.bytesToIntWithSign(bis, 4);
        int shapeId = Util.read(bis, 2);
        this.shape = RunnerManager.getManager().findShape(shapeId);
        this.id = Util.read(bis, 2);
        this.userData = Util.readString(bis);
        if (RunnerManager.isJointInfoPresent) {
            int checkJoint = Util.read(bis, 1);
            this.isJointInfoThere = checkJoint == 1;
            this.jointInfo = Util.read(bis, 2);
        }
    }

    public int getAdditionalX() {
        return this.additionalX;
    }

    public int getAdditionalY() {
        return this.additionalY;
    }

    public int getId() {
        return this.id;
    }

    public void update() {
        if (this.getShape() != null) {
            this.getShape().update(this);
        }
    }

    public void rescale(float persent) {
        this.originaalX = this.x;
        this.orignalY = this.y;
        this.resetX = this.x = RunnerManager.getScaleValue(this.x, persent);
        this.resetY = this.y = RunnerManager.getScaleValue(this.y, persent);
        this.getShape().rescale(persent);
    }

    public int getJointInfo() {
        return this.jointInfo;
    }

    public boolean isJointInfoThere() {
        return this.isJointInfoThere;
    }

    public int getOriginaalX() {
        return this.originaalX;
    }

    public void setOriginaalX(int originaalX) {
        this.originaalX = originaalX;
    }

    public int getOrignalY() {
        return this.orignalY;
    }

    public void setOrignalY(int orignalY) {
        this.orignalY = orignalY;
    }
}

