/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner.model;

import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.Shape;
import com.appon.runner.util.Util;
import com.indiagames.runnergame.Hero;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CircleShape
extends Shape {
    private int radius;

    public void deserilize(InputStream bis) throws Exception {
        super.deserilize(bis);
        this.radius = Util.read(bis, 2);
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(0xFF0000);
        g.fillArc(x, y, this.radius << 1, this.radius << 1, 0, 360);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getWidth() {
        return this.radius << 1;
    }

    public int getHeight() {
        return this.radius << 1;
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (Hero.getHeroState() == 1 ? Util.circleToRectangle(addedShape.getX() + this.radius + addedShape.getAdditionalX(), addedShape.getY() + this.radius + addedShape.getAdditionalY(), this.radius, rectX, rectY, rectWidth, rectHeight << 1) : Util.circleToRectangle(addedShape.getX() + this.radius + addedShape.getAdditionalX(), addedShape.getY() + this.radius + addedShape.getAdditionalY(), this.radius, rectX, rectY, rectWidth, rectHeight)) {
            return addedShape;
        }
        return null;
    }

    public void rescale(float persent) {
        if (this.isRescaled) {
            return;
        }
        this.isRescaled = true;
        this.radius = RunnerManager.getScaleValue(this.radius, persent);
    }
}

