/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.gtantra.GTantra;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;

public class LoadText {
    private static boolean isRTLText = false;
    private StringBuffer textReaderBuffer;
    byte[] tmpData;

    public static boolean isIsRTLText() {
        return isRTLText;
    }

    public String loadText(String fileName, int textId, int languageIndex) {
        try {
            isRTLText = languageIndex != 0;
            ByteArrayInputStream is = new ByteArrayInputStream(GTantra.getFileByteData(fileName));
            DataInputStream dis = new DataInputStream(is);
            this.tmpData = new byte[2];
            this.textReaderBuffer = new StringBuffer();
            int totalLanguagesPacked = this.read(dis, 1);
            int totalTextIds = this.read(dis, 2);
            if (totalLanguagesPacked == 0 || totalTextIds == 0) {
                throw new Exception("no languages or text id's are present in the file");
            }
            byte[] repData = new byte[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                repData[i] = (byte)this.read(dis, 1);
            }
            int langIndex = -1;
            String[] langRepresentations = new String[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                langRepresentations[i] = this.readString(dis, repData[i] & 0xFF);
            }
            langIndex = (byte)languageIndex;
            long[] languageOffsets = new long[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                languageOffsets[i] = this.read(dis);
            }
            if (langIndex != 0) {
                dis.skip(langIndex * totalTextIds * 2);
            }
            short[] tmpBytes = new short[totalTextIds];
            for (int i = 0; i < totalTextIds; ++i) {
                tmpBytes[i] = (short)this.read(dis, 2);
            }
            int bytesToSkip = totalTextIds * totalLanguagesPacked * 2 - langIndex * totalTextIds * 2 - totalTextIds * 2;
            if (bytesToSkip > 0) {
                dis.skip(bytesToSkip);
            }
            if (languageOffsets[langIndex] > 0L) {
                dis.skip(languageOffsets[langIndex]);
            }
            for (int i = 0; i < textId; ++i) {
                dis.skip(tmpBytes[i]);
            }
            String text = this.readString(dis, tmpBytes[textId] & 0xFFFF);
            tmpBytes = null;
            languageOffsets = null;
            try {
                dis.close();
                dis = null;
                ((InputStream)is).close();
                is = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            this.textReaderBuffer = null;
            langRepresentations = null;
            this.tmpData = null;
            return text;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error while loading text";
        }
    }

    public void loadText(Vector vector, String fileName, int languageIndex) {
        try {
            isRTLText = languageIndex != 0;
            ByteArrayInputStream is = new ByteArrayInputStream(GTantra.getFileByteData(fileName));
            DataInputStream dis = new DataInputStream(is);
            this.tmpData = new byte[2];
            this.textReaderBuffer = new StringBuffer();
            int totalLanguagesPacked = this.read(dis, 1);
            int totalTextIds = this.read(dis, 2);
            if (totalLanguagesPacked == 0 || totalTextIds == 0) {
                throw new Exception("no languages or text id's are present in the file");
            }
            byte[] repData = new byte[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                repData[i] = (byte)this.read(dis, 1);
            }
            int langIndex = -1;
            String[] langRepresentations = new String[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                langRepresentations[i] = this.readString(dis, repData[i] & 0xFF);
            }
            langIndex = (byte)languageIndex;
            long[] languageOffsets = new long[totalLanguagesPacked];
            for (int i = 0; i < totalLanguagesPacked; ++i) {
                languageOffsets[i] = this.read(dis);
            }
            if (langIndex != 0) {
                dis.skip(langIndex * totalTextIds * 2);
            }
            short[] tmpBytes = new short[totalTextIds];
            for (int i = 0; i < totalTextIds; ++i) {
                tmpBytes[i] = (short)this.read(dis, 2);
            }
            int bytesToSkip = totalTextIds * totalLanguagesPacked * 2 - langIndex * totalTextIds * 2 - totalTextIds * 2;
            if (bytesToSkip > 0) {
                dis.skip(bytesToSkip);
            }
            if (languageOffsets[langIndex] > 0L) {
                dis.skip(languageOffsets[langIndex]);
            }
            for (int i = 0; i < totalTextIds; ++i) {
                vector.addElement(this.readString(dis, tmpBytes[i] & 0xFFFF));
            }
            tmpBytes = null;
            languageOffsets = null;
            ((InputStream)is).close();
            is = null;
            dis.close();
            dis = null;
            this.textReaderBuffer = null;
            langRepresentations = null;
            this.tmpData = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getLanguageIndex(String[] langArray, String language) {
        if (language == null || language.length() == 0) {
            return -1;
        }
        for (int i = 0; i < langArray.length; ++i) {
            if (!language.toLowerCase().equals(langArray[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private String readString(DataInputStream is, int length) throws Exception {
        if (this.textReaderBuffer.length() > 0) {
            this.textReaderBuffer.delete(0, this.textReaderBuffer.length());
        }
        for (int i = 0; i < length; i += 2) {
            is.read(this.tmpData);
            this.textReaderBuffer.append((char)(((this.tmpData[1] & 0xFF) << 8) + (this.tmpData[0] & 0xFF)));
        }
        return this.textReaderBuffer.toString();
    }

    public int getItemIndex(String[] array, String item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].toLowerCase().equals(item.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private int read(InputStream is, int bytes) throws Exception {
        int value = 0;
        for (int i = 0; i < bytes; ++i) {
            value += (is.read() & 0xFF) << 8 * i;
        }
        return value;
    }

    private long read(InputStream is) throws Exception {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value += (long)((is.read() & 0xFF) << 8 * i);
        }
        return value;
    }
}

