/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.layout;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Util;
import com.appon.util.Serilizable;
import java.io.ByteArrayInputStream;

public class RelativeLayout
implements Serilizable {
    public static final int LEFT_TOP_OF_CONTROL = 0;
    public static final int RIGHT_BOTTOM_OF_CONTROL = 1;
    public static final int CENTER_OF_CONTROL = 2;
    public static final int ALLIGN_LEFT_TOP_OF_CONTROL = 3;
    public static final int ALLIGN_RIGHT_BOTTOM_OF_CONTROL = 4;
    public static final int LEFT_TOP_OF_CONTAINER = 5;
    public static final int RIGHT_BOTTOM_OF_CONTAINER = 6;
    public static final int CENTER_OF_CONTAINER = 7;
    private int relativeControlX = -1;
    private int relativeControlY = -1;
    private int relativeRelationX;
    private int relativeRelationY;
    private int additionalPaddingX;
    private int additionalPaddingY;
    private boolean scalePaddingX;
    private boolean scalePaddingY;
    public boolean reflectInOrigionalPosition = true;

    public int getAdditionalPaddingX() {
        return this.additionalPaddingX;
    }

    public void setReflectInOrigionalPosition(boolean reflectInOrigionalPosition) {
        this.reflectInOrigionalPosition = reflectInOrigionalPosition;
    }

    public void setAdditionalPaddingX(int additionalPaddingX) {
        this.additionalPaddingX = additionalPaddingX;
    }

    public int getAdditionalPaddingY() {
        return this.additionalPaddingY;
    }

    public void setAdditionalPaddingY(int additionalPaddingY) {
        this.additionalPaddingY = additionalPaddingY;
    }

    public int getRelativeControlX() {
        return this.relativeControlX;
    }

    public void setRelativeControlX(int relativeControl) {
        this.relativeControlX = relativeControl;
    }

    public int getRelativeControlY() {
        return this.relativeControlY;
    }

    public void setRelativeControlY(int relativeControl) {
        this.relativeControlY = relativeControl;
    }

    public int getRelativeRelationX() {
        return this.relativeRelationX;
    }

    public void setRelativeRelationX(int relativeRelationX) {
        this.relativeRelationX = relativeRelationX;
    }

    public int getRelativeRelationY() {
        return this.relativeRelationY;
    }

    public void setRelativeRelationY(int relativeRelationY) {
        this.relativeRelationY = relativeRelationY;
    }

    public boolean isScalePaddingX() {
        return this.scalePaddingX;
    }

    public void setScalePaddingX(boolean scalePaddingX) {
        this.scalePaddingX = scalePaddingX;
    }

    public boolean isScalePaddingY() {
        return this.scalePaddingY;
    }

    public void setScalePaddingY(boolean scalePaddingY) {
        this.scalePaddingY = scalePaddingY;
    }

    private void setX(Control c, int x) {
        c.setX(x);
        if (this.reflectInOrigionalPosition) {
            c.setOrigionalX(x);
        }
    }

    private void setY(Control c, int y) {
        c.setY(y);
        if (this.reflectInOrigionalPosition) {
            c.setOrigionalY(y);
        }
    }

    public void applyLayout(Container parent, Control currentControl) {
        boolean xAlligned = true;
        if (this.relativeRelationX != -1) {
            switch (this.relativeRelationX) {
                case 5: {
                    this.setX(currentControl, 0 + this.additionalPaddingX);
                    break;
                }
                case 6: {
                    this.setX(currentControl, this.additionalPaddingX + parent.getBoundWidth() - currentControl.getWidth());
                    break;
                }
                case 7: {
                    this.setX(currentControl, (parent.getBoundWidth() - currentControl.getWidth() >> 1) + this.additionalPaddingX);
                    break;
                }
                default: {
                    xAlligned = false;
                }
            }
        }
        if (!xAlligned) {
            Control foundControl = Util.findControl(Util.getRootControl(currentControl), this.relativeControlX);
            switch (this.relativeRelationX) {
                case 0: {
                    this.setX(currentControl, foundControl.getX() - currentControl.getWidth() + this.additionalPaddingX);
                    break;
                }
                case 3: {
                    this.setX(currentControl, foundControl.getX() + this.additionalPaddingX);
                    break;
                }
                case 4: {
                    this.setX(currentControl, foundControl.getX() + foundControl.getWidth() - currentControl.getWidth() + this.additionalPaddingX);
                    break;
                }
                case 1: {
                    this.setX(currentControl, foundControl.getX() + foundControl.getWidth() + this.additionalPaddingX);
                    break;
                }
                case 2: {
                    this.setX(currentControl, foundControl.getX() + (foundControl.getWidth() - currentControl.getWidth() >> 1) + this.additionalPaddingX);
                }
            }
        }
        boolean yAlligned = true;
        if (this.relativeRelationY != -1) {
            switch (this.relativeRelationY) {
                case 5: {
                    this.setY(currentControl, 0 + this.additionalPaddingY);
                    break;
                }
                case 6: {
                    this.setY(currentControl, parent.getBoundHeight() - currentControl.getHeight() + this.additionalPaddingY);
                    break;
                }
                case 7: {
                    this.setY(currentControl, (parent.getBoundHeight() - currentControl.getHeight() >> 1) + this.additionalPaddingY);
                    break;
                }
                default: {
                    yAlligned = false;
                }
            }
        }
        if (!yAlligned) {
            Control foundControl = Util.findControl(Util.getRootControl(currentControl), this.relativeControlY);
            switch (this.relativeRelationY) {
                case 0: {
                    this.setY(currentControl, this.additionalPaddingY + foundControl.getY() - currentControl.getHeight());
                    break;
                }
                case 1: {
                    this.setY(currentControl, this.additionalPaddingY + foundControl.getY() + foundControl.getHeight());
                    break;
                }
                case 2: {
                    this.setY(currentControl, this.additionalPaddingY + foundControl.getY() + (foundControl.getHeight() - currentControl.getHeight() >> 1));
                    break;
                }
                case 3: {
                    this.setY(currentControl, foundControl.getY() + this.additionalPaddingY);
                    break;
                }
                case 4: {
                    this.setY(currentControl, foundControl.getY() + foundControl.getHeight() - currentControl.getHeight() + this.additionalPaddingX);
                }
            }
        }
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.setRelativeControlX(Util.readSignedInt(bis, 2));
        this.setRelativeControlY(Util.readSignedInt(bis, 2));
        this.setRelativeRelationX(Util.readInt(bis, 1));
        this.setRelativeRelationY(Util.readInt(bis, 1));
        this.setAdditionalPaddingX(Util.readSignedInt(bis, 2));
        this.setAdditionalPaddingY(Util.readSignedInt(bis, 2));
        this.setScalePaddingX(Util.readBoolean(bis));
        this.setScalePaddingY(Util.readBoolean(bis));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1009;
    }

    public void port() {
        int scaleX = Util.getScaleX();
        int scaleY = Util.getScaleY();
        if (this.isScalePaddingX()) {
            this.setAdditionalPaddingX(Util.getScaleValue(this.getAdditionalPaddingX(), scaleX));
        }
        if (this.isScalePaddingY()) {
            this.setAdditionalPaddingY(Util.getScaleValue(this.getAdditionalPaddingY(), scaleY));
        }
    }
}

