/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner;

import com.appon.runner.RunnerListener;
import com.appon.runner.customize.Customize;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.model.EmptyCustom;
import com.appon.runner.model.Shape;
import com.appon.runner.model.ShapeGroup;
import com.appon.runner.util.Util;
import com.indiagames.runnergame.Constant;
import com.indiagames.runnergame.Hero;
import com.indiagames.runnergame.KnightTestEngine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class RunnerManager {
    private static RunnerManager manager;
    private static int quickplayLevelcounter;
    private Vector shapeList = new Vector();
    private Vector onScreenObjects = new Vector();
    private Vector requestAddObject = new Vector();
    private Vector requestRemoveObject = new Vector();
    ByteArrayInputStream levelData;
    private AddedShape nextShape;
    private int totalShapesAdded = 0;
    private int shapesConsumed = 0;
    public static boolean horizontalMovement;
    private RunnerListener listener;
    private int currentCamX;
    public static boolean isJointInfoPresent;
    private Vector sortedVector = new Vector();
    int OnscreenShapePos;
    int oldX = 0;
    private Vector quickPlayData = new Vector();
    private int quickPlayShiftX;
    private boolean isInQuickPlay = false;
    private int endShapeId;
    private boolean startNewQuickPlaySession = false;
    private static float portPercent;

    public static RunnerManager getManager() {
        if (manager == null) {
            manager = new RunnerManager();
        }
        return manager;
    }

    public void addShapeDynamically(AddedShape addedShape) {
        this.requestAddObject.addElement(addedShape);
    }

    public void removeAddedShape(AddedShape addedShape) {
    }

    public void setListener(RunnerListener listener) {
        this.listener = listener;
    }

    public RunnerListener getListener() {
        return this.listener;
    }

    public int getCurrentCamX() {
        return this.currentCamX;
    }

    public Vector getOnScreenObjects() {
        return this.onScreenObjects;
    }

    public void paint(Graphics g, int camY) {
        this.sortedVector.removeAllElements();
        this.sortedVector = this.getSortedObjects(this.onScreenObjects);
        int size = this.sortedVector.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.sortedVector.elementAt(i);
            shape.setAdditionalX(-RunnerManager.getManager().getCurrentCamX());
            shape.setAdditionalY(0);
            if (shape.getShape().isIsVisible() && shape.isIsVisible() && shape.getX() + shape.getAdditionalX() + shape.getShape().getWidth() >= 0 && shape.getX() + shape.getAdditionalX() <= Constant.SCREEN_WIDTH && shape.getY() + shape.getAdditionalY() - Constant.camera.getCamY() >= 0 && shape.getY() + shape.getAdditionalY() - Constant.camera.getCamY() <= Constant.SCREEN_HEIGHT) {
                shape.paint(g, camY);
                continue;
            }
            if (!(shape.getShape() instanceof ShapeGroup)) continue;
            shape.paint(g, camY);
        }
    }

    public boolean isAddedShapePresent(int id) {
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (shape.getId() != id) continue;
            return true;
        }
        return false;
    }

    public AddedShape getNxtBGShape(int hx, int currentY) {
        int closestShapeId = -1;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (!this.isShapeFromBg(shape.getShape())) continue;
            this.OnscreenShapePos = shape.getX() - this.getCurrentCamX();
            if (!(KnightTestEngine.isReverse ? this.OnscreenShapePos < hx && this.OnscreenShapePos >= 0 && currentY > shape.getY() : this.OnscreenShapePos > hx && this.OnscreenShapePos < Constant.SCREEN_WIDTH >> 1 && currentY > shape.getY())) continue;
            return shape;
        }
        return null;
    }

    public boolean isShapeOnScreen(int id, int hx, int hwidth) {
        int closestShapeId = -1;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(shape.getShape())) continue;
            this.OnscreenShapePos = shape.getX() - this.getCurrentCamX();
            if (this.OnscreenShapePos <= hx || this.OnscreenShapePos >= Constant.SCREEN_WIDTH >> 1 || (closestShapeId = shape.getShape().getId()) != id) continue;
            return true;
        }
        return false;
    }

    public boolean isShapeOnScreenForTut(int id, int hx, int hwidth) {
        int closestShapeId = -1;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(shape.getShape())) continue;
            this.OnscreenShapePos = shape.getX() - this.getCurrentCamX();
            if (this.OnscreenShapePos <= hx || this.OnscreenShapePos >= (Constant.SCREEN_WIDTH >> 1) + (Constant.HERO_HEIGHT << 1) || (closestShapeId = shape.getShape().getId()) != id) continue;
            return true;
        }
        return false;
    }

    public boolean isOnRect() {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape shape;
            if (!this.isHoleShape(((AddedShape)this.onScreenObjects.elementAt(i)).getShape()) || !Util.isRectCollision((shape = (AddedShape)this.onScreenObjects.elementAt(i)).getX(), shape.getY(), shape.getShape().getWidth(), shape.getShape().getHeight(), Hero.getHeroInstance().getCollisionX(), Hero.getHeroInstance().getCollisionY(), Hero.getHeroInstance().getHeroWidth() - (Hero.getHeroInstance().getHeroWidth() >> 2), Hero.getHeroInstance().getHeroHeight())) continue;
            return true;
        }
        return false;
    }

    public boolean checkInArray(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    private int findInsertLocation(int value, Vector sortedVect) {
        int left = 0;
        int right = sortedVect.size();
        int middle = 0;
        while (left < right) {
            middle = left + right >> 1;
            int valueAtMiddle = ((AddedShape)sortedVect.elementAt(middle)).getY();
            if (value == valueAtMiddle) {
                return middle;
            }
            if (right - left <= 1) {
                if (((AddedShape)sortedVect.elementAt(left)).getY() < value) {
                    return left;
                }
                return right;
            }
            if (value < valueAtMiddle) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    public Vector getSortedObjects(Vector vectorTosort) {
        int i;
        Vector<AddedShape> bgShapesVector = new Vector<AddedShape>();
        Vector<AddedShape> jumperShapesVector = new Vector<AddedShape>();
        Vector<AddedShape> sortedVecto = new Vector<AddedShape>();
        sortedVecto.removeAllElements();
        bgShapesVector.removeAllElements();
        jumperShapesVector.removeAllElements();
        int size = vectorTosort.size();
        for (i = 0; i < size; ++i) {
            AddedShape newShape = (AddedShape)vectorTosort.elementAt(i);
            if (this.isShapeFromBg(newShape.getShape()) && !this.checkInArray(Constant.staticColldableObjToLog, newShape.getShape().getId())) {
                if (newShape.getShape().getId() == Constant.JUMP_OBJECT_ID) {
                    jumperShapesVector.addElement(newShape);
                    continue;
                }
                bgShapesVector.addElement(newShape);
                continue;
            }
            if (newShape.getShape() instanceof ShapeGroup && ((ShapeGroup)newShape.getShape()).isContaineBGShape()) {
                bgShapesVector.addElement(newShape);
                continue;
            }
            int pos = this.findInsertLocation(newShape.getY(), sortedVecto);
            sortedVecto.insertElementAt(newShape, pos);
        }
        for (i = 0; i < jumperShapesVector.size(); ++i) {
            sortedVecto.insertElementAt((AddedShape)jumperShapesVector.elementAt(i), 0);
        }
        for (i = 0; i < bgShapesVector.size(); ++i) {
            sortedVecto.insertElementAt((AddedShape)bgShapesVector.elementAt(i), 0);
        }
        return sortedVecto;
    }

    public boolean isShapeFromBg(Shape shape) {
        for (int i = 0; i < Constant.BG_USED_SHAPES.length; ++i) {
            if (Constant.BG_USED_SHAPES[i] != shape.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isHoleShape(Shape shape) {
        for (int i = 0; i < Constant.PATCH_CUST_ID.length; ++i) {
            if (Constant.PATCH_CUST_ID[i] != shape.getId()) continue;
            return true;
        }
        return false;
    }

    public void insertObjectOnScreen(AddedShape addedShape) {
        CustomShape newShape;
        if (addedShape.getShape() instanceof ShapeGroup) {
            addedShape.setShape(((ShapeGroup)addedShape.getShape()).clone());
        }
        this.onScreenObjects.addElement(addedShape);
        if (addedShape.getShape() instanceof EmptyCustom && (newShape = Customize.getDynamicCustomClassObject(((CustomShape)addedShape.getShape()).getClassId())) != null) {
            newShape.setIsCollidable(addedShape.getShape().isIsCollidable());
            newShape.setId(addedShape.getShape().getId());
            addedShape.setShape(newShape);
            newShape.reset();
        }
        if (addedShape.getShape() instanceof ShapeGroup) {
            ShapeGroup group = (ShapeGroup)addedShape.getShape();
            Vector listAddedObjects = group.getShapeGroup();
            for (int i = 0; i < listAddedObjects.size(); ++i) {
                CustomShape newShape2;
                AddedShape object = (AddedShape)listAddedObjects.elementAt(i);
                if (!(object.getShape() instanceof EmptyCustom) || (newShape2 = Customize.getDynamicCustomClassObject(((CustomShape)object.getShape()).getClassId())) == null) continue;
                newShape2.setId(object.getShape().getId());
                newShape2.setIsCollidable(object.getShape().isIsCollidable());
                object.setShape(newShape2);
            }
            group.calculateHeight(addedShape);
            group.calculateWidth(addedShape);
            ((ShapeGroup)addedShape.getShape()).reset(addedShape);
        } else if (addedShape.getShape() instanceof CustomShape) {
            ((CustomShape)addedShape.getShape()).reset();
        }
        addedShape.setCollisionOccured(false);
        Customize.newShapeLoaded(addedShape.getShape());
    }

    public void update(int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        this.currentCamX = camX;
        if (this.startNewQuickPlaySession) {
            AddedShape lastShape = (AddedShape)this.onScreenObjects.elementAt(this.onScreenObjects.size() - 1);
            this.startNewQuickPlaySession = false;
            this.startNewQuickPlaySession(lastShape.getX() + lastShape.getShape().getWidth());
        }
        this.oldX = this.currentCamX;
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            int value;
            AddedShape object = (AddedShape)this.onScreenObjects.elementAt(i);
            object.update();
            object.setAdditionalX(0);
            object.setAdditionalY(0);
            if (this.isShapeEnteredInScreen(camX, camY, camWidth, camHeight, object) && this.getListener() != null) {
                this.getListener().shapeEnteredInScreen(object);
            }
            if (this.isOutSideOfScreen(camX, camY, camWidth, camHeight, object) && this.getListener() != null) {
                this.getListener().shapeRemovedFromScreen(object);
            }
            if ((value = this.checkCollision(object, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight)) >= 0) continue;
            --i;
        }
        this.checkRemovalNAddition();
    }

    public void updateAr(int camX, int camY, int camWidth, int camHeight, int[][] collsionArr) {
        this.currentCamX = camX;
        if (this.startNewQuickPlaySession) {
            AddedShape lastShape = (AddedShape)this.onScreenObjects.elementAt(this.onScreenObjects.size() - 1);
            this.startNewQuickPlaySession = false;
            this.startNewQuickPlaySession(lastShape.getX() + lastShape.getShape().getWidth());
        }
        this.oldX = this.currentCamX;
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape object = (AddedShape)this.onScreenObjects.elementAt(i);
            object.update();
            object.setAdditionalX(0);
            object.setAdditionalY(0);
            if (this.isOutSideOfScreen(camX, camY, camWidth, camHeight, object) && this.getListener() != null) {
                this.getListener().shapeRemovedFromScreen(object);
            }
            if (!this.isShapeEnteredInScreen(camX, camY, camWidth, camHeight, object)) continue;
            if (this.getListener() != null) {
                this.getListener().shapeEnteredInScreen(object);
            }
            int value = 0;
            for (int j = 0; j < collsionArr.length; ++j) {
                value = this.checkCollision(object, camX, camY, camWidth, camHeight, collsionArr[j][0], collsionArr[j][1], collsionArr[j][2], collsionArr[j][3]);
            }
            if (value >= 0) continue;
            --i;
        }
        this.checkRemovalNAddition();
    }

    public void checkRemovalNAddition() {
    }

    public void setCurrentCamX(int camX) {
        this.currentCamX = camX;
    }

    public void checkAddionalCollision(int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        this.currentCamX = camX;
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape object = (AddedShape)this.onScreenObjects.elementAt(i);
            if (object.getShape() instanceof ShapeGroup) {
                ShapeGroup group = (ShapeGroup)object.getShape();
                int size = group.getShapeGroup().size();
                for (int j = 0; j < size; ++j) {
                    AddedShape object1 = (AddedShape)group.getShapeGroup().elementAt(j);
                    object1.update();
                    if (object.getShape() instanceof ShapeGroup) {
                        object1.setAdditionalX(object.getX());
                        object1.setAdditionalY(object.getY());
                    }
                    this.checkCollision(object1, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight);
                }
                continue;
            }
            object.update();
            object.setAdditionalX(0);
            object.setAdditionalY(0);
            int value = this.checkCollision(object, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight);
            if (value >= 0) continue;
            --i;
        }
        this.checkRemovalNAddition();
    }

    private int checkCollision(AddedShape object, int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        if (KnightTestEngine.getInstance().getInGameStatus() != 0) {
            return 1;
        }
        if (object.getShape() instanceof ShapeGroup) {
            ShapeGroup group = (ShapeGroup)object.getShape();
            int size = group.getShapeGroup().size();
            for (int i = 0; i < size; ++i) {
                int value;
                AddedShape object1 = (AddedShape)group.getShapeGroup().elementAt(i);
                if (object.getShape() instanceof ShapeGroup) {
                    object1.setAdditionalX(object.getX());
                    object1.setAdditionalY(object.getY());
                }
                if ((value = this.checkCollision(object1, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight)) >= 0) continue;
                return 1;
            }
        } else if (heroWidth > 0 && heroHeight > 0 && object.getShape().isIsCollidable()) {
            AddedShape value = null;
            value = object.getShape().checkRelativeCollision(heroX, heroY, heroWidth, heroHeight, object);
            if (value != null && !value.isCollisionOccured() && object.getShape().isCollidable && this.getListener() != null) {
                value.setCollisionOccured(true);
                this.getListener().shapeCollisionOcurrent(value);
            }
        }
        return 1;
    }

    public boolean isOutSideOfScreen(int camX, int camY, int camWidth, int camHeight, AddedShape addedShape) {
        return addedShape.getX() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() > camWidth || addedShape.getX() + addedShape.getShape().getWidth() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() <= 0;
    }

    public boolean isShapeEnteredInScreen(int camX, int camY, int camWidth, int camHeight, AddedShape addedShape) {
        return addedShape.getX() + addedShape.getShape().getWidth() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() <= camWidth && addedShape.getX() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() >= 0 && !KnightTestEngine.isReverse || addedShape.getX() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() >= 0 && addedShape.getX() + addedShape.getShape().getWidth() + addedShape.getAdditionalX() - RunnerManager.getManager().getCurrentCamX() <= camWidth && KnightTestEngine.isReverse;
    }

    public void loadLevel(int levelIndex, InputStream is) throws Exception {
        int i;
        this.currentCamX = 0;
        this.startNewQuickPlaySession = false;
        this.isInQuickPlay = false;
        this.quickPlayShiftX = 0;
        this.shapeList.removeAllElements();
        this.onScreenObjects.removeAllElements();
        this.sortedVector.removeAllElements();
        this.shapesConsumed = 0;
        this.totalShapesAdded = 0;
        isJointInfoPresent = Util.readBool(is);
        int totalShapes = Util.read(is, 2);
        for (int i2 = 0; i2 < totalShapes; ++i2) {
            int objectType = Util.read(is, 1);
            Shape shape = Customize.getNewShapeObject(objectType);
            if (shape == null) {
                shape = new EmptyCustom();
            }
            if (shape instanceof ShapeGroup) {
                System.out.println();
            }
            if (shape instanceof CustomShape) {
                ((CustomShape)shape).setClassId(objectType);
            }
            shape.deserilize(is);
            this.shapeList.addElement(shape);
        }
        int totalLevels = Util.read(is, 2);
        int[] levelsLength = new int[totalLevels];
        for (i = 0; i < totalLevels; ++i) {
            levelsLength[i] = Util.read(is, 4);
        }
        for (i = 0; i < levelIndex; ++i) {
            is.skip(levelsLength[i]);
        }
        byte[] data = new byte[levelsLength[levelIndex]];
        is.read(data);
        this.levelData = new ByteArrayInputStream(data);
        this.totalShapesAdded = Util.read(this.levelData, 2);
        this.readShapeAllShapes();
        data = null;
        is.close();
        this.sortedVector.removeAllElements();
        this.sortedVector = this.getSortedObjects(this.onScreenObjects);
    }

    public void loadQuickPlayLevel(InputStream is, int endShapeId) throws Exception {
        int i;
        this.startNewQuickPlaySession = false;
        this.isInQuickPlay = true;
        this.quickPlayShiftX = 0;
        this.endShapeId = endShapeId;
        this.shapeList.removeAllElements();
        this.quickPlayData.removeAllElements();
        this.onScreenObjects.removeAllElements();
        this.shapesConsumed = 0;
        this.totalShapesAdded = 0;
        isJointInfoPresent = Util.readBool(is);
        int totalShapes = Util.read(is, 2);
        for (int i2 = 0; i2 < totalShapes; ++i2) {
            int objectType = Util.read(is, 1);
            Shape shape = Customize.getNewShapeObject(objectType);
            if (shape == null) {
                shape = new EmptyCustom();
            }
            if (shape instanceof CustomShape) {
                ((CustomShape)shape).setClassId(objectType);
            }
            shape.deserilize(is);
            this.shapeList.addElement(shape);
        }
        int totalLevels = Util.read(is, 2);
        int[] levelsLength = new int[totalLevels];
        for (i = 0; i < totalLevels; ++i) {
            levelsLength[i] = Util.read(is, 4);
        }
        for (i = 0; i < levelsLength.length; ++i) {
            byte[] data = new byte[levelsLength[i]];
            is.read(data);
            this.quickPlayData.addElement(data);
            data = null;
        }
        quickplayLevelcounter = 0;
        this.playNextQuickPlaySession(10);
        is.close();
    }

    private void startNewQuickPlaySession(int extraX) {
        this.shapesConsumed = 0;
        this.quickPlayShiftX = extraX;
        if (++quickplayLevelcounter % 4 == 0) {
            int randomLevel = com.appon.util.Util.getRandomNumber(31, this.quickPlayData.size() - 1);
            this.playNextQuickPlaySession(randomLevel);
        } else {
            int randomLevel = com.appon.util.Util.getRandomNumber(10, 29);
            this.playNextQuickPlaySession(randomLevel);
        }
    }

    private void playNextQuickPlaySession(int index) {
        try {
            this.levelData = new ByteArrayInputStream((byte[])this.quickPlayData.elementAt(index));
            this.totalShapesAdded = Util.read(this.levelData, 2);
            this.readShape();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getScaleValue(float value, float scale) {
        value += value * scale / 100.0f;
        return (int)Math.ceil(value);
    }

    public void portAddedShape(float percent, AddedShape addedShape) {
        addedShape.rescale(percent);
        if (addedShape.getShape() instanceof ShapeGroup) {
            this.portShapeGroup(percent, (ShapeGroup)addedShape.getShape());
        }
    }

    public void portShapeGroup(float percent, ShapeGroup shapeGroup) {
        shapeGroup.rescale(percent);
    }

    public static void setPortPercent(float portPercent) {
        RunnerManager.portPercent = portPercent;
    }

    public AddedShape getAddedShapeByID(int id) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape addedShape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (id != addedShape.getId()) continue;
            return addedShape;
        }
        return null;
    }

    public boolean readShape() {
        try {
            if (this.shapesConsumed < this.totalShapesAdded) {
                ++this.shapesConsumed;
                this.nextShape = new AddedShape();
                this.nextShape.deserilize(this.levelData);
                if (this.nextShape.getShape() instanceof ShapeGroup) {
                    ((ShapeGroup)this.nextShape.getShape()).calculateHeight(this.nextShape);
                    ((ShapeGroup)this.nextShape.getShape()).calculateWidth(this.nextShape);
                }
                this.portAddedShape(portPercent, this.nextShape);
                if (isJointInfoPresent) {
                    AddedShape jointedToShape;
                    int jointedTo = this.nextShape.getJointInfo();
                    if (this.nextShape.isJointInfoThere() && (jointedToShape = this.getAddedShapeByID(this.nextShape.getId())) != null) {
                        this.nextShape.setX(jointedToShape.getX() + jointedToShape.getShape().getWidth());
                    }
                }
                this.nextShape.setX(this.nextShape.getX() + this.quickPlayShiftX);
                if (this.isInQuickPlay && this.nextShape.getShape().getId() == this.endShapeId) {
                    return this.readShape();
                }
                return true;
            }
            this.nextShape = null;
            if (this.isInQuickPlay) {
                this.startNewQuickPlaySession = true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Vector getShapeList() {
        return this.shapeList;
    }

    public Shape findShape(int shapeId) {
        for (int i = 0; i < this.shapeList.size(); ++i) {
            Shape object = (Shape)this.shapeList.elementAt(i);
            if (object.getId() != shapeId) continue;
            return object;
        }
        return null;
    }

    public void readShapeAllShapes() {
        try {
            while (this.shapesConsumed < this.totalShapesAdded) {
                ++this.shapesConsumed;
                this.nextShape = new AddedShape();
                this.nextShape.deserilize(this.levelData);
                if (this.nextShape.getShape() instanceof ShapeGroup) {
                    ((ShapeGroup)this.nextShape.getShape()).calculateHeight(this.nextShape);
                    ((ShapeGroup)this.nextShape.getShape()).calculateWidth(this.nextShape);
                }
                this.portAddedShape(portPercent, this.nextShape);
                if (isJointInfoPresent) {
                    AddedShape jointedToShape;
                    int jointedTo = this.nextShape.getJointInfo();
                    if (this.nextShape.isJointInfoThere() && (jointedToShape = this.getAddedShapeByID(this.nextShape.getId())) != null) {
                        this.nextShape.setX(jointedToShape.getX() + jointedToShape.getShape().getWidth());
                    }
                }
                this.nextShape.setX(this.nextShape.getX() + this.quickPlayShiftX);
                this.nextShape.reset();
                this.insertObjectOnScreen(this.nextShape);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        quickplayLevelcounter = 0;
        horizontalMovement = true;
        isJointInfoPresent = false;
    }
}

