/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner.util;

import com.appon.runner.RunnerManager;
import java.io.InputStream;

public class Util {
    public static StringBuffer stringBuffer = new StringBuffer();

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static int getTextValue(String text) {
        try {
            return Integer.parseInt(text.trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static byte[] intToBytes(int i, int noofBytes) {
        boolean negative = false;
        if (i < 0) {
            negative = true;
            i *= -1;
        }
        byte[] dword = new byte[1];
        switch (noofBytes) {
            case 1: {
                dword = new byte[]{(byte)(i & 0xFF)};
                break;
            }
            case 2: {
                dword = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF)};
                break;
            }
            case 3: {
                dword = new byte[3];
                dword[0] = (byte)(i & 0xFF);
                dword[1] = (byte)(i >> 8 & 0xFF);
                if (negative) {
                    dword[2] = 1;
                    break;
                }
                dword[2] = 0;
                break;
            }
            case 4: {
                dword = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
            }
        }
        return dword;
    }

    public static int read(InputStream fis, int noofBytes) throws Exception {
        byte[] data = new byte[noofBytes];
        fis.read(data);
        return Util.byteToint(data, noofBytes);
    }

    public static int bytesToIntWithSign(InputStream fis, int numOfBytes) throws Exception {
        int value = Util.read(fis, numOfBytes);
        int signBit = 0;
        int valueWitoutSign = value;
        if (numOfBytes == 1) {
            signBit = value & 0x80;
            valueWitoutSign &= 0x7F;
        } else if (numOfBytes == 2) {
            signBit = value & 0x8000;
            valueWitoutSign &= Short.MAX_VALUE;
        } else if (numOfBytes == 3) {
            signBit = value & 0x800000;
            valueWitoutSign &= 0x7FFFFF;
        } else if (numOfBytes == 4) {
            signBit = value & 0x800000;
            valueWitoutSign &= 0x7FFFFF;
        }
        if (signBit > 0) {
            valueWitoutSign = -valueWitoutSign;
        }
        return valueWitoutSign;
    }

    public static int byteToint(byte[] temp, int noofBytes) {
        int _lib_pOffset = 0;
        switch (noofBytes) {
            case 1: {
                _lib_pOffset = temp[0] & 0xFF;
                break;
            }
            case 2: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                break;
            }
            case 3: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                if (temp[2] != 1) break;
                _lib_pOffset *= -1;
                break;
            }
            case 4: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                _lib_pOffset += (temp[2] & 0xFF) << 16;
                _lib_pOffset += (temp[3] & 0xFF) << 24;
            }
        }
        return _lib_pOffset;
    }

    public static String readString(InputStream bis) throws Exception {
        int length = Util.read(bis, 1);
        if (length == 0) {
            return "";
        }
        stringBuffer.delete(0, stringBuffer.length());
        for (int i = 0; i < length; ++i) {
            stringBuffer.append((char)bis.read());
        }
        return stringBuffer.toString();
    }

    public static boolean readBool(InputStream bis) throws Exception {
        int value = Util.read(bis, 1);
        return value == 1;
    }

    public static boolean isRectCollisionWithoutCamera(int xPos1, int ypos1, int width1, int height1, int xPos2, int ypos2, int width2, int height2) {
        if (xPos1 > xPos2 + width2 || xPos1 + width1 < xPos2) {
            return false;
        }
        return ypos1 <= ypos2 + height2 && ypos1 + height1 >= ypos2;
    }

    public static boolean isRectCollision(int xPos1, int ypos1, int width1, int height1, int xPos2, int ypos2, int width2, int height2) {
        if ((xPos1 -= RunnerManager.getManager().getCurrentCamX()) > xPos2 + width2 || xPos1 + width1 < xPos2) {
            return false;
        }
        return ypos1 <= ypos2 + height2 && ypos1 + height1 >= ypos2;
    }

    public static boolean singleWholeRectCollision(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return Util.isInRect(x2, y2, width2, height2, x1, y1) || Util.isInRect(x2, y2, width2, height2, x1 + width1, y1) || Util.isInRect(x2, y2, width2, height2, x1, y1 + height1) || Util.isInRect(x2, y2, width2, height2, x1 + width1, y1 + height1);
    }

    public static boolean singleRectCollision(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return Util.isInRect(x2, y2, width2, height2, x1, y1) || Util.isInRect(x2, y2, width2, height2, x1 + width1, y1) || Util.isInRect(x2, y2, width2, height2, x1, y1 + height1) || Util.isInRect(x2, y2, width2, height2, x1 + width1, y1 + height1);
    }

    public static boolean lineToRectangle(int x1, int y1, int x2, int y2, int xRect, int yRect, int width, int height) {
        int xBL = xRect;
        int yBL = yRect;
        int xTR = xRect + width;
        int yTR = yRect + height;
        if ((x1 -= RunnerManager.getManager().getCurrentCamX()) > xTR && x2 > xTR) {
            return false;
        }
        if (x1 < xBL && x2 < xBL) {
            return false;
        }
        if (y1 > yTR && y2 > yTR) {
            return false;
        }
        if (y1 < yBL && y2 < yBL) {
            return false;
        }
        int value1 = Util.getFx(x1, y1, x2, y2, xBL, yBL);
        int value2 = Util.getFx(x1, y1, x2, y2, xTR, yBL);
        int value3 = Util.getFx(x1, y1, x2, y2, xBL, yTR);
        int value4 = Util.getFx(x1, y1, x2, y2, xTR, yTR);
        return (value1 >= 0 || value2 >= 0 || value3 >= 0 || value4 >= 0) && (value1 <= 0 || value2 <= 0 || value3 <= 0 || value4 <= 0);
    }

    public static int getFx(int x1, int y1, int x2, int y2, int x, int y) {
        return (y2 - y1) * x + (x1 - x2) * y + (x2 * y1 - x1 * y2);
    }

    public static boolean circleToRectangle(int cx, int cy, int r, int x1, int y1, int width, int height) {
        int circleDistanceX = Math.abs((cx -= RunnerManager.getManager().getCurrentCamX()) - x1 - width / 2);
        int circleDistanceY = Math.abs(cy - y1 - height / 2);
        if (circleDistanceX > width / 2 + r) {
            return false;
        }
        if (circleDistanceY > height / 2 + r) {
            return false;
        }
        if (circleDistanceX <= width / 2) {
            return true;
        }
        if (circleDistanceY <= height / 2) {
            return true;
        }
        int cornerDistance_sq = (circleDistanceX - width / 2) * (circleDistanceX - width / 2) + (circleDistanceY - height / 2) * (circleDistanceY - height / 2);
        return cornerDistance_sq <= (r ^ r);
    }
}

