/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gtantra;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsUtil {
    public static final int ORIGINAL = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 4;
    public static final int MIRROR = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int HCENTER = 16;
    public static final int VCENTER = 64;
    public static final int BASELINE = 256;
    private static int counter = 0;

    public static Image getResizedBitmap(Image bm, int newHeight, int newWidth) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Image resizedBitmap = Image.createImage((Image)bm, (int)0, (int)0, (int)width, (int)height, (int)0);
        return resizedBitmap;
    }

    public static void drawRegionTest(Graphics g, Image bitmap, int xPos, int yPos, int width, int height, int transform, int x, int y, int anchor) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        g.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, x, y, anchor);
    }

    public static void drawRegionTest(Graphics g, Image bitmap, float x, float y, int transform, int anchor) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        g.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, (int)x, (int)y, anchor);
    }

    public static void drawRegion(Graphics g, Image bitmap, int xPos, int yPos, int width, int height, int transform, int x, int y, int anchor, int percentX, int percentYObject) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        g.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, x, y, anchor);
    }

    public static void paintDrawRegionCustomizeAnimation(Graphics g, Image bitmap, int x, int y, int anchor, int resizePersentX, int resizePercentY) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = width * resizePersentX / 100;
        int newHeight = height * resizePercentY / 100;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        if ((anchor & 2) != 0) {
            x -= newWidth;
        }
        if ((anchor & 8) != 0) {
            y -= newHeight;
        }
        if ((anchor & 0x10) != 0) {
            x -= newWidth >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y -= newHeight >> 1;
        }
        if ((anchor & 0x100) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(bitmap, x, y, 0);
    }

    public static void drawImage(Graphics g, Image bitmap, long l, int y, long centerX, int centerY, int anchor, int angle, boolean isScale, float scalePercentage) {
        if ((anchor & 2) != 0) {
            l -= (long)bitmap.getWidth();
        }
        if ((anchor & 8) != 0) {
            y -= bitmap.getHeight();
        }
        if ((anchor & 0x10) != 0) {
            l -= (long)(bitmap.getWidth() >> 1);
        }
        if ((anchor & 0x40) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        if ((anchor & 0x100) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        if (isScale) {
            if (angle != 0) {
                GraphicsUtil.paintRoatateRescaleImage(g, bitmap, l, y, centerX, centerY, angle, scalePercentage);
            }
        } else if (angle != 0) {
            GraphicsUtil.rotateBitmap(g, bitmap, angle, (int)l, y, 80);
        } else {
            g.drawImage(bitmap, (int)l, y, 0);
        }
    }

    public static void rotateBitmap(Graphics g, Image bitmap, int angle, int x, int y, int anchor) {
        Image oldBitmap = bitmap;
        int w = oldBitmap.getWidth();
        int h = oldBitmap.getHeight();
        oldBitmap = Image.createImage((Image)oldBitmap, (int)0, (int)0, (int)w, (int)h, (int)0);
        if ((anchor & 2) != 0) {
            x -= oldBitmap.getWidth();
        }
        if ((anchor & 8) != 0) {
            y -= oldBitmap.getHeight();
        }
        if ((anchor & 0x10) != 0) {
            x -= oldBitmap.getWidth() >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y -= oldBitmap.getHeight() >> 1;
        }
        if ((anchor & 0x100) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(oldBitmap, x, y, 0);
    }

    public static void paintRoatateRescaleImage(Graphics g, Image bitmap, long x, int y, long centerX, int centerY, int angle, float percentage) {
        float width = bitmap.getWidth();
        float height = bitmap.getHeight();
        float newWidth = width * percentage / 100.0f;
        float newHeight = height * percentage / 100.0f;
        float scaleWidth = newWidth / width;
        float scaleHeight = newHeight / height;
        g.drawImage(bitmap, (int)x, y, 0);
    }

    public static void drawRegion(Graphics canvas, Image bitmap, int xPos, int yPos, int width, int height, int transform, int x, int y, int anchor) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        canvas.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, x, y, anchor);
    }

    public static void drawRegion(Graphics g, Image bitmap, float x, float y, int transform, int anchor) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        g.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, (int)x, (int)y, anchor);
    }

    public static void drawScaledRegion(Graphics g, Image bitmap, int x, int y, int transform, int anchorObject, int percenategeX, int percenategeY, boolean resizeBoth) {
        int t = 0;
        if ((transform & 8) != 0 && (transform & 2) != 0) {
            t = 1;
        } else if ((transform & 2) != 0) {
            t = 3;
        } else if ((transform & 8) != 0) {
            t = 2;
        }
        g.drawRegion(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), t, x, y, 0);
    }

    public static void paintFrameCustomizeAnimation(Graphics g, Image bitmap, int x, int y, int anchor, int resizePersentX, int resizePercentY) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = width * resizePersentX / 100;
        int newHeight = height * resizePercentY / 100;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        if ((anchor & 2) != 0) {
            x -= newWidth;
        }
        if ((anchor & 8) != 0) {
            y -= newHeight;
        }
        if ((anchor & 0x10) != 0) {
            x -= newWidth >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y -= newHeight >> 1;
        }
        if ((anchor & 0x100) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(bitmap, x += width - newWidth, y, 0);
    }

    public static void paintCustomizeAnimation(Graphics g, Image bitmap, int x, int y, int anchor, int resizePersentX, int resizePercentY) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = width * resizePersentX / 100;
        int newHeight = height * resizePercentY / 100;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        if ((anchor & 2) != 0) {
            x -= newWidth;
        }
        if ((anchor & 8) != 0) {
            y -= newHeight;
        }
        if ((anchor & 0x10) != 0) {
            x -= newWidth >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y -= newHeight >> 1;
        }
        if ((anchor & 0x100) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(bitmap, x += width - newWidth, y += Math.abs(height - newHeight), 0);
    }

    public static void fillArc(Graphics g, int x, int y, int width, int height, int startAngle, int endAngle) {
        g.drawArc(x, y, x + width, y + height, startAngle, endAngle);
    }

    public static void drawArc(Graphics g, int x, int y, int width, int height, int startAngle, int endAngle) {
        g.drawArc(x + (width >> 1), y + (height >> 1), width >> 1, width >> 1, 0, 360);
    }

    private static void drawArcUtil(Graphics g, int x, int y, int r, int startAngle, int endAngle) {
        g.drawArc(x - (r >> 1), y - (r >> 1), x + (r >> 1), y + (r >> 1), startAngle, endAngle);
    }

    public static void drawCircleEffect(Graphics g, int cx, int cy, int r, int startAngle, int endAngle) {
        float outerStroke = 20.0f;
        GraphicsUtil.drawArcUtil(g, cx, cy, r, startAngle, endAngle);
        GraphicsUtil.drawArcUtil(g, cx, cy, (int)((float)r - (outerStroke - 4.0f)), startAngle, endAngle);
        GraphicsUtil.drawArcUtil(g, cx, cy, r, startAngle, endAngle);
    }

    public static void drawRect(float x, float y, float width, float height, Graphics c) {
        c.drawRect((int)x, (int)y, (int)(x + width), (int)(y + height));
    }

    public static void fillRect(float x, float y, float width, float height, Graphics c) {
        c.fillRect((int)x, (int)y, (int)(x + width), (int)(y + height));
    }

    public static void drawRGB(int[] rgbData, int offset, int scanLength, int x, int y, int width, int height, boolean processAlpha, Graphics c) {
        Image i = Image.createRGBImage((int[])rgbData, (int)width, (int)height, (boolean)processAlpha);
        c.drawImage(i, x, y, 0);
    }

    public static void drawLine(float x, float y, float endx, float endy, Graphics c) {
        c.drawLine((int)x, (int)y, (int)endx, (int)endy);
    }

    public static void drawImage(Graphics g, Image bitmap, int x, int y, int anchor) {
        if ((anchor & 2) != 0) {
            x -= bitmap.getWidth();
        }
        if ((anchor & 8) != 0) {
            y -= bitmap.getHeight();
        }
        if ((anchor & 0x10) != 0) {
            x -= bitmap.getWidth() >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(bitmap, x, y, 0);
    }

    public static void drawImage(Graphics g, Image bitmap, long l, int y, int anchor) {
        if ((anchor & 2) != 0) {
            l -= (long)bitmap.getWidth();
        }
        if ((anchor & 8) != 0) {
            y -= bitmap.getHeight();
        }
        if ((anchor & 0x10) != 0) {
            l -= (long)(bitmap.getWidth() >> 1);
        }
        if ((anchor & 0x40) != 0) {
            y -= bitmap.getHeight() >> 1;
        }
        g.drawImage(bitmap, (int)l, y, 0);
    }

    public static void fillTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
    }

    public static void setClip(Graphics c, int x, int y, int width, int height) {
    }

    public static void drawRadar(Graphics g, int x, int y, int r) {
    }

    public static void drawRoundRect(float x, float y, float width, float height, Graphics c) {
        c.drawRoundRect((int)x, (int)y, (int)(x + width), (int)(y + height), 5, 5);
    }

    public static void fillRoundRect(float x, float y, float width, float height, Graphics c) {
        c.fillRoundRect((int)x, (int)y, (int)(x + width), (int)(y + height), 5, 5);
    }

    public static void fillRoundRect(float x, float y, float width, float height, Graphics c, int cerve) {
        c.fillRoundRect((int)x, (int)y, (int)(x + width), (int)(y + height), cerve, cerve);
    }

    public static void fillRoundRect(int x, int y, int width, int height, int roundX, int roundY, Graphics c) {
        c.fillRoundRect(x, y, x + width, y + height, roundX, roundY);
    }

    public static void drawRoundRect(int x, int y, int width, int height, Graphics c) {
        c.drawRoundRect(x, y, x + width, y + height, 5, 5);
    }

    public static void drawRoundRect(int x, int y, int width, int height, int roundX, int roundY, Graphics c) {
        c.drawRoundRect(x, y, x + width, y + height, roundX, roundY);
    }

    public static void drawBitmap(Graphics g, Image image, int i, int i0, int i1) {
        g.drawImage(image, i, i0, i1);
    }
}

