/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.EventManager;
import com.appon.miniframework.MenuSerilize;
import com.appon.miniframework.ScrollableContainer;
import com.appon.miniframework.Util;
import com.appon.miniframework.controls.TabButton;
import com.appon.miniframework.controls.TabPane;
import com.appon.miniframework.exception.OperationNotSupported;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TabControl
extends Container {
    private Vector tabPane = new Vector();
    private int selectedIndex = 0;
    private boolean isSelectionOnTabButton = false;
    int maxTabButtonHeight = 0;
    public static final int LEFT_ALLIGNMENT = 0;
    public static final int RIGHT_ALLIGNMENT = 1;
    public static final int CENTER_ALLIGNMENT = 2;
    private int tabButtonAllignment = 2;
    private int startX;
    private int padding;
    private int highlightButtonIndex = 0;

    public TabControl(int id) {
        super(id);
    }

    public void setEventManager(EventManager manager) {
        super.setEventManager(manager);
        for (int idx = 0; idx < this.tabPane.size(); ++idx) {
            Control control = (Control)this.tabPane.elementAt(idx);
            control.setEventManager(manager);
        }
    }

    public TabButton getSelectedTabButton() {
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            return this.getTabButton(this.selectedIndex);
        }
        return null;
    }

    public void port() {
        super.port();
        for (int i = 0; i < this.tabPane.size(); ++i) {
            TabPane pane = (TabPane)this.tabPane.elementAt(i);
            pane.port();
        }
    }

    public int getTabButtonPanelHeight() {
        return this.maxTabButtonHeight;
    }

    public ScrollableContainer getSelectedTabBody() {
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            return this.getContainer(this.selectedIndex);
        }
        return null;
    }

    public TabPane getSelectedTabPane() {
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            return (TabPane)this.tabPane.elementAt(this.selectedIndex);
        }
        return null;
    }

    public void takeScrollBackup() {
        for (int i = 0; i < this.tabPane.size(); ++i) {
            TabPane object = (TabPane)this.tabPane.elementAt(i);
            object.takeScrollBackup();
        }
    }

    public void restoreScrollBackup() {
        for (int i = 0; i < this.tabPane.size(); ++i) {
            TabPane object = (TabPane)this.tabPane.elementAt(i);
            object.restoreScrollBackup();
        }
    }

    private ScrollableContainer getContainer(int index) {
        return ((TabPane)this.tabPane.elementAt(index)).getContainer();
    }

    private TabButton getTabButton(int index) {
        return ((TabPane)this.tabPane.elementAt(index)).getTabButton();
    }

    public void paint(Graphics g) {
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            this.getContainer(this.selectedIndex).paintUI(g);
        }
        for (int i = 0; i < this.tabPane.size(); ++i) {
            TabButton button = this.getTabButton(i);
            if (this.selectedIndex == i) continue;
            button.paint(g, i == this.highlightButtonIndex && this.isSelectionOnTabButton && this.isSelected());
        }
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            TabButton button = this.getTabButton(this.selectedIndex);
            button.paint(g, this.selectedIndex == this.highlightButtonIndex && this.isSelectionOnTabButton && this.isSelected());
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void selectTabPane(TabPane pane) {
        int index = this.tabPane.indexOf(pane);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
        this.isSelectionOnTabButton = false;
    }

    public boolean keyPressed(int keycode, int gameKey) {
        if (this.isSelectionOnTabButton && this.tabPane.size() > 0) {
            int backupIndex = this.selectedIndex;
            if (gameKey == 2) {
                this.isSelectionOnTabButton = false;
                this.getContainer(this.selectedIndex).setSelected(true);
                return true;
            }
            if (gameKey == 1) {
                if (--backupIndex < 0) {
                    backupIndex = this.tabPane.size() - 1;
                }
            } else if (gameKey == 6 && ++backupIndex > this.tabPane.size() - 1) {
                backupIndex = 0;
            }
            if (this.selectedIndex != backupIndex) {
                this.setSelectedIndex(backupIndex);
            }
        } else if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            ScrollableContainer c = this.getContainer(this.selectedIndex);
            boolean handle = ((Control)c).keyPressed(keycode, gameKey);
            if (!handle && gameKey == 5) {
                handle = true;
                this.getContainer(this.selectedIndex).setSelected(false);
                this.isSelectionOnTabButton = true;
            } else if (!(handle || gameKey != 1 && gameKey != 6 || this.tabPane.size() <= 1)) {
                this.isSelectionOnTabButton = true;
                if (gameKey == 1 && this.selectedIndex > 0 || gameKey == 6 && this.selectedIndex < this.tabPane.size() - 1) {
                    this.getContainer(this.selectedIndex).setSelected(false);
                    if (gameKey == 1) {
                        this.getContainer(this.selectedIndex - 1).setSelected(true);
                    } else {
                        this.getContainer(this.selectedIndex + 1).setSelected(true);
                    }
                }
                return this.keyPressed(keycode, gameKey);
            }
            return handle;
        }
        return false;
    }

    public boolean pointerPressed(int x, int y) {
        if (Util.isInRect(0, 0, this.getWidth(), this.maxTabButtonHeight, x -= this.getX(), y -= this.getY())) {
            for (int i = 0; i < this.tabPane.size(); ++i) {
                TabButton button = this.getTabButton(i);
                if (!Util.isInRect(button.getX(), 0, button.getWidth(), this.maxTabButtonHeight, x, y)) continue;
                this.highlightButtonIndex = i;
                this.isSelectionOnTabButton = true;
                return true;
            }
        } else if (Util.isInRect(0, this.maxTabButtonHeight, this.getWidth(), this.getHeight() - this.maxTabButtonHeight, x, y)) {
            this.isSelectionOnTabButton = false;
            if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
                return this.getContainer(this.selectedIndex).pointerPressed(x, y);
            }
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (Util.isInRect(0, 0, this.getWidth(), this.maxTabButtonHeight, x -= this.getX(), y -= this.getY())) {
            for (int i = 0; i < this.tabPane.size(); ++i) {
                TabButton button = this.getTabButton(i);
                if (i == this.selectedIndex || !Util.isInRect(button.getX(), 0, button.getWidth(), this.maxTabButtonHeight, x, y) || ScrollableContainer.fromPointerDrag) continue;
                this.setSelectedIndex(i);
                return true;
            }
        } else if (Util.isInRect(0, this.maxTabButtonHeight, this.getWidth(), this.getHeight() - this.maxTabButtonHeight, x, y) && this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            this.isSelectionOnTabButton = false;
            return this.getContainer(this.selectedIndex).pointerReleased(x, y);
        }
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        if (!Util.isInRect(0, 0, this.getWidth(), this.maxTabButtonHeight, x -= this.getX(), y -= this.getY()) && Util.isInRect(0, this.maxTabButtonHeight, this.getWidth(), this.getHeight() - this.maxTabButtonHeight, x, y) && this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            return this.getContainer(this.selectedIndex).pointerDragged(x, y);
        }
        return false;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        for (int i = 0; i < this.tabPane.size(); ++i) {
            TabButton button = this.getTabButton(i);
            if (selectedIndex == i) {
                button.setSelected(true);
                continue;
            }
            button.setSelected(false);
        }
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            this.getContainer(this.selectedIndex).setSelected(false);
        }
        this.highlightButtonIndex = this.selectedIndex;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            if (this.isSelectionOnTabButton) {
                this.getSelectedTabBody().setSelected(false);
            } else {
                this.getSelectedTabBody().setSelected(true);
            }
        } else {
            this.getSelectedTabBody().setSelected(false);
        }
    }

    public int getClassCode() {
        return 1016;
    }

    public void addNewTab(int tabPaneId, int tabBodyContainerId) {
        TabPane pane = new TabPane(tabPaneId, tabBodyContainerId);
        pane.setParent(this);
        this.tabPane.addElement(pane);
    }

    public void showNotify() {
        super.showNotify();
        for (int i = 0; i < this.tabPane.size(); ++i) {
            ScrollableContainer container = this.getContainer(i);
            if (i == this.selectedIndex) continue;
            ((Control)container).showNotify();
        }
        if (this.tabPane.size() > 0 && this.selectedIndex != -1) {
            this.getContainer(this.selectedIndex).showNotify();
            this.setSelectedIndex(this.selectedIndex);
        }
        this.isSelectionOnTabButton = true;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getTabButtonAllignment() {
        return this.tabButtonAllignment;
    }

    public void setTabButtonAllignment(int tabButtonAllignment) {
        this.tabButtonAllignment = tabButtonAllignment;
    }

    public void hideNotify() {
        super.hideNotify();
        for (int i = 0; i < this.tabPane.size(); ++i) {
            ScrollableContainer container = this.getContainer(i);
            if (i == this.selectedIndex) continue;
            ((Control)container).hideNotify();
        }
        if (this.selectedIndex != -1 && this.selectedIndex < this.tabPane.size()) {
            this.getContainer(this.selectedIndex).hideNotify();
        }
    }

    private int getStartX(int index) {
        int _x = this.startX;
        if (index >= 0 && index < this.tabPane.size()) {
            for (int i = 0; i < index; ++i) {
                TabButton button = this.getTabButton(i);
                _x += button.getWidth();
            }
            if (index > 0) {
                _x += this.padding * index;
            }
        }
        return _x;
    }

    public void resize() {
        TabButton button;
        int i;
        super.resize();
        int _width = 0;
        for (i = 0; i < this.tabPane.size(); ++i) {
            button = this.getTabButton(i);
            button.resize();
            if (this.maxTabButtonHeight < button.getHeight()) {
                this.maxTabButtonHeight = button.getHeight();
            }
            _width += button.getWidth();
        }
        if (this.tabPane.size() > 0) {
            _width += this.padding * (this.tabPane.size() - 1);
        }
        this.startX = this.tabButtonAllignment == 2 ? this.getWidth() - _width >> 1 : (this.tabButtonAllignment == 0 ? 0 : this.getWidth() - _width);
        for (i = 0; i < this.tabPane.size(); ++i) {
            ScrollableContainer container = this.getContainer(i);
            container.setSizeSettingX(2);
            container.setSizeSettingY(2);
            container.setWidth(this.getWidth());
            container.setHeight(this.getHeight() - this.maxTabButtonHeight);
            ((Control)container).resize();
            container.setPoistion(0, this.maxTabButtonHeight);
        }
        for (i = 0; i < this.tabPane.size(); ++i) {
            button = this.getTabButton(i);
            button.setX(this.getStartX(i));
            button.setY(this.maxTabButtonHeight - button.getHeight());
        }
    }

    public int getSize() {
        return this.tabPane.size();
    }

    public Control getChild(int index) {
        return (Control)this.tabPane.elementAt(index);
    }

    public int getScrolledX() {
        return 0;
    }

    public int getScrolledY() {
        return 0;
    }

    public int getChildrenIndex(Control control) {
        return this.tabPane.indexOf(control);
    }

    public void removeChildren(Control children) {
        int index = this.getChildrenIndex(children);
        if (index != -1) {
            this.tabPane.removeElementAt(index);
        }
        if (this.getSelectedIndex() >= this.tabPane.size()) {
            this.setSelectedIndex(0);
        }
    }

    public void addChildrenAt(Control control, int index) {
        if (!(control instanceof TabPane)) {
            throw new OperationNotSupported();
        }
        this.tabPane.insertElementAt(control, index);
    }

    public void resetSelecton() {
    }

    public void setSelected(boolean selected, boolean isFromTouch) {
        super.setSelected(selected, isFromTouch);
        if (!this.isSelectionOnTabButton) {
            this.getContainer(this.selectedIndex).setSelected(selected, isFromTouch);
        }
    }

    public void selectChild(int index, boolean isFromTouch) {
        this.setSelectedIndex(index);
    }

    public void stretchDimentions() {
        for (int i = 0; i < this.tabPane.size(); ++i) {
            this.getContainer(i).stretchDimentions();
        }
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        MenuSerilize.serialize(this.tabPane, bos);
        Util.writeSignedInt(bos, this.getSelectedIndex(), 1);
        Util.writeInt(bos, this.getTabButtonAllignment(), 1);
        Util.writeSignedInt(bos, this.getPadding(), 2);
        return bos.toByteArray();
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.tabPane = (Vector)MenuSerilize.deserialize(bis, MenuSerilize.getInstance());
        for (int i = 0; i < this.tabPane.size(); ++i) {
            ((TabPane)this.tabPane.elementAt(i)).setParent(this);
        }
        this.selectedIndex = Util.readSignedInt(bis, 1);
        this.setTabButtonAllignment(Util.readInt(bis, 1));
        this.setPadding(Util.readSignedInt(bis, 2));
        return bis;
    }

    public String toString() {
        return "TabControl: " + this.getId();
    }
}

