/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Car {
    public static final int _iTYPE_CAR_BLUE = 0;
    public static final int _iTYPE_CAR_GREEN = 1;
    public static final int _iTYPE_CAR_ORANGE = 2;
    public static final int _iTYPE_CAR_PURPLE = 3;
    public static final int _iTYPE_CAR_TRUCK = 4;
    public static final int _iTYPE_CAR_YELLOW = 5;
    private int _iX;
    private int _iY;
    private int _iShiftX = 0;
    private int _iOffsetX = 0;
    private int _iTmpShift = 35;
    private int _iTmpPositionX = 0;
    private int _iTmpDefaultPositionX = 0;
    private int _iType = -1;
    private int _iDir = -1;
    private int DIR_LEFT = 1;
    private int DIR_RIGHT = 0;
    private int _iDelay = 0;
    private int DELAY = 1;
    private final int RANDOM_RANGE;
    private final int RANDOM_RATIO;
    private boolean _bIsMoveable = false;
    private boolean _bIsActive = false;
    private boolean _bDraw = true;
    private Rectangle _rectCar;
    private Sprite _sprCar;
    private Sprite _sprCar2;
    private World _world;
    private PreparedText _ptNum;
    boolean drawCoordinate = false;
    private boolean _bGameOver = false;
    private boolean paintCar = false;
    private int color = 0xFF0000;

    public Car(World _wWorld) {
        this.RANDOM_RANGE = 140;
        this.RANDOM_RATIO = 20;
        this._world = _wWorld;
        this._ptNum = new PreparedText(Resources.resGFonts[0]);
    }

    public void activeCar(int _x, int _y, int _iDirection, int _iOffset, int _iIype) {
        if (_iIype != 2) {
            System.out.println("$type is not road");
            return;
        }
        this._iDir = _iDirection;
        this.setGameOver(false);
        this.prepareSprite();
        this.setX(_x);
        this.setY(_y);
        this._iDir = this.DIR_RIGHT;
        this._iOffsetX = _iOffset != 0 ? _iOffset * (this._sprCar.getWidth() >> 2) : (_iOffset + 1) * (this._sprCar.getWidth() >> 2);
        this._rectCar = new Rectangle(this._world._tTiles[this.getX()][this.getY()].get_rectTile().getCenterX() - this._iOffsetX, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y - this._sprCar.getHeight(), this._sprCar.getWidth(), this._sprCar.getHeight());
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectCar.x - this._iOffsetX << 5;
        this._iTmpShift = 10;
        this._iTmpShift = Math.abs(RandomNum.getRandomInt(10, 5));
        this.setActive(true);
        this.setMoveable(true);
        this._bDraw = true;
    }

    private void prepareSprite() {
        int _tmpTyp = RandomNum.getRandomInt(140, 0);
        if (_tmpTyp < 0) {
            _tmpTyp *= -1;
        }
        this._iType = _tmpTyp < 20 ? 0 : (_tmpTyp < 40 ? 1 : (_tmpTyp < 60 ? 2 : (_tmpTyp < 80 ? 3 : (_tmpTyp < 100 ? 4 : 5))));
        this.setSprite(true);
    }

    public void update() {
        if (!this.isActive()) {
            return;
        }
        if (this.isActive() && this._rectCar != null) {
            this.move();
            this._rectCar.y = this._iType != 4 ? this._world._tTiles[this.getX()][this.getY()].getPositionY() - (this._sprCar.getHeight() >> 2) : this._world._tTiles[this.getX()][this.getY()].getPositionY() - (this._sprCar.getHeight() >> 2) - (this._world._tTiles[this.getX()][this.getY()].get_rectTile().height >> 2);
        }
        if (this._rectCar != null && this._rectCar.y >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._rectCar == null) {
            this.deactivate();
        }
    }

    public void paint(Graphics _g) {
        if (this.isActive() && this._rectCar != null && this._sprCar != null && this._bDraw) {
            this._sprCar.setPosition(this._rectCar.x, this._rectCar.y);
            this._sprCar.paint(_g);
        }
        this.checkGameOver();
    }

    private void setSprite(boolean first) {
        switch (this._iType) {
            case 0: {
                if (first) {
                    this._sprCar = Resources.resSprs[13];
                    break;
                }
                this._sprCar2 = Resources.resSprs[13];
                break;
            }
            case 1: {
                if (first) {
                    this._sprCar = Resources.resSprs[14];
                    break;
                }
                this._sprCar2 = Resources.resSprs[14];
                break;
            }
            case 2: {
                if (first) {
                    this._sprCar = Resources.resSprs[15];
                    break;
                }
                this._sprCar2 = Resources.resSprs[15];
                break;
            }
            case 3: {
                if (first) {
                    this._sprCar = Resources.resSprs[16];
                    break;
                }
                this._sprCar2 = Resources.resSprs[16];
                break;
            }
            case 4: {
                if (first) {
                    this._sprCar = Resources.resSprs[17];
                    break;
                }
                this._sprCar2 = Resources.resSprs[17];
                break;
            }
            case 5: {
                if (first) {
                    this._sprCar = Resources.resSprs[18];
                    break;
                }
                this._sprCar2 = Resources.resSprs[18];
            }
        }
        if (first) {
            this._sprCar.setTransform(0);
        } else {
            this._sprCar2.setTransform(0);
        }
    }

    private void move() {
        if (this._iDir == this.DIR_LEFT) {
            if (this.getX() - 1 > 0) {
                if (this._rectCar.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX() + (this._sprCar.getWidth() << 1)) {
                    this.setX(this.getX() - 1);
                    this._iTmpPositionX -= this._iTmpShift;
                } else {
                    this._iTmpPositionX -= this._iTmpShift;
                }
            } else {
                this._iTmpPositionX -= this._iTmpShift;
                if (this._rectCar != null && this._rectCar.x + this._rectCar.width < 0) {
                    this._bIsActive = false;
                    this.reset(this._iDir);
                }
            }
        } else if (this._iDir == this.DIR_RIGHT) {
            if (this.getX() + 1 < this._world.getTOTAL_COLS() && this._rectCar != null) {
                if (this._rectCar.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX() + (this._sprCar.getWidth() << 1)) {
                    this.setX(this.getX() + 1);
                    this._iTmpPositionX += this._iTmpShift;
                } else {
                    this._iTmpPositionX += this._iTmpShift;
                }
            } else {
                this._iTmpPositionX += this._iTmpShift;
                if (this._rectCar != null && this._rectCar.x > this._world.getWidth()) {
                    this._bIsActive = false;
                    this.reset(this._iDir);
                }
            }
        }
        this._iTmpPositionX += this._iTmpShift;
        if (this._rectCar != null) {
            this._rectCar.x = this._iTmpPositionX >> 3;
        } else {
            System.out.println("is NULL");
        }
    }

    private void reset(int _dir) {
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectCar.x - this._iOffsetX << 5;
        if (_dir == this.DIR_LEFT) {
            this.setX(0);
            this._rectCar.x = 0 - this._iOffsetX;
        } else {
            this.setX(0);
            this._rectCar.x = 0 - this._iOffsetX;
        }
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectCar.x;
        this.activeCar(this.getX(), this.getY(), this._iDir, this.getX(), 2);
        this._bDraw = true;
    }

    private void setGameOver(boolean gameOver) {
        this._bGameOver = gameOver;
    }

    public boolean isGameOver() {
        return this._bGameOver;
    }

    public void checkGameOver() {
        if (this._rectCar != null && this._world != null && this._bDraw) {
            if (this._rectCar.x + this._rectCar.width < 0) {
                return;
            }
            if (this._rectCar.x > this._world.getWidth()) {
                return;
            }
            if (this._rectCar.y > this._world.getHeight()) {
                return;
            }
            if (this._rectCar.y + this._rectCar.height < 0) {
                return;
            }
            if (this.isActive()) {
                if (this._rectCar.contains(this._world.getCharacter().get_rectChar().getCenterX(), this._world.getCharacter().get_rectChar().getCenterY())) {
                    if (this.getY() == this._world.getCharacter().get_iY()) {
                        this.setGameOver(true);
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    private void deactivate() {
        this.setActive(false);
        this.setMoveable(false);
        this.setGameOver(false);
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void setMoveable(boolean _bIsMoveable) {
        this._bIsMoveable = _bIsMoveable;
    }

    public boolean isMoveable() {
        return this._bIsMoveable;
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }
}

