/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IGameState;
import com.gamelion.speedx.SpeedXMIDlet;
import com.gamelion.speedx.TexturePool;
import com.gamelion.speedx.Utils;
import com.gamelion.speedx.game.Color;
import com.gamelion.speedx.game.FlashData;
import com.gamelion.speedx.game.Generator;
import com.gamelion.speedx.game.Matrix4f;
import com.gamelion.speedx.game.ObstacleMeshManager;
import com.gamelion.speedx.game.PlayerState;
import com.gamelion.speedx.game.Rainbow;
import com.gamelion.speedx.game.TunnelMesh;
import com.gamelion.speedx.game.Vector2f;
import com.gamelion.speedx.game.Vector3f;
import com.gamelion.speedx.game.dialogs.GameOverDialog;
import com.gamelion.speedx.game.dialogs.PauseMenuDialog;
import com.gamelion.speedx.menu.LabelsAtlas;
import com.nokia.mid.ui.DeviceControl;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Game
extends Generator
implements IGameState {
    private static final int GAMESTATE_STARTING = 1;
    private static final int GAMESTATE_IN_PROGRESS = 2;
    private static final int GAMESTATE_PAUSE = 3;
    private static final int GAMESTATE_GAME_OVER = 4;
    private static final int GAMESTATE_TUTORIAL = 5;
    private static final int ZONE_NONE = 0;
    private static final int ZONE_BLACKOUT = 1;
    private static final int ZONE_GRAVITY = 2;
    private static final int ZONE_HUE_SHIFT = 3;
    private static final int ZONE_NEBULA = 4;
    private static final int ZONE_PLASMA = 5;
    private static final int SPOT_TYPE_SHIELD = 0;
    private static final int SPOT_TYPE_QUAKE = 1;
    private static final int SPOT_TYPE_FREEZ = 2;
    private static final int SPOT_TYPE_TORPEDO = 3;
    private static final int SPOT_TYPE_ZONE_END = 4;
    private static final int SPOT_TYPE_BLACKOUT = 5;
    private static final int SPOT_TYPE_HUE_SHIFT = 6;
    private static final int SPOT_TYPE_NEBULA = 7;
    private static final int SPOT_TYPE_PLASMA = 8;
    private static final int SPOT_TYPE_GRAVITY = 9;
    private static final int SPOT_SEGMENT_MASK = 262143;
    private static final int SPOT_POSITION_MASK = 15;
    private static final int SPOT_LEN_MASK = 15;
    private static final int SPOT_TYPE_MASK = 31;
    private static final int SPOT_POSITION_SHIFT = 18;
    private static final int SPOT_LEN_SHIFT = 22;
    private static final int SPOT_TYPE_SHIFT = 26;
    private static final int SPOT_USED_FLAG = Integer.MIN_VALUE;
    private static final int FIRST_ZONE_SPOT_TYPE = 5;
    private static final int LAST_ZONE_SPOT_TYPE = 9;
    private static final int SHIELD_SPOT_LEN = 3;
    public static final int DIFFICULTY_CASUAL = 0;
    public static final int DIFFICULTY_EASY = 1;
    public static final int DIFFICULTY_NORMAL = 2;
    public static final int DIFFICULTY_HARD = 3;
    public static final int DIFFICULTY_PURE = 4;
    private static final int PART_TYPE_LENGTH = 100;
    private static final int PART_MORPH_LENGTH = 30;
    private static final float INITIAL_SEGMENT = 3.5f;
    private static final int INITIAL_SEGMENT_INT = 3;
    private static final float TURN_FACTOR = 0.75f;
    private static final float ROLL_FACTOR = 5.0f;
    private static final float EYE_ELEVATION = 0.25f;
    private static final int ZONE_GEN_INTERVAL_SEGMENTS = 200;
    private static final float ZONE_DURATION = 7.0f;
    private static final int ZONE_COUNTDOWN_COUNT = 3;
    private static final String[] ZONE_NAMES = new String[]{"none", "blackout", "gravity_well", "hue_shift", "dark_nebula", "plasma_cloud"};
    private static final FlashData FLASH_SHIELD = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_EXPLOSION = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_STARTING_GAME = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_CRASH = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_ZONE = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_QUAKE = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_FREEZ = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_FREEZ_END = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final FlashData FLASH_PLASMA = new FlashData(1.0f, 0.7f, 0.2f, 0.75f, 0.3f, true);
    private static final int BANDS_RENDERING_ADVANCE = 20;
    private static final int BANDS_RENDERING_BLEND = 5;
    private static final float MORPH_CONNECTING_MARGIN = 0.02f;
    private static final int EMITTERS_COUNT = 8;
    private static final float SHIP_WIDTH = 0.25f;
    private static final float SHIP_LENGTH = 0.6f;
    private static final Color OBSTACLE_TRACE_HL_COLOR = new Color(1.0f, 0.2f, 0.2f);
    private static final Color BASE_TRACK_COLOR = new Color(1.0f, 1.0f, 1.0f);
    private static final int OBSTACLE_TRACE_LEN = 25;
    private static final int OBSTACLE_TRACE_BLEND = 10;
    private static final int OBSTACLE_TRACE_HL_LEN = 10;
    private static final int OBSTACLE_TRACE_HL_OFFSET = 5;
    private static final float BOUNCERS_OFFSET_MAX = 1.9318516f;
    private static final float[] PART_INNER_ANGLE = new float[]{150.0f, 180.0f, 210.0f};
    private final DifficultySettings[] DIFFICULTIES = new DifficultySettings[]{new DifficultySettings(0.133f, 150.0f, 1.2f, 10.0f, false), new DifficultySettings(0.1f, 180.0f, 1.0f, 8.0f, false), new DifficultySettings(0.067f, 220.0f, 0.85f, 6.0f, false), new DifficultySettings(0.05f, 250.0f, 0.75f, 5.0f, false), new DifficultySettings(0.08f, 0.0f, 0.0f, 8.0f, true)};
    private static final float PAUSE_BUTTON_SIZE = 30.0f;
    private static final float PAUSE_BUTTON_TOUCH_SIZE = 80.0f;
    private static final int GENERATOR_FREQ = 12;
    private static final int GENERATOR_FREQ_MIN = 8;
    private static final int SEGMENTS_PER_LEVEL = 150;
    private final SpotEntry[] SPOTENTRY_BONUSES = new SpotEntry[]{new SpotEntry(0, 1.0f, 0.7f, 0.2f, 0.6f, 1.0f, 0.7f, 0.2f, 1.0f), new SpotEntry(1, 1.0f, 0.0f, 0.2f, 0.6f, 1.0f, 0.0f, 0.2f, 1.0f), new SpotEntry(2, 0.3f, 0.3f, 1.0f, 0.6f, 0.3f, 0.2f, 1.0f, 1.0f), new SpotEntry(3, 0.8f, 0.1f, 0.9f, 0.6f, 0.7f, 0.2f, 0.9f, 1.0f), new SpotEntry(4, 0.2f, 1.0f, 0.0f, 0.6f, 0.3f, 0.8f, 0.0f, 1.0f)};
    private final SpotEntry[] SPOTENTRY_ZONES = new SpotEntry[]{new SpotEntry(5, 1.0f, 0.5f, 0.5f, 0.9f, 0.8f, 0.0f, 0.0f, 0.6f), new SpotEntry(6, 0.2f, 1.0f, 0.3f, 0.9f, 0.1f, 0.6f, 0.3f, 0.6f), new SpotEntry(7, 0.1f, 0.2f, 1.0f, 0.9f, 0.3f, 0.4f, 1.0f, 0.6f), new SpotEntry(8, 0.8f, 0.8f, 1.0f, 0.9f, 0.5f, 0.5f, 1.0f, 0.6f), new SpotEntry(9, 1.0f, 0.7f, 1.0f, 0.9f, 0.5f, 0.0f, 0.5f, 0.6f)};
    static final int[] HL_CROP_LEFT = new int[]{0, 64, 30, -64};
    static final int[] HL_CROP_CENTER = new int[]{30, 64, 4, -64};
    static final int[] HL_CROP_RIGHT = new int[]{34, 64, 30, -64};
    static final int MAX_EXPLOSIONS_IN_QUAKE = 15;
    static final float FREEZ_DURATION = 10.0f;
    static final Vector2f[] TUTORIAL_DISPLACEMENTS = new Vector2f[]{new Vector2f(-50.0f, 60.0f), new Vector2f(50.0f, 60.0f), new Vector2f(-50.0f, 0.0f), new Vector2f(50.0f, 0.0f), new Vector2f(0.0f, 60.0f)};
    private final SpotPredicate SPOT_EQ_PRED = new SpotEqualPredicate();
    private final SpotPredicate SPOT_LESS = new SpotLessPredicate();
    private final Color[] START_LIGHTS_COLORS = new Color[]{new Color(0.2f, 1.0f, 0.2f), new Color(1.0f, 0.5f, 0.2f), new Color(1.0f, 0.2f, 0.2f)};
    private Transform hudTransform = new Transform();
    private Color hudColor = new Color();
    static float[] coords = new float[12];
    static float[] texCoords = new float[8];
    static int[] fullCrop = new int[4];
    private int[] obstacleNdx = new int[3];
    private Color renderColor = new Color();
    private Color spotColor = new Color();
    private Color spotWhite = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Vector3f _center = new Vector3f();
    private Vector3f _up = new Vector3f();
    private Vector3f _up2 = new Vector3f();
    private Vector3f _dir = new Vector3f();
    private Vector3f _view = new Vector3f();
    private Vector3f _right = new Vector3f();
    private Matrix4f _mtx = new Matrix4f();
    private Color color = new Color();
    private Color baseTrackColor = new Color();
    private Vector allObstacles = new Vector();
    private int[] toRemove = new int[3];
    private Vector3f[] base = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
    private int difficulty = 0;
    private DifficultySettings difficultySettings = this.DIFFICULTIES[this.difficulty];
    private int gameState;
    private float startingAnim;
    private float mainAnim;
    private float stateChangeAnim;
    private float exitingAnim;
    private StartLight[] startingLights = new StartLight[3];
    private Vector3f eye = new Vector3f();
    private float effectiveRoll;
    private int startingSegment;
    private boolean isMorphing;
    private float morphFactor;
    private int changeSegment;
    private int changeSegmentNoFlat;
    private boolean wasOuterPart;
    private float flatBandsAlpha;
    private float segment;
    private float rawPosition;
    private PlayerState playerState;
    private int zone;
    private int targetZone;
    private int zoneCountDown;
    private float zoneCoeff1;
    private float zoneCoeff2;
    private float zoneAnim;
    private float freezAnim;
    private boolean freezed;
    private float value;
    private float zeroPoint;
    private float inclination;
    private float gravity;
    private int obstacleGeneratorLock;
    private int lastGeneratorSegment;
    private int[] spots = new int[100];
    private int[] spotIndices = new int[4];
    private int[] spotStripsLen = new int[1];
    private float spotsAnim;
    private int spotsCount;
    private int nextSpotGen;
    private int zoneSegNext;
    private boolean exiting;
    private boolean restarting;
    private boolean bonusActivated;
    private float timestampStomp;
    private float rollerStillTime;
    private boolean rollerShake;
    private FlashData flash;
    private float flashAnim;
    private boolean touchDown;
    private float touchX;
    private float touchY;
    private static float width;
    private static float height;
    private float[] camMatrix = new float[16];
    private Transform camTransform = new Transform();
    private Camera camera = new Camera();
    private Transform objTransform = new Transform();
    private Camera parallelCamera;
    private Transform parallelCameraTransform;
    private Vector obstacles = new Vector();
    private Vector rollers = new Vector();
    private Vector bouncers = new Vector();
    private Background background;
    private Appearance appearance;
    private CompositingMode compMode;
    private Appearance spotAppearance;
    private CompositingMode spotCompMode;
    private PolygonMode spotPolyMode;
    private Fog fog;
    private static Appearance appearance2D;
    private Appearance addtiveQuadAppearance;
    private Appearance mixQuadAppearance;
    private static SpeedXMIDlet midlet;
    private TunnelMesh tunnel;
    private Random rng;
    private int lastEmitSeg;
    private Color[] hueShiftFrom;
    private Color[] hueShiftTo;
    private Color[] hueShift;
    private float[] hueShiftCycle;
    private Color black = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Texture2D[] spotTexs = new Texture2D[4];
    private ObstacleMeshManager omm;
    private boolean leftPressed;
    private boolean rightPressed;
    private GameOverDialog gameOverDialog;
    private PauseMenuDialog pauseMenuDialog;
    private int tutorialStage;
    private float tutorialStageTimer;
    private float tutorialAlpha;
    private VertexBuffer movableVertexBuffer;
    private VertexArray movablePosVertexArray;
    private VertexArray movableUvVertexArray;
    private IndexBuffer movableIndexBuffer;
    private short[] movablePosBuffer;
    private Transform movableTransform = new Transform();
    private static VertexBuffer quadBuffer;
    private static VertexArray quadPosArray;
    private static VertexArray quadUvArray;
    private static short[] quadPos;
    private static short[] quadUv;
    private static IndexBuffer quadIndexBuffer;

    public Game(SpeedXMIDlet midlet) {
        Game.midlet = midlet;
    }

    public void onEnter() {
        this.rng.setSeed(System.currentTimeMillis());
        this.init();
    }

    public void onLeave() {
    }

    public void onUpdate(float delta) {
        float currentPosition = this.rawPosition;
        boolean crashed = false;
        this.stateChangeAnim += delta;
        this.startingAnim += delta;
        boolean restoreTouch = false;
        if (this.touchDown && 2 == this.gameState) {
            float scale = height / 320.0f;
            if (this.touchX > width - 80.0f && this.touchY < 80.0f) {
                this.gameState = 3;
                this.stateChangeAnim = 0.0f;
                this.pauseMenuDialog.open();
            } else if (this.touchX < 80.0f && this.touchY < 80.0f) {
                if (0 != this.playerState.getBonus()) {
                    this.bonusActivated = true;
                }
            } else if (this.touchX < width / 2.0f) {
                this.leftPressed = true;
                this.rightPressed = false;
            } else if (this.touchX > width / 2.0f) {
                this.rightPressed = true;
                this.leftPressed = false;
            }
        }
        if (this.leftPressed) {
            this.inclination -= 1.9f * delta;
            this.inclination = Math.max(-0.7f, this.inclination);
        } else if (this.rightPressed) {
            this.inclination += 1.9f * delta;
            this.inclination = Math.min(0.7f, this.inclination);
        } else {
            this.inclination *= 1.0f - 0.999f * delta;
        }
        if (this.touchDown) {
            this.rightPressed = false;
            this.leftPressed = false;
        }
        float currentAccelValue = this.value;
        float currentInclination = this.inclination;
        if (this.flash != null) {
            this.flashAnim += delta;
            if (this.flashAnim > this.flash.duration) {
                this.flash = null;
            }
        }
        if (3 == this.gameState) {
            this.pauseMenuDialog.update(delta);
        }
        if (4 == this.gameState) {
            this.gameOverDialog.update(delta);
        }
        if (5 == this.gameState) {
            float apearTime = 0.5f;
            float dissapearTime = 0.5f;
            float visibleTime = 1.5f;
            float totalTime = 2.5f;
            if (this.tutorialStageTimer > 2.5f) {
                if (++this.tutorialStage == 5) {
                    this.gameState = 1;
                    this.startingAnim = 0.0f;
                    this.mainAnim = 0.0f;
                }
                this.tutorialStageTimer = 0.0f;
            } else {
                this.tutorialAlpha = this.tutorialStageTimer < 0.5f ? this.tutorialStageTimer / 0.5f : (this.tutorialStageTimer > 2.0f ? 1.0f - (this.tutorialStageTimer - 0.5f - 1.5f) / 0.5f : 1.0f);
            }
            this.tutorialStageTimer += delta;
        }
        if (2 == this.gameState) {
            boolean bandCrossed;
            if (this.freezed) {
                this.freezAnim += delta;
            }
            float modDelta = delta * (this.freezed ? 0.75f : 1.0f);
            this.mainAnim += modDelta;
            this.spotsAnim += modDelta;
            if (0 != this.zone) {
                this.zoneAnim += modDelta;
            } else if (0 != this.targetZone) {
                this.zoneAnim += delta;
            }
            Debug.error("update particles");
            currentInclination = midlet.settings().controlsInverted() ? -currentInclination : currentInclination;
            this.gravity = 0.0f;
            if (2 == this.zone) {
                this.gravity = (float)(2.5 * Math.sin(2.5 * (double)this.zoneAnim + (double)this.zoneCoeff1) + 1.5 * Math.sin(1.5 * (double)this.zoneAnim + 0.7853981633974483 + (double)this.zoneCoeff2));
                this.gravity = 0.25f * this.gravity;
                if (7.0f - this.zoneAnim < 1.0f) {
                    float coeff = Math.max(0.0f, 7.0f - this.zoneAnim);
                    this.gravity *= coeff;
                }
                currentInclination += 0.4f * this.gravity;
            }
            this.rawPosition += currentInclination * delta * 0.75f;
            boolean bl = bandCrossed = Math.abs(this.rawPosition) > 1.0f;
            if (this.rawPosition > 1.0f) {
                this.rawPosition = -2.0f + this.rawPosition;
            } else if (this.rawPosition < -1.0f) {
                this.rawPosition = 2.0f + this.rawPosition;
            }
            if (bandCrossed) {
                boolean bandCrash = false;
                if (this.isMorphing) {
                    bandCrash = 1 == this.tunnel.getCurrentPartType() ? this.morphFactor < 0.98f : this.morphFactor > 0.02f;
                } else {
                    boolean bl2 = bandCrash = 1 == this.tunnel.getCurrentPartType();
                }
                if (bandCrash) {
                    this.rawPosition = currentPosition;
                    crashed = true;
                }
            }
            this.segment = 3.5f + this.mainAnim / this.difficultySettings.timePerSegment;
            float currentRoll = currentInclination * (float)Math.PI / 25.0f;
            float factor = Math.max(0.0f, Math.min(1.0f, 5.0f * delta));
            this.effectiveRoll = Utils.lerp(this.effectiveRoll, currentRoll, factor);
        } else if (1 == this.gameState) {
            float countdown = this.startingAnim - 3.0f;
            int lightsOnCount = this.startingLights.length;
            int i = 0;
            while (i < this.startingLights.length) {
                float coeff = Math.max(0.0f, countdown / 0.5f);
                if (coeff <= 1.0f) {
                    this.startingLights[i].on = true;
                    this.startingLights[i].coeff = coeff;
                } else {
                    this.startingLights[i].on = false;
                    --lightsOnCount;
                }
                if (coeff > 0.1f && !this.startingLights[i].beep) {
                    this.startingLights[i].beep = true;
                    this.playSoundAndVibrate("alarm2", 50);
                }
                ++i;
                countdown += 1.0f;
            }
            Debug.error("Calibrate data");
            if (0 == lightsOnCount) {
                this.zeroPoint = 0.0f;
                this.gameState = 2;
            }
        } else if (4 == this.gameState) {
            this.mainAnim += delta;
        }
        if (3 != this.gameState) {
            this.playerState.update(delta);
        }
        this.update(this.mainAnim);
        if (2 == this.gameState) {
            if (!crashed && (crashed = this.collisionTest(this.mainAnim))) {
                this.mainAnim = ((float)Math.floor(this.segment) - 3.5f - 0.2f) * this.difficultySettings.timePerSegment;
                this.segment = 3.5f + this.mainAnim / this.difficultySettings.timePerSegment;
            }
            if (crashed) {
                int best = midlet.settings().personalBest();
                int current = this.playerState.getScore();
                if (current > best) {
                    midlet.settings().setPersonalBest(current);
                }
                this.gameState = 4;
                this.gameOverDialog.open();
                this.stateChangeAnim = 0.0f;
                this.scheduleFlash(FLASH_CRASH);
                Debug.error("open gameover menu");
                this.playSoundAndVibrate("nuke", 400);
            }
        }
        this.omm.update(this.mainAnim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepaint(Graphics g) {
        Graphics3D g3d = Graphics3D.getInstance();
        try {
            float coeff;
            g3d.bindTarget((Object)g);
            g3d.clear(this.background);
            float aspectRatio = width / height;
            if (2 == this.zone) {
                float grav = this.gravity;
                if (grav < -aspectRatio / 2.0f) {
                    grav = -aspectRatio / 2.0f;
                }
                this.camera.setPerspective(60.0f, grav + aspectRatio, 0.05f, 100.0f);
            } else {
                this.camera.setPerspective(70.0f, aspectRatio, 0.05f, 100.0f);
            }
            this.renderGeometry(g3d);
            g3d.setCamera(this.parallelCamera, this.parallelCameraTransform);
            if (this.freezed) {
                this.blendFullScreenQuad(g3d, true, 0.3f, 0.3f, 1.0f, 0.2f);
            } else if (5 == this.zone) {
                coeff = (float)((double)0.15f + (double)0.15f * Math.sin(4.0f * this.zoneAnim));
                this.blendFullScreenQuad(g3d, true, 0.5f, 0.5f, 1.0f, coeff);
            }
            if (this.flash != null) {
                coeff = this.flashAnim / this.flash.duration;
                this.blendFullScreenQuad(g3d, this.flash.additive, this.flash.r, this.flash.g, this.flash.b, (int)((float)this.flash.a * (1.0f - coeff)));
            }
            if (this.restarting) {
                this.blendFullScreenQuad(g3d, false, 0.0f, 0.0f, 0.0f, this.startingAnim);
            }
            if (1 == this.gameState || 2 == this.gameState || 5 == this.gameState) {
                this.renderInGameHUD(g3d, 1.0f);
            } else if (!this.exiting && (coeff = 1.0f - 4.0f * this.stateChangeAnim) > 0.0f) {
                this.renderInGameHUD(g3d, coeff);
            }
            if (3 == this.gameState) {
                this.pauseMenuDialog.render(g3d);
            } else if (4 == this.gameState) {
                this.gameOverDialog.render(g3d);
            } else if (5 == this.gameState) {
                this.hudColor.b = 1.0f;
                this.hudColor.g = 1.0f;
                this.hudColor.r = 1.0f;
                this.hudColor.a = this.tutorialAlpha;
                Game.drawQuad2d(g3d, this.hudColor, (width - 128.0f) / 2.0f + Game.TUTORIAL_DISPLACEMENTS[this.tutorialStage].x, (height - 64.0f) / 2.0f + Game.TUTORIAL_DISPLACEMENTS[this.tutorialStage].y, 128.0f, 64.0f, "tutorial_" + (this.tutorialStage + 1));
            }
            if (1 == this.gameState) {
                float size = height / 6.0f;
                float xpos = (width + 3.0f * size) / 2.0f;
                float ypos = height - 3.0f * size;
                int i = 0;
                while (i < this.startingLights.length) {
                    if (this.startingLights[i].on) {
                        float coeff2 = this.startingLights[i].coeff;
                        float zoomed = size * (1.0f + coeff2);
                        float off = (zoomed - size) / 2.0f;
                        Color c = this.START_LIGHTS_COLORS[i];
                        Game.drawQuad2d(g3d, c, xpos - off - size, ypos - off, zoomed, zoomed, "start_light");
                    }
                    ++i;
                    xpos -= size;
                }
                LabelsAtlas atlas = midlet.labelsAtlas();
                this.hudColor.r = 0.7921569f;
                this.hudColor.g = 0.4862745f;
                this.hudColor.b = 0.07058824f;
                this.hudColor.a = 1.0f;
                Game.drawQuad2d(g3d, this.hudColor, (width - 215.0f) / 2.0f, (height - 32.0f) / 2.0f - 50.0f, 256.0f, 32.0f, "personal_best");
                midlet.labelsAtlas().drawInteger(g3d, midlet.settings().personalBest(), (width - 215.0f) / 2.0f + 157.0f, (height - 32.0f) / 2.0f + 5.0f + 50.0f, -3507182);
            }
        }
        finally {
            g3d.releaseTarget();
        }
    }

    public void onPointerPressed(int x, int y) {
        if (3 == this.gameState) {
            this.pauseMenuDialog.onPointerPressed(x, y);
        } else if (4 == this.gameState) {
            this.gameOverDialog.onPointerPressed(x, y);
        } else if (2 == this.gameState) {
            this.touchDown = true;
            this.touchX = x;
            this.touchY = y;
        }
    }

    public void onPointerDragged(int x, int y) {
        if (3 == this.gameState) {
            this.pauseMenuDialog.onPointerDragged(x, y);
        } else if (4 == this.gameState) {
            this.gameOverDialog.onPointerDragged(x, y);
        } else if (2 == this.gameState) {
            this.touchDown = true;
            this.touchX = x;
            this.touchY = y;
        }
    }

    public void onPointerReleased(int x, int y) {
        this.touchDown = false;
        if (3 == this.gameState) {
            this.pauseMenuDialog.onPointerReleased(x, y);
        } else if (4 == this.gameState) {
            this.gameOverDialog.onPointerReleased(x, y);
        }
    }

    public void onKeyPressed(int code) {
        if (3 == this.gameState) {
            this.pauseMenuDialog.onKeyPressed(code);
        } else if (4 == this.gameState) {
            this.gameOverDialog.onKeyPressed(code);
        } else if (2 == this.gameState) {
            if (code == 52) {
                this.leftPressed = true;
            } else if (code == 54) {
                this.rightPressed = true;
            }
        }
    }

    public void onKeyReleased(int code) {
        if (3 == this.gameState) {
            this.pauseMenuDialog.onKeyReleased(code);
        } else if (4 == this.gameState) {
            this.gameOverDialog.onKeyReleased(code);
        } else if (2 == this.gameState) {
            if (code == 52) {
                this.leftPressed = false;
            } else if (code == 54) {
                this.rightPressed = false;
            } else if (code == 51) {
                this.gameState = 3;
                this.stateChangeAnim = 0.0f;
                this.pauseMenuDialog.open();
            } else if (code == 49 && 0 != this.playerState.getBonus()) {
                this.bonusActivated = true;
            }
        }
    }

    public void onFocusChanged(boolean focused) {
        if (!focused && this.gameState != 4) {
            this.gameState = 3;
            this.stateChangeAnim = 0.0f;
            this.pauseMenuDialog.open();
        }
    }

    public void setup() {
        int i;
        TunnelMesh.initializeLookups();
        this.hueShiftFrom = new Color[12];
        this.hueShiftTo = new Color[12];
        this.hueShift = new Color[12];
        this.hueShiftCycle = new float[12];
        for (i = 0; i < 12; ++i) {
            this.hueShiftFrom[i] = new Color();
            this.hueShiftTo[i] = new Color();
            this.hueShift[i] = new Color();
        }
        width = midlet.canvas().getWidth();
        height = midlet.canvas().getHeight();
        for (i = 0; i < this.startingLights.length; ++i) {
            this.startingLights[i] = new StartLight();
        }
        this.background = new Background();
        this.background.setColor(0);
        this.background.setDepthClearEnable(true);
        this.background.setColorClearEnable(true);
        this.appearance = new Appearance();
        PolygonMode pm = new PolygonMode();
        pm.setCulling(162);
        pm.setShading(164);
        this.appearance.setPolygonMode(pm);
        this.compMode = new CompositingMode();
        this.compMode.setColorWriteEnable(true);
        this.compMode.setBlending(68);
        this.compMode.setDepthTestEnable(true);
        this.compMode.setDepthWriteEnable(true);
        this.appearance.setCompositingMode(this.compMode);
        this.spotAppearance = new Appearance();
        this.spotPolyMode = new PolygonMode();
        this.spotPolyMode.setCulling(161);
        this.spotPolyMode.setShading(164);
        this.spotAppearance.setPolygonMode(this.spotPolyMode);
        this.spotCompMode = new CompositingMode();
        this.spotCompMode.setColorWriteEnable(true);
        this.spotCompMode.setBlending(68);
        this.spotCompMode.setDepthTestEnable(true);
        this.spotCompMode.setDepthWriteEnable(true);
        this.spotAppearance.setCompositingMode(this.spotCompMode);
        this.fog = new Fog();
        this.fog.setColor(0);
        this.fog.setMode(81);
        this.fog.setLinear(TunnelMesh.SEGMENT_LEN * 30.0f * 0.35f, TunnelMesh.SEGMENT_LEN * 30.0f * 0.7f);
        this.appearance.setFog(this.fog);
        this.spotAppearance.setFog(this.fog);
        appearance2D = new Appearance();
        pm = new PolygonMode();
        pm.setCulling(162);
        appearance2D.setPolygonMode(pm);
        this.compMode = new CompositingMode();
        this.compMode.setColorWriteEnable(true);
        this.compMode.setBlending(64);
        this.compMode.setDepthTestEnable(false);
        this.compMode.setDepthWriteEnable(false);
        appearance2D.setCompositingMode(this.compMode);
        this.addtiveQuadAppearance = new Appearance();
        CompositingMode cm = new CompositingMode();
        cm.setColorWriteEnable(true);
        cm.setBlending(65);
        cm.setDepthTestEnable(false);
        cm.setDepthWriteEnable(false);
        this.addtiveQuadAppearance.setCompositingMode(cm);
        this.addtiveQuadAppearance.setPolygonMode(pm);
        this.mixQuadAppearance = new Appearance();
        cm = new CompositingMode();
        cm.setColorWriteEnable(true);
        cm.setBlending(64);
        cm.setDepthTestEnable(false);
        cm.setDepthWriteEnable(false);
        this.addtiveQuadAppearance.setCompositingMode(cm);
        this.mixQuadAppearance.setPolygonMode(pm);
        this.rng = new Random();
        this.playerState = new PlayerState();
        this.tunnel = new TunnelMesh(this.rng);
        this.omm = new ObstacleMeshManager(this.rng);
        TexturePool tp = midlet.texturePool();
        this.spotTexs[0] = tp.getTexture("spot1");
        this.spotTexs[1] = tp.getTexture("spot2");
        this.spotTexs[2] = tp.getTexture("spot3");
        this.spotTexs[3] = tp.getTexture("spot4");
        this.parallelCamera = new Camera();
        this.parallelCamera.setParallel(height, width / height, 0.05f, 80.0f);
        this.parallelCameraTransform = new Transform();
        this.parallelCameraTransform.postTranslate(width / 2.0f, height / 2.0f, 0.0f);
        this.parallelCameraTransform.postScale(1.0f, -1.0f, -1.0f);
        quadBuffer = new VertexBuffer();
        quadPosArray = new VertexArray(4, 3, 2);
        quadUvArray = new VertexArray(4, 2, 2);
        quadPos = new short[12];
        quadUv = new short[8];
        quadIndexBuffer = new TriangleStripArray(new int[]{0, 1, 3, 2}, new int[]{4});
        this.playerState.setLabelsAtlas(midlet.labelsAtlas());
        this.playerState.setTexturePool(midlet.texturePool());
        this.gameOverDialog = new GameOverDialog(midlet);
        this.pauseMenuDialog = new PauseMenuDialog(midlet);
        this.movableVertexBuffer = new VertexBuffer();
        this.movablePosVertexArray = new VertexArray(24, 3, 2);
        this.movableUvVertexArray = new VertexArray(24, 2, 1);
        this.movablePosBuffer = new short[72];
        byte[] movableUvBuffer = new byte[48];
        int pos = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            movableUvBuffer[pos++] = 0;
            movableUvBuffer[pos++] = 0;
            movableUvBuffer[pos++] = 1;
            movableUvBuffer[pos++] = 0;
            movableUvBuffer[pos++] = 0;
            movableUvBuffer[pos++] = 1;
            movableUvBuffer[pos++] = 1;
            movableUvBuffer[pos++] = 1;
        }
        this.movableUvVertexArray.set(0, 24, movableUvBuffer);
        int[] movableIndices = new int[36];
        int[] movableIndicesLen = new int[12];
        int pos2 = 0;
        int lenPos = 0;
        for (int i3 = 0; i3 < 6; ++i3) {
            int base = 4 * i3;
            movableIndices[pos2++] = base + 0;
            movableIndices[pos2++] = base + 1;
            movableIndices[pos2++] = base + 2;
            movableIndicesLen[lenPos++] = 3;
            movableIndices[pos2++] = base + 1;
            movableIndices[pos2++] = base + 2;
            movableIndices[pos2++] = base + 3;
            movableIndicesLen[lenPos++] = 3;
        }
        this.movableIndexBuffer = new TriangleStripArray(movableIndices, movableIndicesLen);
    }

    public void _continue() {
        this.gameState = 2;
    }

    public void setDifficulty(int diff) {
        this.difficulty = diff;
    }

    private void renderInGameHUD(Graphics3D g, float fadeOutAlpha) {
        Debug.trace("render hud");
        float scale = height / 320.0f;
        LabelsAtlas labels = midlet.labelsAtlas();
        if (this.zoneCountDown > 0) {
            // empty if block
        }
        this.playerState.renderHUD(g, width, height, fadeOutAlpha);
        if (this.zoneCountDown > 0) {
            this.hudColor.r = 1.0f;
            this.hudColor.g = 0.2f;
            this.hudColor.b = 0.2f;
            this.hudColor.a = 0.8f * fadeOutAlpha;
            Game.drawQuad2d(g, this.hudColor, width / 2.0f - 128.0f, height / 2.0f - 16.0f, 256.0f, 32.0f, "warning");
            String texId = "";
            switch (this.targetZone) {
                case 0: {
                    texId = "none";
                    break;
                }
                case 1: {
                    texId = "blackout";
                    break;
                }
                case 2: {
                    texId = "gravity_well";
                    break;
                }
                case 3: {
                    texId = "hue_shift";
                    break;
                }
                case 4: {
                    texId = "dark_nebula";
                    break;
                }
                case 5: {
                    texId = "plasma_cloud";
                }
            }
            Texture2D tex = midlet.texturePool().getTexture(texId);
            if (tex != null) {
                float w = tex.getImage().getWidth();
                float h = tex.getImage().getHeight();
                Game.drawQuad2d(g, this.hudColor, width / 2.0f - w / 2.0f, height / 2.0f - h / 2.0f - 32.0f, w, h, texId);
            }
        }
        this.hudColor.b = 1.0f;
        this.hudColor.g = 1.0f;
        this.hudColor.r = 1.0f;
        this.hudColor.a = 0.8f * Math.min(1.0f, 4.0f * this.mainAnim) * fadeOutAlpha;
        Game.drawQuad2d(g, this.hudColor, width - 33.0f, height - 33.0f, 32.0f, 32.0f, "pause");
    }

    public static void drawQuad2d(Graphics3D g, Color color, float x, float y, float w, float h, String texName) {
        Game.quadPos[0] = (short)x;
        Game.quadPos[1] = (short)(height - y);
        Game.quadPos[2] = 1;
        Game.quadPos[3] = (short)(x + w);
        Game.quadPos[4] = (short)(height - y);
        Game.quadPos[5] = 1;
        Game.quadPos[6] = (short)(x + w);
        Game.quadPos[7] = (short)(height - (y + h));
        Game.quadPos[8] = 1;
        Game.quadPos[9] = (short)x;
        Game.quadPos[10] = (short)(height - (y + h));
        Game.quadPos[11] = 1;
        Game.quadUv[0] = 0;
        Game.quadUv[1] = 256;
        Game.quadUv[2] = 256;
        Game.quadUv[3] = 256;
        Game.quadUv[4] = 256;
        Game.quadUv[5] = 0;
        Game.quadUv[6] = 0;
        Game.quadUv[7] = 0;
        quadPosArray.set(0, 4, quadPos);
        quadUvArray.set(0, 4, quadUv);
        quadBuffer.setPositions(quadPosArray, 1.0f, null);
        quadBuffer.setTexCoords(0, quadUvArray, 0.00390625f, null);
        if (color != null) {
            quadBuffer.setDefaultColor(color.toInt());
        } else {
            quadBuffer.setDefaultColor(-1);
        }
        appearance2D.setTexture(0, midlet.texturePool().getTexture(texName));
        g.render(quadBuffer, quadIndexBuffer, appearance2D, null);
    }

    private void blendFullScreenQuad(Graphics3D g3d, boolean addtive, float r, float g, float b, float a) {
        this.blendFullScreenQuad(g3d, addtive, (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    private void blendFullScreenQuad(Graphics3D g3d, boolean addtive, int r, int g, int b, int a) {
        float x = 0.0f;
        float y = 0.0f;
        float w = width;
        float h = height;
        Game.quadPos[0] = 0;
        Game.quadPos[1] = (short)height;
        Game.quadPos[2] = 1;
        Game.quadPos[3] = (short)(x + w);
        Game.quadPos[4] = (short)(height - y);
        Game.quadPos[5] = 1;
        Game.quadPos[6] = (short)(x + w);
        Game.quadPos[7] = (short)(height - (y + h));
        Game.quadPos[8] = 1;
        Game.quadPos[9] = (short)x;
        Game.quadPos[10] = (short)(height - (y + h));
        Game.quadPos[11] = 1;
        quadPosArray.set(0, 4, quadPos);
        quadBuffer.setPositions(quadPosArray, 1.0f, null);
        quadBuffer.setTexCoords(0, null, 0.00390625f, null);
        quadBuffer.setDefaultColor(a << 24 | r << 16 | g << 8 | b);
        Appearance ap = addtive ? this.addtiveQuadAppearance : this.mixQuadAppearance;
        g3d.render(quadBuffer, quadIndexBuffer, ap, null);
    }

    public static void drawTex(Graphics3D g, float x, float y, float w, float h, int texWidth, int texHeight, int[] crop, Texture2D tex, Color color) {
        float width = texWidth;
        float height = texHeight;
        Game.fullCrop[0] = 0;
        Game.fullCrop[1] = texHeight;
        Game.fullCrop[2] = texWidth;
        Game.fullCrop[3] = -texHeight;
        Game.coords[0] = x;
        Game.coords[1] = y;
        Game.coords[2] = 0.0f;
        Game.coords[3] = x;
        Game.coords[4] = y + h;
        Game.coords[5] = 0.0f;
        Game.coords[6] = x + w;
        Game.coords[7] = y + h;
        Game.coords[8] = 0.0f;
        Game.coords[9] = x + w;
        Game.coords[10] = y;
        Game.coords[11] = 0.0f;
        if (crop == null) {
            crop = fullCrop;
        }
        Game.texCoords[0] = (float)crop[0] / width;
        Game.texCoords[1] = (float)crop[1] / height;
        Game.texCoords[2] = (float)crop[0] / width;
        Game.texCoords[3] = (float)(crop[1] + crop[3]) / height;
        Game.texCoords[4] = (float)(crop[0] + crop[2]) / width;
        Game.texCoords[5] = (float)(crop[1] + crop[3]) / height;
        Game.texCoords[6] = (float)(crop[0] + crop[2]) / width;
        Game.texCoords[7] = (float)crop[1] / height;
        Game.quadPos[0] = (short)coords[0];
        Game.quadPos[1] = (short)(height - coords[1]);
        Game.quadPos[2] = 1;
        Game.quadPos[3] = (short)coords[3];
        Game.quadPos[4] = (short)(height - coords[4]);
        Game.quadPos[5] = 1;
        Game.quadPos[6] = (short)coords[6];
        Game.quadPos[7] = (short)(height - coords[7]);
        Game.quadPos[8] = 1;
        Game.quadPos[9] = (short)coords[9];
        Game.quadPos[10] = (short)(height - coords[10]);
        Game.quadPos[11] = 1;
        Game.quadUv[0] = (short)(texCoords[0] * 256.0f);
        Game.quadUv[1] = (short)(texCoords[1] * 256.0f);
        Game.quadUv[2] = (short)(texCoords[2] * 256.0f);
        Game.quadUv[3] = (short)(texCoords[3] * 256.0f);
        Game.quadUv[4] = (short)(texCoords[4] * 256.0f);
        Game.quadUv[5] = (short)(texCoords[5] * 256.0f);
        Game.quadUv[6] = (short)(texCoords[6] * 256.0f);
        Game.quadUv[7] = (short)(texCoords[7] * 256.0f);
        quadPosArray.set(0, 4, quadPos);
        quadUvArray.set(0, 4, quadUv);
        quadBuffer.setPositions(quadPosArray, 1.0f, null);
        quadBuffer.setTexCoords(0, quadUvArray, 0.00390625f, null);
        if (color != null) {
            quadBuffer.setDefaultColor(color.toInt());
        } else {
            quadBuffer.setDefaultColor(-1);
        }
        appearance2D.setTexture(0, tex);
        g.render(quadBuffer, quadIndexBuffer, appearance2D, null);
    }

    private void playSoundAndVibrate(String id, int time) {
        midlet.soundPool().play(id);
        try {
            if (time != 0 && midlet.settings().vibrationsEnabled()) {
                DeviceControl.startVibra((int)50, (long)time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scheduleFlash(FlashData flashData) {
        this.flashAnim = 0.0f;
        this.flash = flashData;
    }

    private boolean collisionTest(float now) {
        int count = this.spotsCount;
        block11: for (int i = 0; i < count; ++i) {
            int currentSpot = this.spots[i];
            if (0 != (currentSpot & Integer.MIN_VALUE)) continue;
            int spotSeg = currentSpot & 0x3FFFF;
            int spotPos = currentSpot >> 18 & 0xF;
            int spotLen = currentSpot >> 22 & 0xF;
            int spotType = currentSpot >> 26 & 0x1F;
            if ((int)this.segment < spotSeg || (int)this.segment >= spotSeg + spotLen || !this.testTileHit(spotSeg, spotPos, true)) continue;
            int n = i;
            this.spots[n] = this.spots[n] | Integer.MIN_VALUE;
            switch (spotType) {
                case 5: {
                    this.enterZone(1);
                    continue block11;
                }
                case 9: {
                    this.enterZone(2);
                    continue block11;
                }
                case 6: {
                    this.enterZone(3);
                    continue block11;
                }
                case 7: {
                    this.enterZone(4);
                    continue block11;
                }
                case 8: {
                    this.enterZone(5);
                    continue block11;
                }
                case 1: {
                    this.addBonus(1);
                    continue block11;
                }
                case 2: {
                    this.addBonus(2);
                    continue block11;
                }
                case 4: {
                    this.addBonus(3);
                    continue block11;
                }
                case 3: {
                    this.addBonus(4);
                    continue block11;
                }
                default: {
                    this.addShield();
                }
            }
        }
        Debug.error("ccheck collision with tile emiters");
        boolean crashed = false;
        for (int i = 0; i < this.obstacleNdx.length; ++i) {
            this.obstacleNdx[i] = 0;
        }
        int obstaclesNum = this.obstacles.size();
        int i = 0;
        while (i < obstaclesNum) {
            Generator.Obstacle o = (Generator.Obstacle)this.obstacles.elementAt(i);
            boolean hit = this.testTileHit(o.segment, o.position, false);
            if (!hit && 1 == o.type) {
                if (!this.isMorphing) {
                    if (0 == this.tunnel.getCurrentPartType()) {
                        hit = this.testTileHit(o.segment, (o.position + 6) % 12, false);
                    }
                } else if (0 == this.tunnel.getCurrentPartType()) {
                    if (this.morphFactor <= 0.2f) {
                        hit = this.testTileHit(o.segment, (o.position + 6) % 12, false);
                    }
                } else if (0 == this.tunnel.getNextPartType() && this.morphFactor >= 0.8f) {
                    hit = this.testTileHit(o.segment, (o.position + 6) % 12, false);
                }
            }
            if (hit) {
                if (this.removeShields(1 == o.type ? 2 : 1)) {
                    this.omm.explode(o.type, now, this.eye, o.color, this.obstacleNdx[o.type]);
                    this.playerState.updateScore(1 == o.type ? 300 : 100);
                    this.scheduleFlash(FLASH_EXPLOSION);
                    this.playSoundAndVibrate("breakobs", 50);
                    this.obstacles.removeElementAt(i);
                    obstaclesNum = this.obstacles.size();
                    continue;
                }
                crashed = true;
                ++i;
                continue;
            }
            ++i;
            int n = o.type;
            this.obstacleNdx[n] = this.obstacleNdx[n] + 1;
        }
        crashed = crashed || this.testCollisionWithMovable(now, this.rollers);
        crashed = crashed || this.testCollisionWithMovable(now, this.bouncers);
        return crashed;
    }

    private boolean testCollisionWithMovable(float now, Vector list) {
        boolean crashed = false;
        int num = list.size();
        int i = 0;
        while (!crashed && i < num) {
            Generator.ObstacleBase obstacle = (Generator.ObstacleBase)list.elementAt(i);
            boolean hit = false;
            int clazz = obstacle._getClass();
            if (clazz == 1) {
                hit = this.testHit((Generator.Roller)obstacle);
            } else if (clazz == 2) {
                hit = this.testHit((Generator.Bouncer)obstacle);
            }
            if (hit) {
                if (this.removeShields(1)) {
                    if (clazz == 1) {
                        this.omm.addExplosion(0, now, this.eye, OBSTACLE_TRACE_HL_COLOR, ((Generator.Roller)obstacle).vertices);
                    } else if (clazz == 2) {
                        this.omm.addExplosion(0, now, this.eye, OBSTACLE_TRACE_HL_COLOR, ((Generator.Bouncer)obstacle).vertices);
                    }
                    list.removeElementAt(i);
                    num = list.size();
                    this.playerState.updateScore(200);
                    this.scheduleFlash(FLASH_EXPLOSION);
                    this.playSoundAndVibrate("breakobs", 50);
                    continue;
                }
                crashed = true;
                continue;
            }
            ++i;
        }
        return crashed;
    }

    private boolean testHit(Generator.Roller r) {
        boolean hit = false;
        if (r.hitpos1 >= 0) {
            boolean bl = hit = hit || this.testTileHit(r.segment, r.hitpos1, false);
        }
        if (r.hitpos2 >= 0) {
            hit = hit || this.testTileHit(r.segment, r.hitpos2, false);
        }
        return hit;
    }

    private boolean testHit(Generator.Bouncer b) {
        float len = b.t.length();
        boolean hit = false;
        if (len < 0.75f * TunnelMesh.SEGMENT_LEN) {
            boolean bl = hit = hit || this.testTileHit(b.segment, b.position, false);
        }
        if (0 == this.tunnel.getCurrentPartType() && len > 1.9318516f - 0.75f * TunnelMesh.SEGMENT_LEN) {
            hit = hit || this.testTileHit(b.segment, (b.position + 6) % 12, false);
        }
        return hit;
    }

    private boolean testTileHit(int tileSegment, int tilePosition, boolean skipSegmentTest) {
        float currentPos = (1.0f - this.rawPosition) * 6.0f;
        boolean hit = false;
        if (skipSegmentTest || this.segment >= (float)tileSegment - 0.6f && this.segment <= (float)tileSegment + 1.0f) {
            if (0 == tilePosition) {
                if (currentPos >= 11.75f) {
                    hit = !this.isMorphing && 1 != this.tunnel.getCurrentPartType();
                } else if (currentPos <= 1.25f) {
                    hit = true;
                }
            } else if (11 == tilePosition) {
                if (currentPos >= (float)tilePosition - 0.25f) {
                    hit = true;
                } else if (currentPos < 0.25f) {
                    hit = !this.isMorphing && 1 != this.tunnel.getCurrentPartType();
                }
            } else if (currentPos >= (float)tilePosition - 0.25f && currentPos <= (float)tilePosition + 1.0f + 0.25f) {
                hit = true;
            }
        }
        return hit;
    }

    public void init() {
        int tutorialsNum = midlet.settings().tutorialsNum();
        if (tutorialsNum > 0) {
            this.gameState = 5;
            midlet.settings().setTutorialsNum(tutorialsNum - 1);
            this.tutorialStage = 0;
            this.tutorialStageTimer = 0.0f;
        } else {
            this.gameState = 1;
        }
        this.startingAnim = 0.0f;
        for (int i = 0; i < this.startingLights.length; ++i) {
            this.startingLights[i].on = true;
            this.startingLights[i].beep = false;
            this.startingLights[i].coeff = 1.0f;
        }
        this.mainAnim = 0.0f;
        this.stateChangeAnim = 0.0f;
        this.effectiveRoll = 0.0f;
        this.startingSegment = 0;
        this.isMorphing = false;
        this.morphFactor = 0.0f;
        this.changeSegment = 0;
        this.changeSegmentNoFlat = 0;
        this.wasOuterPart = false;
        this.flatBandsAlpha = 0.0f;
        this.segment = 3.5f;
        this.rawPosition = 0.083333336f;
        this.inclination = 0.0f;
        this.playerState.reset();
        this.zone = 0;
        this.targetZone = 0;
        this.zoneAnim = 0.0f;
        this.zoneCountDown = -1;
        this.gravity = 0.0f;
        this.freezed = false;
        this.freezAnim = 0.0f;
        this.difficultySettings = this.DIFFICULTIES[this.difficulty];
        this.obstacleGeneratorLock = 0;
        this.lastGeneratorSegment = 17;
        this.spotsAnim = 0.0f;
        this.spotsCount = 0;
        this.nextSpotGen = 30;
        this.zoneSegNext = (int)(200.0 * this.rng.nextDouble()) + 200;
        this.flash = FLASH_STARTING_GAME;
        this.flashAnim = 0.0f;
        this.touchDown = false;
        this.omm.reset();
        this.obstacles.removeAllElements();
        this.rollers.removeAllElements();
        this.bouncers.removeAllElements();
        this.removeAllEmitters();
        this.tunnel.initialize();
        this.exiting = false;
        this.restarting = false;
        this.bonusActivated = false;
        this.timestampStomp = 0.0f;
        this.rollerStillTime = 0.0f;
        this.rollerShake = false;
        this.leftPressed = false;
        this.rightPressed = false;
    }

    private float randInRange(float min, float max) {
        float d = max - min;
        return this.rng.nextFloat() * d + min;
    }

    private void renderGeometry(Graphics3D g3d) {
        this.objTransform.setIdentity();
        if (2 == this.gameState && (this.isMorphing || 5 == this.zone || this.rollerShake)) {
            this.objTransform.postTranslate(this.randInRange(-0.01f, 0.01f), this.randInRange(-0.01f, 0.01f), 0.0f);
        }
        this.objTransform.postRotate(this.gravity * 15.0f, 0.0f, 1.0f, 0.0f);
        if (4 == this.gameState) {
            float angle = Math.min(55.0f, 90.0f * this.stateChangeAnim / 2.0f);
            this.objTransform.postRotate(angle, 1.0f, 0.0f, 0.0f);
        }
        this.objTransform.setIdentity();
        this.setupLookAt();
        g3d.setCamera(this.camera, this.camTransform);
        if (1 == this.zone) {
            Debug.error("setup color");
            this.appearance.setTexture(0, midlet.texturePool().getTexture("dark1"));
        } else {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("block1"));
        }
        this.appearance.setTexture(0, midlet.texturePool().getTexture("block1"));
        this.tunnel.render(g3d, this.appearance, this.objTransform, this.zone != 1);
        this.renderSpots(g3d);
        if (this.flatBandsAlpha > 0.0f) {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("redband"));
            CompositingMode cm = this.appearance.getCompositingMode();
            cm.setBlending(64);
            this.tunnel.renderBands(g3d, this.appearance, this.objTransform, this.flatBandsAlpha);
            cm.setBlending(68);
        }
        if (4 == this.zone) {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("dark1"));
        } else {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("block1"));
        }
        Color color = null;
        if (3 != this.zone) {
            color = null;
        } else {
            color = this.renderColor;
            color.b = 1.0f;
            color.g = 1.0f;
            color.r = 1.0f;
            color.a = 1.0f;
        }
        this.omm.render(g3d, 0, this.appearance, this.objTransform, color);
        this.omm.render(g3d, 1, this.appearance, this.objTransform, color);
        this.renderMovables(g3d, color);
        if (3 != this.zone) {
            color = null;
        } else {
            color = this.renderColor;
            color.r = 0.8f;
            color.g = 0.8f;
            color.b = 0.8f;
            color.a = 1.8f;
        }
        if (4 == this.zone) {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("darkspike1"));
        } else {
            this.appearance.setTexture(0, midlet.texturePool().getTexture("spike1"));
        }
        this.omm.render(g3d, 2, this.appearance, this.objTransform, color);
        Debug.error("render parricles");
    }

    private void renderSpotsIf(Graphics3D g3d, SpotPredicate pred, int type, Color color) {
        int totalCount = 0;
        int count = this.spotsCount;
        boolean ipos = false;
        int lenPos = 0;
        for (int i = 0; i < count; ++i) {
            int currentSpot = this.spots[i];
            int spotType = currentSpot >> 26 & 0x1F;
            if (pred.eval(spotType)) {
                int seg = (currentSpot & 0x3FFFF) - this.startingSegment;
                int pos = currentSpot >> 18 & 0xF;
                int len = currentSpot >> 22 & 0xF;
                int base = 13 * seg;
                int k = 0;
                while (k < len) {
                    if (base > 0) {
                        this.spotIndices[0] = base + pos + 12 + 1 + 1;
                        this.spotIndices[1] = base + pos + 12 + 1;
                        this.spotIndices[2] = base + pos + 1;
                        this.spotIndices[3] = base + pos;
                        this.spotStripsLen[0] = 4;
                        TriangleStripArray indexBuffer = new TriangleStripArray(this.spotIndices, this.spotStripsLen);
                        this.tunnel.renderSpots(g3d, this.spotAppearance, this.objTransform, (IndexBuffer)indexBuffer, color);
                        totalCount += 4;
                    }
                    ++k;
                    base += 13;
                }
            }
            if (totalCount <= 0) continue;
            int j = lenPos;
            while (i < this.spotStripsLen.length) {
                this.spotStripsLen[j] = 0;
                ++i;
            }
        }
    }

    private void renderSpotsList(Graphics3D g3d, SpotEntry[] spots, float coeff) {
        for (int i = 0; i < spots.length; ++i) {
            Color.blend(spots[i].c1, spots[i].c2, coeff, this.spotColor);
            this.SPOT_EQ_PRED.setFrist(spots[i].type);
            this.renderSpotsIf(g3d, this.SPOT_EQ_PRED, spots[i].type, this.spotColor);
        }
    }

    private void renderSpots(Graphics3D g3d) {
        this.spotCompMode.setDepthOffset(-1.0f, -10.0f);
        this.spotAppearance.setCompositingMode(this.spotCompMode);
        float coeff = 0.5f + 0.5f * (float)Math.sin(this.spotsAnim * 5.0f);
        int ndx = Math.min(this.spotTexs.length - 1, (int)(4.0 * (0.5 + 0.5 * (double)((float)Math.cos(this.spotsAnim * 10.0f)))));
        this.spotAppearance.setTexture(0, this.spotTexs[ndx]);
        this.renderSpotsList(g3d, this.SPOTENTRY_BONUSES, coeff);
        this.spotAppearance.setTexture(0, midlet.texturePool().getTexture("raster"));
        this.SPOT_LESS.setFrist(5);
        this.renderSpotsIf(g3d, this.SPOT_LESS, 5, this.spotWhite);
        if (0 == this.zone) {
            this.spotAppearance.setTexture(0, midlet.texturePool().getTexture("bar"));
            this.renderSpotsList(g3d, this.SPOTENTRY_ZONES, coeff);
        }
    }

    private void renderMovables(Graphics3D g3d, Color color) {
        int rollersNum = this.rollers.size();
        if (color != null) {
            this.movableVertexBuffer.setDefaultColor(color.toInt());
        } else {
            this.movableVertexBuffer.setDefaultColor(-1);
        }
        for (int i = 0; i < rollersNum; ++i) {
            Generator.Roller r = (Generator.Roller)this.rollers.elementAt(i);
            this.movableTransform.set(this.objTransform);
            this.movableTransform.postTranslate(r.origin.x, r.origin.y, r.origin.z);
            this.movableTransform.postRotate(r.angle, r.axis.x, r.axis.y, r.axis.z);
            this.movableTransform.postTranslate(-r.origin.x, -r.origin.y, -r.origin.z);
            for (int j = 0; j < r.vertices.length; ++j) {
                this.movablePosBuffer[j] = (short)(r.vertices[j] * 64.0f);
            }
            this.movablePosVertexArray.set(0, 24, this.movablePosBuffer);
            this.movableVertexBuffer.setPositions(this.movablePosVertexArray, 0.015625f, null);
            this.movableVertexBuffer.setTexCoords(0, this.movableUvVertexArray, 1.0f, null);
            g3d.render(this.movableVertexBuffer, this.movableIndexBuffer, this.appearance, this.movableTransform);
        }
        int bouncersNum = this.bouncers.size();
        for (int i = 0; i < bouncersNum; ++i) {
            Generator.Bouncer b = (Generator.Bouncer)this.bouncers.elementAt(i);
            this.movableTransform.set(this.objTransform);
            this.movableTransform.postTranslate(b.t.x, b.t.y, b.t.z);
            for (int j = 0; j < b.vertices.length; ++j) {
                this.movablePosBuffer[j] = (short)(b.vertices[j] * 64.0f);
            }
            this.movablePosVertexArray.set(0, 24, this.movablePosBuffer);
            this.movableVertexBuffer.setPositions(this.movablePosVertexArray, 0.015625f, null);
            this.movableVertexBuffer.setTexCoords(0, this.movableUvVertexArray, 1.0f, null);
            g3d.render(this.movableVertexBuffer, this.movableIndexBuffer, this.appearance, this.movableTransform);
        }
    }

    private void setupLookAt() {
        int basepos;
        int segInt = (int)this.segment - this.startingSegment;
        float segRem = this.segment - (float)((int)this.segment);
        float remappedPosition = (1.0f - this.rawPosition) * 6.0f;
        int posInt = (int)remappedPosition;
        float posRem = 1.0f - (remappedPosition - (float)posInt);
        this.tunnel.calculatePointAndNormalAt(segInt, segRem, posInt, posRem, !this.isMorphing, this.eye, this._up);
        if (segRem > 0.5f) {
            this.tunnel.calculatePointAndNormalAt(segInt + 1, segRem, posInt, posRem, !this.isMorphing, null, this._up2);
            Vector3f.lerp(this._up, this._up, this._up2, segRem - 0.5f);
            this._up.normalize();
        } else {
            this.tunnel.calculatePointAndNormalAt(segInt - 1, segRem, posInt, posRem, !this.isMorphing, null, this._up2);
            Vector3f.lerp(this._up, this._up2, this._up, segRem + 0.5f);
            this._up.normalize();
        }
        this.eye.x += this._up.x * 0.25f;
        this.eye.y += this._up.y * 0.25f;
        this.eye.z += this._up.z * 0.25f;
        if (!this.isMorphing) {
            if (1 == this.tunnel.getCurrentPartType()) {
                this._mtx.setIdentity();
                basepos = segInt * 13 + posInt;
                this.tunnel.calculateVectorBetween(basepos + 1 + 13, basepos + 1, this._dir);
                this._dir.normalize();
                this._mtx.setupRotate(this.effectiveRoll, this._dir);
                this._mtx.transform(this._up, this._up);
            }
        } else {
            this._mtx.setIdentity();
            basepos = segInt * 13 + posInt;
            this.tunnel.calculateVectorBetween(basepos + 1 + 13, basepos + 1, this._dir);
            this._dir.normalize();
            if (1 == this.tunnel.getCurrentPartType()) {
                this._mtx.setupRotate((1.0f - this.morphFactor) * this.effectiveRoll, this._dir);
            } else {
                this._mtx.setupRotate(this.morphFactor * this.effectiveRoll, this._dir);
            }
            this._mtx.transform(this._up, this._up);
        }
        float upX = this._up.x;
        float upY = this._up.y;
        float upZ = this._up.z;
        this.tunnel.calculatePointAndNormalAt(segInt + 2, segRem, posInt, posRem, !this.isMorphing, this._center, this._up);
        if (segRem > 0.5f) {
            this.tunnel.calculatePointAndNormalAt(segInt + 3, segRem, posInt, posRem, !this.isMorphing, null, this._up2);
            Vector3f.lerp(this._up, this._up, this._up2, segRem - 0.5f);
            this._up.normalize();
        } else {
            this.tunnel.calculatePointAndNormalAt(segInt + 1, segRem, posInt, posRem, !this.isMorphing, null, this._up2);
            Vector3f.lerp(this._up, this._up2, this._up, segRem + 0.5f);
            this._up.normalize();
        }
        this._center.x += this._up.x * 0.25f;
        this._center.y += this._up.y * 0.25f;
        this._center.z += this._up.z * 0.25f;
        this._view.x = this._center.x - this.eye.x;
        this._view.y = this._center.y - this.eye.y;
        this._view.z = this._center.z - this.eye.z;
        this._up.x = upX;
        this._up.y = upY;
        this._up.z = upZ;
        this._view.normalize();
        this._up.normalize();
        Vector3f.cross(this._right, this._view, this._up);
        this._right.normalize();
        Vector3f.cross(this._up, this._right, this._view);
        this.camMatrix = new float[16];
        this.camMatrix[0] = this._right.x;
        this.camMatrix[1] = this._up.x;
        this.camMatrix[2] = -this._view.x;
        this.camMatrix[3] = this.eye.x;
        this.camMatrix[4] = this._right.y;
        this.camMatrix[5] = this._up.y;
        this.camMatrix[6] = -this._view.y;
        this.camMatrix[7] = this.eye.y;
        this.camMatrix[8] = this._right.z;
        this.camMatrix[9] = this._up.z;
        this.camMatrix[10] = -this._view.z;
        this.camMatrix[11] = this.eye.z;
        this.camMatrix[12] = 0.0f;
        this.camMatrix[13] = 0.0f;
        this.camMatrix[14] = 0.0f;
        this.camMatrix[15] = 1.0f;
        this.camTransform.set(this.camMatrix);
    }

    private boolean update(float now) {
        int i;
        float hlCoeff;
        float coeff;
        float currentPos = (1.0f - this.rawPosition) * 6.0f;
        int newSegments = (int)(this.segment - (float)this.startingSegment) - 3;
        if (newSegments > 0) {
            this.playerState.updateScore(newSegments);
            this.tunnel.moveBy(newSegments);
            this.startingSegment += newSegments;
            this.removeAll();
            this.generateAll(now);
        }
        this.rollerShake = false;
        int rollersNum = this.rollers.size();
        for (int i2 = 0; i2 < rollersNum; ++i2) {
            Generator.Roller r = (Generator.Roller)this.rollers.elementAt(i2);
            float dt = now - r.timestamp;
            float targetAngle = PART_INNER_ANGLE[this.tunnel.getCurrentPartType()] - 90.0f;
            if (dt > 0.0f) {
                float angle = this.difficultySettings.rollersAngualVelocity * dt;
                if (angle >= targetAngle) {
                    angle = 0.0f;
                    int pos = r.position + (r.dir ? 1 : -1);
                    if (1 == this.tunnel.getCurrentPartType()) {
                        if (11 == pos || 0 == pos) {
                            r.dir = !r.dir;
                        }
                    } else if (pos < 0) {
                        pos = 11;
                    }
                    r.position = pos % 12;
                    this.generateMesh(r);
                    r.timestamp = now + 0.5f * targetAngle / this.difficultySettings.rollersAngualVelocity;
                    this.timestampStomp = now;
                    this.rollerStillTime = 0.5f * targetAngle / this.difficultySettings.rollersAngualVelocity;
                }
                float f = r.angle = r.dir ? angle : -angle;
            }
            if ((coeff = 0.0f) > 0.3f) {
                r.hitpos2 = r.position + (r.dir ? 1 : -1);
                if (1 == this.tunnel.getCurrentPartType()) {
                    if (r.hitpos2 >= 12) {
                        r.hitpos2 = -1;
                    }
                } else {
                    if (r.hitpos2 < 0) {
                        r.hitpos2 = 12 + r.hitpos2;
                    }
                    r.hitpos2 %= 12;
                }
                r.hitpos1 = coeff > 0.7f ? -1 : r.position;
            } else {
                r.hitpos1 = r.position;
                r.hitpos2 = -1;
            }
            r.hlpos1 = r.position;
            r.hlpos2 = r.position + (r.dir ? 1 : -1);
            if (1 == this.tunnel.getCurrentPartType()) {
                if (r.hlpos2 >= 12) {
                    r.hlpos2 = -1;
                }
            } else {
                if (r.hlpos2 < 0) {
                    r.hlpos2 = 12 + r.hlpos2;
                }
                r.hlpos2 %= 12;
            }
            if ((hlCoeff = (this.segment + 5.0f + 10.0f - (float)r.segment) / 10.0f) > 1.0f) {
                hlCoeff = 1.0f;
            }
            float coeff1 = 0.0f;
            float coeff2 = 0.0f;
            if (r.hitpos1 >= 0) {
                coeff1 = this.proximityCoeff(r.hitpos1, currentPos);
            }
            if (r.hitpos2 >= 0) {
                coeff1 = this.proximityCoeff(r.hitpos2, currentPos);
            }
            r.hlCoeff = Math.max(coeff1, coeff2) * hlCoeff;
        }
        this.rollerShake = now - this.timestampStomp < this.rollerStillTime / 2.0f;
        int bouncersNum = this.bouncers.size();
        for (i = 0; i < bouncersNum; ++i) {
            float len;
            Generator.Bouncer b = (Generator.Bouncer)this.bouncers.elementAt(i);
            float dt = now - b.timestamp;
            coeff = (1.9318516f - TunnelMesh.SEGMENT_LEN) * (0.5f * (float)Math.sin(Math.PI * (double)dt / (double)this.difficultySettings.bouncersVelocityCoeff) + 0.5f);
            b.t.x = b.dir.x * coeff;
            b.t.y = b.dir.y * coeff;
            b.t.z = b.dir.z * coeff;
            hlCoeff = (this.segment + 5.0f + 10.0f - (float)b.segment) / 10.0f;
            if (hlCoeff > 1.0f) {
                hlCoeff = 1.0f;
            }
            hlCoeff = (len = b.t.length()) < 0.75f * TunnelMesh.SEGMENT_LEN ? (hlCoeff *= this.proximityCoeff(b.position, currentPos)) : ((double)len > 1.9318516254425049 - 0.75 * (double)TunnelMesh.SEGMENT_LEN ? (0 == this.tunnel.getCurrentPartType() ? (hlCoeff *= this.proximityCoeff((b.position + 6) % 12, currentPos)) : 0.0f) : (len < TunnelMesh.SEGMENT_LEN ? (hlCoeff *= 4.0f * (TunnelMesh.SEGMENT_LEN - len) * this.proximityCoeff(b.position, currentPos)) : (len > 1.9318516f - TunnelMesh.SEGMENT_LEN ? (0 == this.tunnel.getCurrentPartType() ? (hlCoeff *= 4.0f * (len - 1.9318516f + 12.0f) * this.proximityCoeff((b.position + 6) % 12, currentPos)) : 0.0f) : 0.0f)));
            b.hlCoeff = hlCoeff;
        }
        if (this.zone != 3) {
            this.updateColors();
        } else {
            this.updateHueShiftColors(now);
        }
        this.handleZones();
        if (this.bonusActivated) {
            this.bonusActivated = false;
            switch (this.playerState.getBonus()) {
                case 1: {
                    this.scheduleFlash(FLASH_QUAKE);
                    int explosions = 0;
                    int total = 0;
                    for (i = 0; i < this.obstacles.size(); ++i) {
                        Generator.Obstacle o = (Generator.Obstacle)this.obstacles.elementAt(i);
                        if (explosions < 15) {
                            ++explosions;
                            this.omm.explode(o.type, now, this.eye, o.color, 0);
                        }
                        ++total;
                    }
                    this.obstacles.removeAllElements();
                    this.omm.clear();
                    for (i = 0; i < this.rollers.size(); ++i) {
                        Generator.Roller r = (Generator.Roller)this.rollers.elementAt(i);
                        if (explosions < 15) {
                            ++explosions;
                            this.omm.addExplosion(0, now, this.eye, OBSTACLE_TRACE_HL_COLOR, r.vertices);
                        }
                        ++total;
                    }
                    for (i = 0; i < this.bouncers.size(); ++i) {
                        Generator.Bouncer r = (Generator.Bouncer)this.bouncers.elementAt(i);
                        if (explosions < 15) {
                            ++explosions;
                            this.omm.addExplosion(0, now, this.eye, OBSTACLE_TRACE_HL_COLOR, r.vertices);
                        }
                        ++total;
                    }
                    this.rollers.removeAllElements();
                    this.bouncers.removeAllElements();
                    this.playSoundAndVibrate("shockwave", 300);
                    break;
                }
                case 2: {
                    this.freezAnim = 0.0f;
                    this.freezed = true;
                    this.scheduleFlash(FLASH_FREEZ);
                    this.playSoundAndVibrate("freez", 100);
                    break;
                }
                case 3: {
                    if (0 == this.zone) break;
                    this.zoneAnim = 7.0f;
                    this.playSoundAndVibrate("fold", 100);
                    break;
                }
            }
            this.playerState.updateBonus(0);
        }
        if (this.freezed && this.freezAnim > 10.0f) {
            int i3;
            this.scheduleFlash(FLASH_FREEZ_END);
            this.freezed = false;
            for (i3 = 0; i3 < this.rollers.size(); ++i3) {
                ((Generator.Roller)this.rollers.elementAt((int)i3)).timestamp += this.freezAnim;
            }
            for (i3 = 0; i3 < this.bouncers.size(); ++i3) {
                ((Generator.Bouncer)this.bouncers.elementAt((int)i3)).timestamp += this.freezAnim;
            }
        }
        this.updateTunnel();
        this.tunnel.updateVBO();
        return true;
    }

    private void updateTunnel() {
        int seg_ = (int)(this.segment - (float)this.changeSegment);
        this.isMorphing = false;
        if (seg_ > 100) {
            if (seg_ <= 130) {
                if (this.tunnel.getCurrentPartType() != this.tunnel.getNextPartType()) {
                    this.isMorphing = true;
                    this.morphFactor = Math.min(1.0f, (this.segment - 100.0f - (float)this.changeSegment) / 30.0f);
                    this.morph((int)(256.0f * this.morphFactor));
                }
            } else {
                if (this.tunnel.getCurrentPartType() != this.tunnel.getNextPartType()) {
                    this.morph(256);
                }
                this.changeSegment += 130;
                this.tunnel.setNextPartType(this.generateNextPartType());
                if (1 != this.tunnel.getCurrentPartType()) {
                    this.changeSegmentNoFlat = this.changeSegment;
                }
            }
        }
        this.updateBandBlend();
    }

    private void updateBandBlend() {
        this.flatBandsAlpha = 0.0f;
        int seg = (int)(this.segment - (float)this.changeSegmentNoFlat);
        float len = this.segment - 100.0f + 20.0f;
        float lenCoeff = 0.4f;
        if (seg > 80 && seg <= 130) {
            if (this.tunnel.getCurrentPartType() != this.tunnel.getNextPartType()) {
                if (1 == this.tunnel.getNextPartType()) {
                    float coeff = Math.min(1.0f, len / 5.0f);
                    this.flatBandsAlpha = (0.5f + 0.25f * ((float)Math.sin(0.4f * len) + 1.0f)) * coeff;
                } else if (1 == this.tunnel.getCurrentPartType()) {
                    float coeff = 1.0f - Math.min(1.0f, (len + 20.0f + 30.0f - 5.0f) / 5.0f);
                    this.flatBandsAlpha = (0.5f + 0.25f * ((float)Math.sin(0.4f * len) + 1.0f)) * coeff;
                }
            } else if (1 == this.tunnel.getCurrentPartType()) {
                this.flatBandsAlpha = 0.5f + 0.25f * ((float)Math.sin(0.4f * len) + 1.0f);
            }
        } else if (1 == this.tunnel.getCurrentPartType()) {
            this.flatBandsAlpha = 0.5f + 0.25f * ((float)Math.sin(0.4f * len) + 1.0f);
        }
    }

    private int generateNextPartType() {
        int nextPart;
        if (1 == this.tunnel.getNextPartType()) {
            if (!this.wasOuterPart || this.rng.nextInt(2) != 0) {
                nextPart = this.rng.nextInt(2) != 0 ? 0 : 2;
                this.wasOuterPart = 2 == nextPart;
            } else {
                nextPart = 0;
                this.wasOuterPart = false;
            }
        } else {
            nextPart = 0 == this.tunnel.getNextPartType() ? (this.rng.nextInt(2) != 0 ? 1 : 0) : 1;
        }
        return nextPart;
    }

    private void morph(int morphCoeff) {
        this.tunnel.morph(morphCoeff);
        Debug.error("Morph implement me!");
        this.omm.clear();
        int size = this.obstacles.size();
        for (int i = 0; i < size; ++i) {
            Generator.ObstacleBase o = (Generator.ObstacleBase)this.obstacles.elementAt(i);
            if (!o.generated) continue;
            this.generateMesh(o);
        }
    }

    private void sortAllObstacles() {
        int size;
        int gap = size = this.allObstacles.size();
        boolean swapped = true;
        while (gap > 1 || swapped) {
            if (gap > 1) {
                gap = (int)((double)gap / 1.247330950103979);
            }
            swapped = false;
            int i = 0;
            while (gap + i < size) {
                if (((Generator.ObstacleBase)this.allObstacles.elementAt((int)i)).segment - ((Generator.ObstacleBase)this.allObstacles.elementAt((int)(i + gap))).segment > 0) {
                    Object swap = this.allObstacles.elementAt(i);
                    this.allObstacles.setElementAt(this.allObstacles.elementAt(i + gap), i);
                    this.allObstacles.setElementAt(swap, i + gap);
                    swapped = true;
                }
                ++i;
            }
        }
    }

    private void updateColors() {
        float currentPos = (1.0f - this.rawPosition) * 6.0f;
        int currentSeg = (int)this.segment;
        float beamCoeff = 0.0f;
        this.baseTrackColor.set(BASE_TRACK_COLOR);
        if (4 == this.zone) {
            float c = (float)(0.5 + 0.3 * Math.sin(this.zoneAnim * 5.0f));
            this.baseTrackColor.g = this.baseTrackColor.b = (c = Math.min(1.0f, Math.max(0.0f, c)));
            this.baseTrackColor.r = this.baseTrackColor.b;
            this.baseTrackColor.a = 1.0f;
        }
        this.tunnel.clearColor(this.baseTrackColor);
        if (this.isMorphing) {
            if (2 != this.tunnel.getCurrentPartType() && 2 != this.tunnel.getNextPartType()) {
                if (1 == this.tunnel.getNextPartType()) {
                    beamCoeff = 1.0f - this.morphFactor * 4.0f;
                    beamCoeff = Math.max(0.0f, beamCoeff);
                } else {
                    beamCoeff = this.morphFactor * 2.0f - 1.0f;
                    beamCoeff = Math.max(0.0f, beamCoeff);
                }
            }
        } else if (0 == this.tunnel.getCurrentPartType()) {
            beamCoeff = 1.0f;
        }
        this.allObstacles.removeAllElements();
        this.allObstacles.ensureCapacity(this.obstacles.size() + this.rollers.size());
        int obstaclesCount = this.obstacles.size();
        for (int i = 0; i < obstaclesCount; ++i) {
            this.allObstacles.addElement(this.obstacles.elementAt(i));
        }
        int rollersCount = this.rollers.size();
        for (int i = 0; i < rollersCount; ++i) {
            this.allObstacles.addElement(this.rollers.elementAt(i));
        }
        this.sortAllObstacles();
        int allObstaclesCount = rollersCount + obstaclesCount;
        for (int i = allObstaclesCount - 1; i >= 0; --i) {
            int pos;
            Generator.ObstacleBase base = (Generator.ObstacleBase)this.allObstacles.elementAt(i);
            if (base.segment - currentSeg > 25) continue;
            int endseg = Math.max(0, base.segment - 25 - this.startingSegment);
            float offset = this.segment - (float)(base.segment - 25);
            float blendCoeff = Math.min(1.0f, offset / 10.0f);
            float hlCoeff = Math.max(0.0f, Math.min(1.0f, (this.segment + 5.0f + 10.0f - (float)base.segment) / 10.0f));
            if (0 == base._getClass()) {
                Generator.Obstacle o = (Generator.Obstacle)base;
                if (4 == this.zone) {
                    Color.blend(this.baseTrackColor, OBSTACLE_TRACE_HL_COLOR, blendCoeff * hlCoeff * this.proximityCoeff(o.position, currentPos), this.color);
                } else {
                    Color.blend(o.color, OBSTACLE_TRACE_HL_COLOR, hlCoeff * this.proximityCoeff(o.position, currentPos), this.color);
                    Color.blend(this.baseTrackColor, this.color, blendCoeff, this.color);
                }
                this.tunnel.fillColorStrip(endseg, o.segment - this.startingSegment, o.position, this.color);
                if (1 != o.type || !(beamCoeff > 0.0f)) continue;
                int pos2 = (o.position + 6) % 12;
                if (4 == this.zone) {
                    Color.blend(this.baseTrackColor, OBSTACLE_TRACE_HL_COLOR, blendCoeff * hlCoeff * this.proximityCoeff(pos2, currentPos), this.color);
                } else {
                    Color.blend(o.color, OBSTACLE_TRACE_HL_COLOR, hlCoeff * this.proximityCoeff(pos2, currentPos), this.color);
                    Color.blend(this.baseTrackColor, this.color, blendCoeff, this.color);
                }
                this.tunnel.blendColorStrip(endseg, o.segment - this.startingSegment, pos2, this.color, beamCoeff);
                continue;
            }
            Generator.Roller r = (Generator.Roller)base;
            float coeff2 = Math.abs(r.angle / (PART_INNER_ANGLE[this.tunnel.getCurrentPartType()] - 90.0f));
            if (r.hlpos1 > 0) {
                pos = r.hlpos1;
                if (4 == this.zone) {
                    Color.blend(this.baseTrackColor, OBSTACLE_TRACE_HL_COLOR, blendCoeff * hlCoeff * this.proximityCoeff(pos, currentPos), this.color);
                } else {
                    Color.blend(r.color, OBSTACLE_TRACE_HL_COLOR, hlCoeff * this.proximityCoeff(pos, currentPos), this.color);
                    Color.blend(this.baseTrackColor, this.color, blendCoeff, this.color);
                }
                this.tunnel.blendColorStrip(endseg, r.segment - this.startingSegment, pos, this.color, 1.0f - coeff2);
            }
            if (r.hlpos2 <= 0) continue;
            pos = r.hlpos2;
            if (4 == this.zone) {
                Color.blend(this.baseTrackColor, OBSTACLE_TRACE_HL_COLOR, blendCoeff * hlCoeff * this.proximityCoeff(pos, currentPos), this.color);
            } else {
                Color.blend(r.color, OBSTACLE_TRACE_HL_COLOR, hlCoeff * this.proximityCoeff(pos, currentPos), this.color);
                Color.blend(this.baseTrackColor, this.color, blendCoeff, this.color);
            }
            this.tunnel.blendColorStrip(endseg, r.segment - this.startingSegment, pos, this.color, coeff2);
        }
    }

    private void updateHueShiftColors(float now) {
        int i;
        for (i = 0; i < 12; ++i) {
            float coeff = 0.5f * (float)Math.cos(Math.PI * 2 * (double)now * (double)this.hueShiftCycle[i]) + 0.5f;
            Color.blend(this.hueShiftFrom[i], this.hueShiftTo[i], coeff, this.hueShift[i]);
            this.hueShift[i].a *= 0.8f;
            this.hueShift[i].r *= 0.8f;
            this.hueShift[i].g *= 0.8f;
            this.hueShift[i].b *= 0.8f;
        }
        for (i = 0; i < 12; ++i) {
            this.tunnel.fillColorStrip(0, 30, i, this.hueShift[i]);
        }
    }

    private float proximityCoeff(int obstaclePos, float pos) {
        float coeff = 0 == obstaclePos ? Math.min(Math.abs(0.5f - pos), Math.abs(12.5f - pos)) : (11 == obstaclePos ? Math.min(Math.abs(-0.5f - pos), Math.abs(11.5f - pos)) : Math.abs((float)obstaclePos + 0.5f - pos));
        coeff = (double)coeff > 1.25 ? 0.0f : Math.min(1.0f, (float)Math.sqrt(1.25f - coeff));
        return coeff;
    }

    private void enterZone(int target) {
        if (0 == this.zone && this.zoneCountDown < 0) {
            this.zoneCountDown = 3;
            this.zoneAnim = 0.0f;
            this.targetZone = target;
            this.zoneCoeff1 = (float)(Math.PI * 2 * this.rng.nextDouble());
            this.zoneCoeff2 = (float)(Math.PI * 2 * this.rng.nextDouble());
            this.scheduleFlash(FLASH_ZONE);
            this.playSoundAndVibrate("warning", 50);
        }
    }

    private void handleZones() {
        if (this.zoneCountDown > 0) {
            if (this.zoneAnim > 1.0f) {
                --this.zoneCountDown;
                this.zoneAnim = 0.0f;
                this.scheduleFlash(FLASH_ZONE);
                if (0 == this.zoneCountDown) {
                    this.zone = this.targetZone;
                    this.zoneCountDown = -1;
                    if (3 == this.zone) {
                        Rainbow rainbow = Generator.getRainbow(this.rng);
                        for (int i = 0; i < 12; ++i) {
                            rainbow.getColor(this.hueShiftFrom[i]);
                            rainbow.getColor(this.hueShiftTo[i]);
                            this.hueShiftCycle[i] = (float)(this.rng.nextDouble() * 0.4 + 0.6);
                        }
                    } else if (5 == this.zone) {
                        Debug.error("reset particles");
                        this.lastEmitSeg = this.startingSegment;
                    }
                }
            }
        } else if (0 != this.zone && this.zoneAnim > 7.0f) {
            if (5 == this.zone) {
                this.removeAllEmitters();
            } else if (2 == this.zone) {
                // empty if block
            }
            this.scheduleFlash(FLASH_ZONE);
            this.zone = 0;
            this.zoneAnim = 0.0f;
            this.zoneSegNext = this.startingSegment + this.rng.nextInt() % 200 + 200;
        }
    }

    private void addBonus(int type) {
        if (0 == this.playerState.getBonus()) {
            this.playerState.updateBonus(type);
            this.playSoundAndVibrate("bonusup", 200);
        }
    }

    private void addShield() {
        if (this.playerState.getShields() < 4) {
            this.playSoundAndVibrate("shieldup", 100);
            this.scheduleFlash(FLASH_SHIELD);
        }
        this.playerState.updateShields(1);
    }

    private boolean removeShields(int count) {
        if (this.playerState.getShields() >= count) {
            this.playerState.updateShields(-count);
            return true;
        }
        return false;
    }

    private void removeOutside(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            Generator.Movable m = (Generator.Movable)v.elementAt(i);
            if (m.segment > this.startingSegment) continue;
            v.removeElementAt(i);
            --i;
        }
    }

    private void removeAll() {
        int i;
        for (i = 0; i < this.toRemove.length; ++i) {
            this.toRemove[i] = 0;
        }
        while (!this.obstacles.isEmpty()) {
            Generator.Obstacle o = (Generator.Obstacle)this.obstacles.firstElement();
            if (o.segment > this.startingSegment) break;
            int n = o.type;
            this.toRemove[n] = this.toRemove[n] + 1;
            this.obstacles.removeElementAt(0);
        }
        for (i = 0; i < this.toRemove.length; ++i) {
            this.omm.remove(i, this.toRemove[i]);
        }
        this.removeOutside(this.rollers);
        this.removeOutside(this.bouncers);
        int removedCount = 0;
        int i2 = 0;
        int count = this.spotsCount;
        while (i2 < count && (this.spots[i2] & 0x3FFFF) <= this.startingSegment) {
            ++i2;
            ++removedCount;
        }
        if (removedCount > 0) {
            for (i2 = 0; i2 < this.spotsCount - removedCount; ++i2) {
                this.spots[i2] = this.spots[i2 + removedCount];
            }
            this.spotsCount -= removedCount;
        }
    }

    private void generateAll(float now) {
        if (5 == this.zone) {
            Debug.error("generate all remove emiters");
        }
        this.generateIfNeeded(this.obstacles);
        this.generateIfNeeded(this.rollers);
        this.generateIfNeeded(this.bouncers);
        int obstacleGeneratorFreq = 12 - this.startingSegment / 300;
        obstacleGeneratorFreq = Math.max(8, obstacleGeneratorFreq);
        for (int i = this.lastGeneratorSegment; i < this.startingSegment + 30 - 5; ++i) {
            if (0 != i % obstacleGeneratorFreq) continue;
            if (this.obstacleGeneratorLock > 0) {
                --this.obstacleGeneratorLock;
                continue;
            }
            boolean nonMorphPos = i < this.changeSegment + 100 - 30;
            boolean outsidePos = nonMorphPos && 0 != this.tunnel.getCurrentPartType();
            int level = this.startingSegment / 150;
            this.obstacleGeneratorLock = this.generate(this.rng, now, i, level, !this.difficultySettings.pure && nonMorphPos, outsidePos);
        }
        this.lastGeneratorSegment = this.startingSegment + 30 - 5;
        this.generateSpots();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateSpots() {
        int generatorFreq = 12 - this.startingSegment / 300;
        generatorFreq = 3 * Math.max(8, generatorFreq);
        int count = (int)((double)(1 + this.startingSegment / 450) * this.rng.nextDouble());
        count = Math.min(3, 1 + count);
        int increment = 12 / count;
        while (true) {
            int i;
            int currentPos;
            if (this.nextSpotGen < this.startingSegment + 30 - 3) {
                int pos = (int)(12.0 * this.rng.nextDouble());
                currentPos = pos;
            } else {
                if (this.zoneSegNext <= this.startingSegment) return;
                if (this.zoneSegNext >= this.startingSegment + 30) return;
                int type = this.generateZoneSpotType();
                if (type < 0) {
                    this.zoneSegNext = this.startingSegment + (int)(200.0 * this.rng.nextDouble()) + 200;
                    return;
                }
                i = 0;
                while (true) {
                    if (i >= 12) {
                        this.zoneSegNext = Integer.MAX_VALUE;
                        return;
                    }
                    int spot = type << 26 | 0x400000 | i << 18 | this.zoneSegNext;
                    this.spots[this.spotsCount++] = spot;
                    ++i;
                }
            }
            for (i = 0; i < count; ++i, currentPos += increment) {
                int type;
                int p;
                block15: {
                    block16: {
                        boolean quake = false;
                        p = currentPos % 12;
                        type = 0;
                        if (this.difficultySettings.pure) break block15;
                        if (this.nextSpotGen > 750) {
                            quake = 0 == this.rng.nextInt() % 5;
                        } else {
                            boolean bl = quake = 0 == this.rng.nextInt() % 10;
                        }
                        if (quake) break block16;
                        if (this.nextSpotGen > 300) {
                            int v = (int)(6.0 * this.rng.nextDouble());
                            if (0 == v) {
                                type = 2;
                                break block15;
                            } else if (1 == v) {
                                type = 4;
                                break block15;
                            } else if (2 != v) {
                                // empty if block
                            }
                        }
                        break block15;
                    }
                    type = 1;
                }
                int spot = type << 26 | 0xC00000 | p << 18 | this.nextSpotGen;
                this.spots[this.spotsCount++] = spot;
            }
            this.nextSpotGen += generatorFreq;
        }
    }

    private int generateZoneSpotType() {
        if (this.difficultySettings.pure) {
            return (this.rng.nextInt() & 1) != 0 ? 5 : -1;
        }
        return (int)(5.0 * this.rng.nextDouble()) + 5;
    }

    private void generateIfNeeded(Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Generator.ObstacleBase o = (Generator.ObstacleBase)v.elementAt(i);
            if (o.generated || o.segment >= this.startingSegment + 30 - 1) continue;
            this.generateMesh(o);
        }
    }

    public void addObstacle(int type, int segment, int position, Color color) {
        Generator.Obstacle o = new Generator.Obstacle(this);
        this.obstacles.addElement(o);
        o.type = type;
        o.segment = segment;
        o.position = position;
        o.color.set(color);
        o.generated = false;
        if (o.segment < this.startingSegment + 30 - 1) {
            this.generateMesh(o);
        }
    }

    public void addRoller(int segment, int position, float timestamp, Color color, boolean dir) {
        Generator.Roller o = new Generator.Roller(this);
        this.rollers.addElement(o);
        o.segment = segment;
        o.position = position;
        o.angle = 0.0f;
        o.dir = dir;
        o.color.set(color);
        o.generated = false;
        o.timestamp = timestamp;
        o.hitpos1 = position;
        o.hitpos2 = -1;
        if (o.segment < this.startingSegment + 30 - 1) {
            this.generateMesh(o);
        }
    }

    public void addBouncer(int segment, int position, float timestamp, Color color) {
        Generator.Bouncer o = new Generator.Bouncer(this);
        this.bouncers.addElement(o);
        o.segment = segment;
        o.position = position;
        o.color.set(color);
        o.generated = false;
        o.timestamp = timestamp;
        if (o.segment < this.startingSegment + 30 - 1) {
            this.generateMesh(o);
        }
    }

    private void generateMesh(Generator.ObstacleBase o) {
        switch (o._getClass()) {
            case 2: {
                this.generateMesh((Generator.Bouncer)o);
                break;
            }
            case 0: {
                this.generateMesh((Generator.Obstacle)o);
                break;
            }
            case 1: {
                this.generateMesh((Generator.Roller)o);
                break;
            }
            default: {
                Debug.error("Invalid obstacle class");
            }
        }
    }

    private void generateMesh(Generator.Bouncer b) {
        float[] vertices = b.vertices;
        this.tunnel.getTileVertices(b.segment - this.startingSegment, b.position, this.base);
        b.dir.set(ObstacleMeshManager.createCubeMesh(vertices, this.base, TunnelMesh.SEGMENT_LEN));
        b.generated = true;
    }

    private void generateMesh(Generator.Roller r) {
        float originz;
        float originy;
        float originx;
        float[] vertices = r.vertices;
        this.tunnel.getTileVertices(r.segment - this.startingSegment, r.position, this.base);
        ObstacleMeshManager.createCubeMesh(vertices, this.base, TunnelMesh.SEGMENT_LEN);
        if (!r.dir) {
            originx = vertices[0];
            originy = vertices[1];
            originz = vertices[2];
            r.axis.set(originx - vertices[6], originy - vertices[7], originz - vertices[8]);
        } else {
            originx = vertices[3];
            originy = vertices[4];
            originz = vertices[5];
            r.axis.set(originx - vertices[9], originy - vertices[10], originz - vertices[11]);
        }
        r.origin.set(originx, originy, originz);
        r.generated = true;
    }

    private void generateMesh(Generator.Obstacle o) {
        float size = TunnelMesh.SEGMENT_LEN;
        this.tunnel.getTileVertices(o.segment - this.startingSegment, o.position, this.base);
        if (1 == o.type) {
            size = 2.0f * (float)Math.sin(1.3089969389957472);
        }
        this.omm.add(o.type, this.base, o.color, size);
        o.generated = true;
    }

    private void removeAllEmitters() {
        Debug.error("remove all emitters");
    }

    private class SpotLessPredicate
    extends SpotPredicate {
        private SpotLessPredicate() {
        }

        public boolean eval(int spotType) {
            return this.spotType < spotType;
        }
    }

    private class SpotEqualPredicate
    extends SpotPredicate {
        private SpotEqualPredicate() {
        }

        public boolean eval(int spotType) {
            return this.spotType == spotType;
        }
    }

    private abstract class SpotPredicate {
        protected int spotType;

        private SpotPredicate() {
        }

        public void setFrist(int spotType) {
            this.spotType = spotType;
        }

        public abstract boolean eval(int var1);
    }

    private class SpotEntry {
        public int type;
        public Color c1;
        public Color c2;

        public SpotEntry(int type, float r1, float g1, float b1, float a1, float r2, float b2, float g2, float a2) {
            this.type = type;
            this.c1 = new Color(r1, g1, b1, a1);
            this.c2 = new Color(r2, g2, b2, a2);
        }
    }

    private class DifficultySettings {
        float timePerSegment;
        float rollersAngualVelocity;
        float bouncersVelocityCoeff;
        float plasmaEmittersCount;
        boolean pure;

        public DifficultySettings(float _timePerSegment, float _rollersAngualVelocity, float _bouncersVelocityCoeff, float _plasmaEmittersCount, boolean _pure) {
            this.timePerSegment = _timePerSegment;
            this.rollersAngualVelocity = _rollersAngualVelocity;
            this.bouncersVelocityCoeff = _bouncersVelocityCoeff;
            this.plasmaEmittersCount = _plasmaEmittersCount;
            this.pure = _pure;
        }
    }

    private class StartLight {
        public float coeff;
        public boolean on;
        public boolean beep;

        private StartLight() {
        }
    }
}

