/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game.dialogs;

import com.gamelion.speedx.SpeedXMIDlet;
import com.gamelion.speedx.game.Game;
import com.gamelion.speedx.menu.IOptionsListListener;
import com.gamelion.speedx.menu.OptionsList;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public abstract class AbstractDialog
implements IOptionsListListener {
    public static final int STATE_BACKGROUND_APPEAR = 0;
    public static final int STATE_MENU_APPEAR = 1;
    public static final int STATE_MENU_DISAPPEAR = 2;
    public static final int STATE_BACKGROUND_DISAPEAR = 3;
    public static final int STATE_VISIBLE = 4;
    public static final int STATE_INVISIBLE = 5;
    private static final float APPEAR_TIME = 0.5f;
    private static final float DISSAPEAR_TIME = 0.5f;
    protected float height;
    protected float screenWidth;
    protected float screenHeight;
    protected float currentTop;
    protected float currentHeight;
    protected OptionsList menu;
    protected SpeedXMIDlet midlet;
    protected Transform oldCameraTransform = new Transform();
    protected int state;
    protected float timer;
    protected Appearance appearance;
    private Camera camera;
    private Transform cameraTransform;
    private VertexBuffer backgroundVertexBuffer;
    private IndexBuffer backgroundIndexBuffer;
    private Transform backgroundTransform = new Transform();
    private int selectedOption;
    private String headerTextureId;
    private float headerTextureWidth;
    private float headerTextureHeight;

    public AbstractDialog(SpeedXMIDlet midlet) {
        this.midlet = midlet;
        this.screenWidth = midlet.canvas().getWidth();
        this.screenHeight = midlet.canvas().getHeight();
        this.camera = new Camera();
        this.camera.setParallel(this.screenHeight, this.screenWidth / this.screenHeight, 0.05f, 80.0f);
        this.cameraTransform = new Transform();
        this.cameraTransform.postTranslate(this.screenWidth / 2.0f, this.screenHeight / 2.0f, 0.0f);
        this.cameraTransform.postScale(1.0f, -1.0f, -1.0f);
        this.appearance = new Appearance();
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setDepthTestEnable(false);
        compositingMode.setDepthWriteEnable(false);
        compositingMode.setBlending(64);
        this.appearance.setCompositingMode(compositingMode);
        PolygonMode polyMode = new PolygonMode();
        polyMode.setCulling(162);
        this.appearance.setPolygonMode(polyMode);
        VertexArray positions = new VertexArray(4, 3, 2);
        short[] pos = new short[]{0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1};
        positions.set(0, 4, pos);
        this.backgroundVertexBuffer = new VertexBuffer();
        this.backgroundVertexBuffer.setDefaultColor(0x7F000000);
        this.backgroundVertexBuffer.setPositions(positions, 1.0f, null);
        this.backgroundIndexBuffer = new TriangleStripArray(0, new int[]{4});
    }

    public void open() {
        this.setState(0);
        this.selectedOption = -1;
    }

    public void update(float dt) {
        switch (this.state) {
            case 0: {
                if (this.timer > 0.5f) {
                    this.setState(1);
                    break;
                }
                this.computeBackgroundSize(this.timer / 0.5f);
                break;
            }
            case 1: {
                this.menu.update(dt);
                break;
            }
            case 2: {
                this.menu.update(dt);
                break;
            }
            case 3: {
                if (this.timer > 0.5f) {
                    this.setState(5);
                    break;
                }
                this.computeBackgroundSize(1.0f - this.timer / 0.5f);
                break;
            }
            case 4: {
                this.menu.update(dt);
                break;
            }
        }
        this.timer += dt;
    }

    public void render(Graphics3D g) {
        Camera oldCamera = g.getCamera(this.oldCameraTransform);
        g.setCamera(this.camera, this.cameraTransform);
        switch (this.state) {
            case 0: {
                this.renderBackground(g);
                break;
            }
            case 1: {
                this.renderBackground(g);
                this.renderHeader(g, 1.0f);
                this.menu.render(g);
                break;
            }
            case 2: {
                this.renderBackground(g);
                this.renderHeader(g, 1.0f);
                this.menu.render(g);
                break;
            }
            case 3: {
                this.renderBackground(g);
                break;
            }
            case 4: {
                this.renderBackground(g);
                this.renderHeader(g, 1.0f);
                this.menu.render(g);
                break;
            }
        }
        g.setCamera(oldCamera, this.oldCameraTransform);
    }

    public void onPointerPressed(int x, int y) {
        if (this.state == 4) {
            this.menu.onPointerPressed(x, y);
        }
    }

    public void onPointerDragged(int x, int y) {
        if (this.state == 4) {
            this.menu.onPointerDragged(x, y);
        }
    }

    public void onPointerReleased(int x, int y) {
        if (this.state == 4) {
            this.menu.onPointerReleased(x, y);
        }
    }

    public void onKeyPressed(int code) {
    }

    public void onKeyReleased(int code) {
        if (this.state == 4) {
            this.menu.onKeyReleased(code);
        }
    }

    public void onOptionClicked(int optionId) {
        this.selectedOption = optionId;
        this.setState(2);
        this.midlet.soundPool().play("click");
    }

    public void onOptionStateChanged(int optionId, boolean state) {
    }

    public void onOptionIndexChanged(int optionId, int indes) {
    }

    public void onMenuVisible() {
        this.setState(4);
    }

    public void onMenuHidden() {
        this.setState(3);
    }

    protected void setState(int newState) {
        this.state = newState;
        this.timer = 0.0f;
        if (this.state == 1) {
            this.currentHeight = this.height;
            this.currentTop = this.screenHeight / 2.0f - this.height / 2.0f;
            this.menu.show();
        } else if (this.state == 2) {
            this.menu.hide(-1);
        } else if (this.state == 5) {
            this.handleSelection(this.selectedOption);
        }
    }

    protected void setHeader(String texId, float width, float height) {
        this.headerTextureId = texId;
        this.headerTextureWidth = width;
        this.headerTextureHeight = height;
    }

    protected abstract void handleSelection(int var1);

    private void renderBackground(Graphics3D g) {
        this.backgroundTransform.setIdentity();
        this.backgroundTransform.postTranslate(0.0f, this.currentTop, 0.0f);
        this.backgroundTransform.postScale(this.screenWidth, this.currentHeight, 1.0f);
        g.render(this.backgroundVertexBuffer, this.backgroundIndexBuffer, this.appearance, this.backgroundTransform);
    }

    private void computeBackgroundSize(float ratio) {
        this.currentHeight = this.height * ratio;
        this.currentTop = this.screenHeight / 2.0f - this.currentHeight / 2.0f;
    }

    private void renderHeader(Graphics3D g, float alpha) {
        Game.drawQuad2d(g, null, this.screenWidth / 2.0f - this.headerTextureWidth / 2.0f, this.screenHeight - this.currentTop - this.headerTextureHeight * 3.0f / 2.0f, this.headerTextureWidth, this.headerTextureHeight, this.headerTextureId);
    }
}

