/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.textdisplay;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.textdisplay.IParserListener;
import com.gamelion.speedx.textdisplay.Tokenizer;

public class Parser {
    private static final String CMD_FONT = "font";
    private static final String CMD_IMAGE = "image";
    private static final String CMD_BREAK = "break";
    private static final String CMD_ALIGN = "align";
    private static final String CMD_LBRACKET = "lbracket";
    private static final String CMD_RBRACKET = "rbracket";
    private static final String ALIGN_LEFT = "left";
    private static final String ALIGN_RIGHT = "right";
    private static final String ALIGN_CENTER = "center";
    private static final String ALIGN_JUSTIFY = "justify";
    private Tokenizer tokenizer = new Tokenizer();
    private IParserListener listener;
    private int token;

    public Parser(IParserListener listener) {
        this.listener = listener;
    }

    public void parse(String str) {
        this.tokenizer.tokenize(str);
        this.token = this.tokenizer.nextToken();
        boolean stop = false;
        while (!stop) {
            switch (this.token) {
                case 3: {
                    stop = true;
                    break;
                }
                case 1: {
                    this.token = this.tokenizer.nextToken();
                    this.parseCommand();
                    break;
                }
                case 2: {
                    Debug.warn("Right brace without matching left brace!");
                    this.listener.onText(this.tokenizer.stringToken());
                    this.token = this.tokenizer.nextToken();
                    break;
                }
                case 0: {
                    this.listener.onText(this.tokenizer.stringToken());
                    this.token = this.tokenizer.nextToken();
                }
            }
        }
    }

    private void parseCommand() {
        String name = this.readString();
        if (name.equals(CMD_FONT)) {
            this.parseFont();
        } else if (name.equals(CMD_IMAGE)) {
            this.parseImage();
        } else if (name.equals(CMD_BREAK)) {
            this.parseBreak();
        } else if (name.equals(CMD_ALIGN)) {
            this.parseAlign();
        } else if (name.equals(CMD_LBRACKET)) {
            this.listener.onText("[");
        } else if (name.equals(CMD_RBRACKET)) {
            this.listener.onText("]");
        } else {
            Debug.error("Unknown command name " + name);
        }
        if (this.token != 2) {
            Debug.error("Missign right brace");
        } else {
            this.token = this.tokenizer.nextToken();
        }
    }

    private void parseFont() {
        this.listener.onFontChange(this.readString());
    }

    private void parseImage() {
        this.listener.onImage(this.readString());
    }

    private void parseBreak() {
        this.listener.onBreak();
    }

    private void parseAlign() {
        String align = this.readString();
        int alignType = -1;
        if (align.equals(ALIGN_LEFT)) {
            alignType = 0;
        } else if (align.equals(ALIGN_RIGHT)) {
            alignType = 1;
        } else if (align.equals(ALIGN_CENTER)) {
            alignType = 2;
        } else if (align.equals(ALIGN_JUSTIFY)) {
            alignType = 3;
        } else {
            Debug.error("Unknown align type " + align);
        }
        if (alignType != -1) {
            this.listener.onLayoutChange(alignType);
        }
    }

    private String readString() {
        String str;
        if (this.token != 0) {
            Debug.error("string expected");
            str = "";
        } else {
            str = this.tokenizer.stringToken();
        }
        this.token = this.tokenizer.nextToken();
        return str;
    }
}

