/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.game.Color;
import com.gamelion.speedx.game.Rainbow;
import com.gamelion.speedx.game.Vector3f;
import java.util.Random;

public abstract class Generator {
    public static final int MAX_OBSTACLES_CHAIN_LEN = 5;
    public static final int LEVEL_WITHOUT_SINGLE_CUBES = 5;
    public static final int CLASS_Obstacle = 0;
    public static final int CLASS_Roller = 1;
    public static final int CLASS_Bouncer = 2;
    private static final int CONSTRUCT_CUBE = 0;
    private static final int CONSTRUCT_BEAM = 1;
    private static final int CONSTRUCT_DOUBLE = 2;
    private static final int CONSTRUCT_TRIPLE_GROUP = 3;
    private static final int CONSTRUCT_DOUBLE_DOUBLE = 4;
    private static final int CONSTRUCT_TWO_TOWERS = 5;
    private static final int CONSTRUCT_TRIPLE = 6;
    private static final int CONSTRUCT_PENDULUM = 7;
    private static final int CONSTRUCT_SIMPLE_TRIPLE = 8;
    private static final int CONSTRUCT_CROSS = 9;
    private static final int CONSTRUCT_FOUR = 10;
    private static final int CONSTRUCT_TRIPLE_DOUBLE = 11;
    private static final int CONSTRUCT_SPIRAL = 12;
    private static final int CONSTRUCT_DOUBLE_TRIPLE = 13;
    private static final int CONSTRUCT_THREE_TOWERS = 14;
    private static final int CONSTRUCT_SIX = 15;
    private static final int CONSTRUCT_MAX = 16;
    private static Rainbow rainbow = null;

    public int generate(Random rng, float now, int segment, int level, boolean allowMovables, boolean outside) {
        int lock = 0;
        if (0 == level) {
            Generator.generateChains(this, rng, 1, 0, segment, false);
        } else {
            int pos;
            int construct = rng.nextInt(Math.min(level + 1, 16));
            if (level > 5) {
                construct = Math.min(construct + 1, level + 1);
            }
            boolean useSpikes = 0 == rng.nextInt(3);
            boolean useWalls = outside && 0 == rng.nextInt(3);
            boolean movableGenerated = false;
            if (allowMovables && Generator.randomBool(rng)) {
                movableGenerated = true;
                switch (construct) {
                    case 0: {
                        if (Generator.randomBool(rng)) {
                            Generator.generateBouncers(this, rng, 1, segment, Generator.randomPos(rng), now, true);
                            break;
                        }
                        Generator.generateRollers(this, rng, 1, segment, now, true);
                        break;
                    }
                    case 2: {
                        if (Generator.randomBool(rng)) {
                            Generator.generateBouncers(this, rng, 2, segment, Generator.randomPos(rng), now, false);
                            break;
                        }
                        Generator.generateRollers(this, rng, 1, segment, now, false);
                        break;
                    }
                    case 4: {
                        if (Generator.randomBool(rng) && !outside) {
                            pos = Generator.randomPos(rng);
                            Generator.generateBouncers(this, rng, 1, segment, pos, now, true);
                            Generator.generateBouncers(this, rng, 1, segment + 1, pos + 3, now - 0.4f, true);
                            break;
                        }
                        Generator.generateRollersNoOffset(this, rng, 2 + rng.nextInt(2), segment, now, Generator.randomBool(rng));
                        break;
                    }
                    case 3: {
                        if (Generator.randomBool(rng)) {
                            Generator.generateRollers(this, rng, 3, segment, now, false);
                            break;
                        }
                        Generator.generateBouncers(this, rng, 3, segment, Generator.randomPos(rng), now, false);
                        break;
                    }
                    case 6: {
                        Generator.generateRollers(this, rng, 2 + rng.nextInt(4), segment, now, true);
                        break;
                    }
                    case 8: {
                        boolean dir = Generator.randomBool(rng);
                        Generator.generateRollersNoOffset(this, rng, 2, segment, now, dir);
                        Generator.generateRollersNoOffset(this, rng, 2, segment + 2, now, !dir);
                        break;
                    }
                    default: {
                        movableGenerated = false;
                    }
                }
            }
            if (!movableGenerated) {
                switch (construct) {
                    case 0: {
                        Generator.generateChains(this, rng, 1, 0, segment, false);
                        break;
                    }
                    case 2: {
                        if (useWalls) {
                            Generator.generateWall(this, rng, 2, Generator.randomBool(rng) ? 0 : 1, segment, Generator.randomPos(rng));
                            break;
                        }
                        Generator.generateChains(this, rng, 2, 0, segment, false);
                        break;
                    }
                    case 1: {
                        Generator.generateChains(this, rng, 1, 1, segment, false);
                        break;
                    }
                    case 3: {
                        if (useSpikes) {
                            Generator.generateWall(this, rng, 3, 2, segment, Generator.randomPos(rng));
                            break;
                        }
                        if (useWalls) {
                            Generator.generateWall(this, rng, 3, 0, segment, Generator.randomPos(rng));
                            break;
                        }
                        if (!outside && Generator.randomBool(rng)) {
                            Generator.generateChains(this, rng, 3, 0, segment, Generator.randomBool(rng));
                            break;
                        }
                        Generator.generateSkewChain(this, rng, 3, 0, segment);
                        break;
                    }
                    case 4: {
                        int pos2;
                        if (useSpikes) {
                            pos2 = Generator.randomPos(rng);
                            Generator.generateWall(this, rng, 2, 2, segment, pos2);
                            Generator.generateWall(this, rng, 2, 2, segment, (pos2 + 6) % 12);
                            break;
                        }
                        pos2 = Generator.randomPos(rng);
                        Color color = new Color();
                        Generator.getRainbow(rng).getColor(color);
                        for (int i = 0; i < 2; ++i) {
                            this.addObstacle(0, segment + i, (pos2 + i) % 12, color);
                            this.addObstacle(0, segment + i, (pos2 + 6 + i) % 12, color);
                        }
                        break;
                    }
                    case 6: {
                        Generator.generateChains(this, rng, 3, 0, segment, Generator.randomBool(rng));
                        break;
                    }
                    case 8: {
                        Generator.generateChainsWithStep(this, rng, 3, 0, segment, 3, Generator.randomBool(rng), false);
                        break;
                    }
                    case 5: {
                        Generator.generateSkewChain(this, rng, 2, 1, segment);
                        break;
                    }
                    case 10: {
                        if (useSpikes) {
                            Generator.generateWall(this, rng, 4, 2, segment, Generator.randomPos(rng));
                            break;
                        }
                        if (useWalls) {
                            Generator.generateWall(this, rng, 4, 0, segment, Generator.randomPos(rng));
                            break;
                        }
                        Generator.generateChains(this, rng, 4, 0, segment, Generator.randomBool(rng));
                        break;
                    }
                    case 9: {
                        if (outside) {
                            Generator.generateChains(this, rng, 4, 1, segment, Generator.randomBool(rng));
                            break;
                        }
                        Color color = new Color();
                        pos = Generator.randomPos(rng);
                        Generator.getRainbow(rng).getColor(color);
                        this.addObstacle(1, segment, pos, color);
                        this.addObstacle(1, segment + 1, (pos + 3) % 12, color);
                        break;
                    }
                    case 7: {
                        Generator.generatePendulum(this, rng, segment);
                        break;
                    }
                    case 15: {
                        int pos2;
                        if (useSpikes) {
                            if (Generator.randomBool(rng)) {
                                pos2 = Generator.randomPos(rng);
                                Generator.generateWall(this, rng, 3, 2, segment, pos2);
                                Generator.generateWall(this, rng, 3, 2, segment, (pos2 + 6) % 12);
                            } else if (Generator.randomBool(rng)) {
                                Generator.generateWall(this, rng, 6, 2, segment, Generator.randomPos(rng));
                            } else {
                                pos2 = Generator.randomPos(rng);
                                Generator.generateWall(this, rng, 2, 2, segment, pos2);
                                Generator.generateWall(this, rng, 2, 2, segment, (pos2 + 4) % 12);
                                Generator.generateWall(this, rng, 2, 2, segment, (pos2 + 4) % 12);
                            }
                        } else if (useSpikes && Generator.randomBool(rng)) {
                            Generator.generateChains(this, rng, 6, 2, segment, false);
                        } else {
                            Generator.generateChains(this, rng, 6, 0, segment, false);
                        }
                        lock = 1;
                        break;
                    }
                    case 12: {
                        Generator.generateSkewChain(this, rng, 6, 0, segment);
                        lock = 2;
                        break;
                    }
                    case 13: {
                        Generator.generateDoubleTriple(this, rng, segment);
                        lock = 1;
                        break;
                    }
                    case 11: {
                        Generator.generateTripleDouble(this, rng, segment);
                        break;
                    }
                    case 14: {
                        Generator.generateSkewChain(this, rng, 3, 1, segment);
                        lock = 1;
                    }
                }
            }
        }
        return lock;
    }

    public abstract void addObstacle(int var1, int var2, int var3, Color var4);

    public abstract void addRoller(int var1, int var2, float var3, Color var4, boolean var5);

    public abstract void addBouncer(int var1, int var2, float var3, Color var4);

    public static boolean compareObstaclesSegments(ObstacleBase o1, ObstacleBase o2) {
        return false;
    }

    protected static int randomPos(Random rng) {
        return rng.nextInt(12);
    }

    protected static boolean randomBool(Random rng) {
        return (rng.nextInt() & 1) == 1;
    }

    protected static Rainbow getRainbow(Random rng) {
        if (rainbow == null) {
            rainbow = new Rainbow(rng);
        }
        return rainbow;
    }

    protected static void generateChainsWithStep(Generator mng, Random rng, int count, int type, int segment, int increment, boolean differentColors, boolean forceSingle) {
        int pos = Generator.randomPos(rng);
        int len = 1;
        if (!forceSingle) {
            if (0 == type) {
                len = Generator.randomBool(rng) || count > 4 ? 1 : 1 + rng.nextInt(4);
            } else if (1 == type) {
                len = count >= 3 ? 1 : 1 + rng.nextInt(2);
            }
        }
        Rainbow rainbow = Generator.getRainbow(rng);
        Color refColor = new Color();
        if (!differentColors) {
            rainbow.getColor(refColor);
        }
        for (int i = 0; i < len; ++i) {
            int j = 0;
            int currentPos = pos;
            while (j < count) {
                if (differentColors) {
                    rainbow.getColor(refColor);
                }
                mng.addObstacle(type, segment + i, currentPos % 12, refColor);
                ++j;
                currentPos += increment;
            }
        }
    }

    protected static void generateChains(Generator mng, Random rng, int count, int type, int segment, boolean differentColors) {
        Generator.generateChainsWithStep(mng, rng, count, type, segment, 12 / count, differentColors, false);
    }

    protected static void generateBouncers(Generator mng, Random rng, int count, int segment, int position, float timestamp, boolean sameDir) {
        Rainbow rainbow = Generator.getRainbow(rng);
        Color color = new Color();
        rainbow.getColor(color);
        for (int i = 0; i < count; ++i) {
            if (!sameDir) {
                rainbow.getColor(color);
            }
            mng.addBouncer(segment + i, position, timestamp - (sameDir ? 0.0f : (float)i * 0.25f), color);
        }
    }

    protected static void generateRollers(Generator mng, Random rng, int count, int segment, float timestamp, boolean sameDir) {
        Rainbow rainbow = Generator.getRainbow(rng);
        int pos = 2 + rng.nextInt(8);
        boolean dir = Generator.randomBool(rng);
        Color color = new Color();
        rainbow.getColor(color);
        for (int i = 0; i < count; ++i) {
            if (!sameDir) {
                rainbow.getColor(color);
            }
            mng.addRoller(segment + i, pos, timestamp + (sameDir ? (float)i * 0.1f : 0.0f), color, dir);
            dir = sameDir ? dir : !dir;
        }
    }

    protected static void generateRollersNoOffset(Generator mng, Random rng, int count, int segment, float timestamp, boolean dir) {
        int pos = 2 + rng.nextInt(8);
        Color color = new Color();
        Generator.getRainbow(rng).getColor(color);
        for (int i = 0; i < count; ++i) {
            mng.addRoller(segment + i, pos, timestamp, color, dir);
        }
    }

    protected static void generateWall(Generator mng, Random rng, int count, int type, int segment, int position) {
        Color color = new Color();
        Generator.getRainbow(rng).getColor(color);
        for (int i = 0; i < count; ++i) {
            mng.addObstacle(type, segment, (position + i) % 12, color);
        }
    }

    protected static void generateSkewChain(Generator mng, Random rng, int count, int type, int segment) {
        int pos = Generator.randomPos(rng);
        Color color = new Color();
        Generator.getRainbow(rng).getColor(color);
        for (int i = 0; i < count; ++i) {
            mng.addObstacle(type, segment + i, (pos + i) % 12, color);
        }
    }

    protected static void generatePendulum(Generator mng, Random rng, int segment) {
        int pos = Generator.randomPos(rng);
        Color color = new Color();
        Generator.getRainbow(rng).getColor(color);
        mng.addObstacle(0, segment, (pos + 12 - 1) % 12, color);
        mng.addObstacle(1, segment + 1, pos, color);
        mng.addObstacle(0, segment + 2, (pos + 6 - 1) % 12, color);
    }

    protected static void generateTripleDouble(Generator mng, Random rng, int segment) {
        Color color1 = new Color();
        Color color2 = new Color();
        Color color3 = new Color();
        Rainbow rainbow = Generator.getRainbow(rng);
        int pos = Generator.randomPos(rng);
        rainbow.getColor(color1);
        rainbow.getColor(color2);
        rainbow.getColor(color3);
        boolean differentColors = Generator.randomBool(rng);
        for (int i = 0; i < 2; ++i) {
            if (differentColors) {
                mng.addObstacle(0, segment + i, (pos + i) % 12, color1);
                mng.addObstacle(0, segment + i, (pos + 4 + i) % 12, color2);
                mng.addObstacle(0, segment + i, (pos + 8 + i) % 12, color3);
                continue;
            }
            mng.addObstacle(0, segment + i, (pos + i) % 12, color1);
            mng.addObstacle(0, segment + i, (pos + 4 + i) % 12, color1);
            mng.addObstacle(0, segment + i, (pos + 8 + i) % 12, color1);
        }
    }

    protected static void generateDoubleTriple(Generator mng, Random rng, int segment) {
        Rainbow rainbow = Generator.getRainbow(rng);
        int pos = Generator.randomPos(rng);
        Color color1 = new Color();
        Color color2 = new Color();
        rainbow.getColor(color1);
        rainbow.getColor(color2);
        for (int i = 0; i < 3; ++i) {
            mng.addObstacle(0, segment + i, (pos + i) % 12, color1);
            mng.addObstacle(0, segment + i, (pos + 6 + i) % 12, color2);
        }
    }

    public class Bouncer
    extends Movable {
        public Vector3f dir = new Vector3f();
        public Vector3f t = new Vector3f();

        public Bouncer() {
        }

        public Bouncer(Bouncer other) {
        }

        public int _getClass() {
            return 2;
        }
    }

    public class Roller
    extends Movable {
        public int hitpos1;
        public int hitpos2;
        public int hlpos1;
        public int hlpos2;
        public Vector3f axis = new Vector3f();
        public Vector3f origin = new Vector3f();
        public float angle;
        public boolean dir;

        public Roller() {
        }

        public Roller(Roller other) {
        }

        public int _getClass() {
            return 1;
        }
    }

    public abstract class Movable
    extends ObstacleBase {
        public float timestamp;
        public float hlCoeff;
        public float[] vertices;

        public Movable() {
            this.vertices = new float[72];
        }

        public Movable(Movable other) {
            this.vertices = other.vertices;
        }
    }

    public class Obstacle
    extends ObstacleBase {
        public int type;

        public int _getClass() {
            return 0;
        }
    }

    public abstract class ObstacleBase {
        public int segment;
        public int position;
        public Color color = new Color();
        public boolean generated;

        public abstract int _getClass();
    }
}

