/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.TexturePool;
import com.gamelion.speedx.game.Color;
import com.gamelion.speedx.game.Game;
import com.gamelion.speedx.menu.LabelsAtlas;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;

public class PlayerState {
    public static final int MAX_SHIELDS = 4;
    public static final int BONUS_NONE = 0;
    public static final int BONUS_QUAKE = 1;
    public static final int BONUS_FREEZ = 2;
    public static final int BONUS_ZONE_END = 3;
    public static final int BONUS_TORPEDO = 4;
    private static final float SHILED_TIMEOUT = 20.0f;
    private static final float SHILED_CHANGE_ANIM_TIME = 0.25f;
    private static final int[] RDISP_CROP_LEFT = new int[]{0, 64, 16, -64};
    private static final int[] RDISP_CROP_CENTER = new int[]{16, 64, 48, -64};
    private static final int[] LDISP_CROP_RIGHT = new int[]{16, 64, -16, -64};
    private static final int[] LDISP_CROP_CENTER = new int[]{64, 64, -48, -64};
    private static final Color[] BONUSES_COLORS = new Color[]{new Color(), new Color(1.0f, 0.2f, 0.2f), new Color(0.2f, 0.2f, 1.0f), new Color(0.2f, 1.0f, 0.2f), new Color(1.0f, 0.2f, 1.0f)};
    private static final Color SHIELD_IND_COLOR = new Color(1.0f, 0.7f, 0.2f, 0.6f);
    private int shields;
    private int prevShields;
    private float shieldLevel;
    private float prevShieldLevel;
    private int score;
    private int bonus;
    private float shieldChange;
    private float shieldLevelChange;
    private float bonusAnim;
    private float startingAnim;
    private Color color = new Color();
    private TexturePool texturePool;
    private LabelsAtlas labels;
    private Transform scoreTransform = new Transform();

    public void reset() {
        this.shields = 0;
        this.prevShields = 0;
        this.shieldLevel = 0.0f;
        this.prevShieldLevel = 0.0f;
        this.score = 0;
        this.bonus = 0;
        this.startingAnim = 0.0f;
        this.bonusAnim = 0.0f;
        this.shieldChange = 0.0f;
        this.shieldLevelChange = 0.0f;
    }

    public void updateScore(int points) {
        this.score += points;
    }

    public int getScore() {
        return this.score;
    }

    public void updateBonus(int bonus) {
        this.bonus = bonus;
        this.bonusAnim = 0.0f;
    }

    public int getBonus() {
        return this.bonus;
    }

    public void updateShields(int count) {
        this.shieldLevelChange = 0.0f;
        if (count < 0 || this.shields < 4) {
            this.prevShields = this.shields;
            this.prevShieldLevel = this.shieldLevel;
            this.shieldChange = 0.0f;
        }
        this.shields += count;
        this.shields = Math.min(4, Math.max(0, this.shields));
    }

    public int getShields() {
        return this.shields;
    }

    public void update(float dt) {
        this.startingAnim += dt;
        this.bonusAnim += dt;
        this.shieldChange += dt;
        this.shieldLevelChange += dt;
        this.shieldLevel = 1.0f - this.shieldLevelChange / 20.0f;
        if (this.shieldLevel < 0.0f) {
            if (this.shields > 0) {
                --this.shields;
            }
            this.shieldLevelChange = 0.0f;
        }
    }

    public void renderHUD(Graphics3D g, float width, float height, float alpha) {
        float size = 16.0f;
        float w = 72.0f;
        float scale = 1.0f;
        Texture2D tex = this.texturePool.getTexture("displaybg");
        this.color.b = 1.0f;
        this.color.g = 1.0f;
        this.color.r = 1.0f;
        this.color.a = alpha;
        float x1 = width - Math.min(Math.max(-8.0f, 72.0f * this.startingAnim - 8.0f), 72.0f);
        Game.drawTex(g, x1 - 8.0f, 0.0f, 16.0f, 32.0f, 64, 64, RDISP_CROP_LEFT, tex, this.color);
        Game.drawTex(g, x1 + 8.0f, 0.0f, width - 8.0f, 32.0f, 64, 64, RDISP_CROP_CENTER, tex, this.color);
        float x2 = -Math.max(80.0f * (1.0f - this.startingAnim), 0.0f);
        Game.drawTex(g, x2 + 72.0f - 8.0f, 0.0f, 16.0f, 32.0f, 64, 64, LDISP_CROP_RIGHT, tex, this.color);
        Game.drawTex(g, x2, 0.0f, 64.0f, 32.0f, 64, 64, LDISP_CROP_CENTER, tex, this.color);
        if (this.shieldChange < 0.25f) {
            float coeff = this.shieldChange / 0.25f;
            if (this.prevShields < this.shields) {
                this.renderShieldInd(g, width, height, 0, this.prevShields, 0.75f * alpha, 1.0f, Math.min(1.0f, this.prevShieldLevel + coeff));
                this.renderShieldInd(g, width, height, this.prevShields, this.shields, 0.75f * alpha, 1.0f, coeff);
            } else {
                this.renderShieldInd(g, width, height, 0, this.shields, 0.75f * alpha, 1.0f, this.shieldLevel);
                this.renderShieldInd(g, width, height, this.shields, this.prevShields, 0.75f * (1.0f - coeff) * alpha, 1.0f + 0.5f * coeff, this.prevShieldLevel);
            }
        } else if (this.shields > 0) {
            this.renderShieldInd(g, width, height, 0, this.shields, 0.75f * alpha, 1.0f, this.shieldLevel);
        }
        if (0 != this.bonus) {
            float coeff1 = Math.min(1.0f, this.bonusAnim / 0.25f);
            float coeff2 = (float)Math.cos(Math.PI * (double)(this.bonusAnim / 0.75f - (float)Math.floor(this.bonusAnim / 0.75f)) / 2.0);
            Color c = BONUSES_COLORS[this.bonus];
            float s = 1.0f * (1.0f - coeff2) * 64.0f;
            this.color.set(c);
            this.color.a = coeff1 * 0.8f * alpha;
            Game.drawQuad2d(g, this.color, 1.0f, height - 33.0f, 32.0f, 32.0f, "button");
            this.color.a = coeff2 * 0.8f * alpha;
            Game.drawQuad2d(g, this.color, 17.0f - s / 2.0f, height + 16.0f - s / 2.0f, (float)Math.ceil(32.0f + s), (float)Math.ceil(32.0f + s), "ring");
        }
        this.color.b = 1.0f;
        this.color.g = 1.0f;
        this.color.r = 1.0f;
        this.color.a = alpha;
        this.scoreTransform.setIdentity();
        this.scoreTransform.postTranslate(Math.min(1.0f, this.startingAnim) - 4.0f + 7.0f, 36.0f, 0.0f);
        this.labels.drawInteger(g, this.score, this.scoreTransform, this.color.toInt());
    }

    public void setTexturePool(TexturePool tp) {
        this.texturePool = tp;
    }

    public void setLabelsAtlas(LabelsAtlas la) {
        this.labels = la;
    }

    void renderShieldInd(Graphics3D g, float width, float height, int from, int to, float alpha, float zoom, float level) {
        float size = width / 15.0f;
        float zoomed = zoom * size;
        float offset = (zoomed - size) / 2.0f;
        int[] shieldIndCrop = new int[]{0, 64, 64, -64};
        float xpos = width - (4.0f * size + 8.0f) + (float)from * size;
        int i = from;
        while (i < to) {
            float spotWidth;
            if (i == to - 1) {
                shieldIndCrop[2] = 8 + (int)(48.0f * level);
                spotWidth = zoomed * level;
            } else {
                shieldIndCrop[2] = 64;
                spotWidth = zoomed;
            }
            Game.drawTex(g, xpos - offset, size / 2.0f - offset, spotWidth, zoomed, 64, 64, shieldIndCrop, this.texturePool.getTexture("shield_mark"), SHIELD_IND_COLOR);
            ++i;
            xpos += size;
        }
    }
}

