/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontMain;
    private Game game;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_MAIN;
    public final byte MENU_INSTRUCTIONS;
    public final byte MENU_ABOUT = (byte)2;
    public final byte MENU_QUIT = (byte)3;
    public static final byte GAME_MAIN = 0;
    public static final byte GAME_OVER = 1;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_ABOUT = (byte)2;
    final byte ID_MENU_SOUND = (byte)3;
    final byte ID_MENU_ITEMS_TOTAL = (byte)4;
    private int iMenuItemsTotal;
    private int screen;
    public int subScreen;
    public int iSelectedMenuItem;
    public boolean bLoading = false;
    Rectangle[] rectMenuItems;
    int[] menuItemsImages;
    public boolean bDragInstructions = false;
    private int iTextLines = 1;
    public String strTextBody;
    String[] strTextMenu = new String[4];
    String[] strTextPom = new String[3];
    PreparedText prepText;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iInstructionsShiftY = 0;
    private int iInstructionsMaxShiftY = 0;
    private int iAboutCenterY;
    private int iAboutWidth;
    private int iAboutHeight;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes = new String[]{"en", "de", "pt", "fr", "es", "it"};
    private static final int[] LANGUAGES = new int[]{0, 1, 2, 3, 4, 5};
    private static final int MAX_LANGUAGES = 6;
    private Rectangle[] rectLanguages = new Rectangle[6];
    private int iSelectedLanguage;
    private int iFlash;
    boolean bPause = false;
    public static Image imgSplash;
    public static Image imgInlogic;
    public static Sprite sprLanguage;
    public static Sprite sprBoard;
    public static Sprite sprLanguageOff;
    public static Sprite sprButtons;
    public static Sprite sprFKIcons;
    public static Sprite sprArrows;
    public static Sprite sprIcons;
    public static Sprite sprDialogBg;
    public static Sprite sprDots;
    public static Sprite sprNumbersBig;
    public static Sprite sprNumbersSmall;
    private Rectangle rectTitleCenter;
    private int iHeaderHeight;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_INSTRUCTIONS = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_INSTRUCTIONS = 1;
        this.mainCanvas = mainCanvas;
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (this.iFlash > 0) {
            this.iFlash = (int)((long)this.iFlash - lTick);
        } else if (this.iFlash < 0) {
            this.iFlash = 0;
        }
        if (this.bPause) {
            return;
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.updateInstructions();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            this.game.update(lTick);
                            break block0;
                        }
                        case 1: {
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.mainCanvas.repaint();
        }
    }

    public void gameContinue() {
        if (this.screen != 0) {
            if (this.screen == 2 && this.subScreen == 0) {
                this.playMusic(Sounds.MUSIC_GAME, -1);
            } else {
                this.playMusic(Sounds.MUSIC_MENU, -1);
            }
        }
        this.bPause = false;
    }

    public void paintContinue(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
        this.paintLeftButton(g, 9);
    }

    public void paint(Graphics g) {
        if (this.iFlash > 0) {
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            return;
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(29111);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.bPause) {
            this.paintContinue(g);
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 2: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 3: {
                        this.paintQuit(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.game.paint(g);
                        break block0;
                    }
                    case 1: {
                        this.game.paintGameOver(g);
                        break block0;
                    }
                }
                break;
            }
        }
        this.paintControls(g);
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 9);
                        this.paintRightButton(g, 6);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintRightButton(g, 10);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        this.paintRightButton(g, 5);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g, 9);
                        this.paintRightButton(g, 6);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 1: {
                        this.paintLeftButton(g, 9);
                        this.paintRightButton(g, 6);
                        break block0;
                    }
                    case 0: {
                        this.paintRightButton(g, 5);
                        break block0;
                    }
                }
            }
        }
    }

    public void paintLeftButton(Graphics g, int frame) {
        sprFKIcons.setFrame(0);
        sprFKIcons.setPosition(0, MainCanvas.HEIGHT - sprFKIcons.getHeight());
        sprFKIcons.paint(g);
        sprIcons.setFrame(frame);
        sprIcons.setPosition(0, MainCanvas.HEIGHT - sprFKIcons.getHeight());
        sprIcons.paint(g);
    }

    public void paintRightButton(Graphics g, int frame) {
        sprFKIcons.setFrame(0);
        sprFKIcons.setPosition(MainCanvas.WIDTH - sprFKIcons.getWidth(), MainCanvas.HEIGHT - sprFKIcons.getHeight());
        sprFKIcons.paint(g);
        sprIcons.setFrame(frame);
        sprIcons.setPosition(MainCanvas.WIDTH - sprFKIcons.getWidth(), MainCanvas.HEIGHT - sprFKIcons.getHeight());
        sprIcons.paint(g);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (imgInlogic.getHeight() >> 1), 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            sprLanguage.setFrame(LANGUAGES[i]);
            sprLanguage.setPosition(this.rectLanguages[i].x, this.rectLanguages[i].y);
            sprLanguage.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTitle(Graphics g) {
        g.drawImage(imgSplash, (MainCanvas.WIDTH >> 1) - (imgSplash.getWidth() >> 1), 0, 20);
    }

    public void paintMainMenu(Graphics g) {
        this.paintTitle(g);
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], this.menuItemsImages[i], true);
                continue;
            }
            this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], this.menuItemsImages[i], false);
        }
    }

    private void paintMenuButton(Graphics g, Rectangle bounds, String text, int iconFrame, boolean selected) {
        sprButtons.setFrame(0);
        sprButtons.setPosition(bounds.x, bounds.y);
        sprButtons.paint(g);
        sprIcons.setFrame(iconFrame);
        sprIcons.setPosition(bounds.x, bounds.y);
        sprIcons.paint(g);
        this.fontMain.drawString(g, text.toCharArray(), bounds.x + sprIcons.getWidth() + (sprIcons.getWidth() >> 2), bounds.getCenterY(), 6);
    }

    public void paintInstructions(Graphics g) {
        this.paintHeader(g);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void paintHeader(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, 0, this.rectTitleCenter.width, this.iHeaderHeight);
        this.fontMain.drawString(g, this.strTextBody.toCharArray(), MainCanvas.WIDTH >> 1, this.iHeaderHeight >> 2, 3);
    }

    public void updateInstructions() {
        if (this.iTextShiftY < 0) {
            if (this.iInstructionsShiftY > 0) {
                this.iInstructionsShiftY += this.iTextShiftY;
                if (this.iInstructionsShiftY <= 0) {
                    this.iInstructionsShiftY = 0;
                    this.iTextShiftY = 0;
                } else if (this.bDragInstructions) {
                    this.iTextShiftY = 0;
                } else {
                    this.iTextShiftY += MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY > 0) {
                        this.iTextShiftY = 0;
                    }
                }
            } else {
                this.iTextShiftY = 0;
            }
        }
        if (this.iTextShiftY > 0) {
            if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY += this.iTextShiftY;
                if (this.iInstructionsShiftY >= this.iInstructionsMaxShiftY) {
                    this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
                    this.iTextShiftY = 0;
                } else if (this.bDragInstructions) {
                    this.iTextShiftY = 0;
                } else {
                    this.iTextShiftY -= MainCanvas.HEIGHT >> 6;
                    if (this.iTextShiftY < 0) {
                        this.iTextShiftY = 0;
                    }
                }
            } else {
                this.iTextShiftY = 0;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public void paintInstructionsText(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, this.iInstructionsCenterY, this.iInstructionsWidth, this.iInstructionsHeight);
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + (sprArrows.getHeight() << 1);
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - (sprArrows.getHeight() << 1);
        if (this.iInstructionsShiftY > 0) {
            sprArrows.setFrame(0);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYUp - sprArrows.getHeight() - (sprArrows.getHeight() >> 1));
            sprArrows.paint(g);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            sprArrows.setFrame(1);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYDown + (sprArrows.getHeight() >> 1));
            sprArrows.paint(g);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + (i + 1) * this.fontMain.getHeight() - this.iInstructionsShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY + this.fontMain.getHeight() >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintAbout(Graphics g) {
        this.paintHeader(g);
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, this.iAboutCenterY, this.iAboutWidth, this.iAboutHeight);
        if (this.iAboutCenterY - (this.iAboutHeight >> 1) < this.iAboutCenterY - imgInlogic.getHeight()) {
            g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), this.iAboutCenterY - imgInlogic.getHeight(), 20);
            int pomY = this.iAboutCenterY + (this.iAboutHeight >> 2) - (this.fontMain.getHeight() >> 1) - this.fontMain.getHeight();
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[0].toCharArray()) >> 1), pomY, 20);
            this.fontMain.drawString(g, this.strTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[1].toCharArray()) >> 1), pomY += this.fontMain.getHeight(), 20);
        } else {
            g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), this.iAboutCenterY - (this.iAboutHeight >> 1) + (this.fontMain.getHeight() >> 1), 20);
            int pomY = this.iAboutCenterY + this.fontMain.getHeight();
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[0].toCharArray()) >> 1), pomY, 20);
            this.fontMain.drawString(g, this.strTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[1].toCharArray()) >> 1), pomY += this.fontMain.getHeight(), 20);
        }
    }

    public void paintQuit(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTextInRectangle(Graphics g, Rectangle rect) {
        int iCenterY = MainCanvas.HEIGHT >> 1;
        int textHeight = this.fontMain.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
            pomY += this.fontMain.getHeight();
        }
    }

    public void setTitleCenter(String s) {
        this.rectTitleCenter.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
        int textMaxWidth = this.rectTitleCenter.width - (this.rectTitleCenter.width >> 3);
        this.prepText = new PreparedText(this.fontMain);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
        }
    }

    public void keyPressed(int keyCode) {
        if (this.screen == 2 && this.subScreen == 0) {
            this.game.keyPressed(keyCode);
        }
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage > 1) {
                    this.iSelectedLanguage -= 2;
                    break;
                }
                if (this.iSelectedLanguage == 0) {
                    this.iSelectedLanguage = 4;
                    break;
                }
                this.iSelectedLanguage = 5;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage == 4) {
                    this.iSelectedLanguage = 0;
                    break;
                }
                if (this.iSelectedLanguage == 5) {
                    this.iSelectedLanguage = 1;
                    break;
                }
                this.iSelectedLanguage += 2;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage > 0) {
                    --this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 5;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage < 5) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            this.playMusic(Sounds.MUSIC_MENU, -1);
            this.menuItemsImages[3] = 3;
        } else {
            this.soundOff();
            this.menuItemsImages[3] = 4;
        }
        this.setTexts();
    }

    public void changeSelectedMenuItem(int iShift) {
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem < this.iMenuItemsTotal - 1 ? ++this.iSelectedMenuItem : 0) : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : this.iMenuItemsTotal - 1);
    }

    public void keyReleased(int keyCode) {
        if (this.bPause) {
            if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                this.bPause = false;
                this.gameContinue();
            }
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break block0;
                        this.delay = 100;
                        break block0;
                    }
                    case 3: {
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeLanguage(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeLanguage(1);
                            return;
                        }
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            this.changeLanguage(2);
                            return;
                        }
                        if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                            this.changeLanguage(3);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.nextScreen(0, 4);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.nextScreen(1, 3);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                this.nextScreen(2, 0);
                                break;
                            }
                            case 1: {
                                this.nextScreen(1, 1);
                                break;
                            }
                            case 2: {
                                this.nextScreen(1, 2);
                                break;
                            }
                            case 3: {
                                this.changeSound();
                                break;
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.quit();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        this.playMusic(Sounds.MUSIC_MENU, -1);
                        return;
                    }
                    case 1: {
                        if (Keys.isFKRightCode(keyCode)) {
                            this.nextScreen(1, 0);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode)) break block0;
                        this.nextScreen(2, 0);
                        return;
                    }
                }
                break;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1) {
            if (this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = true;
            }
        } else if (this.screen == 2 && this.subScreen == 0) {
            this.game.pointerPressed(x, y);
        }
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isLeftButtonPressed(int x, int y) {
        return x <= sprFKIcons.getWidth() && y >= MainCanvas.HEIGHT - sprFKIcons.getHeight();
    }

    public boolean isRightButtonPressed(int x, int y) {
        return x >= MainCanvas.WIDTH - sprFKIcons.getWidth() && y >= MainCanvas.HEIGHT - sprFKIcons.getHeight();
    }

    public void pointerDragged(int x, int y) {
        if (this.screen == 1 && this.subScreen == 1 && this.bDragInstructions) {
            if (!this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = false;
            }
            this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
            MainCanvas.lastPointerPressedY = y;
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.bPause) {
            this.bPause = false;
            this.gameContinue();
            return;
        }
        if (this.screen == 1 && this.subScreen == 1 && this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break;
                        this.delay = 100;
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 6; ++i) {
                            if (!this.rectLanguages[i].contains(x, y)) continue;
                            this.iSelectedLanguage = i;
                            this.nextScreen(0, 4);
                            return;
                        }
                        break block0;
                    }
                    case 4: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.nextScreen(1, 3);
                            return;
                        }
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            if (!this.rectMenuItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.nextScreen(2, 0);
                                    break;
                                }
                                case 1: {
                                    this.nextScreen(1, 1);
                                    break;
                                }
                                case 2: {
                                    this.nextScreen(1, 2);
                                    break;
                                }
                                case 3: {
                                    this.changeSound();
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.quit();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                }
                break;
            }
            case 2: {
                if (this.subScreen == 0) {
                    if (!this.isRightButtonPressed(x, y)) break;
                    this.nextScreen(1, 0);
                    this.playMusic(Sounds.MUSIC_MENU, -1);
                    return;
                }
                if (this.subScreen != 1) break;
                if (this.isLeftButtonPressed(x, y)) {
                    this.nextScreen(2, 0);
                    return;
                }
                if (!this.isRightButtonPressed(x, y)) break;
                this.nextScreen(1, 0);
                return;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            this.bPause = true;
            this.strTextBody = Resources.resTexts[0].getHashedString(19);
            this.setTitleCenter(this.strTextBody);
            if (this.screen == 2 && this.subScreen == 0) {
                this.game.pause();
            }
        }
    }

    public void afterInteruption() {
    }

    public void initGraphics() {
        this.bLoading = true;
        Resources.loadGFonts(new int[]{0});
        this.fontMain = Resources.resGFonts[0];
        Resources.loadImages(new int[]{1, 2});
        imgSplash = Resources.resImgs[1];
        imgInlogic = Resources.resImgs[2];
        Resources.loadSprites(new int[]{0, 9, 10, 2, 3, 4, 5, 6, 1, 7, 8});
        sprLanguage = Resources.resSprs[0];
        sprLanguageOff = Resources.resSprs[1];
        sprBoard = Resources.resSprs[9];
        sprButtons = Resources.resSprs[2];
        sprDialogBg = Resources.resSprs[3];
        sprDots = Resources.resSprs[4];
        sprFKIcons = Resources.resSprs[5];
        sprArrows = Resources.resSprs[10];
        sprIcons = Resources.resSprs[6];
        sprNumbersBig = Resources.resSprs[7];
        sprNumbersSmall = Resources.resSprs[8];
        this.nextScreen(0, 1);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        this.iSelectedLanguage = 0;
        this.rectLanguages[0] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth() - (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - (sprLanguage.getHeight() >> 2) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[1] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - (sprLanguage.getHeight() >> 2) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[2] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth() - (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[3] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[4] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth() - (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) + (sprLanguage.getHeight() >> 1) + (sprLanguage.getHeight() >> 2), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[5] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLanguage.getWidth() >> 2), (MainCanvas.HEIGHT >> 1) + (sprLanguage.getHeight() >> 1) + (sprLanguage.getHeight() >> 2), sprLanguage.getWidth(), sprLanguage.getHeight());
        int pomMenuButtonHeight = (this.fontMain.getHeight() << 2) + (this.fontMain.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = MainCanvas.HEIGHT < 241 ? new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), MainCanvas.HEIGHT >> 4, pomMenuButtonWidth, pomMenuButtonHeight >> 2) : new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.nextScreen(0, 2);
        this.bLoading = false;
    }

    public void init() {
        this.bLoading = true;
        this.game = new Game(this);
        this.nextScreen(1, 0);
        Resources.freeSprites(new int[]{0});
        sprLanguage = null;
        System.gc();
        this.iHeaderHeight = this.fontMain.getHeight() + (this.fontMain.getHeight() << 1) << 1;
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        int iTitleH = imgSplash.getHeight();
        int iControlH = sprFKIcons.getHeight();
        int iMnuItemsH = MainCanvas.HEIGHT - iTitleH - iControlH;
        int offY = iMnuItemsH - this.iMenuItemsTotal * sprButtons.getHeight() >> 1;
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (sprButtons.getWidth() >> 1), iTitleH + offY + i * sprButtons.getHeight(), sprButtons.getWidth(), sprButtons.getHeight());
        }
        this.menuItemsImages = new int[this.iMenuItemsTotal];
        this.menuItemsImages[0] = 1;
        this.menuItemsImages[1] = 2;
        this.menuItemsImages[2] = 0;
        this.menuItemsImages[3] = 3;
        this.iInstructionsCenterY = (MainCanvas.HEIGHT >> 1) + (this.iHeaderHeight >> 1) - sprFKIcons.getHeight();
        this.iInstructionsWidth = this.rectTitleCenter.width;
        this.iInstructionsHeight = MainCanvas.HEIGHT - (this.iHeaderHeight >> 1) - (sprFKIcons.getHeight() << 1);
        this.iAboutCenterY = (MainCanvas.HEIGHT >> 1) + (this.iHeaderHeight >> 1) - sprFKIcons.getHeight();
        this.iAboutWidth = this.rectTitleCenter.width;
        this.iAboutHeight = MainCanvas.HEIGHT < 241 ? this.iInstructionsHeight : imgInlogic.getHeight() + (this.fontMain.getHeight() << 3);
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
            this.menuItemsImages[3] = 3;
        } else {
            this.soundOff();
            this.menuItemsImages[3] = 4;
        }
        this.bLoading = false;
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 4;
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(7);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(36);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(10);
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(9);
                        if (Profile.bMusic) {
                            this.strTextMenu[3] = this.strTextMenu[3] + " " + Resources.resTexts[0].getHashedString(15);
                            break block0;
                        }
                        this.strTextMenu[3] = this.strTextMenu[3] + " " + Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 1: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(36);
                        this.bLoading = true;
                        this.setTitleCenter(this.strTextBody);
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(8) + "\n\n" + Resources.resTexts[0].getHashedString(26);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.strTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1);
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight + (iTextHeight >> 2);
                        this.iInstructionsMaxShiftY += this.iInstructionsMaxShiftY >> 3;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 2: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(10);
                        this.setTitleCenter(this.strTextBody);
                        this.strTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.strTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                    case 3: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    default: 
                }
                break;
            }
        }
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iFlash = 150;
                if (this.subScreen != 0) break;
                this.iSelectedMenuItem = 0;
                break;
            }
            case 2: {
                this.iFlash = 150;
                if (this.subScreen == 1) {
                    this.game.initGameOver();
                    break;
                }
                if (this.subScreen != 0) break;
                this.game.restart();
                break;
            }
        }
        this.setTexts();
    }

    public void playMusic(int type, int times) {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(type, times);
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }
}

