/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import main.MainCanvas;
import utils.Utils;

public class Avatar
extends Sprite {
    private static final int AVATAR_CENTER = 0;
    private static final int AVATAR_UP = 1;
    private static final int AVATAR_DOWN = 2;
    private static final int AVATAR_LEFT = 3;
    private static final int AVATAR_RIGHT = 4;
    private static final int AVATAR_FAST_UP = 5;
    private static final int AVATAR_HIT_1 = 6;
    private static final int AVATAR_HIT_2 = 7;
    private static final int AVATAR_ROCKET = 8;
    public static final int AVATAR_ACTION_NORMAL = 0;
    public static final int AVATAR_ACTION_JUMP = 1;
    public static final int AVATAR_ACTION_DROP = 2;
    public static final int AVATAR_ACTION_HIT = 3;
    public static final int AVATAR_ACTION_FALL = 4;
    public static final int AVATAR_ACTION_ROCKET = 5;
    public static final int AVATAR_ACTION_SPRING = 6;
    private int nState = 0;
    private int nPrevState;
    private int nType;
    public int nSpeedX = 0;
    private int nVelocity = -18;
    private int nAcceleration = 1;
    private int count = 0;
    private int nTime = 0;
    private int nLastMovX;
    private int nLastMovY;
    private int nJumpedHeight = 0;
    private int nCoinsCollected = 0;
    private int nOnPlatformType = -1;
    private int nOnPlatform = -1;
    private int nPrevPlatform = -1;
    private Image primaryImage;
    private Image specialImage;
    private int primaryWidth;
    private int primaryHeight;
    public boolean isMovingLeft;
    public boolean isMovingRight;

    public Avatar(int type, Image image, int width, int height) {
        super(image, width, height);
        this.nType = type;
        this.primaryImage = image;
        this.primaryWidth = width;
        this.primaryHeight = height;
        this.setFrame(0);
        this.defineReferencePixel(width / 2, height / 2);
        try {
            this.specialImage = Image.createImage((String)Utils.getAvatarRocket(this.nType));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getState() {
        return this.nState;
    }

    public void setState(int state) {
        this.count = 0;
        this.nPrevState = this.nState;
        this.nState = state;
        if (this.nPrevState == 5) {
            this.setImage(this.primaryImage, this.primaryWidth, this.primaryHeight);
        }
        switch (this.nState) {
            case 1: {
                this.setFrame(1);
                if (this.nPrevPlatform != this.nOnPlatform) {
                    this.nPrevPlatform = this.nOnPlatform;
                }
                this.setVelocity(-18);
                this.nTime = 2;
                break;
            }
            case 2: {
                this.setFrame(2);
                break;
            }
            case 3: {
                this.setFrame(6);
                break;
            }
            case 4: {
                this.nTime = 2;
                break;
            }
            case 5: {
                this.setVelocity(-54);
                try {
                    this.setImage(this.specialImage, this.specialImage.getWidth(), this.specialImage.getHeight());
                    this.setFrame(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                this.setVelocity(-36);
                this.setFrame(5);
            }
        }
    }

    public int getVelocity() {
        return this.nVelocity;
    }

    public void setVelocity(int velocity) {
        this.nVelocity = velocity;
    }

    public void increaseVelocity() {
        ++this.nVelocity;
    }

    public int getOnPlatformType() {
        return this.nOnPlatformType;
    }

    public void setOnPlatformType(int type) {
        this.nOnPlatformType = type;
    }

    public int getOnPlatform() {
        return this.nOnPlatform;
    }

    public void setOnPlatform(int id) {
        this.nOnPlatform = id;
    }

    public void input(int keyStates) {
        switch (this.nState) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if ((keyStates & 4) != 0) {
                    this.nSpeedX = -12;
                    if (this.nState == 5) break;
                    this.setFrame(3);
                    break;
                }
                if ((keyStates & 0x20) != 0) {
                    this.nSpeedX = 12;
                    if (this.nState == 5) break;
                    this.setFrame(4);
                    break;
                }
                this.nSpeedX = 0;
            }
        }
    }

    public void inputRepeated(int keyStates) {
        if ((keyStates & 4) != 0) {
            this.isMovingLeft = true;
        } else if ((keyStates & 0x20) != 0) {
            this.isMovingRight = true;
        }
    }

    public void inputReleased(int keyStates) {
        if ((keyStates & 4) != 0) {
            this.isMovingLeft = false;
        } else if ((keyStates & 0x20) != 0) {
            this.isMovingRight = false;
        }
    }

    public void logic(int width) {
        switch (this.nState) {
            case 0: {
                switch (this.nOnPlatformType) {
                    case 0: {
                        this.setVelocity(-18);
                        break;
                    }
                    case 2: {
                        this.setVelocity(0);
                    }
                    default: {
                        this.setVelocity(-18);
                    }
                }
                if (this.nPrevPlatform != this.nOnPlatform) {
                    this.nPrevPlatform = this.nOnPlatform;
                }
                this.setFrame(0);
                this.setState(1);
                break;
            }
            case 1: 
            case 2: {
                this.moveAhead(this.nSpeedX, this.nVelocity, width, 0);
                if (this.nVelocity >= 0) {
                    this.setState(2);
                }
                this.nVelocity += this.nAcceleration;
                break;
            }
            case 4: {
                if (this.nTime < 2) {
                    this.setState(2);
                }
                --this.nTime;
                break;
            }
            case 3: {
                this.moveAhead(this.nSpeedX, this.nVelocity, width, 0);
                this.nVelocity += this.nAcceleration;
                break;
            }
            case 5: 
            case 6: {
                this.moveHorizontally(this.nSpeedX, MainCanvas.height / 2, width, 0);
            }
        }
        if (this.isMovingLeft) {
            --this.nSpeedX;
        } else if (this.nSpeedX < 0) {
            ++this.nSpeedX;
        }
        if (this.isMovingRight) {
            ++this.nSpeedX;
        } else if (this.nSpeedX > 0) {
            --this.nSpeedX;
        }
        if (this.nSpeedX > 12) {
            this.nSpeedX = 12;
        } else if (this.nSpeedX < -12) {
            this.nSpeedX = -12;
        }
    }

    public void moveHorizontally(int x, int y, int width, int height) {
        this.nLastMovX = x;
        this.nLastMovY = y;
        if (this.getRefPixelX() > width) {
            this.setRefPixelPosition(0 + x, y);
        } else if (this.getRefPixelX() < 0) {
            this.setRefPixelPosition(width, y);
        } else {
            this.setRefPixelPosition(this.getRefPixelX() + x, y);
        }
    }

    public void moveAhead(int x, int y, int width, int height) {
        this.nLastMovX = x;
        this.nLastMovY = y;
        if (this.getRefPixelX() > width) {
            this.setRefPixelPosition(0 + x, this.getRefPixelY() + y);
        } else if (this.getRefPixelX() < 0) {
            this.setRefPixelPosition(width, this.getRefPixelY() + y);
        } else {
            this.setRefPixelPosition(this.getRefPixelX() + x, this.getRefPixelY() + y);
        }
    }

    public void moveBack() {
        int x = this.getRefPixelX();
        int y = this.getRefPixelY();
        this.setRefPixelPosition(x - this.nLastMovX, y - this.nLastMovY);
    }

    public void setScore(int score) {
        if (score < 0) {
            score = -score;
        }
        this.nJumpedHeight += score;
    }

    public int getScore() {
        if (this.nJumpedHeight < 0) {
            this.nJumpedHeight *= -1;
        }
        return this.nJumpedHeight;
    }

    public int getTotalScore() {
        return this.nJumpedHeight + this.nCoinsCollected * 25;
    }

    public int getCoinsCollected() {
        return this.nCoinsCollected;
    }

    public void setCoinsCollected(int nCoinsCollected) {
        this.nCoinsCollected += nCoinsCollected;
    }
}

