/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Keys;

public class MainCanvas
extends GameCanvas
implements Runnable {
    public static final int FPS = 40;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    private static Thread mainThread;
    private Vector activeScreens = new Vector();
    public long lLastRun;
    private boolean interuptionIn;
    private boolean handsetTiled;
    private boolean paintIn;
    public boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public static SoundManager soundManager;
    public static int UPS;
    public static long upsControlLen;
    public static int upsCount;
    public static long upsLastRun;
    public static int delayRatio;

    public MainCanvas() {
        super(false);
        this.initCanvas();
        Keys.canvas = this;
        this.handsetTiled = false;
        soundManager = new SoundManager(2);
        soundManager.LoadPlayList(Sounds.GAME_MUSIC_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
    }

    public void startGame() {
        mainThread = new Thread(this);
        mainThread.start();
    }

    public void pausePaint() {
        this.paintPaused = true;
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
    }

    public void changeLastActiveScreen(IScreen newScreen) {
        if (newScreen == null || this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait> changeLastActiveScreen()");
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        newScreen.beforeShow();
        this.activeScreens.addElement(newScreen);
        this.lLastRun = System.currentTimeMillis();
        this.paintPaused = false;
    }

    public void addActiveScreen(IScreen screen) {
        if (screen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        screen.beforeShow();
        this.activeScreens.addElement(screen);
    }

    public void removeLastActiveScreen() {
        if (this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait> removeLastActiveScreen()");
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        this.paintPaused = false;
    }

    public void hideNotify() {
        if (this.interuptionIn) {
            return;
        }
        this.interuptionIn = true;
        soundManager.Stop();
        ((IScreen)this.activeScreens.lastElement()).beforeInteruption();
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        ((IScreen)this.activeScreens.lastElement()).afterInteruption();
        this.repaint();
    }

    public boolean isInterrupted() {
        return this.interuptionIn;
    }

    public void run() {
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lLastRun < 40L) continue;
            if (upsLastRun != 0L) {
                ++upsCount;
                if ((upsControlLen += currentTime - upsLastRun) >= 1000L) {
                    UPS = upsCount;
                    upsCount = 0;
                    upsControlLen = 0L;
                    delayRatio = UPS << 4;
                    delayRatio /= 10;
                    if ((delayRatio >>= 4) < 1) {
                        delayRatio = 1;
                    }
                }
            }
            if (!this.bScreenSizeAdjusted) {
                this.repaint();
                this.lLastRun = currentTime;
                continue;
            }
            if (this.handsetTiled) {
                this.repaint();
                continue;
            }
            if (!this.paintPaused && currentTime - this.lLastRun > 2000L && this.lLastRun != 0L) {
                this.hideNotify();
                this.showNotify();
            }
            try {
                Thread.sleep(15L);
            }
            catch (Exception e) {
                // empty catch block
            }
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).update(currentTime - this.lLastRun);
            }
            upsLastRun = this.lLastRun = System.currentTimeMillis();
        }
    }

    public void paint(Graphics g) {
        if (this.paintPaused) {
            return;
        }
        HEIGHT = g.getClipHeight();
        WIDTH = g.getClipWidth();
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.handsetTiled = true;
            this.paintRotate(g);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        this.handsetTiled = false;
        if (!this.bScreenSizeAdjusted) {
            this.bScreenSizeAdjusted = true;
            this.addActiveScreen(new ScreenMain(this));
        }
        if (this.activeScreens.size() > 0) {
            this.paintIn = true;
            g.setColor(0);
            g.fillRect(0, 0, WIDTH, HEIGHT);
            g.setColor(0xFFFFFF);
            g.setClip(0, 0, WIDTH, HEIGHT);
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).paint(g);
            }
            this.paintIn = false;
        }
    }

    private void paintRotate(Graphics g) {
        g.setClip(0, 0, WIDTH, HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        if (Resources.resImgs[0] == null) {
            Resources.loadImage(0);
        } else {
            g.drawImage(Resources.resImgs[0], WIDTH / 2, HEIGHT / 2, 3);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.handsetTiled) {
            return;
        }
        if (keyCode == 102) {
            keyCode = 52;
        } else if (keyCode == 104) {
            keyCode = 54;
        } else if (keyCode == 103) {
            keyCode = 53;
        } else if (keyCode == 116) {
            keyCode = 50;
        } else if (keyCode == 98) {
            keyCode = 56;
        } else if (keyCode == 117) {
            keyCode = 42;
        } else if (keyCode == 112 || keyCode == 114 || keyCode == 97 || keyCode == 106 || keyCode == 118 || keyCode == 100 || keyCode == 108 || keyCode == 107 || keyCode == 109 || keyCode == 121 || keyCode == 110) {
            return;
        }
        Keys.keyPressed(keyCode);
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).keyPressed(keyCode);
        }
    }

    private void onKeyReleased(int keyCode) {
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).keyReleased(keyCode);
        }
        Keys.keyReleased(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (this.handsetTiled) {
            return;
        }
        if (keyCode == 102) {
            keyCode = 52;
        } else if (keyCode == 104) {
            keyCode = 54;
        } else if (keyCode == 103) {
            keyCode = 53;
        } else if (keyCode == 116) {
            keyCode = 50;
        } else if (keyCode == 98) {
            keyCode = 56;
        } else if (keyCode == 117) {
            keyCode = 42;
        } else if (keyCode == 112 || keyCode == 114 || keyCode == 97 || keyCode == 106 || keyCode == 118 || keyCode == 100 || keyCode == 108 || keyCode == 107 || keyCode == 109 || keyCode == 121 || keyCode == 110) {
            return;
        }
        this.onKeyReleased(keyCode);
    }

    static {
        String fullCanvasSize = "320x240";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UPS = 0;
        upsControlLen = 0L;
        upsCount = 0;
        upsLastRun = 0L;
        delayRatio = 0;
    }
}

