/*
 * Decompiled with CFR 0.152.
 */
package org.albite.book.model.book;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import org.albite.book.model.book.BookException;
import org.albite.book.model.book.Bookmark;
import org.albite.book.model.book.BookmarkManager;
import org.albite.book.model.book.Chapter;
import org.albite.book.model.book.EPubBook;
import org.albite.book.model.book.FileBook;
import org.albite.book.model.parser.HTMLTextParser;
import org.albite.book.model.parser.PlainTextParser;
import org.albite.book.model.parser.TextParser;
import org.albite.io.PartitionedConnection;
import org.albite.io.RandomReadingFile;
import org.albite.util.archive.Archive;
import org.albite.util.archive.File;
import org.albite.util.archive.folder.ArchiveFolder;
import org.geometerplus.zlibrary.text.hyphenation.Languages;
import org.kxml2.io.KXmlParser;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Book
implements Connection {
    public static final String EPUB_EXTENSION = ".epub";
    public static final String PLAIN_TEXT_EXTENSION = ".txt";
    public static final String HTM_EXTENSION = ".htm";
    public static final String HTML_EXTENSION = ".html";
    public static final String XHTML_EXTENSION = ".xhtml";
    public static final String[] SUPPORTED_BOOK_EXTENSIONS = new String[]{".epub", ".txt", ".htm", ".html", ".xhtml"};
    private static byte[] a = "b".getBytes();
    protected String a;
    protected String b;
    protected String c = "";
    protected String d = "";
    private BookmarkManager a;
    private FileConnection a;
    private FileConnection b = null;
    protected String e = null;
    protected Chapter[] a;
    protected Chapter a;
    protected TextParser a = null;
    public static final int MAXIMUM_TXT_FILESIZE = 65536;
    public static final int MAXIMUM_HTML_FILESIZE = 196608;

    public abstract void close();

    protected final void a() {
        if (this.a != null) {
            this.a.close();
        }
        if (this.b != null) {
            this.b.close();
        }
    }

    public final String getLanguage() {
        return this.d;
    }

    public final String getLanguageAlias() {
        String[][] stringArray = Languages.LANGUAGES;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2][0].equalsIgnoreCase(this.c)) continue;
            return stringArray[i2][1];
        }
        return this.c;
    }

    public final boolean setLanguage(String string) {
        if (string != null && !string.equalsIgnoreCase(this.d)) {
            this.d = string;
            return true;
        }
        return false;
    }

    public final String getDefaultLanguage() {
        return this.c;
    }

    public final void unloadChaptersBuffers() {
        for (Chapter chapter = this.a[0]; chapter != null; chapter = chapter.getNextChapter()) {
            chapter.unload();
        }
    }

    public boolean setEncoding(String string) {
        boolean bl = this.a.a(string);
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].a(string);
        }
        return bl;
    }

    protected final void a(String object) {
        this.a = this.a[0];
        this.a = Book.a(RandomReadingFile.changeExtension((String)object, ".alx"));
        this.b = Book.a(RandomReadingFile.changeExtension((String)object, ".alb"));
        object = this;
        try {
            super.c();
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
        }
        catch (BookException bookException) {}
        try {
            super.d();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
        catch (BookException bookException) {
            return;
        }
    }

    private static FileConnection a(String string) {
        try {
            string = (FileConnection)Connector.open((String)string, (int)3);
            return string;
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private void c() {
        if (this.a != null) {
            DataInputStream dataInputStream = this.a.openDataInputStream();
            try {
                if (dataInputStream.readInt() != 1634493048) {
                    throw new BookException("Wrong magic number");
                }
                this.d = dataInputStream.readUTF();
                this.a = this.getChapter(dataInputStream.readShort());
                int n2 = dataInputStream.readShort();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Chapter chapter = this.getChapter(i2);
                    chapter.setCurrentPosition(dataInputStream.readInt());
                    chapter.a(dataInputStream.readUTF());
                }
                return;
            }
            finally {
                dataInputStream.close();
            }
        }
    }

    private void d() {
        Object object;
        Object object2;
        if (this.b == null) {
            return;
        }
        InputStream inputStream = this.b.openInputStream();
        try {
            object2 = new KXmlParser();
            ((KXmlParser)object2).setInput(new InputStreamReader(inputStream, "UTF-8"));
            object = new Document();
            ((Document)object).parse((XmlPullParser)object2);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new BookException("Wrong XML data.");
        }
        try {
            object2 = ((Document)object).getRootElement();
            int n2 = ((Node)object2).getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (((Node)object2).getType(i2) != 2) continue;
                object = ((Node)object2).getElement(i2);
                int n3 = Book.a((Element)object, "c");
                int n4 = Book.a((Element)object, "p");
                if (n4 < 0) {
                    n4 = 0;
                }
                if (!((Element)object).getName().equals("b")) continue;
                if ((object = ((Node)object).getText(0)) == null) {
                    object = "Untitled";
                }
                this.a.addBookmark(new Bookmark(this.getChapter(n3), n4, (String)object));
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.a.deleteAll();
            throw new BookException("Missing info (NP Exception)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.a.deleteAll();
            throw new BookException("Malformed int data");
        }
        catch (RuntimeException runtimeException) {
            this.a.deleteAll();
            throw new BookException("Wrong data");
        }
        finally {
            inputStream.close();
        }
    }

    private static int a(Element element, String string) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(element.getAttributeValue("", string));
        }
        catch (NumberFormatException numberFormatException) {}
        return n2;
    }

    public final void saveBookSettings() {
        if (this.a != null && this.a != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeInt(1634493048);
                    dataOutputStream.writeUTF(this.d);
                    dataOutputStream.writeShort((short)this.a.getNumber());
                    int n2 = this.a.length;
                    dataOutputStream.writeShort((short)n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Chapter chapter = this.a[i2];
                        dataOutputStream.writeInt(chapter.getCurrentPosition());
                        dataOutputStream.writeUTF(chapter.getEncoding());
                    }
                    Book.a(byteArrayOutputStream.toByteArray(), this.a);
                }
                finally {
                    dataOutputStream.close();
                }
            }
            catch (IOException iOException) {
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    public final void saveBookmarks() {
        if (this.a != null && this.b != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.write(60);
                    dataOutputStream.write(a);
                    dataOutputStream.write(62);
                    dataOutputStream.write(10);
                    Bookmark bookmark = this.a.getFirst();
                    while (bookmark != null) {
                        dataOutputStream.write(60);
                        dataOutputStream.write("b".getBytes("UTF-8"));
                        dataOutputStream.write(32);
                        dataOutputStream.write("c".getBytes("UTF-8"));
                        dataOutputStream.write(61);
                        dataOutputStream.write(34);
                        dataOutputStream.write(Integer.toString(bookmark.getChapter().getNumber()).getBytes("UTF-8"));
                        dataOutputStream.write(34);
                        dataOutputStream.write(32);
                        dataOutputStream.write("p".getBytes("UTF-8"));
                        dataOutputStream.write(61);
                        dataOutputStream.write(34);
                        dataOutputStream.write(Integer.toString(bookmark.getPosition()).getBytes("UTF-8"));
                        dataOutputStream.write(34);
                        dataOutputStream.write(62);
                        dataOutputStream.write(bookmark.getTextForHTML().getBytes("UTF-8"));
                        dataOutputStream.write(60);
                        dataOutputStream.write(47);
                        dataOutputStream.write("b".getBytes("UTF-8"));
                        dataOutputStream.write(62);
                        dataOutputStream.write(10);
                        bookmark = bookmark.b;
                    }
                    dataOutputStream.write(60);
                    dataOutputStream.write(47);
                    dataOutputStream.write(a);
                    dataOutputStream.write(62);
                    dataOutputStream.write(10);
                    Book.a(byteArrayOutputStream.toByteArray(), this.b);
                }
                catch (IOException iOException) {
                }
                finally {
                    dataOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void a(byte[] byArray, FileConnection object) {
        if (object != null && !object.isDirectory()) {
            try {
                if (!object.exists()) {
                    object.create();
                }
                object.truncate(0L);
                object = object.openDataOutputStream();
                try {
                    ((FilterOutputStream)object).write(byArray);
                }
                catch (IOException iOException) {
                }
                finally {
                    ((FilterOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    public final int getChaptersCount() {
        return this.a.length;
    }

    public final Chapter getChapter(int n2) {
        if (n2 < 0) {
            return this.a[0];
        }
        if (n2 > this.a.length - 1) {
            return this.a[this.a.length - 1];
        }
        return this.a[n2];
    }

    public final void fillBookInfo(Form form) {
        StringItem stringItem = new StringItem("Title:", this.a);
        stringItem.setLayout(1);
        form.append((Item)stringItem);
        stringItem = new StringItem("Author:", this.b);
        form.append((Item)stringItem);
        stringItem = new StringItem("Language:", this.getLanguageAlias());
        form.append((Item)stringItem);
        new StringItem("Language:", this.c);
    }

    public final BookmarkManager getBookmarkManager() {
        return this.a;
    }

    public final Chapter getCurrentChapter() {
        return this.a;
    }

    public final void setCurrentChapter(Chapter chapter) {
        this.a = chapter;
    }

    public final int getCurrentChapterPosition() {
        return this.a.getCurrentPosition();
    }

    public final void setCurrentChapterPos(int n2) {
        if (n2 < 0 || n2 >= this.a.getTextBuffer().length) {
            throw new IllegalArgumentException("Position is wrong");
        }
        this.a.setCurrentPosition(n2);
    }

    public final TextParser getParser() {
        return this.a;
    }

    public static Book open(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(EPUB_EXTENSION)) {
            return new EPubBook(string);
        }
        if (string2.endsWith(PLAIN_TEXT_EXTENSION)) {
            return new FileBook(string, null, new PlainTextParser(), false);
        }
        if (string2.endsWith(HTM_EXTENSION) || string2.endsWith(HTML_EXTENSION) || string2.endsWith(XHTML_EXTENSION)) {
            return new FileBook(string, new ArchiveFolder(RandomReadingFile.getPathFromURL(string)), new HTMLTextParser(), true);
        }
        throw new BookException("Unsupported file format.");
    }

    protected final void b() {
        for (int i2 = 1; i2 < this.a.length; ++i2) {
            Chapter chapter = this.a[i2 - 1];
            Chapter chapter2 = this.a[i2];
            chapter.setNextChapter(chapter2);
            chapter2.setPrevChapter(chapter);
        }
    }

    protected static void a(InputConnection inputConnection, int n2, File file, int n3, int n4, boolean bl, Vector vector) {
        if (n2 <= n3) {
            vector.addElement(new Chapter(inputConnection, n2, file, "Chapter #" + (n4 + 1), bl, n4));
            return;
        }
        int n5 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n5;
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = n2 > n3 ? n3 : n2;
            vector.addElement(new Chapter(new PartitionedConnection(inputConnection, i2 * n3, n6), n6, file, "Chapter #" + (n4 + i2 + 1), bl, n4 + i2));
            n2 -= n3;
        }
    }

    public final String getURL() {
        return this.e;
    }

    public abstract Archive getArchive();

    static {
        "c".getBytes();
        "e".getBytes();
        "p".getBytes();
    }
}

