/*
 * Decompiled with CFR 0.152.
 */
package general.display;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class MemoryDisplayUpdater {
    private final GameCanvas c;
    private final Graphics grph;
    private final int width;
    private final int height;
    private boolean rotated;
    private int drawingAreaWidth;
    private int drawingAreaHeight;
    private int activeWidth;
    private int activeHeight;
    private int[] pixels;
    private int[] activePixels;
    private int[] rgbData;
    private int ratioX;
    private int ratioY;
    private int[] translate;
    private final int[][] rgbMaps;
    private int[] currentRgbMap;

    public MemoryDisplayUpdater(GameCanvas c, Graphics grph, boolean rotated, int[] pixels, int width, int height, int numberPalletes) {
        this(c, grph, rotated, pixels, width, height, c.getWidth(), c.getHeight(), numberPalletes);
    }

    public MemoryDisplayUpdater(GameCanvas c, Graphics grph, boolean rotated, int[] pixels, int width, int height, int drawingAreaWidth, int drawingAreaHeight, int numberPalletes) {
        this.rotated = rotated;
        this.c = c;
        this.grph = grph;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.rgbMaps = new int[numberPalletes][];
        this.currentRgbMap = null;
        this.drawingAreaWidth = drawingAreaWidth;
        this.drawingAreaHeight = drawingAreaHeight;
        this.initActiveAreaArrays();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeActiveArea(int drawingAreaWidth, int drawingAreaHeight) {
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            this.drawingAreaWidth = drawingAreaWidth;
            this.drawingAreaHeight = drawingAreaHeight;
            this.initActiveAreaArrays();
            this.reduce(0, 0, drawingAreaWidth, drawingAreaHeight);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotation(boolean newRotationState) {
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            this.rotated = newRotationState;
            this.initActiveAreaArrays();
            this.reduce(0, 0, this.activeWidth, this.activeHeight);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            this.grph.setColor(255, 255, 255);
            this.grph.fillRect(0, 0, this.c.getWidth(), this.c.getHeight());
            if (this.currentRgbMap != null) {
                this.draw(0, 0, this.activeWidth, this.activeHeight);
            }
        }
        this.c.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPallete(int index, int[] r, int[] g, int[] b) {
        boolean changingActivePallete;
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            changingActivePallete = this.rgbMaps[index] == this.currentRgbMap;
            this.rgbMaps[index] = new int[r.length];
            for (int i = 0; i < r.length; ++i) {
                this.rgbMaps[index][i] = b[i] + (g[i] << 8) + (r[i] << 16);
            }
            if (this.currentRgbMap == null) {
                this.currentRgbMap = this.rgbMaps[index];
            }
        }
        if (changingActivePallete) {
            this.newPixels(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPallete(int newPalleteIndex) {
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            if (this.rgbMaps[newPalleteIndex] == null) {
                throw new RuntimeException("Pallete " + newPalleteIndex + " is undefined.");
            }
            this.currentRgbMap = this.rgbMaps[newPalleteIndex];
            this.draw(0, 0, this.activeWidth, this.activeHeight);
        }
        this.flushGraphics(0, 0, this.activeWidth, this.activeHeight);
    }

    public void newPixels(boolean immediateFlush) {
        this.newPixels(immediateFlush, 0, 0, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPixels(boolean immediateFlush, int x, int y, int w, int h) {
        int activeH;
        int activeW;
        int activeY0;
        int activeX0;
        MemoryDisplayUpdater memoryDisplayUpdater = this;
        synchronized (memoryDisplayUpdater) {
            if (this.currentRgbMap == null) {
                throw new RuntimeException("Need to add at least one pallete.");
            }
            activeX0 = x * this.ratioX / 1000;
            activeY0 = y * this.ratioY / 1000;
            activeW = Math.min((x + w) * this.ratioX / 1000 - activeX0 + 2, this.activeWidth - activeX0);
            activeH = Math.min((y + h) * this.ratioY / 1000 - activeY0 + 2, this.activeHeight - activeY0);
            this.reduce(activeX0, activeY0, activeW, activeH);
            this.draw(activeX0, activeY0, activeW, activeH);
        }
        if (immediateFlush) {
            this.flushGraphics(activeX0, activeY0, activeW, activeH);
        }
    }

    public void flush() {
        this.flushGraphics(0, 0, this.activeWidth, this.activeHeight);
    }

    public Image getAsImage() {
        if (!this.rotated) {
            return Image.createRGBImage((int[])this.rgbData, (int)this.activeWidth, (int)this.activeHeight, (boolean)false);
        }
        return Image.createRGBImage((int[])this.rgbData, (int)this.activeHeight, (int)this.activeWidth, (boolean)false);
    }

    private void initActiveAreaArrays() {
        if (!this.rotated) {
            this.activeHeight = this.drawingAreaHeight;
            this.activeWidth = this.drawingAreaWidth;
        } else {
            this.activeHeight = this.drawingAreaWidth;
            this.activeWidth = this.drawingAreaHeight;
        }
        this.activePixels = new int[this.activeWidth * this.activeHeight];
        this.ratioX = (int)((double)this.activeWidth / (double)this.width * 1000.0);
        this.ratioY = (int)((double)this.activeHeight / (double)this.height * 1000.0);
        this.translate = new int[this.activeWidth * this.activeHeight];
        for (int i = 0; i < this.activeHeight; ++i) {
            for (int j = 0; j < this.activeWidth; ++j) {
                int x;
                int y = i * 1000 / this.ratioY;
                if (i * 1000 - y * this.ratioY > 500) {
                    ++y;
                }
                if (j * 1000 - (x = j * 1000 / this.ratioX) * this.ratioX > 500) {
                    ++x;
                }
                this.translate[i * this.activeWidth + j] = y * this.width + x;
            }
        }
        this.rgbData = new int[this.activeWidth * this.activeHeight];
    }

    private void reduce(int activeX0, int activeY0, int activeW, int activeH) {
        for (int y = activeY0; y < activeY0 + activeH; ++y) {
            for (int x = activeX0; x < activeX0 + activeW; ++x) {
                int index = y * this.activeWidth + x;
                this.activePixels[index] = this.pixels[this.translate[index]];
            }
        }
    }

    private void draw(int activeX0, int activeY0, int activeW, int activeH) {
        if (!this.rotated) {
            for (int i = 0; i < activeH; ++i) {
                for (int j = 0; j < activeW; ++j) {
                    this.rgbData[(activeY0 + i) * this.activeWidth + activeX0 + j] = this.currentRgbMap[this.activePixels[(activeY0 + i) * this.activeWidth + activeX0 + j]];
                }
            }
            this.grph.drawRGB(this.rgbData, activeY0 * this.activeWidth + activeX0, this.activeWidth, activeX0, activeY0, activeW, activeH, false);
        } else {
            for (int i = 0; i < activeH; ++i) {
                for (int j = 0; j < activeW; ++j) {
                    this.rgbData[(activeX0 + j) * this.activeHeight + this.activeHeight - activeY0 - i - 1] = this.currentRgbMap[this.activePixels[(activeY0 + i) * this.activeWidth + activeX0 + j]];
                }
            }
            this.grph.drawRGB(this.rgbData, activeX0 * this.activeHeight + (this.activeHeight - activeY0 - activeH), this.activeHeight, this.activeHeight - activeY0 - activeH, activeX0, activeH, activeW, false);
        }
    }

    private void flushGraphics(int activeX0, int activeY0, int activeW, int activeH) {
        if (!this.rotated) {
            this.c.flushGraphics(activeX0, activeY0, activeW, activeH);
        } else {
            this.c.flushGraphics(this.activeHeight - activeY0 - activeH, activeX0, activeH, activeW);
        }
    }
}

