/*
 * Decompiled with CFR 0.152.
 */
package general.sound;

import java.io.IOException;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.ToneControl;

public class SimpleToneSequencePlayer {
    private final byte[] toneSequence;
    Thread playingThread = null;
    Object playingThreadLock = new Object();
    final PlayerListener playerListener = new PlayerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playerUpdate(Player player, String event, Object eventData) {
            if (event.equals("endOfMedia")) {
                Object object = SimpleToneSequencePlayer.this.playingThreadLock;
                synchronized (object) {
                    if (SimpleToneSequencePlayer.this.playingThread != null) {
                        SimpleToneSequencePlayer.this.playingThread.interrupt();
                    }
                }
            }
        }
    };

    public SimpleToneSequencePlayer(byte[] toneSequence) {
        this.toneSequence = toneSequence;
    }

    private Thread createPlayingThread(final boolean loop) {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Player player = null;
                try {
                    player = Manager.createPlayer((String)"device://tone");
                    if (loop) {
                        player.setLoopCount(-1);
                    } else {
                        player.setLoopCount(1);
                    }
                    player.realize();
                    ToneControl tc = (ToneControl)player.getControl("javax.microedition.media.control.ToneControl");
                    tc.setSequence(SimpleToneSequencePlayer.this.toneSequence);
                    if (!loop) {
                        player.addPlayerListener(SimpleToneSequencePlayer.this.playerListener);
                    }
                    player.start();
                    SimpleToneSequencePlayer.this.playingThread.join();
                }
                catch (IOException e) {
                }
                catch (MediaException e) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = SimpleToneSequencePlayer.this.playingThreadLock;
                synchronized (object) {
                    player.removePlayerListener(SimpleToneSequencePlayer.this.playerListener);
                    if (player != null) {
                        player.close();
                        player = null;
                    }
                    SimpleToneSequencePlayer.this.playingThread = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playInLoop() {
        Object object = this.playingThreadLock;
        synchronized (object) {
            if (this.playingThread != null) {
                return;
            }
            this.playingThread = this.createPlayingThread(true);
            this.playingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSingle() {
        Object object = this.playingThreadLock;
        synchronized (object) {
            if (this.playingThread != null) {
                return;
            }
            this.playingThread = this.createPlayingThread(false);
            this.playingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlaying() {
        Object object = this.playingThreadLock;
        synchronized (object) {
            if (this.playingThread == null) {
                return;
            }
            this.playingThread.interrupt();
        }
    }
}

