/*
 * Decompiled with CFR 0.152.
 */
package general.ui;

import java.util.Hashtable;
import javax.microedition.lcdui.game.GameCanvas;

public class ExtendedGameCanvas
extends GameCanvas {
    public static final int LSK = 900;
    public static final int RSK = 901;
    private final Hashtable keyCodes = new Hashtable();

    public ExtendedGameCanvas(boolean arg0) {
        super(arg0);
        String type = this.getDeviceType();
        if (type.startsWith("SonyEricsson")) {
            this.keyPut(-6, 900);
            this.keyPut(-7, 901);
        }
        if (type.startsWith("Nokia")) {
            this.keyPut(-6, 900);
            this.keyPut(-7, 901);
        }
    }

    public int getGameAction(int keyCode) {
        try {
            int superAction = super.getGameAction(keyCode);
            if (superAction == 0) {
                return this.keyGet(keyCode);
            }
            return superAction;
        }
        catch (IllegalArgumentException e) {
            return this.keyGet(keyCode);
        }
    }

    public int getKeyCode(int gameAction) {
        return super.getKeyCode(gameAction);
    }

    public boolean canDetect(int gameAction) {
        return this.keyCodes.contains(new Integer(gameAction));
    }

    protected String getDeviceType() {
        return System.getProperty("microedition.platform");
    }

    private void keyPut(int code, int action) {
        this.keyCodes.put(new Integer(code), new Integer(action));
    }

    private int keyGet(int code) {
        Object actionObject = this.keyCodes.get(new Integer(code));
        if (actionObject == null) {
            return 0;
        }
        return (Integer)actionObject;
    }
}

