/*
 * Decompiled with CFR 0.152.
 */
package digger;

import digger.DiggerCanvas;
import digger.ScoreStorage;
import general.ui.MenuEvent;
import general.ui.MenuItem;
import general.ui.MenuListener;
import general.ui.MenuScreen;
import general.ui.TextMenuItem;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class DiggerMidlet
extends MIDlet
implements CommandListener,
MenuListener {
    private static String WARRENTY_TEXT_1 = "1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. ";
    private static String WARRENTY_TEXT_2 = "2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.";
    private DiggerCanvas gameCanvas;
    private static DiggerMidlet midlet;
    private final Command acceptCommand = new Command("Accept", 8, 0);
    private final Command exitCommand = new Command("Quit", 8, 0);
    private final Command menuCommand = new Command("Menu", 5, 0);
    private final TextMenuItem restartMenuItem = new TextMenuItem("Restart");
    private final TextMenuItem muteMenuItem = new TextMenuItem("Mute: OFF");
    private final TextMenuItem soundModeMenuItem = new TextMenuItem("Music: MIDI");
    private final TextMenuItem rotateMenuItem = new TextMenuItem("Rotate: OFF");
    private final TextMenuItem activeAreaMenuItem = new TextMenuItem("Drawing Area: FULL");
    private final TextMenuItem settingsMenuItem = new TextMenuItem("Settings");
    private final TextMenuItem backMenuItem = new TextMenuItem("Back");
    private final TextMenuItem exitOptionsMenuItem = new TextMenuItem("Exit Menu");
    private final TextMenuItem exitMenuItem = new TextMenuItem("Quit");
    boolean restrictingActiveArea = false;
    private final MenuScreen optionsMenu = new MenuScreen(4);
    private final MenuScreen settingsMenu = new MenuScreen(5);

    public static DiggerMidlet getMidlet() {
        return midlet;
    }

    public DiggerMidlet() {
        this.optionsMenu.setMenuListener(this);
        this.optionsMenu.setBackgroundColor(255, 255, 255);
        this.optionsMenu.setMenuBackgroundColor(255, 255, 255, 200);
        this.optionsMenu.setItemsColor(0, 0, 0);
        this.optionsMenu.setMenuItem(0, this.settingsMenuItem);
        this.optionsMenu.setMenuItem(1, this.restartMenuItem);
        this.optionsMenu.setMenuItem(2, this.exitOptionsMenuItem);
        this.optionsMenu.setMenuItem(3, this.exitMenuItem);
        this.settingsMenu.setMenuListener(this);
        this.settingsMenu.setBackgroundColor(255, 255, 255);
        this.settingsMenu.setMenuBackgroundColor(255, 255, 255, 200);
        this.settingsMenu.setItemsColor(0, 0, 0);
        this.settingsMenu.setMenuItem(0, this.activeAreaMenuItem);
        this.settingsMenu.setMenuItem(1, this.rotateMenuItem);
        this.settingsMenu.setMenuItem(2, this.soundModeMenuItem);
        this.settingsMenu.setMenuItem(3, this.muteMenuItem);
        this.settingsMenu.setMenuItem(4, this.backMenuItem);
    }

    public void startApp() {
        midlet = this;
        if (ScoreStorage.scoreStorageExists()) {
            this.startGame();
        } else {
            Form warnForm = new Form("No-Warrenty Terms");
            StringItem text1 = new StringItem(null, "Please read the following no-warrenty terms carefully. You must accept them to use the game. They will be displayed only on the first run.");
            text1.setLayout(1);
            warnForm.append((Item)text1);
            StringItem text2 = new StringItem(null, WARRENTY_TEXT_1);
            text2.setLayout(1);
            warnForm.append((Item)text2);
            StringItem text3 = new StringItem(null, WARRENTY_TEXT_2);
            text3.setLayout(1);
            warnForm.append((Item)text3);
            warnForm.addCommand(this.acceptCommand);
            warnForm.addCommand(this.exitCommand);
            warnForm.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)warnForm);
        }
    }

    public void startGame() {
        this.gameCanvas = new DiggerCanvas();
        if (this.gameCanvas.canCatchMenu()) {
            this.gameCanvas.setMenuPressAction(this, this.menuCommand);
        } else {
            this.gameCanvas.addCommand(this.menuCommand);
            this.gameCanvas.setCommandListener(this);
        }
        new Thread(this.gameCanvas).start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gameCanvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.gameCanvas.stop();
    }

    public void commandAction(Command cmd, Displayable dsply) {
        if (cmd == this.acceptCommand) {
            this.startGame();
        }
        if (cmd == this.exitCommand) {
            this.notifyDestroyed();
        }
        if (cmd == this.menuCommand) {
            this.optionsMenu.setBackgroundImage(this.gameCanvas.Pc.displayUpdater.getAsImage());
            this.settingsMenu.setBackgroundImage(this.gameCanvas.Pc.displayUpdater.getAsImage());
            this.optionsMenu.open(Display.getDisplay((MIDlet)this));
        }
    }

    public void onMenuEvent(MenuItem item, MenuEvent event, Displayable dsply) {
        Image newImage;
        if (item == this.exitMenuItem) {
            this.notifyDestroyed();
        }
        if (item == this.restartMenuItem) {
            this.gameCanvas.endgame();
            if (this.optionsMenu.isOpen()) {
                this.optionsMenu.close();
            }
        }
        if (item == this.muteMenuItem && (event == MenuEvent.LEFT_EVENT || event == MenuEvent.RIGHT_EVENT)) {
            boolean newMuteState = !this.gameCanvas.newSound.isMute();
            this.gameCanvas.newSound.setMuteState(newMuteState);
            this.muteMenuItem.setText("Mute: " + (newMuteState ? "ON" : "OFF"));
        }
        if (item == this.soundModeMenuItem && (event == MenuEvent.LEFT_EVENT || event == MenuEvent.RIGHT_EVENT)) {
            int newMusicMode = 1;
            String modeString = "MIDI";
            switch (this.gameCanvas.newSound.getMusicMode()) {
                case 1: {
                    newMusicMode = 2;
                    modeString = "TONE";
                    break;
                }
                case 2: {
                    newMusicMode = 1;
                    modeString = "MIDI";
                }
            }
            this.gameCanvas.newSound.setMusicMode(newMusicMode);
            this.soundModeMenuItem.setText("Music: " + modeString);
        }
        if (item == this.rotateMenuItem && (event == MenuEvent.LEFT_EVENT || event == MenuEvent.RIGHT_EVENT)) {
            boolean newRotation = !this.gameCanvas.getRotation();
            this.gameCanvas.setRotation(newRotation);
            newImage = this.gameCanvas.Pc.displayUpdater.getAsImage();
            this.optionsMenu.setBackgroundImage(newImage);
            this.settingsMenu.setBackgroundImage(newImage);
            this.rotateMenuItem.setText("Rotate: " + (newRotation ? "ON" : "OFF"));
        }
        if (item == this.activeAreaMenuItem && (event == MenuEvent.LEFT_EVENT || event == MenuEvent.RIGHT_EVENT)) {
            String d;
            if (!this.restrictingActiveArea) {
                if (this.gameCanvas.getWidth() >= 220) {
                    this.gameCanvas.changeDrawingArea(220, 176);
                } else if (this.gameCanvas.getHeight() >= 220) {
                    this.gameCanvas.changeDrawingArea(176, 220);
                } else if (this.gameCanvas.getHeight() >= 176 && this.gameCanvas.getWidth() >= 176) {
                    this.gameCanvas.changeDrawingArea(176, 176);
                } else {
                    return;
                }
                this.restrictingActiveArea = true;
                d = "SMALL";
            } else {
                this.gameCanvas.changeDrawingArea(this.gameCanvas.getWidth(), this.gameCanvas.getHeight());
                this.restrictingActiveArea = false;
                d = "FULL";
            }
            newImage = this.gameCanvas.Pc.displayUpdater.getAsImage();
            this.optionsMenu.setBackgroundImage(newImage);
            this.settingsMenu.setBackgroundImage(newImage);
            this.activeAreaMenuItem.setText("Drawing Area: " + d);
        }
        if (item == this.settingsMenuItem) {
            this.settingsMenu.open(Display.getDisplay((MIDlet)this));
        }
        if (item == this.backMenuItem) {
            this.settingsMenu.close();
        }
        if (item == this.exitOptionsMenuItem) {
            this.optionsMenu.close();
        }
    }
}

