/*
 * Decompiled with CFR 0.152.
 */
package digger;

import general.sound.MusicNotes;
import general.sound.NoteSequenceTunePlayer;
import general.sound.NoteSeriallizer;
import general.sound.ResourceTunePlayer;
import general.sound.TunePlayer;
import general.ui.GaugableResource;

public class NewSound
implements GaugableResource {
    private boolean muteFlag = false;
    public static final int NO_MUSIC_MODE = 0;
    public static final int MIDI_MUSIC_MODE = 1;
    public static final int TONE_MUSICE_MODE = 2;
    private int musicMode = 0;
    private TunePlayer normalBackgroundPlayer = null;
    private TunePlayer bonusBackgroundPlayer = null;
    private TunePlayer deathPlayer = null;
    private TunePlayer newLevelPlayer = null;
    private TunePlayer bonusPulseMidiPlayer = null;
    private final TunePlayer eatMonsterPlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.EAT_MONSTER_TUNE, 60);
    private final TunePlayer explodePlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.EXPLODE_TUNE, 60);
    private final TunePlayer moneyEatPlayer;
    private final NoteSeriallizer noteSerializer = NoteSeriallizer.getInstance();
    private int emeraldEatingCount = 0;
    private int volume = 100;
    private boolean pauseState = false;
    private boolean deathAtPause = false;
    private boolean normalMusicMode = false;
    private boolean bonusMusicMode = false;
    private boolean falling = false;
    private boolean firing = false;
    private boolean bonusPulsePlaying = false;
    private Thread bonusPulsePlayingThread = null;

    public NewSound() {
        this.setMusicMode(1);
        this.normalBackgroundPlayer.setPriority(0);
        this.bonusBackgroundPlayer.setPriority(1);
        this.newLevelPlayer.setPriority(9);
        this.deathPlayer.setPriority(10);
        byte[] moneySeq = new byte[20];
        int low = 62;
        int high = 92;
        int pos = 0;
        boolean toggle = true;
        while (low < high) {
            moneySeq[pos] = toggle ? low : high;
            moneySeq[pos + 1] = 1;
            pos += 2;
            if (toggle) {
                low = (byte)(low + 3);
            } else {
                high = (byte)(high - 3);
            }
            toggle = !toggle;
        }
        this.moneyEatPlayer = new NoteSequenceTunePlayer(moneySeq, 60);
        this.moneyEatPlayer.setPriority(3);
        this.eatMonsterPlayer.setPriority(3);
        this.explodePlayer.setPriority(3);
        this.setVolume(this.volume);
    }

    public void killAll() {
        this.normalBackgroundPlayer.stopPlaying();
        this.bonusBackgroundPlayer.stopPlaying();
        this.deathPlayer.stopPlaying();
        this.fallEnd();
        this.fireEnd();
        this.newLevelPlayer.stopPlaying();
        this.endBonusPulse();
    }

    public synchronized void changePauseState(boolean newPauseState) {
        if (newPauseState && !this.pauseState) {
            this.deathAtPause = this.deathPlayer.isPlaying();
            this.normalBackgroundPlayer.pausePlaying();
            this.bonusBackgroundPlayer.pausePlaying();
            this.deathPlayer.pausePlaying();
            this.fallEnd();
            this.fireEnd();
            this.newLevelPlayer.stopPlaying();
            this.endBonusPulse();
            this.pauseState = true;
        }
        if (!newPauseState && this.pauseState) {
            if (this.normalMusicMode) {
                this.startNormalBackgroundMusic();
            }
            if (this.bonusMusicMode) {
                this.startBonusBackgroundMusic();
            }
            if (this.deathAtPause) {
                this.playDeath();
            }
            this.pauseState = false;
        }
    }

    public void startNormalBackgroundMusic() {
        this.normalMusicMode = true;
        if (!this.muteFlag) {
            this.normalBackgroundPlayer.playInLoop();
        }
    }

    public void stopNormalBackgroundMusic() {
        this.normalMusicMode = false;
        if (!this.muteFlag) {
            this.normalBackgroundPlayer.stopPlaying();
        }
    }

    public void startBonusBackgroundMusic() {
        this.bonusMusicMode = true;
        if (!this.muteFlag) {
            this.bonusBackgroundPlayer.playInLoop();
        }
    }

    public void stopBonusBackgroundMusic() {
        this.bonusMusicMode = false;
        if (!this.muteFlag) {
            this.bonusBackgroundPlayer.stopPlaying();
        }
    }

    public void playDeath() {
        if (!this.muteFlag) {
            this.deathPlayer.playSingle();
        }
    }

    void playEatEmerald(boolean resetCount) {
        byte note;
        if (this.muteFlag || this.musicMode != 2) {
            return;
        }
        if (resetCount) {
            this.emeraldEatingCount = 1;
            note = DIGGER_SOUND_DATA.EMERALD_EAT_NOTES[0];
        } else {
            note = DIGGER_SOUND_DATA.EMERALD_EAT_NOTES[this.emeraldEatingCount];
            ++this.emeraldEatingCount;
            if (this.emeraldEatingCount == DIGGER_SOUND_DATA.EMERALD_EAT_NOTES.length) {
                this.emeraldEatingCount = 0;
            }
        }
        this.noteSerializer.playNote(note, 100, this.volume, 2);
    }

    public void playLooseLevel(int wt) {
        if (this.muteFlag || this.musicMode != 2) {
            return;
        }
        switch (wt) {
            case 15: {
                this.noteSerializer.playNote(62, 30, this.volume, 2);
                break;
            }
            case 11: {
                this.noteSerializer.playNote(58, 30, this.volume, 2);
                break;
            }
            case 7: {
                this.noteSerializer.playNote(55, 30, this.volume, 2);
                break;
            }
            case 3: {
                this.noteSerializer.playNote(58, 30, this.volume, 2);
            }
        }
    }

    public void playBagBreak() {
        if (!this.muteFlag && this.musicMode == 2) {
            this.noteSerializer.playNote(40, 70, this.volume, 2);
        }
    }

    public void playMoneyEat() {
        if (!this.muteFlag && this.musicMode == 2) {
            this.moneyEatPlayer.playSingle();
        }
    }

    public void playMonsterEat() {
        if (!this.muteFlag && this.musicMode == 2) {
            this.eatMonsterPlayer.playSingle();
        }
    }

    public synchronized void fallStart() {
        if (this.muteFlag || this.musicMode != 2) {
            return;
        }
        if (!this.falling) {
            this.falling = true;
            Thread fallingSoundThread = new Thread(){
                private int nextNote = 86;
                private boolean toggle = false;

                public void run() {
                    try {
                        while (NewSound.this.falling) {
                            int waitPeriod = NewSound.this.noteSerializer.playNote(this.nextNote, 30, NewSound.this.volume, 2);
                            if (waitPeriod == -1) {
                                waitPeriod = 30;
                            }
                            if (this.toggle) {
                                this.nextNote = Math.min(this.nextNote + 1, 93);
                            }
                            this.toggle = !this.toggle;
                            Thread.sleep(waitPeriod);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            fallingSoundThread.start();
        }
    }

    public synchronized void fallEnd() {
        this.falling = false;
    }

    public synchronized void fireStart() {
        if (this.muteFlag || this.musicMode != 2) {
            return;
        }
        if (!this.firing) {
            this.firing = true;
            Thread firingSoundThread = new Thread(){
                private int nextNote = 98;
                private boolean toggle = false;

                public void run() {
                    try {
                        while (NewSound.this.firing) {
                            int waitPeriod = NewSound.this.noteSerializer.playNote(this.nextNote + 1 - this.nextNote % 3, 30, NewSound.this.volume, 2);
                            if (waitPeriod == -1) {
                                waitPeriod = 30;
                            }
                            if (this.toggle) {
                                --this.nextNote;
                            }
                            if (this.nextNote >= 27) {
                                this.toggle = !this.toggle;
                                Thread.sleep(waitPeriod);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            firingSoundThread.start();
        }
    }

    public synchronized void fireEnd() {
        this.firing = false;
    }

    public void playExplode() {
        if (!this.muteFlag && this.musicMode == 2) {
            this.explodePlayer.playSingle();
        }
    }

    public void playNewLevel() {
        if (this.muteFlag) {
            return;
        }
        try {
            this.newLevelPlayer.playSingle();
            while (this.newLevelPlayer.isPlaying()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBonusPulse() {
        if (this.muteFlag) {
            return;
        }
        if (this.musicMode == 1) {
            this.bonusPulseMidiPlayer.playInLoop();
        }
        if (this.musicMode == 2) {
            if (this.bonusPulsePlayingThread == null) {
                this.bonusPulsePlaying = true;
                this.bonusPulsePlayingThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            while (true) {
                                boolean toggle = true;
                                while (NewSound.this.bonusPulsePlaying) {
                                    int waitPeriod = toggle ? NewSound.this.noteSerializer.playNote(83, 60, NewSound.this.volume, 3) : NewSound.this.noteSerializer.playNote(79, 60, NewSound.this.volume, 3);
                                    if (waitPeriod == -1) {
                                        waitPeriod = 60;
                                    }
                                    Thread.sleep(waitPeriod);
                                }
                                Thread thread = NewSound.this.bonusPulsePlayingThread;
                                synchronized (thread) {
                                    NewSound.this.bonusPulsePlayingThread.wait();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                };
                this.bonusPulsePlayingThread.start();
            } else if (!this.bonusPulsePlaying) {
                this.bonusPulsePlaying = true;
                Thread thread = this.bonusPulsePlayingThread;
                synchronized (thread) {
                    this.bonusPulsePlayingThread.notify();
                }
            }
        }
    }

    public void endBonusPulse() {
        this.bonusPulsePlaying = false;
        if (this.musicMode == 1) {
            this.bonusPulseMidiPlayer.stopPlaying();
        }
    }

    public void setMuteState(boolean mute) {
        if (mute) {
            this.killAll();
            this.muteFlag = true;
        } else {
            this.muteFlag = false;
        }
    }

    public boolean isMute() {
        return this.muteFlag;
    }

    public void setMusicMode(int newMusicMode) {
        if (this.musicMode == newMusicMode) {
            return;
        }
        if (this.musicMode != 0) {
            this.killAll();
            this.normalBackgroundPlayer.close();
            this.bonusBackgroundPlayer.close();
            this.deathPlayer.close();
            this.newLevelPlayer.close();
            this.bonusPulseMidiPlayer.close();
        }
        switch (newMusicMode) {
            case 2: {
                this.normalBackgroundPlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.NORMAL_BACKGROUND, 11);
                this.bonusBackgroundPlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.BONUS_BACKGROUND, 30);
                this.deathPlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.DIGGER_DEATH, 8);
                this.newLevelPlayer = new NoteSequenceTunePlayer(DIGGER_SOUND_DATA.NEW_LEVEL, 25);
                this.bonusPulseMidiPlayer = null;
                break;
            }
            case 1: {
                this.normalBackgroundPlayer = new ResourceTunePlayer("/audiofiles/popcorn.mid");
                this.bonusBackgroundPlayer = new ResourceTunePlayer("/audiofiles/williamtell.mid");
                this.deathPlayer = new ResourceTunePlayer("/audiofiles/funeral.mid");
                this.newLevelPlayer = new ResourceTunePlayer("/audiofiles/level.mid");
                this.bonusPulseMidiPlayer = new ResourceTunePlayer("/audiofiles/bonus_pulse.mid");
                this.bonusPulseMidiPlayer.setVolume(this.volume);
            }
        }
        this.normalBackgroundPlayer.setVolume(this.volume);
        this.bonusBackgroundPlayer.setVolume(this.volume);
        this.deathPlayer.setVolume(this.volume);
        this.newLevelPlayer.setVolume(this.volume);
        this.musicMode = newMusicMode;
    }

    public int getMusicMode() {
        return this.musicMode;
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.normalBackgroundPlayer.setVolume(volume);
        this.bonusBackgroundPlayer.setVolume(volume);
        this.newLevelPlayer.setVolume(volume);
        this.deathPlayer.setVolume(volume);
        this.moneyEatPlayer.setVolume(volume);
        this.eatMonsterPlayer.setVolume(volume);
        this.explodePlayer.setVolume(volume);
    }

    public int getGaugeValue() {
        return this.volume;
    }

    public void increaseVolume() {
        this.setVolume((this.volume + 10) % 100);
    }

    public void decreaseVolume() {
        this.setVolume(Math.max(this.volume, this.volume - 10));
    }

    private static class DIGGER_SOUND_DATA
    extends MusicNotes {
        static final byte[] NORMAL_BACKGROUND = new byte[]{62, 2, 60, 2, 62, 2, 57, 2, 53, 2, 57, 2, 50, 4, 62, 2, 60, 2, 62, 2, 57, 2, 53, 2, 57, 2, 50, 4, 62, 2, 64, 2, 65, 2, 64, 2, 65, 2, 62, 2, 64, 2, 62, 2, 64, 2, 60, 2, 62, 2, 60, 2, 62, 2, 58, 2, 62, 4, 62, 2, 60, 2, 62, 2, 57, 2, 53, 2, 57, 2, 50, 4, 62, 2, 60, 2, 62, 2, 57, 2, 53, 2, 57, 2, 50, 4, 62, 2, 64, 2, 65, 2, 64, 2, 65, 2, 62, 2, 64, 2, 62, 2, 64, 2, 60, 2, 62, 2, 60, 2, 62, 2, 64, 2, 65, 4, 69, 2, 67, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 67, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 71, 2, 72, 2, 71, 2, 72, 2, 69, 2, 71, 2, 69, 2, 71, 2, 67, 2, 69, 2, 67, 2, 69, 2, 65, 2, 69, 4, 69, 2, 67, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 67, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 71, 2, 72, 2, 71, 2, 72, 2, 69, 2, 71, 2, 69, 2, 71, 2, 67, 2, 69, 2, 67, 2, 69, 2, 65, 2, 69, 4, 74, 2, 72, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 67, 2, 69, 2, 65, 2, 60, 2, 65, 2, 57, 4, 69, 2, 71, 2, 72, 2, 71, 2, 72, 2, 69, 2, 71, 2, 69, 2, 71, 2, 67, 2, 69, 2, 67, 2, 65, 2, 67, 2, 69, 4};
        static final byte[] BONUS_BACKGROUND = new byte[]{60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 65, 4, 67, 4, 69, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 65, 2, 69, 2, 67, 4, 64, 4, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 65, 4, 67, 4, 69, 4, 65, 2, 69, 2, 72, 10, 70, 2, 69, 2, 67, 2, 65, 4, 69, 4, 65, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 65, 4, 67, 4, 69, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 65, 2, 69, 2, 67, 4, 64, 4, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 60, 4, 60, 2, 60, 2, 65, 4, 67, 4, 69, 4, 65, 2, 69, 2, 72, 10, 70, 2, 69, 2, 67, 2, 65, 4, 69, 4, 65, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 67, 4, 65, 4, 64, 4, 62, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 74, 4, 72, 4, 71, 4, 72, 4, 71, 4, 72, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 67, 4, 65, 4, 64, 4, 62, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 69, 2, 69, 2, 69, 4, 74, 4, 69, 4, 74, 4, 69, 4, 74, 4, 72, 4, 71, 4, 72, 4, 71, 4, 72, 4};
        static final byte[] DIGGER_DEATH = new byte[]{-1, 2, 60, 6, 60, 4, 60, 2, 60, 6, 63, 4, 62, 2, 62, 4, 60, 2, 60, 4, 59, 2, 60, 12};
        static final byte[] NEW_LEVEL = new byte[]{72, 1, 72, 1, 72, 1, 72, 1, 76, 1, 76, 1, 76, 1, 76, 1, 79, 1, 79, 1, 79, 1, 79, 1, 74, 1, 74, 1, 74, 1, 74, 1, 77, 1, 77, 1, 77, 1, 77, 1, 81, 1, 81, 1, 81, 1, 81, 1, 76, 1, 76, 1, 76, 1, 76, 1, 79, 1, 79, 1, 79, 1, 79, 1, 83, 1, 83, 1, 83, 1, 83, 1, 72, 1, 72, 1, 72, 1, 72, 1};
        static final String NORMAL_MIDI_FILE = "/audiofiles/popcorn.mid";
        static final String BONUS_MIDI_FILE = "/audiofiles/williamtell.mid";
        static final String DEATH_MIDI_FILE = "/audiofiles/funeral.mid";
        static final String NEW_LEVEL_MIDI_FILE = "/audiofiles/level.mid";
        static final String BONUS_PULSE_MIDI_FILE = "/audiofiles/bonus_pulse.mid";
        static final int TEMPO_NORMAL_BACKGROUND = 11;
        static final int TEMPO_BONUS_BACKGROUND = 30;
        static final int TEMPO_DIGGER_DEATH = 8;
        static final int TEMPO_NEW_LEVEL = 25;
        static final byte[] EMERALD_EAT_NOTES = new byte[]{74, 76, 77, 79, 81, 83, 84, 72};
        static final int EMERALD_NOTE_LENGTH = 100;
        static final byte BAG_BREAK_NOTE = 40;
        static final int BAG_BREAK_NOTE_LENGTH = 70;
        static final int MONEY_MIDI_LOW = 62;
        static final int MONEY_MIDI_HIGH = 92;
        static final int MONEY_JUMP = 3;
        static final byte MONEY_NOTE_LENGTH = 1;
        static final int MONEY_TEMPO = 60;
        static final byte[] EAT_MONSTER_TUNE = new byte[]{74, 1, 86, 1, 98, 1, 74, 1, 86, 1, 98, 1, 74, 1, 86, 1, 98, 1};
        static final int EAT_MONSTER_TEMPO = 60;
        static final byte[] EXPLODE_TUNE = new byte[]{79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1};
        static final int EXPLODE_TEMPO = 60;
        static final byte BONUS_NOTE_A = 83;
        static final byte BONUS_NOTE_B = 79;
        static final int BONUS_NOTE_LENGTH = 60;
        static final byte FALL_START_NOTE = 86;
        static final int FALL_NOTE_LENGTH = 30;
        static final int FALL_MAX_NOTE = 93;
        static final byte FIRE_START_NOTE = 98;
        static final int FIRE_NOTE_LENGTH = 30;
        static final int FIRE_MIN_NOTE = 27;
        static final int DEATH_PRIORITY = 10;
        static final int NEW_LEVEL_PRIORITY = 9;
        static final int NORMAL_BACKGROUND_PRIORITY = 0;
        static final int BONUS_BACKGROUND_PRIORITY = 1;
        static final int LOW_PRIORITY_EFFECTS = 2;
        static final int EFFECTS_PRIORITY = 3;

        private DIGGER_SOUND_DATA() {
        }
    }
}

