/*
 * Decompiled with CFR 0.152.
 */
package digger;

import digger.DiggerCanvas;
import digger.alpha;
import digger.cgagrafx1;
import digger.cgagrafx2;
import general.display.MemoryDisplayUpdater;

class Pc {
    DiggerCanvas dig;
    MemoryDisplayUpdater displayUpdater;
    int width = 320;
    int height = 200;
    int size = this.width * this.height;
    int[] pixels;
    int[][][] pal = new int[][][]{new int[][]{{0, 0, 170, 170}, {0, 170, 0, 84}, {0, 0, 0, 0}}, new int[][]{{0, 84, 255, 255}, {0, 255, 84, 255}, {0, 84, 84, 84}}};

    Pc(DiggerCanvas d) {
        this.dig = d;
    }

    void gclear() {
        for (int i = 0; i < this.size; ++i) {
            this.pixels[i] = 0;
        }
        this.displayUpdater.newPixels(true);
    }

    long gethrt() {
        return System.currentTimeMillis();
    }

    int getkips() {
        return 0;
    }

    void ggeti(int x, int y, short[] p, int w, int h) {
        int src = 0;
        int x0 = x & 0xFFFC;
        int dest = y * this.width + x0;
        for (int i = 0; i < h; ++i) {
            int d = dest;
            for (int j = 0; j < w; ++j) {
                p[src++] = (short)(((this.pixels[d] << 2 | this.pixels[d + 1]) << 2 | this.pixels[d + 2]) << 2 | this.pixels[d + 3]);
                d += 4;
                if (src == p.length) break;
            }
            if (src == p.length) break;
            dest += this.width;
        }
        int pw = Math.min(4 * w, this.width - x0);
        int ph = Math.min(h, this.height - y);
        if (ph > 0 & pw > 0) {
            this.displayUpdater.newPixels(false, x0, y, pw, ph);
        }
    }

    int ggetpix(int x, int y) {
        int x0 = x & 0xFFFC;
        int ofs = this.width * y + x0;
        int retVal = ((this.pixels[ofs] << 2 | this.pixels[ofs + 1]) << 2 | this.pixels[ofs + 2]) << 2 | this.pixels[ofs + 3];
        int pw = Math.min(4, this.width - x0);
        if (y < this.height && pw > 0) {
            this.displayUpdater.newPixels(false, x0, y, pw, 1);
        }
        return retVal;
    }

    void ginit() {
    }

    void ginten(int inten) {
        this.displayUpdater.switchPallete(inten);
    }

    void gpal(int pal) {
    }

    void gputi(int x, int y, short[] p, int w, int h) {
        this.gputi(x, y, p, w, h, true);
    }

    void gputi(int x, int y, short[] p, int w, int h, boolean b) {
        int src = 0;
        int x0 = x & 0xFFFC;
        int dest = y * this.width + x0;
        for (int i = 0; i < h; ++i) {
            int d = dest;
            for (int j = 0; j < w; ++j) {
                short px = p[src++];
                this.pixels[d + 3] = px & 3;
                px = (short)(px >> 2);
                this.pixels[d + 2] = px & 3;
                px = (short)(px >> 2);
                this.pixels[d + 1] = px & 3;
                px = (short)(px >> 2);
                this.pixels[d] = px & 3;
                d += 4;
                if (src == p.length) break;
            }
            if (src == p.length) break;
            dest += this.width;
        }
        int pw = Math.min(4 * w, this.width - x0);
        int ph = Math.min(h, this.height - y);
        if (pw > 0 && ph > 0) {
            this.displayUpdater.newPixels(false, x0, y, pw, ph);
        }
    }

    void gputim(int x, int y, int ch, int w, int h) {
        short[] spr = cgagrafx1.cgatable[ch * 2];
        short[] msk = cgagrafx1.cgatable[ch * 2 + 1];
        int src = 0;
        int x0 = x & 0xFFFC;
        int dest = y * this.width + x0;
        for (int i = 0; i < h; ++i) {
            int d = dest;
            for (int j = 0; j < w; ++j) {
                short px = spr[src];
                short mx = msk[src];
                ++src;
                if ((mx & 3) == 0) {
                    this.pixels[d + 3] = px & 3;
                }
                px = (short)(px >> 2);
                if ((mx & 0xC) == 0) {
                    this.pixels[d + 2] = px & 3;
                }
                px = (short)(px >> 2);
                if ((mx & 0x30) == 0) {
                    this.pixels[d + 1] = px & 3;
                }
                px = (short)(px >> 2);
                if ((mx & 0xC0) == 0) {
                    this.pixels[d] = px & 3;
                }
                d += 4;
                if (src == spr.length || src == msk.length) break;
            }
            if (src == spr.length || src == msk.length) break;
            dest += this.width;
        }
        int pw = Math.min(4 * w, this.width - x0);
        int ph = Math.min(h, this.height - y);
        if (pw > 0 && ph > 0) {
            this.displayUpdater.newPixels(false, x0, y, pw, ph);
        }
    }

    void gtitle() {
        int src = 0;
        int dest = 0;
        boolean plus = false;
        while (src < cgagrafx2.cgatitledat.length) {
            int c;
            int l;
            int b;
            if ((b = cgagrafx2.cgatitledat[src++]) == 254) {
                if ((l = cgagrafx2.cgatitledat[src++]) == 0) {
                    l = 256;
                }
                c = cgagrafx2.cgatitledat[src++];
            } else {
                l = 1;
                c = b;
            }
            for (int i = 0; i < l; ++i) {
                int px = c;
                int adst = 0;
                adst = dest < 32768 ? dest / 320 * 640 + dest % 320 : 320 + (dest - 32768) / 320 * 640 + (dest - 32768) % 320;
                this.pixels[adst + 3] = px & 3;
                this.pixels[adst + 2] = (px >>= 2) & 3;
                this.pixels[adst + 1] = (px >>= 2) & 3;
                this.pixels[adst + 0] = (px >>= 2) & 3;
                if ((dest += 4) >= 65535) break;
            }
            if (dest < 65535) continue;
            break;
        }
        this.displayUpdater.newPixels(false);
    }

    void gwrite(int x, int y, int ch, int c) {
        this.gwrite(x, y, ch, c, true);
    }

    void gwrite(int x, int y, int ch, int c, boolean upd) {
        int dest = x + y * this.width;
        int ofs = 0;
        int color = c & 3;
        if ((ch -= 32) < 0 || ch > 95) {
            return;
        }
        short[] chartab = alpha.ascii2cga[ch];
        if (chartab == null) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            int d = dest;
            for (int j = 0; j < 3; ++j) {
                int px = chartab[ofs++];
                this.pixels[d + 3] = px & color;
                this.pixels[d + 2] = (px >>= 2) & color;
                this.pixels[d + 1] = (px >>= 2) & color;
                this.pixels[d] = (px >>= 2) & color;
                d += 4;
            }
            dest += this.width;
        }
        if (upd) {
            this.displayUpdater.newPixels(true, x, y, 12, 12);
        }
    }
}

