/*
 * Decompiled with CFR 0.152.
 */
package digger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class ScoreStorage {
    private static String FILE_NAME = "digger.scores";

    private static byte[] scoresAsBytes(String[] names, long[] scores) throws IOException {
        int i;
        int size = 162;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(size);
        DataOutputStream out = new DataOutputStream(byteStream);
        for (i = 0; i < 11; ++i) {
            out.writeChar(names[i].charAt(0));
            out.writeChar(names[i].charAt(1));
            out.writeChar(names[i].charAt(2));
        }
        for (i = 0; i < 12; ++i) {
            out.writeLong(scores[i]);
        }
        return byteStream.toByteArray();
    }

    public static boolean readFromStorage(String[] names, long[] scores) {
        try {
            int i;
            RecordStore store = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
            RecordEnumeration en = store.enumerateRecords(null, null, false);
            byte[] data = store.getRecord(en.nextRecordId());
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            DataInputStream in = new DataInputStream(byteStream);
            for (i = 0; i < 11; ++i) {
                char[] name = new char[]{'.', '.', '.'};
                name[0] = in.readChar();
                name[1] = in.readChar();
                name[2] = in.readChar();
                names[i] = new String(name);
            }
            for (i = 0; i < 12; ++i) {
                scores[i] = in.readLong();
            }
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void writeToStorage(String[] names, long[] scores) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
            RecordEnumeration en = store.enumerateRecords(null, null, false);
            store.deleteRecord(en.nextRecordId());
            byte[] data = ScoreStorage.scoresAsBytes(names, scores);
            store.addRecord(data, 0, data.length);
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createInStorage(String[] names, long[] scores) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
            byte[] data = ScoreStorage.scoresAsBytes(names, scores);
            store.addRecord(data, 0, data.length);
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean scoreStorageExists() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
            store.closeRecordStore();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

