/*
 * Decompiled with CFR 0.152.
 */
package general.sound;

import general.sound.TunePlayer;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class ResourceTunePlayer
implements TunePlayer {
    private static final int MINIMUM_TIME_BETWEEN_PLAY = 250;
    private static long lastTimePlayerActivated = 0L;
    private static ResourceTunePlayer activePlayer = null;
    private final Player player;
    private int volume;
    private boolean nonZeroPosition = false;

    private static String findType(String fileName) {
        String type;
        if (fileName.endsWith("wav")) {
            type = "audio/x-wav";
        } else if (fileName.endsWith("jts")) {
            type = "audio/x-tone-seq";
        } else if (fileName.endsWith("mid")) {
            type = "audio/midi";
        } else {
            throw new RuntimeException("Don't know the type of " + fileName);
        }
        return type;
    }

    public ResourceTunePlayer(String fileName) {
        this(fileName, -1);
    }

    public ResourceTunePlayer(String fileName, int volume) {
        Player builtPlayer = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            String type = ResourceTunePlayer.findType(fileName);
            builtPlayer = Manager.createPlayer((InputStream)is, (String)type);
            builtPlayer.realize();
        }
        catch (MediaException e) {
            builtPlayer = null;
        }
        catch (IOException e) {
            builtPlayer = null;
        }
        this.player = builtPlayer;
        this.volume = volume;
    }

    public void playInLoop() {
        if (this.isPlaying()) {
            return;
        }
        try {
            this.prepareToPlay();
            this.player.setLoopCount(-1);
            this.nonZeroPosition = true;
            this.player.start();
        }
        catch (InterruptedException ex) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playSingle() {
        if (this.isPlaying()) {
            return;
        }
        try {
            this.prepareToPlay();
            this.player.setLoopCount(1);
            this.nonZeroPosition = true;
            this.player.start();
        }
        catch (InterruptedException ex) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stopPlaying() {
        try {
            if (this.isPlaying()) {
                this.player.stop();
            }
            this.rewind();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void pausePlaying() {
        try {
            if (!this.isPlaying()) {
                return;
            }
            this.player.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void rewind() {
        try {
            if (this.nonZeroPosition) {
                this.player.setMediaTime(0L);
            }
            this.nonZeroPosition = false;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setPriority(int priority) {
    }

    public boolean isPlaying() {
        return this.player.getState() == 400;
    }

    public void close() {
        this.player.close();
    }

    public boolean isClosed() {
        return this.player.getState() == 0;
    }

    private void activate() throws InterruptedException, MediaException {
        if (activePlayer == this) {
            return;
        }
        if (activePlayer != null && !activePlayer.isClosed()) {
            activePlayer.deactivate();
            if (System.currentTimeMillis() - lastTimePlayerActivated < 250L) {
                Thread.sleep(lastTimePlayerActivated + 250L - System.currentTimeMillis());
            }
        }
        activePlayer = this;
        lastTimePlayerActivated = System.currentTimeMillis();
        this.player.prefetch();
    }

    private void deactivate() throws MediaException {
        if (this.isPlaying()) {
            throw new RuntimeException("Cannot deactivate a playing resource tune player.");
        }
        this.player.deallocate();
        this.player.realize();
    }

    private void setupVolume() {
        if (this.volume != -1) {
            VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            volumeControl.setLevel(this.volume);
        }
    }

    private void prepareToPlay() throws InterruptedException, MediaException {
        this.activate();
        this.setupVolume();
    }
}

