/*
 * Decompiled with CFR 0.152.
 */
package general.ui;

import general.ui.MenuEvent;
import general.ui.MenuItem;
import general.ui.MenuListener;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuScreen {
    private String title = null;
    private final MenuScreenCanvas canvas = new MenuScreenCanvas();
    private Displayable oldDisplayable;
    private Display display;
    private boolean isOpen;
    private final int itemsNumber;
    private final MenuItem[] items;
    private MenuListener menuListener;
    private int backgroundColor;
    private int menuBackgroundColor;
    private int menuBackgroundOpacity;
    private int itemsColor;
    private int selectionColor;
    private int titleColor;
    private Image backgroundImage = null;

    public MenuScreen(int itemsNumber) {
        this.setBackgroundColor(0, 0, 0);
        this.setMenuBackgroundColor(0, 0, 0);
        this.setItemsColor(255, 255, 255);
        this.setSelectionColor(255, 0, 0);
        this.setTitleColor(0, 0, 255);
        this.itemsNumber = itemsNumber;
        this.items = new MenuItem[itemsNumber];
        this.isOpen = false;
    }

    public void open(Display display) {
        this.isOpen = true;
        this.canvas.setCurrentSelection(0);
        this.display = display;
        this.oldDisplayable = display.getCurrent();
        display.setCurrent((Displayable)this.canvas);
    }

    public void close() {
        if (this.isOpen) {
            this.display.setCurrent(this.oldDisplayable);
            this.isOpen = false;
        }
    }

    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public void setMenuItem(int itemNumber, MenuItem menuItem) {
        if (itemNumber >= this.itemsNumber) {
            throw new IllegalArgumentException("Invalid item number.");
        }
        this.items[itemNumber] = menuItem;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBackgroundColor(int red, int green, int blue) {
        this.backgroundColor = blue + (green << 8) + (red << 16);
    }

    public void setItemsColor(int red, int green, int blue) {
        this.itemsColor = blue + (green << 8) + (red << 16);
    }

    public void setSelectionColor(int red, int green, int blue) {
        this.selectionColor = blue + (green << 8) + (red << 16);
    }

    public void setTitleColor(int red, int green, int blue) {
        this.titleColor = blue + (green << 8) + (red << 16);
    }

    public void setMenuBackgroundColor(int red, int green, int blue) {
        this.setMenuBackgroundColor(red, green, blue, 254);
        this.menuBackgroundColor = blue + (green << 8) + (red << 16);
    }

    public void setMenuBackgroundColor(int red, int green, int blue, int opacity) {
        this.menuBackgroundOpacity = opacity;
        this.menuBackgroundColor = blue + (green << 8) + (red << 16);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    private class MenuScreenCanvas
    extends Canvas {
        private int currentSelection;

        public MenuScreenCanvas() {
            this.setFullScreenMode(true);
            this.currentSelection = 0;
        }

        protected void paint(Graphics graphics) {
            graphics.setColor(MenuScreen.this.backgroundColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (MenuScreen.this.backgroundImage != null) {
                graphics.drawImage(MenuScreen.this.backgroundImage, 0, 0, 0);
            }
            Font font = graphics.getFont();
            int boxWidth = Math.max(MenuScreen.this.title != null ? font.stringWidth(MenuScreen.this.title) : 0, this.getWidth() * 2 / 3);
            for (int i = 0; i < MenuScreen.this.itemsNumber; ++i) {
                if (MenuScreen.this.items[i] == null) continue;
                boxWidth = Math.max(boxWidth, MenuScreen.this.items[i].getWidth(graphics));
            }
            int lineHeight = font.getHeight();
            int boxHeight = lineHeight * MenuScreen.this.itemsNumber + 4 * lineHeight / 10;
            if (MenuScreen.this.title != null) {
                boxHeight += lineHeight;
            }
            if (boxWidth > this.getWidth()) {
                throw new RuntimeException("Text in menu too long!");
            }
            if (boxHeight > this.getHeight()) {
                throw new RuntimeException("Too many menu options to fit in screen!");
            }
            int[] rgbData = new int[boxWidth * boxHeight];
            int i = 0;
            while (i < boxWidth * boxHeight) {
                int n = i++;
                rgbData[n] = rgbData[n] + (MenuScreen.this.menuBackgroundColor + (MenuScreen.this.menuBackgroundOpacity << 24));
            }
            Image boxmenuImage = Image.createRGBImage((int[])rgbData, (int)boxWidth, (int)boxHeight, (boolean)true);
            graphics.drawImage(boxmenuImage, this.getWidth() / 2, (this.getHeight() - boxHeight) / 2, 17);
            int heightOffset = (this.getHeight() - boxHeight) / 2 + 2 * lineHeight / 10;
            if (MenuScreen.this.title != null) {
                graphics.setColor(MenuScreen.this.titleColor);
                graphics.drawString(MenuScreen.this.title, this.getWidth() / 2, heightOffset, 17);
                heightOffset += lineHeight;
            }
            for (int i2 = 0; i2 < MenuScreen.this.itemsNumber; ++i2) {
                if (MenuScreen.this.items[i2] == null) continue;
                if (i2 == this.currentSelection) {
                    graphics.setColor(MenuScreen.this.selectionColor);
                } else {
                    graphics.setColor(MenuScreen.this.itemsColor);
                }
                MenuScreen.this.items[i2].draw(graphics, this.getWidth() / 2, heightOffset);
                heightOffset += lineHeight;
            }
        }

        protected void keyPressed(int key) {
            try {
                switch (this.getGameAction(key)) {
                    case 6: {
                        do {
                            this.currentSelection = (this.currentSelection + 1) % MenuScreen.this.itemsNumber;
                        } while (MenuScreen.this.items[this.currentSelection] == null);
                        this.repaint();
                        break;
                    }
                    case 1: {
                        do {
                            --this.currentSelection;
                            if (this.currentSelection != -1) continue;
                            this.currentSelection = MenuScreen.this.itemsNumber - 1;
                        } while (MenuScreen.this.items[this.currentSelection] == null);
                        this.repaint();
                        break;
                    }
                    case 8: {
                        MenuScreen.this.menuListener.onMenuEvent(MenuScreen.this.items[this.currentSelection], MenuEvent.SELECT_EVENT, MenuScreen.this.oldDisplayable);
                        if (!MenuScreen.this.isOpen()) break;
                        this.repaint();
                        break;
                    }
                    case 5: {
                        MenuScreen.this.menuListener.onMenuEvent(MenuScreen.this.items[this.currentSelection], MenuEvent.RIGHT_EVENT, MenuScreen.this.oldDisplayable);
                        if (!MenuScreen.this.isOpen()) break;
                        this.repaint();
                        break;
                    }
                    case 2: {
                        MenuScreen.this.menuListener.onMenuEvent(MenuScreen.this.items[this.currentSelection], MenuEvent.LEFT_EVENT, MenuScreen.this.oldDisplayable);
                        if (!MenuScreen.this.isOpen()) break;
                        this.repaint();
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void setCurrentSelection(int newSelection) {
            this.currentSelection = newSelection;
        }
    }
}

