/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import overthehill.dustdigger.Bresenham;

public final class StarWay3D {
    private Graphics m_Gfx;
    private Bresenham m_Bresenham;
    private OneStar[] m_StarField;
    private int m_StarCount;
    private int m_MidX;
    private int m_MidY;
    private int m_MaxLen;
    private int m_MaxX;
    private int m_MaxY;
    private boolean m_ColoredDisp;

    public StarWay3D(int cnt, int cx, int cy, boolean bColored) {
        this.m_MaxX = cx;
        this.m_MaxY = cy;
        this.m_MidX = cx >> 1;
        this.m_MidY = cy >> 1;
        this.m_ColoredDisp = bColored;
        this.m_MaxLen = (this.m_MidX < this.m_MidY ? this.m_MidX : this.m_MidY) >> 4;
        this.m_StarCount = cnt;
        this.m_StarField = new OneStar[this.m_StarCount];
        Random RndGenerator = new Random();
        RndGenerator.setSeed(180576L);
        for (int i = 0; i < this.m_StarCount; ++i) {
            this.m_StarField[i] = new OneStar();
            this.m_StarField[i].x = Math.abs(RndGenerator.nextInt()) % cx - this.m_MidX;
            this.m_StarField[i].y = Math.abs(RndGenerator.nextInt()) % cy - this.m_MidY;
            this.m_StarField[i].z = (Math.abs(RndGenerator.nextInt()) & 0xFF) + 64;
        }
        this.m_Bresenham = new Bresenham();
    }

    public final void Paint(Graphics gfx) {
        this.m_Gfx = gfx;
        for (int i = 0; i < this.m_StarCount; ++i) {
            this.m_StarField[i].z += 8;
            if (this.m_StarField[i].z > 512) {
                this.m_StarField[i].z = 64;
            }
            this.m_StarField[i].Draw_Star();
        }
    }

    private final class OneStar {
        int x = 0;
        int y = 0;
        int z = 1;

        private final void Draw_Star() {
            int cl;
            int ax = (this.x * this.z >> 7) + StarWay3D.this.m_MidX;
            int ay = (this.y * this.z >> 7) + StarWay3D.this.m_MidY;
            int az = this.z - 96 >> 2;
            int n = cl = StarWay3D.this.m_ColoredDisp ? this.z : 255;
            if (cl > 255) {
                cl = 255;
            }
            if (ax < 0 || ax > StarWay3D.this.m_MaxX || ay < 0 || ay > StarWay3D.this.m_MaxY) {
                this.z = 64;
            }
            if (az > 0) {
                int cnt;
                if (az > StarWay3D.this.m_MaxLen) {
                    az = StarWay3D.this.m_MaxLen;
                }
                if ((cnt = StarWay3D.this.m_Bresenham.Prepaire_Line(ax, ay, StarWay3D.this.m_MidX, StarWay3D.this.m_MidY)) < az) {
                    az = cnt;
                }
                while (az-- > 0) {
                    StarWay3D.this.m_Bresenham.Calc_Next_Point();
                    StarWay3D.this.m_Gfx.setColor(cl << 16 | cl << 8 | cl);
                    ax = StarWay3D.this.m_Bresenham.Get_X();
                    ay = StarWay3D.this.m_Bresenham.Get_Y();
                    StarWay3D.this.m_Gfx.drawLine(ax, ay, ax, ay);
                    if ((cl -= 32) >= 16) continue;
                    cl = 16;
                }
            } else {
                StarWay3D.this.m_Gfx.setColor(cl << 16 | cl << 8 | cl);
                StarWay3D.this.m_Gfx.drawLine(ax, ay, ax, ay);
            }
        }
    }
}

