/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import java.util.Random;
import javax.microedition.lcdui.Graphics;

public final class DungeonBeam {
    private OneStar[] StarField;
    private int StarCount;
    private int FieldWidth;
    private int FieldHeight;
    private int MidX;
    private int MidY;
    private Graphics GfxObj;
    private Random RndGenerator;

    public DungeonBeam(int cnt, int cx, int cy) {
        this.FieldWidth = cx;
        this.FieldHeight = cy;
        this.MidX = cx >> 1;
        this.MidY = cy >> 1;
        this.StarCount = cnt;
        this.StarField = new OneStar[this.StarCount];
        this.RndGenerator = new Random();
        for (int i = 0; i < this.StarCount; ++i) {
            this.StarField[i] = new OneStar();
        }
        this.InitStars();
    }

    public final void InitStars() {
        this.RndGenerator.setSeed(180576L);
        for (int i = 0; i < this.StarCount; ++i) {
            do {
                this.StarField[i].x = Math.abs(this.RndGenerator.nextInt()) % this.FieldWidth - this.MidX;
                this.StarField[i].y = Math.abs(this.RndGenerator.nextInt()) % this.FieldHeight - this.MidY;
                this.StarField[i].z = 64 + (Math.abs(this.RndGenerator.nextInt()) & 0x3F);
            } while (Math.abs(this.StarField[i].x) < 8 && Math.abs(this.StarField[i].y) < 8);
        }
    }

    public final void Paint(Graphics gfx) {
        this.GfxObj = gfx;
        for (int i = 0; i < this.StarCount; ++i) {
            int zs = this.StarField[i].z;
            if ((zs -= 6) < 1) {
                zs = 127;
            }
            this.StarField[i].z = zs;
            this.StarField[i].Draw();
        }
    }

    private final class OneStar {
        int x = 0;
        int y = 0;
        int z = 1;

        public final void Draw() {
            int ax = (this.x << 7) / this.z + DungeonBeam.this.MidX;
            int ay = (this.y << 7) / this.z + DungeonBeam.this.MidY;
            int az = (128 - this.z) / 12;
            int cl = 64 + ((127 - this.z) * 3 >> 1);
            DungeonBeam.this.GfxObj.setColor(255, cl >> 2, cl >> 1);
            if (az > 0) {
                DungeonBeam.this.GfxObj.drawLine(ax, ay - az, ax, ay + az);
                DungeonBeam.this.GfxObj.drawLine(ax - az, ay, ax + az, ay);
                if (az > 4) {
                    DungeonBeam.this.GfxObj.drawLine(ax - az, ay - az, ax + az, ay + az);
                    DungeonBeam.this.GfxObj.drawLine(ax + az, ay - az, ax - az, ay + az);
                }
            } else {
                DungeonBeam.this.GfxObj.drawLine(ax, ay, ax, ay);
            }
        }
    }
}

