/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonItems;
import overthehill.madmaze.Moveable;

public final class DungeonFlash
extends DungeonCube
implements Moveable {
    int AnimIndex = 0;
    int AnimRand = 0;
    static final int[] ArcAnim = new int[]{2, -32, -3, -10, 27, -10, 22, -4, -15, 28, -10, 4, 8, -4, 16, -2, -18, -20, 9, -12, 24, -13, -4, -10, -4, 8, -12, 9, -17, 28, -19, 29};
    static final int[] ArcRand = new int[]{0, 24, 13, 9, 10, 3, 7, 11, 14, 21, 6, 15, 1, 8, 5, 12, 2, 28, 17, 21, 29, 23, 27, 12, 8, 26, 4, 19, 2, 16, 22, 28, 29};

    void PaintFront(int lftcube, int rgtcube) {
        int ox = this.WallWidth >> 2;
        int cx = this.LeftPos + ox + (ox >> 1);
        int oy = this.WallHeight >> 2;
        int cy = this.TopPos + oy + (oy >> 1);
        DungeonItems.Paint_Small_Mode_D(this.GfxObj, DungeonItems.ItemStar, cx, cy, ox, oy, this.ShapeBrightness >> 1);
        int i = (this.ShapeBrightness + ArcAnim[this.AnimIndex]) * 3 >> 1;
        if (i > 255) {
            i = 255;
        }
        int col1 = i << 16;
        int col2 = col1 + (i << 8);
        int lpos = this.LeftPos + (this.WallWidth >> 1);
        int len = ArcAnim.length;
        int hg = (this.WallHeight + (len - 1)) / len;
        ox = lpos;
        oy = this.TopPos;
        int cz = 1 + (this.MaxVisible + this.yp << 1);
        int twidth = (this.AnimIndex & 1) == 1 ? this.WallWidth : -this.WallWidth;
        i = 1;
        int k = this.AnimIndex + 1;
        while (i < len) {
            if (k >= len) {
                k = 0;
            }
            int anim = ArcAnim[k];
            cy = oy + hg;
            int vzoom = twidth * anim >> 6;
            this.GfxObj.setColor(col1);
            if ((k & 7) == 0) {
                cx = lpos + vzoom;
                this.GfxObj.drawLine(cx, cy - cz, cx, cy + cz);
                this.GfxObj.drawLine(cx - cz, cy, cx + cz, cy);
                if (cz > 4) {
                    this.GfxObj.drawLine(cx - cz, cy - cz, cx + cz, cy + cz);
                    this.GfxObj.drawLine(cx + cz, cy - cz, cx - cz, cy + cz);
                }
            }
            cx = lpos + (vzoom >> 1);
            this.GfxObj.drawLine(ox + 1, oy, cx + 1, cy);
            this.GfxObj.drawLine(ox - 1, oy, cx - 1, cy);
            this.GfxObj.setColor(col2);
            this.GfxObj.drawLine(ox, oy, cx, cy);
            ox = cx;
            oy = cy;
            ++i;
            ++k;
        }
    }

    void PaintWallLeft() {
        int lpos = this.LeftPos;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = this.WallHeight;
        int cy = theight / 3;
        lpos -= twidth >> 1;
        tpos = DungeonCube.Height - theight >> 1;
        int bpos = tpos + (theight - cy >> 1);
        twidth = twidth * 40 / 100;
        DungeonItems.Paint_Small_Mode_D(this.GfxObj, DungeonItems.ItemStar, lpos, bpos, twidth, cy, this.ShapeBrightness - 90);
        int i = (this.ShapeBrightness + ArcAnim[this.AnimIndex]) * 3 >> 1;
        if (i > 255) {
            i = 255;
        }
        int col1 = i << 16;
        int col2 = col1 + (i << 8);
        int len = ArcAnim.length;
        int hg = (theight + (len - 1)) / len;
        int ox = lpos += twidth >> 1;
        int oy = tpos;
        int cz = this.MaxVisible + this.yp << 1;
        twidth = (this.AnimIndex & 1) == 1 ? twidth : -twidth;
        i = 1;
        int k = this.AnimIndex + 1;
        while (i < len) {
            int cx;
            if (k >= len) {
                k = 0;
            }
            int anim = ArcAnim[k];
            cy = oy + hg;
            vzoom = twidth * anim >> 4;
            this.GfxObj.setColor(col1);
            if ((k & 7) == 0) {
                cx = lpos + vzoom;
                this.GfxObj.drawLine(cx, cy - cz, cx, cy + cz);
                this.GfxObj.drawLine(cx - cz, cy, cx + cz, cy);
                if (cz > 4) {
                    this.GfxObj.drawLine(cx - cz, cy - cz, cx + cz, cy + cz);
                    this.GfxObj.drawLine(cx + cz, cy - cz, cx - cz, cy + cz);
                }
            }
            cx = lpos + (vzoom >> 1);
            this.GfxObj.drawLine(ox + 1, oy, cx + 1, cy);
            this.GfxObj.drawLine(ox - 1, oy, cx - 1, cy);
            this.GfxObj.setColor(col2);
            this.GfxObj.drawLine(ox, oy, cx, cy);
            ox = cx;
            oy = cy;
            ++i;
            ++k;
        }
    }

    void PaintWallRight() {
        int lpos = this.LeftPos + this.WallWidth;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = this.WallHeight;
        int cy = theight / 3;
        tpos = DungeonCube.Height - theight >> 1;
        int bpos = tpos + (theight - cy >> 1);
        twidth = twidth * 40 / 100;
        DungeonItems.Paint_Small_Mode_D(this.GfxObj, DungeonItems.ItemStar, lpos, bpos, twidth, cy, this.ShapeBrightness - 90);
        int i = (this.ShapeBrightness + ArcAnim[this.AnimIndex]) * 3 >> 1;
        if (i > 255) {
            i = 255;
        }
        int col1 = i << 16;
        int col2 = col1 + (i << 8);
        int len = ArcAnim.length;
        int hg = (theight + (len - 1)) / len;
        int ox = lpos += twidth >> 1;
        int oy = tpos;
        int cz = this.MaxVisible + this.yp << 1;
        twidth = (this.AnimIndex & 1) == 1 ? twidth : -twidth;
        i = 1;
        int k = this.AnimIndex + 1;
        while (i < len) {
            int cx;
            if (k >= len) {
                k = 0;
            }
            int anim = ArcAnim[k];
            cy = oy + hg;
            vzoom = twidth * anim >> 4;
            this.GfxObj.setColor(col1);
            if ((k & 7) == 0) {
                cx = lpos + vzoom;
                this.GfxObj.drawLine(cx, cy - cz, cx, cy + cz);
                this.GfxObj.drawLine(cx - cz, cy, cx + cz, cy);
                if (cz > 4) {
                    this.GfxObj.drawLine(cx - cz, cy - cz, cx + cz, cy + cz);
                    this.GfxObj.drawLine(cx + cz, cy - cz, cx - cz, cy + cz);
                }
            }
            cx = lpos + (vzoom >> 1);
            this.GfxObj.drawLine(ox + 1, oy, cx + 1, cy);
            this.GfxObj.drawLine(ox - 1, oy, cx - 1, cy);
            this.GfxObj.setColor(col2);
            this.GfxObj.drawLine(ox, oy, cx, cy);
            ox = cx;
            oy = cy;
            ++i;
            ++k;
        }
    }

    final void AnimateObj() {
        if (++this.AnimRand >= ArcRand.length) {
            this.AnimRand = 0;
        }
        this.AnimIndex = ArcRand[this.AnimRand];
    }

    static final boolean MoveThroughPlayfield(char[] Playfield, int PlayerOffset, int AbsLevelCols, int AbsLevelRows) {
        return Moveable.MovableObj.MoveMovableObjects(Playfield, PlayerOffset, AbsLevelCols, AbsLevelRows, 167);
    }

    final void FindFlashObjects(char[] Playfield, int AbsLevelCols, int AbsLevelRows) {
        Moveable.MovableObj.FindMovableObjects(Playfield, AbsLevelCols, AbsLevelRows, 167);
    }
}

