/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import javax.microedition.lcdui.Graphics;
import overthehill.madmaze.DungeonItems;

public abstract class DungeonCube {
    static int Width;
    static int Height;
    static int[] CubeItem;
    int xp;
    int yp;
    int WallWidth;
    int WallHeight;
    int LeftPos;
    int TopPos;
    int MaxVisible = 3;
    int ShapeRed = 120;
    int ShapeGreen = 115;
    int ShapeBlue = 220;
    int FloorRed = 256;
    int FloorGreen = 184;
    int FloorBlue = 160;
    int ShapeBrightness;
    int FrameBrigthness;
    int ShapeColor;
    int FrameColor;
    public static int Perspective;
    public static int ViewThrought;
    Graphics GfxObj;

    DungeonCube() {
        Perspective = 37;
        ViewThrought = 29;
    }

    public static void SetDimension(int iWidth, int iHeight, boolean ColoredDisp) {
        Width = iWidth;
        Height = iHeight;
        CubeItem = ColoredDisp ? DungeonItems.ItemWallColored : DungeonItems.ItemWallGrayScale;
    }

    public void SetPosition(int x, int y) {
        this.xp = x;
        this.yp = y;
        int vzoom = this.yp * Perspective;
        int pfactor = 100 - (this.yp + 1) * ViewThrought;
        this.WallWidth = Width + Width * vzoom / pfactor;
        this.WallHeight = Height + Height * vzoom / pfactor;
        this.LeftPos = (Width - this.WallWidth * this.MaxVisible >> 1) + (this.xp + 1) * this.WallWidth;
        this.TopPos = Height - this.WallHeight >> 1;
        this.ShapeBrightness = 256 + 235 * vzoom / pfactor - 1;
        if (this.ShapeBrightness > 255) {
            this.ShapeBrightness = 255;
        }
        this.FrameBrigthness = this.ShapeBrightness * 51 >> 7;
        if (this.FrameBrigthness > 255) {
            this.FrameBrigthness = 255;
        }
        this.ShapeColor = this.ShapeRed * this.ShapeBrightness << 8 & 0xFF0000 | this.ShapeGreen * this.ShapeBrightness & 0xFF00 | this.ShapeBlue * this.ShapeBrightness >> 8;
        this.FrameColor = this.ShapeRed * this.FrameBrigthness << 8 & 0xFF0000 | this.ShapeGreen * this.FrameBrigthness & 0xFF00 | this.ShapeBlue * this.FrameBrigthness >> 8;
    }

    final void SetGfx(Graphics gfx) {
        this.GfxObj = gfx;
    }

    abstract void PaintFront(int var1, int var2);

    abstract void PaintWallLeft();

    abstract void PaintWallRight();

    final void PaintFloor(int y) {
        int scl1 = 290;
        int scl2 = 175;
        int i = y * Perspective;
        int k = i - Perspective;
        int pfactor1 = 100 - (y + 1) * ViewThrought;
        int theight1 = Height + Height * i / pfactor1;
        int pfactor2 = pfactor1 + ViewThrought;
        int theight2 = Height + Height * k / pfactor2;
        int tpos = theight1 + (Height - theight1 >> 1);
        int bpos = theight2 + (Height - theight2 >> 1);
        int ypos = tpos - bpos;
        int bheight = ypos >> 1;
        int blk = ypos >> 2;
        k = (y - 1) * scl2;
        int frstbr = scl1 + k / this.MaxVisible;
        int nxtbr = frstbr - (frstbr - (scl1 + (k - scl2) / this.MaxVisible) + 1 >> 1);
        i = frstbr + (k = frstbr - nxtbr >> 1);
        if (i < 8) {
            i = 8;
        }
        this.GfxObj.setColor(this.FloorRed * i >> 8, this.FloorGreen * i >> 8, this.FloorBlue * i >> 8);
        this.GfxObj.fillRect(0, bpos + bheight + blk, Width, ypos - bheight - blk);
        i = frstbr;
        if (i < 8) {
            i = 8;
        }
        this.GfxObj.setColor(this.FloorRed * i >> 8, this.FloorGreen * i >> 8, this.FloorBlue * i >> 8);
        this.GfxObj.fillRect(0, bpos + bheight, Width, blk);
        i = nxtbr + k;
        if (i < 8) {
            i = 8;
        }
        this.GfxObj.setColor(this.FloorRed * i >> 8, this.FloorGreen * i >> 8, this.FloorBlue * i >> 8);
        this.GfxObj.fillRect(0, bpos + blk, Width, bheight - blk);
        i = nxtbr;
        if (i < 8) {
            i = 8;
        }
        this.GfxObj.setColor(this.FloorRed * i >> 8, this.FloorGreen * i >> 8, this.FloorBlue * i >> 8);
        this.GfxObj.fillRect(0, bpos, Width, blk);
        scl1 = 255;
        scl2 = 194;
        ypos = (bpos -= theight2) - (tpos -= theight1);
        bheight = ypos >> 1;
        blk = ypos >> 2;
        k = y * scl2;
        frstbr = scl1 + k / this.MaxVisible;
        nxtbr = frstbr - (frstbr - (scl1 + (k - scl2) / this.MaxVisible) + 1 >> 1);
        i = frstbr - nxtbr >> 1;
        k = frstbr;
        if (k < 8) {
            k = 8;
        }
        this.GfxObj.setColor(k, k, k);
        this.GfxObj.fillRect(0, tpos, Width, blk);
        k = frstbr - i;
        if (k < 8) {
            k = 8;
        }
        this.GfxObj.setColor(k, k, k);
        this.GfxObj.fillRect(0, tpos + blk, Width, bheight - blk);
        k = nxtbr;
        if (k < 8) {
            k = 8;
        }
        this.GfxObj.setColor(k, k, k);
        this.GfxObj.fillRect(0, tpos + bheight, Width, blk);
        k = nxtbr - i;
        if (k < 8) {
            k = 8;
        }
        this.GfxObj.setColor(k, k, k);
        this.GfxObj.fillRect(0, tpos + bheight + blk, Width, ypos - bheight - blk);
    }

    final void PaintEdge(int y) {
        int pfactor = 100 - (y + 1) * ViewThrought;
        pfactor = Height + Height * (y * Perspective) / pfactor;
        this.GfxObj.setColor(0);
        this.GfxObj.fillRect(0, Height - pfactor >> 1, Width, pfactor);
    }

    void AnimateObj() {
    }
}

