/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonGame;

public final class DungeonDoor
extends DungeonCube {
    short KeysFound;
    boolean DoorOpened;

    public DungeonDoor() {
        this.ShapeRed = 255;
        this.ShapeGreen = 180;
        this.ShapeBlue = 120;
        this.KeysFound = 0;
        this.DoorOpened = false;
    }

    final void PaintFront(int lftcube, int rgtcube) {
        int halfwidth = this.WallWidth >> 1;
        int quadwidth = halfwidth >> 1;
        int halfheight = this.WallHeight >> 1;
        int quadheight = halfheight >> 1;
        int tpos = this.TopPos;
        if (this.DoorOpened) {
            tpos -= halfheight + quadheight + (quadheight >> 1);
        }
        if (!this.DoorOpened) {
            this.GfxObj.setColor(this.ShapeColor);
            this.GfxObj.fillRect(this.LeftPos + 1, tpos + 1, this.WallWidth - 1, quadheight);
            this.GfxObj.fillRect(this.LeftPos + 1, tpos + quadheight, quadwidth, quadheight + 1);
            this.GfxObj.fillRect(this.LeftPos + this.WallWidth - quadwidth, tpos + quadheight, quadwidth, quadheight + 1);
            this.GfxObj.fillRect(this.LeftPos + 1, tpos + halfheight, this.WallWidth - 1, quadheight + (quadheight >> 1) - 1);
            int lp = this.LeftPos + 1;
            int wd = this.LeftPos + this.WallWidth - 1;
            int i = quadheight + (quadheight >> 1);
            int k = i + tpos + halfheight - 1;
            int curcolor = this.ShapeColor;
            while (i <= halfheight) {
                if (curcolor < 0) {
                    curcolor = 0;
                }
                this.GfxObj.setColor(curcolor);
                this.GfxObj.drawLine(lp, k, wd, k);
                ++i;
                ++k;
                curcolor -= 393985;
            }
            i = quadwidth >> 1;
            wd = i >> 1;
            lp = tpos + quadheight;
            k = this.LeftPos + quadwidth;
            this.GfxObj.setColor(this.FrameColor);
            this.GfxObj.drawRect(k, lp, halfwidth, quadheight);
            this.GfxObj.drawRect(k - (halfwidth >> 4), lp - (halfheight >> 4), halfwidth + (halfwidth >> 3), quadheight + (halfheight >> 3));
            this.GfxObj.drawLine(k + wd, lp, k + wd, tpos + halfheight - 1);
            this.GfxObj.drawLine(k + i, lp, k + i, tpos + halfheight - 1);
            this.GfxObj.drawLine(k + wd * 3, lp, k + wd * 3, tpos + halfheight - 1);
            k = this.LeftPos + halfwidth;
            this.GfxObj.drawLine(k, lp, this.LeftPos + halfwidth, tpos + halfheight - 1);
            this.GfxObj.drawLine(k + wd, lp, k + wd, tpos + halfheight - 1);
            this.GfxObj.drawLine(k + i, lp, k + i, tpos + halfheight - 1);
            this.GfxObj.drawLine(k + wd * 3, lp, k + wd * 3, tpos + halfheight - 1);
            this.GfxObj.drawRect(this.LeftPos, tpos, this.WallWidth, this.WallHeight - 1);
        } else {
            int wd = this.LeftPos + this.WallWidth - 1;
            int i = quadheight + (quadheight >> 1);
            int k = i + tpos + halfheight - 1;
            int curcolor = this.ShapeColor;
            while (i <= halfheight) {
                if (curcolor < 0) {
                    curcolor = 0;
                }
                this.GfxObj.setColor(curcolor);
                this.GfxObj.drawLine(this.LeftPos, k, wd, k);
                ++i;
                ++k;
                curcolor -= 393985;
            }
        }
    }

    final void PaintWallLeft() {
        int curcolor;
        if (this.DoorOpened) {
            return;
        }
        int lpos = this.LeftPos;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int curcol = this.ShapeColor - 0x100E0E * -(-(this.MaxVisible + 1) - this.yp);
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + twidth + this.xp * twidth;
        int bpos = DungeonCube.Height - theight >> 1;
        int i = theight;
        this.GfxObj.setColor(curcol);
        while (--i > 0) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        i = this.TopPos + this.WallHeight;
        int quadheight = i - (i - tpos >> 2);
        vzoom = 0;
        this.GfxObj.setColor(curcol);
        int pery = (i - tpos) * 942 >> 10;
        bpos -= pery;
        pery -= quadheight - tpos + 1;
        while (tpos <= quadheight) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        while (tpos < i) {
            if (tpos > quadheight) {
                if ((curcolor = curcol - vzoom++ * 393985) < 0) {
                    curcolor = 0;
                }
                this.GfxObj.setColor(curcolor);
            }
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos);
            if (pery == 0) continue;
            --pery;
            ++bpos;
        }
        lpos = this.LeftPos;
        tpos = this.TopPos;
        bpos -= theight;
        if (this.yp > -4) {
            int halfwidth = rpos - lpos >> 1;
            int quadwidth = halfwidth >> 1;
            int halfheight = theight >> 1;
            quadheight = halfheight >> 1;
            int offsy = quadheight >> 2;
            pery = (bpos - tpos) * 123 >> 8;
            this.GfxObj.setColor(this.FrameColor);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + pery + offsy);
            for (i = 3; i < halfheight - (quadheight >> 1); ++i) {
                this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + i + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 16 / 100 + offsy);
                curcolor = 0x555555 - (i >> 1) * 131585 - 0x101010 * -this.yp;
                if (curcolor < 0) {
                    curcolor = 0;
                }
                this.GfxObj.setColor(curcolor);
            }
            this.GfxObj.setColor(this.FrameColor);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + i + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 16 / 100 + offsy);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + (i += 3) + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 15 / 100 + offsy);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + offsy, lpos + quadwidth, tpos + quadheight + i + offsy);
            this.GfxObj.drawLine(lpos + quadwidth + halfwidth, tpos + quadheight + pery + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 15 / 100 + offsy);
        }
        lpos = this.LeftPos;
        tpos = this.TopPos;
        this.GfxObj.setColor(this.FrameColor);
        this.GfxObj.drawLine(lpos, tpos, rpos, bpos);
        this.GfxObj.drawLine(lpos, tpos + this.WallHeight, rpos, bpos + theight);
        this.GfxObj.drawLine(rpos, bpos, rpos, bpos + theight);
    }

    final void PaintWallRight() {
        int curcolor;
        if (this.DoorOpened) {
            return;
        }
        int lpos = this.LeftPos + this.WallWidth;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int curcol = this.ShapeColor - 0x100E0E * -(-(this.MaxVisible + 1) - this.yp);
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + (1 + (this.xp + 1)) * twidth;
        int bpos = DungeonCube.Height - theight >> 1;
        int i = theight;
        this.GfxObj.setColor(curcol);
        while (--i > 0) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        i = this.TopPos + this.WallHeight;
        int quadheight = i - (i - tpos >> 2);
        vzoom = 0;
        this.GfxObj.setColor(curcol);
        int pery = (i - tpos) * 942 >> 10;
        bpos -= pery;
        pery -= quadheight - tpos + 1;
        while (tpos <= quadheight) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        while (tpos < i) {
            if ((curcolor = curcol - vzoom++ * 393985) < 0) {
                curcolor = 0;
            }
            this.GfxObj.setColor(curcolor);
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos);
            if (pery == 0) continue;
            --pery;
            ++bpos;
        }
        lpos = this.LeftPos + this.WallWidth;
        tpos = this.TopPos;
        bpos -= theight;
        if (this.yp > -4) {
            int halfwidth = rpos - lpos >> 1;
            int quadwidth = halfwidth >> 1;
            int halfheight = theight >> 1;
            quadheight = halfheight >> 1;
            int offsy = quadheight >> 2;
            pery = (bpos - tpos) * 123 >> 8;
            this.GfxObj.setColor(this.FrameColor);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + pery + offsy);
            for (i = 3; i < halfheight - (quadheight >> 1); ++i) {
                this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + i + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 16 / 100 + offsy);
                curcolor = 0x555555 - (i >> 1) * 131585 - 0x101010 * -this.yp;
                if (curcolor < 0) {
                    curcolor = 0;
                }
                this.GfxObj.setColor(curcolor);
            }
            this.GfxObj.setColor(this.FrameColor);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + i + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 16 / 100 + offsy);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + (i += 3) + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 15 / 100 + offsy);
            this.GfxObj.drawLine(lpos + quadwidth, tpos + quadheight + offsy, lpos + quadwidth, tpos + quadheight + i + offsy);
            this.GfxObj.drawLine(lpos + quadwidth + halfwidth, tpos + quadheight + pery + offsy, lpos + quadwidth + halfwidth, tpos + quadheight + i + pery - i * 15 / 100 + offsy);
        }
        lpos = this.LeftPos + this.WallWidth;
        tpos = this.TopPos;
        this.GfxObj.setColor(this.FrameColor);
        this.GfxObj.drawLine(lpos, tpos, rpos, bpos);
        this.GfxObj.drawLine(lpos, tpos + this.WallHeight, rpos, bpos + theight);
        this.GfxObj.drawLine(rpos, bpos, rpos, bpos + theight);
    }

    final char IncrementKeys(char[] Playfield, int curcubeoffset) {
        this.KeysFound = (short)(this.KeysFound + 1);
        DungeonGame.PlaySound(134, 1);
        Playfield[curcubeoffset] = 46;
        return Playfield[curcubeoffset];
    }

    final void ClearKeys() {
        this.KeysFound = 0;
    }

    final char OpenDoor(char[] Playfield, int curcubeoffset) {
        if (this.KeysFound > 0) {
            this.KeysFound = (short)(this.KeysFound - 1);
            DungeonGame.PlaySound(135, 1);
            Playfield[curcubeoffset] = 58;
        }
        return Playfield[curcubeoffset];
    }

    final void SetDoorOpen(boolean bOpen) {
        this.DoorOpened = bOpen;
    }
}

