/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.madmaze.DungeonArrow;
import overthehill.madmaze.DungeonBeam;
import overthehill.madmaze.DungeonCrystal;
import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonDark;
import overthehill.madmaze.DungeonDiamond;
import overthehill.madmaze.DungeonDoor;
import overthehill.madmaze.DungeonFlash;
import overthehill.madmaze.DungeonGame;
import overthehill.madmaze.DungeonGate;
import overthehill.madmaze.DungeonGrid;
import overthehill.madmaze.DungeonHit;
import overthehill.madmaze.DungeonKey;
import overthehill.madmaze.DungeonLevels;
import overthehill.madmaze.DungeonLines;
import overthehill.madmaze.DungeonPortal;
import overthehill.madmaze.DungeonPreview;
import overthehill.madmaze.DungeonShot;
import overthehill.madmaze.DungeonSplash;
import overthehill.madmaze.DungeonStick;
import overthehill.madmaze.DungeonStone;
import overthehill.madmaze.DungeonSwitch;
import overthehill.madmaze.DungeonTransport;
import overthehill.madmaze.DungeonTreasure;
import overthehill.madmaze.DungeonWall;
import overthehill.madmaze.JoyPad;

public final class DungeonPlayfield {
    private int InternalState;
    private int PlayerOffset;
    private int PreviewColor;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int FadeOutColor;
    private int PlayfieldWidthHalf;
    private int PlayfieldHeightHalf;
    private int PlayerScore;
    private int FontHeight;
    private int GameImageHeight;
    private int BonusImageHeight;
    private long StylusEventTimeStamp;
    private short LevelNum;
    private short LevelTextFadeIn;
    private short CrystalInfo;
    private short LetsGoCount;
    private short PlayerHitCount;
    private short BeamingCount;
    private short ClickCount;
    private short EnergyCount;
    private short PlayerViewDirection;
    private short EnergyInfo;
    private boolean PauseFlag;
    private boolean MapFlag;
    private boolean PlayerMovedFlag;
    private String PlayerScoreString;
    private DungeonBeam BeamEffect;
    private Font GameFont;
    private Image GameImage;
    public static final int AbsLevelCols = 32;
    public static final int AbsLevelRows = 32;
    private static final int[][] ColumnOrder = new int[][]{{-3, -2, -1, 3, 2, 1, 0}, {-3, -2, -1, 3, 2, 1, 0}, {-3, -2, -1, 3, 2, 1, 0}, {-2, -1, 2, 1, 0}, {-1, 1, 0}, {-1, 1, 0}};
    private static final int Distance = -5;
    private static final short MaxEnergyCount = 64;
    private final SimplePoint StylusPos = new SimplePoint();
    private final SimplePoint FadeInPoint = new SimplePoint();
    private final SimplePoint FadeOutPoint = new SimplePoint();
    private final SimplePoint EnergySize = new SimplePoint();
    private static final DungeonWall WallObject = new DungeonWall();
    private static final DungeonTransport TransportObject = new DungeonTransport();
    private static final DungeonDoor DoorObject = new DungeonDoor();
    private static final DungeonKey KeyObject = new DungeonKey();
    private static final DungeonSwitch SwitchObject = new DungeonSwitch();
    private static final DungeonGate GateObject = new DungeonGate();
    private static final DungeonArrow DungeonArrowLf = new DungeonArrow(-1);
    private static final DungeonArrow DungeonArrowRg = new DungeonArrow(1);
    private static final DungeonFlash DungeonFlashObject = new DungeonFlash();
    private static final DungeonDark DarkObject = new DungeonDark();
    private static final DungeonPortal PortalObject = new DungeonPortal();
    private static final DungeonDiamond DiamondObject = new DungeonDiamond();
    private static final DungeonCrystal CrystalObject = new DungeonCrystal();
    private static final DungeonShot ShotObject = new DungeonShot();
    private static final DungeonHit HitObject = new DungeonHit();
    private static final DungeonGrid GridObject = new DungeonGrid();
    private static final DungeonLines LinesObject = new DungeonLines();
    private static final DungeonStone StoneObject = new DungeonStone();
    private static final DungeonTreasure TreasureObject = new DungeonTreasure();
    private static final DungeonStick StickObject = new DungeonStick();
    private char[] Playfield;

    public DungeonPlayfield(Font FontObj, int dWidth, int dHeight, short LargeInfo, boolean ColoredFlag) {
        this.GameFont = FontObj;
        this.GameImage = DungeonGame.GameImage;
        this.FontHeight = this.GameFont != null ? this.GameFont.getHeight() : 10;
        this.GameImageHeight = this.GameImage.getHeight();
        this.EnergyInfo = LargeInfo;
        switch (this.EnergyInfo) {
            case 1: {
                this.EnergySize.x = 128;
                this.EnergySize.y = 22;
                break;
            }
            case 2: {
                this.EnergySize.x = 64;
                this.EnergySize.y = 11;
                break;
            }
            default: {
                this.EnergySize.x = 32;
                this.EnergySize.y = 5;
            }
        }
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.PlayfieldWidthHalf = this.PlayfieldWidth >> 1;
        this.PlayfieldHeightHalf = this.PlayfieldHeight >> 1;
        this.Playfield = new char[1025];
        this.BeamEffect = new DungeonBeam(256, this.PlayfieldWidth, this.PlayfieldHeight);
        this.PauseFlag = false;
        this.MapFlag = false;
        this.ClickCount = 0;
        this.LevelTextFadeIn = 0;
        this.CrystalInfo = 0;
        this.LetsGoCount = 0;
        this.BeamingCount = 0;
        this.LevelNum = 0;
        this.EnergyCount = 0;
        this.PreviewColor = 0;
        this.BonusImageHeight = DungeonGame.BonusIconImage.getHeight();
        this.InternalState = 0;
        DungeonCube.SetDimension(dWidth, dHeight, ColoredFlag);
        this.SetStartLevel(0);
        this.InternalState = 1;
    }

    public final void BuildPlayfield(Graphics gfx) {
        if (this.GameFont != null) {
            gfx.setFont(this.GameFont);
        }
        this.PauseFlag = JoyPad.IsPauseKey();
        this.MapFlag = JoyPad.IsMapKey();
        if (!this.PauseFlag && !this.MapFlag) {
            if (JoyPad.IsAnyCtrlKey()) {
                this.LetsGoCount = 0;
                this.ClickCount = 0;
                this.StylusPos.x = this.PlayfieldWidthHalf;
                this.StylusPos.y = this.PlayfieldHeightHalf;
                if (JoyPad.IsLeftKey()) {
                    this.StylusPos.x = this.PlayfieldWidth >> 3;
                    JoyPad.SetLeftKeyState(false);
                }
                if (JoyPad.IsRightKey()) {
                    this.StylusPos.x = this.PlayfieldWidth - (this.PlayfieldWidth >> 3);
                    JoyPad.SetRightKeyState(false);
                }
                if (JoyPad.IsUpKey()) {
                    this.StylusPos.y = this.PlayfieldHeight >> 3;
                    JoyPad.SetUpKeyState(false);
                }
                if (JoyPad.IsDownKey()) {
                    this.StylusPos.y = this.PlayfieldHeight - (this.PlayfieldHeight >> 3);
                    JoyPad.SetDownKeyState(false);
                }
                this.PlayerMovedFlag = true;
            }
            if (this.PlayerMovedFlag) {
                this.PlayerMovedFlag = false;
                this.MovePlayer();
                this.StylusPos.x = 0;
            }
        }
        this.AnimateLevel();
        if (this.FadeInPoint.x > 0) {
            this.FadeInPoint.x -= this.PlayfieldWidth >> 3;
            if (this.FadeInPoint.x < 0) {
                this.FadeInPoint.x = 0;
            }
        }
        if (this.FadeInPoint.y > 0) {
            this.FadeInPoint.y -= this.PlayfieldHeight >> 3;
            if (this.FadeInPoint.y < 0) {
                this.FadeInPoint.y = 0;
            }
        }
        if (this.FadeInPoint.x != 0 && this.FadeInPoint.y != 0) {
            gfx.setClip(this.FadeInPoint.x, this.FadeInPoint.y, this.PlayfieldWidthHalf - this.FadeInPoint.x << 1, this.PlayfieldHeightHalf - this.FadeInPoint.y << 1);
        } else {
            gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
            if (this.MapFlag) {
                this.PaintMapInGame(gfx);
                if (this.PauseFlag) {
                    this.DrawBanner(gfx, "Pause");
                }
                return;
            }
        }
        this.PaintPlayfield(gfx);
        if (this.LetsGoCount > 0) {
            this.DrawBanner(gfx, "Let's go!");
            this.LetsGoCount = (short)(this.LetsGoCount - 1);
        }
        if (this.PlayerHitCount > 0 || this.EnergyCount <= 0) {
            this.PlayerHitCount = (short)(this.PlayerHitCount - 1);
            this.DrawBangEffect(gfx, this.PlayerHitCount);
            if (this.PlayerHitCount == -8) {
                this.InternalState = 5;
                return;
            }
        }
        if (this.BeamingCount > 0) {
            this.DrawBeamEffect(gfx);
        }
        if (this.PauseFlag) {
            this.DrawBanner(gfx, "Pause");
        }
        if (this.ClickCount > 0) {
            DungeonSplash.PaintKickSplash(gfx, "Beep!", 0xFF8000);
            this.ClickCount = (short)(this.ClickCount - 1);
        }
        this.DrawCompass(gfx);
        this.DrawScoreEnergy(gfx);
        if (this.FadeOutPoint.x > 0 || this.FadeOutPoint.y > 0) {
            this.PaintFadeOut(gfx);
        }
    }

    public final void BuildPreview(Graphics gfx) {
        DungeonPreview.SetBrushColor(this.PreviewColor);
        DungeonPreview.Paint(gfx, this.Playfield, this.PlayerOffset, this.PlayerViewDirection);
        this.PreviewColor = this.PreviewColor >= 0x222222 ? (this.PreviewColor -= 0x222222) : 0;
    }

    private final void PaintPlayfield(Graphics gfx) {
        WallObject.SetGfx(gfx);
        WallObject.PaintEdge(-5);
        int playerrow = this.PlayerOffset / 32;
        int playercol = this.PlayerOffset % 32;
        if (JoyPad.IsFireKey()) {
            if (!this.PauseFlag) {
                this.HandleFireAction(playercol, playerrow);
            }
            JoyPad.SetFireKeyState(false);
        }
        for (int mrow = -5; mrow <= 0; ++mrow) {
            int oidy = mrow - -5;
            int mcnt = ColumnOrder[oidy].length;
            for (int oidx = 0; oidx < mcnt; ++oidx) {
                int col;
                int row;
                int mcol = ColumnOrder[oidy][oidx];
                int curcube = 32;
                int nxtcube = 32;
                int lftcube = 32;
                int rgtcube = 32;
                int ldwcube = 32;
                int rdwcube = 32;
                int curcubeoffset = -1;
                switch (this.PlayerViewDirection) {
                    case -32: {
                        row = playerrow + mrow;
                        col = playercol + mcol;
                        if (row < 0 || row >= 32 || col < 0 || col >= 32) break;
                        curcubeoffset = row * 32 + col;
                        curcube = this.Playfield[curcubeoffset];
                        nxtcube = row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col] : 32;
                        lftcube = col - 1 >= 0 ? this.Playfield[row * 32 + col - 1] : 32;
                        int n = rgtcube = col + 1 < 32 ? this.Playfield[row * 32 + col + 1] : 32;
                        if (mrow == 0) break;
                        if (mcol > 0) {
                            int n2 = ldwcube = col - 1 >= 0 && row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col - 1] : 32;
                        }
                        if (mcol >= 0) break;
                        rdwcube = col + 1 < 32 && row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col + 1] : 32;
                        break;
                    }
                    case 32: {
                        row = playerrow - mrow;
                        col = playercol - mcol;
                        if (row < 0 || row >= 32 || col < 0 || col >= 32) break;
                        curcubeoffset = row * 32 + col;
                        curcube = this.Playfield[curcubeoffset];
                        nxtcube = row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col] : 32;
                        lftcube = col + 1 < 32 ? this.Playfield[row * 32 + col + 1] : 32;
                        int n = rgtcube = col - 1 >= 0 ? this.Playfield[row * 32 + col - 1] : 32;
                        if (mrow == 0) break;
                        if (mcol > 0) {
                            int n3 = ldwcube = col + 1 < 32 && row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col + 1] : 32;
                        }
                        if (mcol >= 0) break;
                        rdwcube = col - 1 >= 0 && row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col - 1] : 32;
                        break;
                    }
                    case -1: {
                        row = playerrow - mcol;
                        col = playercol + mrow;
                        if (row < 0 || row >= 32 || col < 0 || col >= 32) break;
                        curcubeoffset = row * 32 + col;
                        curcube = this.Playfield[curcubeoffset];
                        nxtcube = col + 1 < 32 ? this.Playfield[row * 32 + col + 1] : 32;
                        lftcube = row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col] : 32;
                        int n = rgtcube = row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col] : 32;
                        if (mrow == 0) break;
                        if (mcol > 0) {
                            int n4 = ldwcube = col + 1 < 32 && row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col + 1] : 32;
                        }
                        if (mcol >= 0) break;
                        rdwcube = col + 1 < 32 && row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col + 1] : 32;
                        break;
                    }
                    case 1: {
                        row = playerrow + mcol;
                        col = playercol - mrow;
                        if (row < 0 || row >= 32 || col < 0 || col >= 32) break;
                        curcubeoffset = row * 32 + col;
                        curcube = this.Playfield[curcubeoffset];
                        nxtcube = col - 1 >= 0 ? this.Playfield[row * 32 + col - 1] : 32;
                        lftcube = row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col] : 32;
                        int n = rgtcube = row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col] : 32;
                        if (mrow == 0) break;
                        if (mcol > 0) {
                            int n5 = ldwcube = col - 1 >= 0 && row - 1 >= 0 ? this.Playfield[(row - 1) * 32 + col - 1] : 32;
                        }
                        if (mcol >= 0) break;
                        rdwcube = col - 1 >= 0 && row + 1 < 32 ? this.Playfield[(row + 1) * 32 + col - 1] : 32;
                        break;
                    }
                    default: {
                        row = 0;
                        col = 0;
                    }
                }
                DungeonCube CubeObject = null;
                switch (curcube) {
                    case 43: {
                        CubeObject = TransportObject;
                        break;
                    }
                    case 35: {
                        DoorObject.SetDoorOpen(false);
                        CubeObject = DoorObject;
                        break;
                    }
                    case 58: {
                        if (this.Is_Walkable(nxtcube, false)) {
                            DoorObject.SetDoorOpen(true);
                            CubeObject = DoorObject;
                            break;
                        }
                        CubeObject = WallObject;
                        curcube = 32;
                        break;
                    }
                    case 38: {
                        SwitchObject.SetActivated(false);
                        CubeObject = SwitchObject;
                        break;
                    }
                    case 37: {
                        SwitchObject.SetActivated(true);
                        CubeObject = SwitchObject;
                        break;
                    }
                    case 33: {
                        KeyObject.SetGrabKey(false);
                        CubeObject = KeyObject;
                        break;
                    }
                    case 46: {
                        KeyObject.SetGrabKey(true);
                        CubeObject = KeyObject;
                        break;
                    }
                    case 122: {
                        CubeObject = GateObject;
                        break;
                    }
                    case 60: {
                        CubeObject = DungeonArrowLf;
                        break;
                    }
                    case 62: {
                        CubeObject = DungeonArrowRg;
                        break;
                    }
                    case 167: {
                        CubeObject = DungeonFlashObject;
                        break;
                    }
                    case 45: 
                    case 64: {
                        CubeObject = WallObject;
                        curcube = 32;
                        break;
                    }
                    case 66: {
                        CubeObject = DarkObject;
                        break;
                    }
                    case 84: {
                        CubeObject = PortalObject;
                        break;
                    }
                    case 68: {
                        DiamondObject.SetCollectedFlag(false);
                        CubeObject = DiamondObject;
                        break;
                    }
                    case 100: {
                        DiamondObject.SetCollectedFlag(true);
                        CubeObject = DiamondObject;
                        break;
                    }
                    case 110: {
                        CubeObject = CrystalObject;
                        break;
                    }
                    case 109: {
                        HitObject.SetStateBrightness(128);
                        CubeObject = HitObject;
                        this.Playfield[curcubeoffset] = 108;
                        break;
                    }
                    case 108: {
                        HitObject.SetStateBrightness(256);
                        CubeObject = HitObject;
                        this.Playfield[curcubeoffset] = 32;
                        break;
                    }
                    case 102: {
                        GridObject.SetGridWidth(2);
                        CubeObject = GridObject;
                        break;
                    }
                    case 103: {
                        GridObject.SetGridWidth(4);
                        CubeObject = GridObject;
                        break;
                    }
                    case 104: {
                        GridObject.SetGridWidth(6);
                        CubeObject = GridObject;
                        break;
                    }
                    case 107: {
                        CubeObject = LinesObject;
                        break;
                    }
                    case 111: {
                        ShotObject.SetAnimPhase(row + col);
                        CubeObject = ShotObject;
                        break;
                    }
                    case 112: {
                        HitObject.SetStateBrightness(64);
                        CubeObject = HitObject;
                        break;
                    }
                    case 113: {
                        HitObject.SetStateBrightness(128);
                        CubeObject = HitObject;
                        this.AddPlayerScore(100);
                        break;
                    }
                    case 114: {
                        StoneObject.SetInMove(false);
                        CubeObject = StoneObject;
                        break;
                    }
                    case 115: {
                        StoneObject.SetInMove(true);
                        CubeObject = StoneObject;
                        int itmp = curcubeoffset - 32;
                        if (this.Playfield[itmp] == '\u00a7') {
                            this.Playfield[itmp] = 112;
                            DungeonGame.PlaySound(131, 1);
                            break;
                        }
                        if (this.Playfield[itmp] == 'p') {
                            this.Playfield[itmp] = 113;
                            break;
                        }
                        if (this.Playfield[itmp] == 'q') {
                            this.Playfield[itmp] = 114;
                        } else {
                            this.Playfield[itmp] = 114;
                            DungeonGame.PlaySound(135, 1);
                        }
                        this.Playfield[curcubeoffset] = 32;
                        break;
                    }
                    case 116: {
                        StoneObject.SetInMove(true);
                        CubeObject = StoneObject;
                        int itmp = curcubeoffset + 32;
                        if (this.Playfield[itmp] == '\u00a7') {
                            this.Playfield[itmp] = 112;
                            DungeonGame.PlaySound(131, 1);
                            break;
                        }
                        if (this.Playfield[itmp] == 'p') {
                            this.Playfield[itmp] = 113;
                            break;
                        }
                        if (this.Playfield[itmp] == 'q') {
                            this.Playfield[itmp] = 114;
                        } else {
                            this.Playfield[itmp] = 114;
                            DungeonGame.PlaySound(135, 1);
                        }
                        this.Playfield[curcubeoffset] = 32;
                        break;
                    }
                    case 117: {
                        StoneObject.SetInMove(true);
                        CubeObject = StoneObject;
                        int itmp = curcubeoffset - 1;
                        if (this.Playfield[itmp] == '\u00a7') {
                            this.Playfield[itmp] = 112;
                            DungeonGame.PlaySound(131, 1);
                            break;
                        }
                        if (this.Playfield[itmp] == 'p') {
                            this.Playfield[itmp] = 113;
                            break;
                        }
                        if (this.Playfield[itmp] == 'q') {
                            this.Playfield[itmp] = 114;
                        } else {
                            this.Playfield[itmp] = 114;
                            DungeonGame.PlaySound(135, 1);
                        }
                        this.Playfield[curcubeoffset] = 32;
                        break;
                    }
                    case 118: {
                        StoneObject.SetInMove(true);
                        CubeObject = StoneObject;
                        int itmp = curcubeoffset + 1;
                        if (this.Playfield[itmp] == '\u00a7') {
                            this.Playfield[itmp] = 112;
                            DungeonGame.PlaySound(131, 1);
                            break;
                        }
                        if (this.Playfield[itmp] == 'p') {
                            this.Playfield[itmp] = 113;
                            break;
                        }
                        if (this.Playfield[itmp] == 'q') {
                            this.Playfield[itmp] = 114;
                        } else {
                            this.Playfield[itmp] = 114;
                            DungeonGame.PlaySound(135, 1);
                        }
                        this.Playfield[curcubeoffset] = 32;
                        break;
                    }
                    case 119: {
                        TreasureObject.SetCollectedFlag(false);
                        CubeObject = TreasureObject;
                        break;
                    }
                    case 120: {
                        TreasureObject.SetCollectedFlag(true);
                        CubeObject = TreasureObject;
                        break;
                    }
                    case 121: {
                        CubeObject = StickObject;
                        break;
                    }
                    default: {
                        CubeObject = WallObject;
                    }
                }
                if (CubeObject == null) continue;
                boolean benable = true;
                CubeObject.SetGfx(gfx);
                if (oidx == 0) {
                    CubeObject.PaintFloor(mrow);
                }
                if (curcube == 32) continue;
                CubeObject.SetPosition(mcol, mrow);
                if ((mrow != 0 || mcol == 0) && (mrow == 0 || nxtcube == 32 || nxtcube == 64 || nxtcube == 43 || nxtcube == 45 || nxtcube == 58 || nxtcube == 35 || nxtcube == 167 || nxtcube == 107 || nxtcube >= 108 && nxtcube <= 121 || nxtcube >= 102 && nxtcube <= 104) && (curcube != 167 || mcol == 0 || lftcube != 32 && rgtcube != 32)) {
                    CubeObject.PaintFront(mcol < 0 ? -1 : lftcube, mcol > 0 ? -1 : rgtcube);
                    if (curcube == 167) {
                        benable = false;
                    }
                }
                if (!benable) continue;
                if (mcol < 0 && rgtcube != 65 && rdwcube != 65 && rgtcube != 66 && rgtcube != 68 && rgtcube != 100 && rgtcube != 35 && rgtcube != 33 && rgtcube != 46 && rgtcube != 38 && rgtcube != 37 && rgtcube != 60 && rgtcube != 62 && rgtcube != 122 && rgtcube != 84) {
                    CubeObject.PaintWallRight();
                }
                if (mcol <= 0 || lftcube == 65 || ldwcube == 65 || lftcube == 66 || lftcube == 68 || lftcube == 100 || lftcube == 35 || lftcube == 33 || lftcube == 46 || lftcube == 38 || lftcube == 37 || lftcube == 60 || lftcube == 62 || rgtcube == 122 || rgtcube == 84) continue;
                CubeObject.PaintWallLeft();
            }
        }
        if (this.LevelTextFadeIn > 0) {
            this.DrawBanner(gfx, "Code: " + DungeonLevels.GetLevelCode(this.LevelNum));
        }
        if (this.CrystalInfo > 0) {
            this.CrystalInfo = (short)(this.CrystalInfo - 1);
            this.DrawBanner(gfx, null);
            gfx.drawImage(DungeonGame.BonusIconImage, this.PlayfieldWidth >> 1, (this.PlayfieldHeight >> 1) - (this.BonusImageHeight >> 1), 17);
            this.AddPlayerScore(75);
        }
        this.InternalState = 3;
    }

    private final void AnimateLevel() {
        if (!this.PauseFlag) {
            ShotObject.AnimateObj();
            char curcube = this.Playfield[this.PlayerOffset];
            if (curcube == 'k' && LinesObject.Is_Visible()) {
                this.DecreaseLiveEnergy(1);
            }
            this.Playfield[this.PlayerOffset] = 42;
            TransportObject.AnimateObj();
            DungeonArrowLf.AnimateObj();
            DungeonArrowRg.AnimateObj();
            DungeonFlashObject.AnimateObj();
            DarkObject.AnimateObj();
            CrystalObject.AnimateObj();
            if (DungeonFlash.MoveThroughPlayfield(this.Playfield, this.PlayerOffset, 32, 32) && this.BeamingCount == 0) {
                if (this.MapFlag) {
                    this.MapFlag = false;
                    JoyPad.ToogleMapKeyState();
                }
                this.DecreaseLiveEnergy(1);
            }
            this.Playfield[this.PlayerOffset] = curcube;
        }
    }

    private final void PrepareLevel() {
        this.PlayerHitCount = 0;
        this.EnergyCount = (short)64;
        this.BeamingCount = 0;
        this.LetsGoCount = (short)8;
        this.ClickCount = 0;
        this.PlayerViewDirection = (short)-32;
        this.PlayerOffset = 33;
        if (this.LevelNum < DungeonLevels.GetLevelCount()) {
            this.Playfield = DungeonLevels.GetLevelCharArray(this.LevelNum);
            for (int idx = 0; idx < this.Playfield.length; ++idx) {
                if (this.Playfield[idx] != '*') continue;
                this.Playfield[idx] = 32;
                this.PlayerOffset = idx;
                break;
            }
        }
        this.PreviewColor = 0xFFFFFF;
        this.FadeInPoint.x = this.PlayfieldWidthHalf - 1;
        this.FadeInPoint.y = this.PlayfieldHeightHalf - 1;
        DoorObject.ClearKeys();
        DiamondObject.ClearDiamonds();
        ShotObject.SetPlayfield(this.Playfield);
        DungeonFlashObject.FindFlashObjects(this.Playfield, 32, 32);
    }

    private final void MovePlayer() {
        char NewPlaceChr;
        if (this.BeamingCount != 0) {
            return;
        }
        boolean PlayerIsMoving = false;
        boolean MovingForward = false;
        int NewPlayerOffset = this.PlayerOffset;
        if (this.StylusPos.y > this.PlayfieldHeightHalf + (this.PlayfieldHeightHalf >> 1) && this.StylusPos.x > this.PlayfieldWidthHalf - (this.PlayfieldWidthHalf >> 1) && this.StylusPos.x < this.PlayfieldWidthHalf + (this.PlayfieldWidthHalf >> 1)) {
            PlayerIsMoving = true;
            switch (this.PlayerViewDirection) {
                case -32: {
                    NewPlayerOffset += 32;
                    break;
                }
                case 32: {
                    NewPlayerOffset -= 32;
                    break;
                }
                case 1: {
                    --NewPlayerOffset;
                    break;
                }
                case -1: {
                    ++NewPlayerOffset;
                    break;
                }
            }
            this.StylusEventTimeStamp = System.currentTimeMillis() + 250L;
        }
        if (this.StylusPos.y < this.PlayfieldHeightHalf - (this.PlayfieldHeightHalf >> 1) && this.StylusPos.x > this.PlayfieldWidthHalf - (this.PlayfieldWidthHalf >> 1) && this.StylusPos.x < this.PlayfieldWidthHalf + (this.PlayfieldWidthHalf >> 1)) {
            PlayerIsMoving = true;
            MovingForward = true;
            switch (this.PlayerViewDirection) {
                case -32: {
                    NewPlayerOffset -= 32;
                    break;
                }
                case 32: {
                    NewPlayerOffset += 32;
                    break;
                }
                case 1: {
                    ++NewPlayerOffset;
                    break;
                }
                case -1: {
                    --NewPlayerOffset;
                    break;
                }
            }
            this.StylusEventTimeStamp = System.currentTimeMillis() + 250L;
        }
        if ((NewPlaceChr = this.Playfield[NewPlayerOffset]) == 'r' && MovingForward) {
            switch (this.PlayerViewDirection) {
                case -32: {
                    NewPlaceChr = this.Playfield[NewPlayerOffset - 32];
                    if (NewPlaceChr != ' ' && NewPlaceChr != '-' && NewPlaceChr != '\u00a7' && NewPlaceChr != 'n') break;
                    this.Playfield[NewPlayerOffset] = 115;
                    break;
                }
                case 32: {
                    NewPlaceChr = this.Playfield[NewPlayerOffset + 32];
                    if (NewPlaceChr != ' ' && NewPlaceChr != '-' && NewPlaceChr != '\u00a7' && NewPlaceChr != 'n') break;
                    this.Playfield[NewPlayerOffset] = 116;
                    break;
                }
                case -1: {
                    NewPlaceChr = this.Playfield[NewPlayerOffset - 1];
                    if (NewPlaceChr != ' ' && NewPlaceChr != '-' && NewPlaceChr != '\u00a7' && NewPlaceChr != 'n') break;
                    this.Playfield[NewPlayerOffset] = 117;
                    break;
                }
                case 1: {
                    NewPlaceChr = this.Playfield[NewPlayerOffset + 1];
                    if (NewPlaceChr != ' ' && NewPlaceChr != '-' && NewPlaceChr != '\u00a7' && NewPlaceChr != 'n') break;
                    this.Playfield[NewPlayerOffset] = 118;
                    break;
                }
            }
            NewPlaceChr = this.Playfield[NewPlayerOffset];
        }
        if (this.Is_Walkable(NewPlaceChr, MovingForward)) {
            if (NewPlaceChr == 'z' && MovingForward && this.FadeOutPoint.x == 0) {
                this.FadeOutPoint.x = (this.PlayfieldWidth * 3 >> 2) - 1;
                this.FadeOutPoint.y = (this.PlayfieldHeight * 3 >> 2) - 1;
                this.FadeOutColor = 986895;
                DungeonGame.PlaySound(132, 1);
            }
            this.PlayerOffset = NewPlayerOffset;
            if (NewPlaceChr == 'n') {
                this.Playfield[NewPlayerOffset] = 109;
                this.CrystalInfo = (short)8;
                this.IncreaseLiveEnergy(1);
                DungeonGame.PlaySound(134, 1);
            }
            if (NewPlaceChr == '+' && MovingForward && this.BeamingCount == 0) {
                this.BeamEffect.InitStars();
                this.BeamingCount = (short)10;
                DungeonGame.PlaySound(132, 1);
            }
        }
        if (this.StylusPos.x < this.PlayfieldWidthHalf - (this.PlayfieldWidthHalf >> 1) && this.StylusPos.y < this.PlayfieldHeightHalf + (this.PlayfieldHeightHalf >> 1) && this.StylusPos.y > this.PlayfieldHeightHalf - (this.PlayfieldHeightHalf >> 1)) {
            PlayerIsMoving = true;
            switch (this.PlayerViewDirection) {
                case -32: {
                    this.PlayerViewDirection = (short)-1;
                    break;
                }
                case 32: {
                    this.PlayerViewDirection = 1;
                    break;
                }
                case 1: {
                    this.PlayerViewDirection = (short)-32;
                    break;
                }
                case -1: {
                    this.PlayerViewDirection = (short)32;
                    break;
                }
            }
            this.StylusEventTimeStamp = System.currentTimeMillis() + 500L;
        }
        if (this.StylusPos.x > this.PlayfieldWidthHalf + (this.PlayfieldWidthHalf >> 1) && this.StylusPos.y < this.PlayfieldHeightHalf + (this.PlayfieldHeightHalf >> 1) && this.StylusPos.y > this.PlayfieldHeightHalf - (this.PlayfieldHeightHalf >> 1)) {
            PlayerIsMoving = true;
            switch (this.PlayerViewDirection) {
                case -32: {
                    this.PlayerViewDirection = 1;
                    break;
                }
                case 32: {
                    this.PlayerViewDirection = (short)-1;
                    break;
                }
                case 1: {
                    this.PlayerViewDirection = (short)32;
                    break;
                }
                case -1: {
                    this.PlayerViewDirection = (short)-32;
                    break;
                }
            }
            this.StylusEventTimeStamp = System.currentTimeMillis() + 500L;
        }
        if (PlayerIsMoving && this.LevelTextFadeIn > 0) {
            this.LevelTextFadeIn = (short)(this.LevelTextFadeIn - 1);
        }
    }

    private final void StartLevel() {
        this.StylusPos.x = 0;
        this.StylusPos.y = 0;
        this.PlayerMovedFlag = false;
        this.PreviewColor = 0xFFFFFF;
        this.PrepareLevel();
    }

    private final void StartNextLevel() {
        this.LevelNum = (short)(this.LevelNum + 1);
        if (this.LevelNum >= DungeonLevels.GetLevelCount()) {
            this.InternalState = 7;
            return;
        }
        this.LevelTextFadeIn = (short)3;
        this.StartLevel();
        this.InternalState = 4;
    }

    public final void StylusRelease(int StylusX, int StylusY) {
        if (this.StylusEventTimeStamp - System.currentTimeMillis() > 0L) {
            return;
        }
        if (this.InternalState == 3) {
            int range_x = this.PlayfieldWidthHalf >> 2;
            int range_y = this.PlayfieldHeightHalf >> 2;
            if (StylusX > this.PlayfieldWidthHalf - range_x && StylusX < this.PlayfieldWidthHalf + range_x && StylusY > this.PlayfieldHeightHalf - range_y && StylusY < this.PlayfieldHeightHalf + range_y) {
                JoyPad.SetFireKeyState(true);
            }
        }
    }

    public final void StylusMove(int StylusX, int StylusY) {
        if (this.StylusEventTimeStamp - System.currentTimeMillis() > 0L) {
            return;
        }
        if (this.InternalState == 3) {
            if (!this.PlayerMovedFlag) {
                this.StylusPos.x = StylusX;
                this.StylusPos.y = StylusY;
                this.PlayerMovedFlag = true;
            }
        } else {
            int range_x = this.PlayfieldWidthHalf - (this.PlayfieldWidthHalf >> 3);
            int range_y = this.PlayfieldHeightHalf - (this.PlayfieldHeightHalf >> 3);
            if (StylusX > this.PlayfieldWidthHalf - range_x && StylusX < this.PlayfieldWidthHalf + range_x && StylusY > this.PlayfieldHeightHalf - range_y && StylusY < this.PlayfieldHeightHalf + range_y) {
                JoyPad.SetFireKeyState(true);
            }
        }
    }

    public final int GetInternalGameState() {
        return this.InternalState;
    }

    public final void SetInternalGameState(int GameState) {
        this.InternalState = GameState;
    }

    public final void SetStartLevel(int LevelNumber) {
        this.StylusEventTimeStamp = System.currentTimeMillis();
        this.LevelNum = (short)LevelNumber;
        this.SetPlayerScore(0);
        this.PrepareLevel();
    }

    public final void DrawBangEffect(Graphics gfx, int EffectIdx) {
        if (EffectIdx >= 0) {
            int icolor = 0xFF0000 + EffectIdx * 16384;
            int izoom = 128 / (EffectIdx + 1);
            DungeonSplash.PaintHitSplash(gfx, EffectIdx == 0 ? "BANG!" : "ARRGG!", icolor, izoom, 64);
        } else {
            int icolor = 0xFF0000 - EffectIdx * 4112;
            int izoom = 256 - (EffectIdx << 4);
            DungeonSplash.PaintHitSplash(gfx, EffectIdx == -1 ? "OHHH?" : "Game over!", icolor, izoom, 64 - (EffectIdx << 4));
        }
    }

    public final void DrawBanner(Graphics gfx, String BannerText) {
        int i;
        int part = this.PlayfieldHeight >> 3;
        int blks = 65536 / part;
        int grady = part + 1 >> 1;
        int plmid = this.PlayfieldHeightHalf - grady;
        for (i = 0; i < grady; ++i) {
            gfx.setColor(0xFFFFFF - 258 * (i * blks >> 8));
            gfx.fillRect(0, plmid + i, this.PlayfieldWidth, 1);
        }
        for (i = 0; i < grady; ++i) {
            gfx.setColor(0xFF0000 + 258 * (i * blks >> 8));
            gfx.fillRect(0, grady + plmid + i, this.PlayfieldWidth, 1);
        }
        gfx.setColor(0);
        gfx.fillRect(0, (grady << 1) + plmid, this.PlayfieldWidth, 1);
        if (BannerText != null) {
            int tx = this.PlayfieldWidthHalf;
            int ty = plmid + grady - (gfx.getFont().getHeight() >> 1);
            gfx.setColor(0);
            gfx.drawString(BannerText, tx + 1, ty, 17);
            gfx.setColor(0xFFFFFF);
            gfx.drawString(BannerText, tx, ty, 17);
        }
    }

    public final void PaintMapInGame(Graphics gfx) {
        gfx.setColor(0xFFFFFF);
        gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        DungeonPreview.SetBrushColor(0);
        DungeonPreview.Paint(gfx, this.Playfield, this.PlayerOffset, this.PlayerViewDirection);
    }

    public final void DrawBeamEffect(Graphics gfx) {
        this.BeamEffect.Paint(gfx);
        if (this.BeamingCount > 3 && this.BeamingCount < 8) {
            this.DrawBanner(gfx, "Beaming");
        }
        if ((this.BeamingCount = (short)(this.BeamingCount - 1)) == 5) {
            int OldPlayerOffset = this.PlayerOffset;
            while (this.Playfield[this.PlayerOffset] != '@') {
                if (this.PlayerOffset > 0) {
                    --this.PlayerOffset;
                    continue;
                }
                this.PlayerOffset = OldPlayerOffset;
                this.Playfield[this.PlayerOffset] = 32;
            }
        }
    }

    public final void AddPlayerScore(int addscore) {
        this.SetPlayerScore(this.PlayerScore + addscore);
    }

    public final void SetPlayerScore(int newscore) {
        this.PlayerScore = newscore;
        this.PlayerScoreString = "";
        String scorestr = Integer.toString(this.PlayerScore);
        int slen = scorestr.length();
        while (slen++ < 5) {
            this.PlayerScoreString = this.PlayerScoreString + '0';
        }
        this.PlayerScoreString = this.PlayerScoreString + scorestr;
    }

    public final void DrawScoreEnergy(Graphics gfx) {
        int oldxc = gfx.getClipX();
        int oldyc = gfx.getClipY();
        int newcw = this.EnergySize.x;
        int newch = this.EnergySize.y;
        if (newcw > 0 && newch > 0) {
            int cy;
            int cx;
            int lpos = this.PlayfieldWidth - (this.PlayfieldWidth >> 4);
            int oldwc = gfx.getClipWidth();
            int oldhc = gfx.getClipHeight();
            if (oldyc <= this.FontHeight) {
                gfx.setColor(167, 95, 25);
                gfx.setClip(0, 0, lpos, this.FontHeight + 1 >> 1);
                gfx.drawString(this.PlayerScoreString, lpos, 0, 24);
                gfx.setColor(128, 99, 70);
                gfx.setClip(0, this.FontHeight >> 1, lpos, this.FontHeight + 1);
                gfx.drawString(this.PlayerScoreString, lpos, 0, 24);
            }
            int enlost = 64 - this.EnergyCount;
            switch (this.EnergyInfo) {
                case 1: {
                    enlost <<= 1;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    enlost >>= 1;
                }
            }
            lpos = this.PlayfieldWidth >> 4;
            int tpos = this.FontHeight - (this.GameImageHeight >> 1) >> 1;
            if (tpos < 0) {
                tpos = 0;
            }
            if ((cx = lpos) < oldxc) {
                cx = oldxc;
            }
            if ((cy = tpos) < oldyc) {
                cy = oldyc;
            }
            newcw -= cx - lpos;
            if ((newch -= cy - tpos) > 0) {
                gfx.setClip(cx, cy, newcw - enlost, newch);
                gfx.drawImage(this.GameImage, lpos, tpos, 20);
                if (enlost > 0) {
                    gfx.setClip(cx + (newcw - enlost), cy, enlost, newch);
                    gfx.drawImage(this.GameImage, lpos, -this.EnergySize.y + tpos, 20);
                }
            }
            gfx.setClip(oldxc, oldyc, oldwc, oldhc);
        }
    }

    public final void DrawCompass(Graphics gfx) {
        int width = this.PlayfieldWidthHalf;
        int wd3 = width >> 5;
        int fth = this.FontHeight + 1;
        int xpos = this.PlayfieldWidth >> 2;
        int ypos = this.PlayfieldHeight - (this.PlayfieldHeight >> 4) - 2;
        int hg1 = this.PlayfieldHeight - (fth >> 1) - 1;
        int md1 = xpos - wd3;
        int wd2 = md1 + width + (width >> 4);
        gfx.setColor(0xFFFFFF);
        gfx.drawLine(width, ypos, width, this.PlayfieldHeight - 1);
        gfx.drawLine(md1 + 1, hg1, wd2 - 2, hg1);
        ypos -= fth + 1;
        int wd1 = xpos - wd3 - (fth >> 1);
        wd2 += wd3;
        hg1 = this.PlayfieldHeight - fth - 1;
        md1 = 17;
        int md2 = 20;
        ++width;
        switch (this.PlayerViewDirection) {
            case -32: {
                gfx.drawString("N", width, ypos, md1);
                gfx.drawString("W", wd1 -= fth >> 2, hg1, md2);
                gfx.drawString("O", wd2, hg1, md2);
                break;
            }
            case 32: {
                gfx.drawString("S", width, ypos, md1);
                gfx.drawString("O", wd1, hg1, md2);
                gfx.drawString("W", wd2, hg1, md2);
                break;
            }
            case 1: {
                gfx.drawString("O", width, ypos, md1);
                gfx.drawString("N", wd1, hg1, md2);
                gfx.drawString("S", wd2, hg1, md2);
                break;
            }
            case -1: {
                gfx.drawString("W", width, ypos, md1);
                gfx.drawString("S", wd1, hg1, md2);
                gfx.drawString("N", wd2, hg1, md2);
                break;
            }
        }
    }

    public final void PaintFadeOut(Graphics gfx) {
        if (this.FadeOutPoint.x > 0) {
            this.FadeOutPoint.x -= this.PlayfieldWidth >> 3;
            if (this.FadeOutPoint.x < 0) {
                this.FadeOutPoint.x = 0;
            }
        }
        if (this.FadeOutPoint.y > 0) {
            this.FadeOutPoint.y -= this.PlayfieldHeight >> 3;
            if (this.FadeOutPoint.y < 0) {
                this.FadeOutPoint.y = 0;
            }
        }
        if (this.FadeOutPoint.x < this.PlayfieldWidthHalf && this.FadeOutPoint.y < this.PlayfieldHeightHalf) {
            gfx.setColor(this.FadeOutColor);
            this.FadeOutColor += 0x404040;
            if (this.FadeOutColor > 0xFFFFFF) {
                this.FadeOutColor = 0xFFFFFF;
            }
            gfx.fillRect(this.FadeOutPoint.x, this.FadeOutPoint.y, this.PlayfieldWidthHalf - this.FadeOutPoint.x << 1, this.PlayfieldHeightHalf - this.FadeOutPoint.y << 1);
        }
        if (this.FadeOutPoint.x == 0 && this.FadeOutPoint.y == 0) {
            this.StartNextLevel();
        }
    }

    public final void HandleFireAction(int playercol, int playerrow) {
        int col;
        int row;
        switch (this.PlayerViewDirection) {
            case -32: {
                row = playerrow - 1;
                col = playercol;
                break;
            }
            case 32: {
                row = playerrow + 1;
                col = playercol;
                break;
            }
            case -1: {
                row = playerrow;
                col = playercol - 1;
                break;
            }
            case 1: {
                row = playerrow;
                col = playercol + 1;
                break;
            }
            default: {
                row = 0;
                col = 0;
            }
        }
        int curcubeoffset = row * 32 + col;
        switch (this.Playfield[curcubeoffset]) {
            case '&': {
                TransportObject.OpenNextGate(this.Playfield, curcubeoffset);
                this.ClickCount = (short)5;
                break;
            }
            case '%': {
                TransportObject.CloseNextGate(this.Playfield, curcubeoffset);
                this.ClickCount = (short)5;
                break;
            }
            case '!': {
                DoorObject.IncrementKeys(this.Playfield, curcubeoffset);
                this.AddPlayerScore(50);
                break;
            }
            case '#': {
                if (DoorObject.OpenDoor(this.Playfield, curcubeoffset) != ':') break;
                this.AddPlayerScore(100);
                break;
            }
            case 'D': {
                DiamondObject.Collect(this.Playfield, curcubeoffset);
                this.IncreaseLiveEnergy(1);
                this.AddPlayerScore(25);
                break;
            }
            case 'w': {
                TreasureObject.Collect(this.Playfield, curcubeoffset);
                this.AddPlayerScore(500);
                break;
            }
            default: {
                ShotObject.SetShot(this.PlayerOffset, this.PlayerViewDirection);
            }
        }
    }

    private final void DecreaseLiveEnergy(int EnergyPoints) {
        if (this.PlayerHitCount == 0 && this.EnergyCount > 0) {
            this.PlayerHitCount = (short)3;
            DungeonGame.PlaySound(131, 1);
            while (EnergyPoints-- > 0) {
                this.EnergyCount = (short)(this.EnergyCount - (this.EnergyCount == 64 ? 8 : 7));
                if (this.EnergyCount >= 0) continue;
                this.EnergyCount = 0;
                break;
            }
        }
    }

    private final void IncreaseLiveEnergy(int EnergyPoints) {
        while (EnergyPoints-- > 0) {
            this.EnergyCount = (short)(this.EnergyCount + (this.EnergyCount == 56 ? 8 : 7));
            if (this.EnergyCount <= 64) continue;
            this.EnergyCount = (short)64;
            break;
        }
    }

    public final int GetScore() {
        return this.PlayerScore;
    }

    public final boolean Is_Walkable(int chr, boolean forward) {
        return chr == 32 || chr == 45 || chr == 64 || chr == 58 || chr == 107 || chr >= 108 && chr <= 113 || (chr == 122 || chr == 43) && forward;
    }

    public void sizeChanged(Font FontObj, int dWidth, int dHeight, short LargeInfo, boolean ColoredFlag) {
        this.GameFont = FontObj;
        this.GameImage = DungeonGame.GameImage;
        this.FontHeight = this.GameFont != null ? this.GameFont.getHeight() : 10;
        this.GameImageHeight = this.GameImage.getHeight();
        this.EnergyInfo = LargeInfo;
        switch (this.EnergyInfo) {
            case 1: {
                this.EnergySize.x = 128;
                this.EnergySize.y = 22;
                break;
            }
            case 2: {
                this.EnergySize.x = 64;
                this.EnergySize.y = 11;
                break;
            }
            default: {
                this.EnergySize.x = 32;
                this.EnergySize.y = 5;
            }
        }
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.PlayfieldWidthHalf = this.PlayfieldWidth >> 1;
        this.PlayfieldHeightHalf = this.PlayfieldHeight >> 1;
        this.BeamEffect = new DungeonBeam(256, this.PlayfieldWidth, this.PlayfieldHeight);
        this.BonusImageHeight = DungeonGame.BonusIconImage.getHeight();
        DungeonCube.SetDimension(dWidth, dHeight, ColoredFlag);
    }

    private final class SimplePoint {
        int x = 0;
        int y = 0;

        SimplePoint() {
        }
    }
}

