/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import javax.microedition.lcdui.Graphics;

public final class DungeonPreview {
    private static int Width;
    private static int Height;
    private static int BrushColor;
    private static int DetailColor1;
    private static int DetailColor2;
    private static int cx;
    private static int cy;
    private static int wd;
    private static int hg;
    private static int xl;
    private static int yl;

    public DungeonPreview() {
        BrushColor = 0xFFFFFF;
        DetailColor1 = 0;
        DetailColor2 = 0;
    }

    public static final void SetDimension(int iWidth, int iHeight) {
        Width = iWidth;
        Height = iHeight;
        cx = 32;
        cy = 32;
        wd = (Width + (cx >> 2)) / cx;
        hg = (Height + (cy >> 2)) / cy;
        xl = Width - wd * cx >> 1;
        yl = Height - hg * cy >> 1;
    }

    public static final void Paint(Graphics gfx, char[] Playfield, int PlayerOffset, int PlayerViewDirection) {
        int y2;
        int x2;
        char curchr;
        gfx.setColor(0xFFFFFF);
        gfx.fillRect(0, 0, Width, Height);
        int curoff = 0;
        int yp = 0;
        int rw = 0;
        while (yp < cy) {
            int xp = 0;
            int cl = 0;
            while (xp < cx) {
                curchr = Playfield[curoff];
                if (curchr == 'A' || curchr == 'B' || curchr == '&' || curchr == '%' || curchr == '<' || curchr == '>' || curchr == '!' || curchr == 'T' || curchr == 'D' || curchr == 'd') {
                    x2 = xl + cl;
                    y2 = yl + rw;
                    if (BrushColor <= 0x7F7F7F) {
                        if (BrushColor <= 0x3F3F3F) {
                            gfx.setColor(BrushColor > 0x1F1F1F ? BrushColor << 2 : 0xCFCFCF);
                            gfx.fillRect(x2 + (wd >> 1), y2 + (hg >> 1), wd, hg);
                        }
                        gfx.setColor(BrushColor > 0x4F4F4F ? BrushColor << 1 : 0x7F7F7F);
                        gfx.fillRect(x2 + (wd >> 2), y2 + (hg >> 2), wd, hg);
                    }
                    gfx.setColor(BrushColor);
                    if (DetailColor1 > 0) {
                        gfx.fillRect(x2 + 1, y2 + 1, wd - 1, hg - 1);
                        gfx.setColor(BrushColor + DetailColor1);
                        gfx.drawLine(x2, y2, x2 + wd - 1, y2);
                        gfx.drawLine(x2, y2, x2, y2 + hg - 1);
                        gfx.setColor(BrushColor + DetailColor2);
                        gfx.drawLine(x2, y2, x2 + (wd >> 2), y2);
                        gfx.drawLine(x2, y2, x2, y2 + (hg >> 2));
                        gfx.setColor(BrushColor + DetailColor1);
                        gfx.drawLine(++x2, ++y2, x2 + (wd >> 2), y2);
                        gfx.drawLine(x2, y2, x2, y2 + (hg >> 2));
                    } else {
                        gfx.fillRect(x2, y2, wd, hg);
                    }
                }
                ++xp;
                cl += wd;
                ++curoff;
            }
            ++yp;
            rw += hg;
        }
        curoff = 0;
        for (yp = 0; yp < cy; ++yp) {
            int xp = 0;
            while (xp < cx) {
                int y;
                int x;
                curchr = Playfield[curoff];
                if (curchr == '\u00a7') {
                    x = xl + xp * wd;
                    y = yl + yp * hg;
                    if (BrushColor <= 0x7F7F7F) {
                        gfx.setColor(BrushColor);
                        gfx.fillArc(x, y, wd + 2, hg + 2, 180, 360);
                    }
                    gfx.setColor(BrushColor | 0xFF3F00);
                    gfx.fillArc(x - 1, y - 1, wd + 2, hg + 2, 0, 360);
                    if (BrushColor <= 0x3F3F3F && wd > 3 && hg > 3) {
                        gfx.setColor(BrushColor | 0xFF7F00);
                        gfx.fillArc(x + 1, y + 1, wd - 2, hg - 2, 0, 360);
                    }
                }
                if (curchr == 'z') {
                    x = xl + xp * wd;
                    y = yl + yp * hg;
                    gfx.setColor(BrushColor | 0x3F00FF);
                    gfx.fillRect(x - 1, y - 1, wd + 2, hg + 2);
                    gfx.setColor(0xFFFFFF);
                    gfx.drawLine(x, y, x + wd - 1, y + hg - 1);
                    gfx.drawLine(x, y + hg - 1, x + wd - 1, y);
                }
                if (curoff == PlayerOffset) {
                    x = xl + xp * wd;
                    y = yl + yp * hg;
                    gfx.setColor(BrushColor | 0x7FF00);
                    gfx.fillRect(x - 1, y - 1, wd + 2, hg + 2);
                    gfx.setColor(BrushColor);
                    if (PlayerViewDirection < 0) {
                        if (PlayerViewDirection == -cx) {
                            x2 = wd >> 1;
                            y2 = hg + 1 >> 1;
                            gfx.drawLine(x + x2, y, x + x2, y + hg - 1);
                            gfx.drawLine(x + x2, y, x, y + y2);
                            gfx.drawLine(x + x2, y, x + wd - 1, y + y2);
                        } else {
                            x2 = wd + 1 >> 1;
                            y2 = hg >> 1;
                            gfx.drawLine(x, y + y2, x + wd - 1, y + y2);
                            gfx.drawLine(x, y + y2, x + x2, y);
                            gfx.drawLine(x, y + y2, x + x2, y + hg - 1);
                        }
                    }
                    if (PlayerViewDirection > 0) {
                        if (PlayerViewDirection == cx) {
                            x2 = wd >> 1;
                            y2 = hg + 1 >> 1;
                            gfx.drawLine(x + x2, y, x + x2, y + hg - 1);
                            gfx.drawLine(x + x2, y + hg - 1, x, y + hg - y2 - 1);
                            gfx.drawLine(x + x2, y + hg - 1, x + wd - 1, y + hg - y2 - 1);
                        } else {
                            x2 = wd + 1 >> 1;
                            y2 = hg >> 1;
                            gfx.drawLine(x, y + y2, x + wd - 1, y + y2);
                            gfx.drawLine(x + wd - 1, y + y2, x + wd - x2, y);
                            gfx.drawLine(x + wd - 1, y + y2, x + wd - x2, y + hg - 1);
                        }
                    }
                }
                ++xp;
                ++curoff;
            }
        }
    }

    public static final void DrawSheme(Graphics gfx, char[] Playfield, int ShemeColor) {
        int idx = 0;
        int yp = 0;
        int y2 = yl;
        int ShemeColorBright = (ShemeColor & 0xFF0000) * 3 >> 1 & 0xFF0000 | (ShemeColor & 0xFF00) * 3 >> 1 & 0xFF00 | (ShemeColor & 0xFF) * 3 >> 1 & 0xFF;
        while (yp++ < cy) {
            int xp = 0;
            int x2 = xl;
            while (xp < cx) {
                if (Playfield[idx++] == ' ') {
                    gfx.setColor((idx & 1) == 0 ? ShemeColorBright : ShemeColor);
                    gfx.drawLine(x2, y2, x2, y2);
                }
                ++xp;
                x2 += wd;
            }
            y2 += hg;
        }
    }

    public static final void SetBrushColor(int newcolor) {
        BrushColor = newcolor;
        int bluecomponent = newcolor & 0xFF;
        if (bluecomponent < 128) {
            bluecomponent = 128 - bluecomponent;
            DetailColor2 = (bluecomponent & 0xFFFFFFFE) << 15 | (bluecomponent & 0xFFFFFFFE) << 7 | bluecomponent;
            DetailColor1 = ((bluecomponent >>= 1) & 0xFFFFFFFE) << 15 | (bluecomponent & 0xFFFFFFFE) << 7 | bluecomponent;
        } else {
            DetailColor1 = 0;
            DetailColor2 = 0;
        }
    }
}

