/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonGame;

public final class DungeonTransport
extends DungeonCube {
    int[] ArcAnim = new int[8];

    public DungeonTransport() {
        for (int i = 0; i < this.ArcAnim.length; ++i) {
            this.ArcAnim[i] = 25 * (i + 1);
        }
    }

    void PaintFront(int lftcube, int rgtcube) {
        int archeight;
        int arcwidth;
        for (int i = 0; i < this.ArcAnim.length; ++i) {
            int arcanim = this.ArcAnim[i];
            arcwidth = this.WallWidth * arcanim / 225 & 0xFFFFFFFE;
            archeight = this.WallHeight * arcanim / 225 & 0xFFFFFFFE;
            this.GfxObj.setColor(0xFFFF00 - (arcanim << 8));
            this.GfxObj.drawArc(this.LeftPos + (this.WallWidth - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        }
        this.GfxObj.setColor(16720150);
        arcwidth = this.WallWidth >> 2 & 0xFFFFFFFE;
        archeight = this.WallHeight >> 2 & 0xFFFFFFFE;
        this.GfxObj.fillArc(this.LeftPos + (this.WallWidth - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth | 1, archeight | 1, 0, 360);
        this.GfxObj.setColor(16742678);
        arcwidth = this.WallWidth / 6 & 0xFFFFFFFE;
        archeight = this.WallHeight / 6 & 0xFFFFFFFE;
        this.GfxObj.fillArc(this.LeftPos + (this.WallWidth - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth | 1, archeight | 1, 0, 360);
        this.GfxObj.setColor(16764947);
        arcwidth = this.WallWidth >> 3 & 0xFFFFFFFE;
        archeight = this.WallHeight >> 3 & 0xFFFFFFFE;
        this.GfxObj.fillArc(this.LeftPos + (this.WallWidth - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth | 1, archeight | 1, 0, 360);
        this.GfxObj.setColor(0xFFF116);
        arcwidth = this.WallWidth / 13 & 0xFFFFFFFE;
        archeight = this.WallHeight / 13 & 0xFFFFFFFE;
        this.GfxObj.fillArc(this.LeftPos + (this.WallWidth - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth | 1, archeight | 1, 0, 360);
    }

    void PaintWallLeft() {
        int archeight;
        int arcwidth;
        int lpos = this.LeftPos + this.WallWidth / 6;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + twidth + this.xp * twidth;
        int middle = lpos - rpos;
        lpos -= (rpos - lpos << 1) / 3;
        for (int i = 0; i < this.ArcAnim.length; ++i) {
            int arcanim = this.ArcAnim[i];
            arcwidth = (twidth >> 3) * arcanim / 100;
            archeight = (theight >> 1) * arcanim / 100;
            this.GfxObj.setColor(0xFFFF00 - (arcanim << 8));
            this.GfxObj.drawArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        }
        this.GfxObj.setColor(16720150);
        arcwidth = twidth >> 3;
        archeight = theight >> 2;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        this.GfxObj.setColor(16742678);
        arcwidth = twidth / 12;
        archeight = theight / 6;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        this.GfxObj.setColor(0xFFF116);
        arcwidth = twidth / 20;
        archeight = theight / 10;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
    }

    void PaintWallRight() {
        int archeight;
        int arcwidth;
        int lpos = this.LeftPos + this.WallWidth - this.WallWidth / 6;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + (1 + (this.xp + 1)) * twidth;
        int middle = lpos - rpos;
        lpos -= (rpos - lpos << 1) / 3;
        for (int i = 0; i < this.ArcAnim.length; ++i) {
            int arcanim = this.ArcAnim[i];
            arcwidth = (twidth >> 3) * arcanim / 100;
            archeight = (theight >> 1) * arcanim / 100;
            this.GfxObj.setColor(0xFFFF00 - (arcanim << 8));
            this.GfxObj.drawArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        }
        this.GfxObj.setColor(16720150);
        arcwidth = twidth >> 3;
        archeight = theight >> 2;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        this.GfxObj.setColor(16742678);
        arcwidth = twidth / 12;
        archeight = theight / 6;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
        this.GfxObj.setColor(0xFFF116);
        arcwidth = twidth / 20;
        archeight = theight / 10;
        this.GfxObj.fillArc(rpos + (middle - arcwidth >> 1), this.TopPos + (this.WallHeight - archeight >> 1), arcwidth, archeight, 0, 360);
    }

    void AnimateObj() {
        for (int i = 0; i < this.ArcAnim.length; ++i) {
            int n = i;
            this.ArcAnim[n] = this.ArcAnim[n] + 5;
            if (this.ArcAnim[i] < 225) continue;
            this.ArcAnim[i] = 25;
        }
    }

    public char OpenNextGate(char[] Playfield, int curcubeoffset) {
        char chr;
        Playfield[curcubeoffset] = 37;
        int i = curcubeoffset - 32 - 1;
        if (i < 0) {
            i = 0;
        }
        if ((chr = Playfield[i]) == 'T') {
            Playfield[i] = 35;
        } else {
            i = Playfield.length - curcubeoffset;
            while (i-- > 0) {
                chr = Playfield[curcubeoffset];
                if (chr == 'y') {
                    Playfield[curcubeoffset] = 32;
                    break;
                }
                if (chr == '+') {
                    Playfield[curcubeoffset] = 45;
                    break;
                }
                ++curcubeoffset;
            }
        }
        DungeonGame.PlaySound(44, 1);
        return '%';
    }

    char CloseNextGate(char[] Playfield, int curcubeoffset) {
        Playfield[curcubeoffset] = 38;
        int i = Playfield.length - curcubeoffset;
        while (i-- > 0) {
            if (Playfield[curcubeoffset] == '-') {
                Playfield[curcubeoffset] = 43;
                break;
            }
            ++curcubeoffset;
        }
        DungeonGame.PlaySound(44, 1);
        return '&';
    }
}

