/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public final class SoundPlayer
implements Runnable {
    private static final int TONETYPEMASK = 32;
    private static final int MIDITYPEMASK = 64;
    private static final int WAVETYPEMASK = 128;
    public static final int SOUND_TITLE = 64;
    public static final int SOUND_OVER = 65;
    public static final int SOUND_FINAL = 66;
    public static final int SOUND_DEATH = 131;
    public static final int SOUND_BEAM = 132;
    public static final int SOUND_PHASER = 133;
    public static final int SOUND_REWARD = 134;
    public static final int SOUND_PUSH = 135;
    public static final int SOUND_FEEDBACK = 40;
    public static final int SOUND_DIAMOND = 41;
    public static final int SOUND_GOTIT = 42;
    public static final int SOUND_POINTUP = 43;
    public static final int SOUND_GRAB = 44;
    private Object SyncObject = null;
    private boolean GameDestroyed = false;
    private int PlaySndIdx = -1;
    private int PlayChannel = -1;
    private int[] OldPlayingSndIdx;
    private String AudioPath;
    private Thread WorkerThread = null;
    private boolean WorkerThreadReady = false;
    public static final int MaxPlayerInst = 2;
    private static final byte[] FeedbackTune = new byte[]{-2, 1, -5, 0, 40, 1, 95, 1, 50, 2, -6, 0, -7, 0};
    private static final byte[] DiamondTune = new byte[]{-2, 1, -5, 0, 94, 1, 95, 1, 96, 1, -6, 0, -7, 0};
    private static final byte[] GotItTune = new byte[]{-2, 1, -5, 0, 83, 2, 84, 2, 85, 2, -6, 0, -7, 0};
    private static final byte[] PointsUpTune = new byte[]{-2, 1, -5, 0, 64, 3, 76, 3, 84, 6, -6, 0, -7, 0};
    private static final byte[] GrabTune = new byte[]{-2, 1, -5, 0, 85, 4, 90, 2, 94, 2, 98, 2, 102, 4, -6, 0, -5, 0, 85, 2, 90, 1, 94, 1, 98, 1, 102, 2, -6, 0, -7, 0};
    private static final String[] FileList = new String[]{"zippel.mid", "zealot.mid", "roy.mid", "death.wav", "beam.wav", "phaser.wav", "liveup.wav", "push.wav"};
    private static final byte[][] ToneList = new byte[][]{null, null, null, null, null, null, null, null, FeedbackTune, DiamondTune, GotItTune, PointsUpTune, GrabTune};
    private Player[] SoundPlayer = null;
    private ToneControl[] SoundControl = null;
    private int SoundCurrent = 0;

    public SoundPlayer(String SoundRootPath) {
        this.AudioPath = SoundRootPath;
        this.SoundPlayer = new Player[2];
        this.SoundControl = new ToneControl[2];
        this.OldPlayingSndIdx = new int[2];
        for (int i = 0; i < 2; ++i) {
            this.OldPlayingSndIdx[i] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void StopSound(int SoundChannel) {
        if (this.SyncObject != null) {
            Object object = this.SyncObject;
            synchronized (object) {
                this.PlaySndIdx = -1;
                this.PlayChannel = SoundChannel;
                this.SyncObject.notify();
            }
        }
    }

    public final void SetSound(int SoundIdx, int SoundChannel) {
        this.OldPlayingSndIdx[SoundChannel] = SoundIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void PlaySound(int SoundIdx, int SoundChannel) {
        if (this.SyncObject != null) {
            Object object = this.SyncObject;
            synchronized (object) {
                this.PlaySndIdx = SoundIdx;
                this.PlayChannel = SoundChannel;
                this.SyncObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReplaySound(int SoundChannel) {
        if (this.OldPlayingSndIdx[SoundChannel] != -1 && this.SyncObject != null) {
            Object object = this.SyncObject;
            synchronized (object) {
                this.PlaySndIdx = this.OldPlayingSndIdx[SoundChannel];
                this.PlayChannel = SoundChannel;
                this.SyncObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.SyncObject == null) {
            this.SyncObject = new Object();
        }
        this.WorkerThreadReady = true;
        while (!this.GameDestroyed) {
            try {
                Object object = this.SyncObject;
                synchronized (object) {
                    this.SyncObject.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this.GameDestroyed) break;
            int sndidx = this.PlaySndIdx;
            this.PlayThisSound(sndidx, this.PlayChannel, false);
            if (sndidx == -1 || this.SoundCurrent < 0 || this.SoundCurrent >= this.OldPlayingSndIdx.length) continue;
            this.OldPlayingSndIdx[this.SoundCurrent] = sndidx;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.SoundPlayer[i] != null) {
                this.SoundPlayer[i].deallocate();
                this.SoundPlayer[i].close();
            }
            this.SoundPlayer[i] = null;
            this.SoundControl[i] = null;
        }
        this.SyncObject = null;
    }

    void PlayThisSound(int PlayingSndIdx, int SoundChannel, boolean PrefetchOnly) {
        this.SoundCurrent = SoundChannel;
        if (this.SoundCurrent >= 2) {
            this.SoundCurrent = 0;
        }
        if (PlayingSndIdx == -1) {
            if (this.SoundPlayer[this.SoundCurrent] != null) {
                try {
                    this.SoundPlayer[this.SoundCurrent].stop();
                }
                catch (MediaException emedia) {
                    // empty catch block
                }
                this.SoundPlayer[this.SoundCurrent].deallocate();
                this.SoundPlayer[this.SoundCurrent].close();
            }
            this.SoundPlayer[this.SoundCurrent] = null;
            this.SoundControl[this.SoundCurrent] = null;
            this.SoundCurrent = 0;
            return;
        }
        if ((PlayingSndIdx & 0x20) != 0) {
            this.PlayToneSound(PlayingSndIdx, PrefetchOnly);
        } else if ((PlayingSndIdx & 0x80) != 0) {
            this.PlayWaveSound(PlayingSndIdx, PrefetchOnly);
        } else if ((PlayingSndIdx & 0x40) != 0) {
            this.PlayMidiSound(PlayingSndIdx, PrefetchOnly);
        }
    }

    public boolean Create() {
        this.GameDestroyed = false;
        if (this.WorkerThread == null) {
            this.WorkerThread = new Thread(this);
            this.WorkerThread.start();
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                if (this.WorkerThreadReady) break;
            }
        }
        return this.WorkerThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Destroy() {
        this.GameDestroyed = true;
        if (this.SyncObject != null) {
            Object object = this.SyncObject;
            synchronized (object) {
                this.SyncObject.notify();
                try {
                    Thread.sleep(125L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private final void PlayMidiSound(int PlayingSndIdx, boolean PrefetchOnly) {
        int MidiIdx = PlayingSndIdx & 0xFFFFFFBF;
        try {
            if (PlayingSndIdx != this.OldPlayingSndIdx[this.SoundCurrent] && this.SoundPlayer[this.SoundCurrent] != null) {
                this.SoundPlayer[this.SoundCurrent].stop();
                this.SoundControl[this.SoundCurrent] = null;
                this.SoundPlayer[this.SoundCurrent].deallocate();
                this.SoundPlayer[this.SoundCurrent].close();
                this.SoundPlayer[this.SoundCurrent] = null;
            }
        }
        catch (MediaException emedia) {
            // empty catch block
        }
        if (this.SoundPlayer[this.SoundCurrent] == null) {
            try {
                InputStream IStream = this.getClass().getResourceAsStream(this.AudioPath + FileList[MidiIdx]);
                this.SoundPlayer[this.SoundCurrent] = Manager.createPlayer((InputStream)IStream, (String)"audio/midi");
                this.SoundPlayer[this.SoundCurrent].realize();
            }
            catch (IOException eio) {
            }
            catch (MediaException emedia) {
                // empty catch block
            }
        }
        try {
            if (!PrefetchOnly) {
                this.SoundPlayer[this.SoundCurrent].start();
            }
        }
        catch (MediaException emedia) {
            // empty catch block
        }
    }

    private final void PlayWaveSound(int PlayingSndIdx, boolean PrefetchOnly) {
        int WaveIdx = PlayingSndIdx & 0xFFFFFF7F;
        try {
            if (PlayingSndIdx != this.OldPlayingSndIdx[this.SoundCurrent] && this.SoundPlayer[this.SoundCurrent] != null) {
                this.SoundPlayer[this.SoundCurrent].stop();
                this.SoundControl[this.SoundCurrent] = null;
                this.SoundPlayer[this.SoundCurrent].deallocate();
                this.SoundPlayer[this.SoundCurrent].close();
                this.SoundPlayer[this.SoundCurrent] = null;
            }
        }
        catch (MediaException emedia) {
            // empty catch block
        }
        if (this.SoundPlayer[this.SoundCurrent] == null) {
            try {
                InputStream IStream = this.getClass().getResourceAsStream(this.AudioPath + FileList[WaveIdx]);
                this.SoundPlayer[this.SoundCurrent] = Manager.createPlayer((InputStream)IStream, (String)"audio/x-wav");
                this.SoundPlayer[this.SoundCurrent].realize();
            }
            catch (IOException eio) {
            }
            catch (MediaException emedia) {
                // empty catch block
            }
        }
        try {
            if (!PrefetchOnly) {
                this.SoundPlayer[this.SoundCurrent].start();
            }
        }
        catch (MediaException emedia) {
            // empty catch block
        }
    }

    private final void PlayToneSound(int PlayingSndIdx, boolean PrefetchOnly) {
        try {
            int ToneIdx = PlayingSndIdx & 0xFFFFFFDF;
            if (this.SoundPlayer[this.SoundCurrent] == null || PlayingSndIdx != this.OldPlayingSndIdx[this.SoundCurrent]) {
                if (this.SoundPlayer[this.SoundCurrent] != null && (this.OldPlayingSndIdx[this.SoundCurrent] & 0x20) == 0) {
                    this.SoundPlayer[this.SoundCurrent].stop();
                    this.SoundControl[this.SoundCurrent] = null;
                    this.SoundPlayer[this.SoundCurrent].deallocate();
                    this.SoundPlayer[this.SoundCurrent].close();
                    this.SoundPlayer[this.SoundCurrent] = null;
                }
                if (this.SoundPlayer[this.SoundCurrent] == null) {
                    this.SoundPlayer[this.SoundCurrent] = Manager.createPlayer((String)"device://tone");
                    this.SoundPlayer[this.SoundCurrent].realize();
                    this.SoundControl[this.SoundCurrent] = (ToneControl)this.SoundPlayer[this.SoundCurrent].getControl("javax.microedition.media.control.ToneControl");
                } else {
                    this.SoundPlayer[this.SoundCurrent].deallocate();
                }
                if (this.SoundPlayer[this.SoundCurrent] != null && this.SoundControl[this.SoundCurrent] != null) {
                    this.SoundControl[this.SoundCurrent].setSequence(ToneList[ToneIdx]);
                }
                if (this.SoundControl[this.SoundCurrent] != null && !PrefetchOnly) {
                    this.SoundPlayer[this.SoundCurrent].start();
                }
            } else if (this.SoundControl[this.SoundCurrent] != null && !PrefetchOnly) {
                this.SoundPlayer[this.SoundCurrent].stop();
                this.SoundPlayer[this.SoundCurrent].deallocate();
                this.SoundPlayer[this.SoundCurrent].start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

