/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import java.util.Enumeration;
import java.util.Vector;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Arbiter;
import net.phys2d.raw.ArbiterList;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.BroadCollisionStrategy;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionSpace;
import net.phys2d.raw.Contact;
import net.phys2d.raw.Joint;
import net.phys2d.raw.JointList;
import net.phys2d.raw.forcesource.ForceSource;
import net.phys2d.raw.strategies.BruteCollisionStrategy;

public strictfp class World
extends CollisionSpace {
    private JointList joints = new JointList();
    private Vector2f gravity = new Vector2f(0.0f, 0.0f);
    private int iterations;
    private float damping = 1.0f;
    private boolean restingBodyDetection = false;
    private float hitTolerance;
    private float rotationTolerance;
    private float positionTolerance;
    private Vector sources = new Vector();

    public World(Vector2f gravity, int iterations) {
        this(gravity, iterations, new BruteCollisionStrategy());
    }

    public World(Vector2f gravity, int iterations, BroadCollisionStrategy strategy) {
        super(strategy);
        this.gravity = gravity;
        this.iterations = iterations;
    }

    public void add(ForceSource source) {
        this.sources.addElement(source);
    }

    public void remove(ForceSource source) {
        this.sources.removeElement(source);
    }

    public void enableRestingBodyDetection(float hitTolerance, float rotationTolerance, float positionTolerance) {
        this.hitTolerance = hitTolerance;
        this.rotationTolerance = rotationTolerance;
        this.positionTolerance = positionTolerance;
        this.restingBodyDetection = true;
    }

    public void disableRestingBodyDetection() {
        this.restingBodyDetection = false;
    }

    public void clearRestingState() {
        for (int i = 0; i < this.bodies.size(); ++i) {
            this.bodies.get(i).setIsResting(false);
        }
    }

    public void setDamping(float damping) {
        this.damping = damping;
    }

    public void setGravity(float x, float y) {
        this.gravity.x = x;
        this.gravity.y = y;
    }

    public JointList getJoints() {
        return this.joints;
    }

    public ArbiterList getArbiters() {
        return this.arbiters;
    }

    public void clearArbiters(Body b) {
        for (int i = 0; i < this.arbiters.size(); ++i) {
            if (!this.arbiters.get(i).concerns(b)) continue;
            this.arbiters.remove(this.arbiters.get(i));
            --i;
        }
    }

    public void add(Joint joint) {
        this.joints.add(joint);
    }

    public void remove(Joint joint) {
        this.joints.remove(joint);
    }

    public void clear() {
        super.clear();
        this.joints.clear();
    }

    public void step() {
        this.step(0.016666668f);
    }

    protected BodyList getActiveBodies() {
        return this.bodies;
    }

    protected JointList getActiveJoints() {
        return this.joints;
    }

    public void step(float dt) {
        Joint j;
        Body b;
        int i;
        float invDT;
        for (int i2 = 0; i2 < this.bodies.size(); ++i2) {
            for (int j2 = 0; j2 < this.sources.size(); ++j2) {
                ((ForceSource)this.sources.elementAt(j2)).apply(this.bodies.get(i2), dt);
            }
        }
        BodyList bodies = this.getActiveBodies();
        JointList joints = this.getActiveJoints();
        float f = invDT = dt > 0.0f ? 1.0f / dt : 0.0f;
        if (this.restingBodyDetection) {
            for (i = 0; i < bodies.size(); ++i) {
                b = bodies.get(i);
                b.startFrame();
            }
            for (i = 0; i < joints.size(); ++i) {
                j = joints.get(i);
                j.getBody1().setIsResting(false);
                j.getBody2().setIsResting(false);
            }
        }
        this.broadPhase(dt);
        for (i = 0; i < bodies.size(); ++i) {
            b = bodies.get(i);
            if (b.getInvMass() == 0.0f || b.isResting() && this.restingBodyDetection) continue;
            Vector2f temp = new Vector2f(b.getForce());
            temp.scale(b.getInvMass());
            if (b.getGravityEffected()) {
                temp.add(this.gravity);
            }
            temp.scale(dt);
            b.adjustVelocity(temp);
            Vector2f damping = new Vector2f(b.getVelocity());
            damping.scale(-b.getDamping() * b.getInvMass());
            b.adjustVelocity(damping);
            b.adjustAngularVelocity(dt * b.getInvI() * b.getTorque());
            b.adjustAngularVelocity(-b.getAngularVelocity() * b.getInvI() * b.getRotDamping());
        }
        for (i = 0; i < this.arbiters.size(); ++i) {
            Arbiter arb = this.arbiters.get(i);
            if (this.restingBodyDetection && arb.hasRestingPair()) continue;
            arb.preStep(invDT, dt, this.damping);
        }
        for (i = 0; i < joints.size(); ++i) {
            j = joints.get(i);
            j.preStep(invDT);
        }
        for (i = 0; i < this.iterations; ++i) {
            int k;
            for (k = 0; k < this.arbiters.size(); ++k) {
                Arbiter arb = this.arbiters.get(k);
                if (!this.restingBodyDetection || !arb.hasRestingPair()) {
                    arb.applyImpulse();
                    continue;
                }
                arb.getBody1().collided(arb.getBody2());
                arb.getBody2().collided(arb.getBody1());
            }
            for (k = 0; k < joints.size(); ++k) {
                Joint j3 = joints.get(k);
                j3.applyImpulse();
            }
        }
        for (i = 0; i < bodies.size(); ++i) {
            Body b2 = bodies.get(i);
            if (b2.getInvMass() == 0.0f || this.restingBodyDetection && b2.isResting()) continue;
            b2.adjustPosition(b2.getVelocity(), dt);
            b2.adjustPosition(b2.getBiasedVelocity(), dt);
            b2.adjustRotation(dt * b2.getAngularVelocity());
            b2.adjustRotation(dt * b2.getBiasedAngularVelocity());
            b2.resetBias();
            b2.setForce(0.0f, 0.0f);
            b2.setTorque(0.0f);
        }
        if (this.restingBodyDetection) {
            for (i = 0; i < bodies.size(); ++i) {
                Body b3 = bodies.get(i);
                b3.endFrame();
            }
        }
        this.cleanUpArbiters();
    }

    private void cleanUpArbiters() {
        for (int i = 0; i < this.arbiters.size(); ++i) {
            Arbiter arbiter = this.arbiters.get(i);
            if (arbiter.getBody1().added() && arbiter.getBody2().added()) continue;
            this.arbiters.remove(arbiter);
            --i;
        }
    }

    void broadPhase(float dt) {
        this.collide(dt);
    }

    public CollisionEvent[] getContacts(Body body) {
        Vector<CollisionEvent> collisions = new Vector<CollisionEvent>();
        for (int i = 0; i < this.arbiters.size(); ++i) {
            Arbiter arb = this.arbiters.get(i);
            if (!arb.concerns(body)) continue;
            for (int j = 0; j < arb.getNumContacts(); ++j) {
                Contact contact = arb.getContact(j);
                CollisionEvent event = new CollisionEvent(0.0f, arb.getBody1(), arb.getBody2(), contact.getPosition(), contact.getNormal(), contact.getSeparation());
                collisions.addElement(event);
            }
        }
        CollisionEvent[] t = new CollisionEvent[collisions.size()];
        Enumeration b = collisions.elements();
        int i = 0;
        while (b.hasMoreElements()) {
            t[i] = (CollisionEvent)((Object)b);
            ++i;
        }
        return t;
    }

    public float getTotalEnergy() {
        float total = 0.0f;
        for (int i = 0; i < this.bodies.size(); ++i) {
            total += this.bodies.get(i).getEnergy();
        }
        return total;
    }

    public void add(Body body) {
        body.configureRestingBodyDetection(this.hitTolerance, this.rotationTolerance, this.positionTolerance);
        super.add(body);
    }

    public void remove(Body body) {
        this.clearArbiters(body);
        super.remove(body);
    }
}

