/*
 * Decompiled with CFR 0.152.
 */
package com.appon.car;

import com.appon.car.IngameButtonListener;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IngameButtonEngine {
    private Vector addedButtons = new Vector();
    private Vector addedButtonsSelections = new Vector();
    IngameButtonListener listener;

    public IngameButtonEngine(IngameButtonListener listener) {
        this.listener = listener;
    }

    public Vector getaddedButtonVector() {
        return this.addedButtons;
    }

    public Vector getaddedButtonSelectionVector() {
        return this.addedButtonsSelections;
    }

    public void keyPressed(int keycode, int gamekey) {
        this.listener.buttonkeyPressed(keycode, gamekey);
    }

    public void keyReleased(int keycode, int gamekey) {
        this.listener.buttonkeyReleased(keycode, gamekey);
    }

    public void pointerReleased(int x, int y) {
        IngameButton b;
        int i;
        for (i = 0; i < this.addedButtons.size(); ++i) {
            b = (IngameButton)this.addedButtons.elementAt(i);
            if (!b.isPressed) continue;
            b.isPressed = false;
            this.listener.buttonReleased(b);
        }
        for (i = 0; i < this.addedButtonsSelections.size(); ++i) {
            b = (IngameButton)this.addedButtonsSelections.elementAt(i);
            if (!b.isPressed) continue;
            b.isPressed = false;
            this.listener.buttonReleased(b);
        }
    }

    public void enableButton(String name, boolean status) {
        for (int i = 0; i < this.addedButtons.size(); ++i) {
            IngameButton b = (IngameButton)this.addedButtons.elementAt(i);
            if (!b.getName().equals(name)) continue;
            b.setEnabled(status);
        }
    }

    public void pointerPressed(int x, int y) {
        IngameButton b;
        int i;
        for (i = 0; i < this.addedButtons.size(); ++i) {
            b = (IngameButton)this.addedButtons.elementAt(i);
            if (b.isEnabled() && IngameButtonEngine.isInRect(b.x, b.y, b.width, b.height, x, y)) {
                b.isPressed = true;
                this.listener.buttonPressed(b);
                continue;
            }
            b.isPressed = false;
        }
        for (i = 0; i < this.addedButtonsSelections.size(); ++i) {
            b = (IngameButton)this.addedButtonsSelections.elementAt(i);
            if (b.isEnabled() && IngameButtonEngine.isInRect(b.x, b.y, b.width, b.height, x, y)) {
                b.isPressed = true;
                this.listener.buttonPressed(b);
                continue;
            }
            b.isPressed = false;
        }
    }

    public static boolean isInRect(double xPos, double yPos, double width, double height, double x, double y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public void paint(Graphics g) {
        IngameButton b;
        int i;
        for (i = 0; i < this.addedButtons.size(); ++i) {
            b = (IngameButton)this.addedButtons.elementAt(i);
            g.drawImage(b.img, b.x, b.y, 0);
        }
        for (i = 0; i < this.addedButtonsSelections.size(); ++i) {
            b = (IngameButton)this.addedButtonsSelections.elementAt(i);
            if (!b.isPressed) continue;
            g.drawImage(b.img, b.x, b.y, 0);
        }
    }

    public void removeAll() {
        this.addedButtons.removeAllElements();
        this.addedButtonsSelections.removeAllElements();
    }

    public void addButton(String name, int x, int y, int width, int height, int color, Image img) {
        this.addedButtons.addElement(new IngameButton(name, x, y, width, height, color, img));
    }

    public void addButtonSelection(String name, int x, int y, int width, int height, int color, Image img) {
        this.addedButtonsSelections.addElement(new IngameButton(name, x, y, width, height, color, img));
    }

    class IngameButton {
        private int x;
        private int y;
        private int width;
        private int height;
        private int color;
        boolean isPressed;
        String name;
        boolean enabled = true;
        Image img;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public IngameButton(String name, int x, int y, int width, int height, int color, Image image) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.color = color;
            this.name = name;
            this.img = image;
        }

        public String getName() {
            return this.name;
        }
    }
}

