/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DateFormaterUtil {
    private String format;
    private String dateData;
    private Date dateObj;
    private String origionalData;
    private Vector parsedData = new Vector();
    private static final int STRING_TYPE = 0;
    private static final int INTEGER_TYPE = 1;
    private static final int FIXED_TYPE = 0;
    private static final int VARIABLE_TYPE = 1;
    private static final int DATE_INDEX = 0;
    private static final int HOUR_INDEX = 1;
    private static final int SECOND_INDEX = 2;
    private static final int MONTH_INDEX = 3;
    private static final int ZONE_INDEX = 4;
    private static final int DAY_INDEX = 5;
    private static final int MINUT_INDEX = 6;
    private static final int YEAR_INDEX = 7;
    private static final int PHASE_INDEX = 8;
    private static final String[][] formatRecoznizer = new String[][]{{"dd"}, {"hh"}, {"second", "ss"}, {"mmm", "month", "mm"}, {"zone", "tzd"}, {"sday", "days", "day"}, {"minute"}, {"yyyy", "yy"}, {"am", "pm"}};
    private static final String[] MONTH_SHORT_FORMAT = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final String[] MONTH_FULL_FORMAT = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    private static final String[] DAYS_SHORT_FORM = new String[]{"sun", "mon", "tues", "wed", "thu", "fri", "sat"};
    private static final String[] DAYS_FULL_FORM = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    private static final String[] DAYS_VERY_SHORT_FORM = new String[]{"sn", "m", "t", "w", "th", "f", "s"};
    private int date = -1;
    private int hours = -1;
    private int second = -1;
    private int month = -1;
    private int minutes = -1;
    private int day = -1;
    private String zone;
    private String year;
    private String phase;
    private static DateFormaterUtil instance;

    private DateFormaterUtil() {
    }

    public static synchronized DateFormaterUtil getInstance() {
        if (instance == null) {
            instance = new DateFormaterUtil();
        }
        return instance;
    }

    public String formateDate(String date, String format, String newformat) {
        if (date.trim().length() == 0) {
            return "";
        }
        Date tmpDate = this.formateDate(format, date);
        return this.formateDate(newformat, tmpDate);
    }

    public Date formateDate(String format, String dateFormat) {
        this.dateData = dateFormat.toLowerCase();
        this.format = format.toLowerCase();
        this.origionalData = format;
        this.reset();
        this.parseFormat();
        this.parseDateFormat();
        return this.makeDateObject();
    }

    public String formateDate(String format, Date date) {
        this.dateObj = date;
        this.format = format.toLowerCase();
        this.origionalData = format;
        this.reset();
        this.parseFormat();
        String finalData = "";
        for (int i = 0; i < this.parsedData.size(); ++i) {
            Object object = this.parsedData.elementAt(i);
            String tmpStr = null;
            if (object instanceof Field) {
                tmpStr = this.getDateField(((Field)object).fieldType, ((Field)object).locationIndex, this.dateObj);
                if (this.isCapitalLatter(((Field)object).leftIndex, this.origionalData)) {
                    tmpStr = this.makeCapitalLatter(tmpStr);
                }
            } else {
                tmpStr = object.toString();
            }
            finalData = finalData + tmpStr;
        }
        return finalData;
    }

    private boolean isCapitalLatter(int leftIndex, String str) {
        char ch = str.charAt(leftIndex);
        return ch >= 'A' && ch <= 'Z';
    }

    private String makeCapitalLatter(String str) {
        String secondPart = str.substring(1, str.length());
        String firstPart = str.substring(0, 1).toUpperCase();
        return firstPart + secondPart;
    }

    private boolean isFieldPresent(int fieldType) {
        for (int i = 0; i < this.parsedData.size(); ++i) {
            Object object = this.parsedData.elementAt(i);
            if (!(object instanceof Field) || ((Field)object).fieldType != fieldType) continue;
            return true;
        }
        return false;
    }

    private String getDateField(int fieldType, int internalIndex, Date dateObject) {
        String tmpData = null;
        Calendar calender = Calendar.getInstance();
        Date dateBackup = calender.getTime();
        calender.setTime(this.dateObj);
        int val = 0;
        switch (fieldType) {
            case 0: {
                tmpData = "" + calender.get(5);
                if (tmpData.trim().length() >= 2) break;
                tmpData = "0" + tmpData;
                break;
            }
            case 1: {
                if (this.isFieldPresent(8)) {
                    tmpData = "" + calender.get(10);
                    break;
                }
                tmpData = "" + calender.get(11);
                break;
            }
            case 2: {
                tmpData = "" + calender.get(13);
                break;
            }
            case 6: {
                tmpData = "" + calender.get(12);
                break;
            }
            case 7: {
                tmpData = "" + calender.get(1);
                if (internalIndex != 1) break;
                tmpData = tmpData.substring(2, tmpData.length());
                break;
            }
            case 3: {
                val = calender.get(2);
                tmpData = internalIndex == 0 ? MONTH_SHORT_FORMAT[val] : (internalIndex == 1 ? MONTH_FULL_FORMAT[val] : "" + (val + 1));
                if (tmpData.length() >= 2) break;
                tmpData = "0" + tmpData;
                break;
            }
            case 4: {
                tmpData = calender.getTimeZone().getID();
                break;
            }
            case 8: {
                val = calender.get(9);
                if (val == 0) {
                    tmpData = "AM";
                    break;
                }
                tmpData = "PM";
                break;
            }
            case 5: {
                val = calender.get(7) - 1;
                tmpData = internalIndex == 0 ? DAYS_VERY_SHORT_FORM[val] : (internalIndex == 1 ? DAYS_FULL_FORM[val] : DAYS_SHORT_FORM[val]);
            }
        }
        calender.setTime(dateBackup);
        return tmpData;
    }

    private int getFieldLengthType(int fieldIndex) {
        if (fieldIndex <= 6) {
            return 1;
        }
        return 0;
    }

    private int getFieldDataType(int fieldIndex, int fieldInternalIndex) {
        switch (fieldIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: {
                if (fieldInternalIndex == 2) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    private void setData(int fieldIndex, int fieldInternalIndex, String data) {
        int dataType = this.getFieldDataType(fieldIndex, fieldInternalIndex);
        int convertedData = 0;
        if (dataType == 1) {
            convertedData = Integer.parseInt(data);
        }
        switch (fieldIndex) {
            case 0: {
                this.date = convertedData;
                break;
            }
            case 1: {
                this.hours = convertedData;
                break;
            }
            case 2: {
                this.second = convertedData;
                break;
            }
            case 6: {
                this.minutes = convertedData;
                break;
            }
            case 7: {
                this.year = new String(data);
                break;
            }
            case 3: {
                if (fieldInternalIndex == 2) {
                    this.month = convertedData - 1;
                    break;
                }
                this.month = this.getMonthIndex(data, fieldInternalIndex);
                break;
            }
            case 5: {
                this.day = this.getDayIndex(data, fieldInternalIndex);
                break;
            }
            case 4: {
                this.zone = new String(data);
            }
        }
    }

    private Date makeDateObject() {
        Calendar calender = Calendar.getInstance();
        Date currentDate = calender.getTime();
        if (this.date != -1) {
            calender.set(5, this.date);
        }
        if (this.second != -1) {
            calender.set(13, this.second);
        }
        if (this.month != -1) {
            calender.set(2, this.month);
        }
        if (this.minutes != -1) {
            calender.set(12, this.minutes);
        }
        if (this.year != null) {
            if (this.year.length() == 2) {
                int currentYear = calender.get(1);
                this.year = ("" + currentYear).substring(0, 2) + this.year;
            }
            calender.set(1, Integer.parseInt(this.year));
        }
        if (this.hours != -1) {
            boolean isTwintyFourHourClock = true;
            if (this.zone != null) {
                isTwintyFourHourClock = false;
            }
            if (this.hours > 12) {
                isTwintyFourHourClock = true;
            }
            if (isTwintyFourHourClock) {
                calender.set(11, this.hours);
            } else {
                calender.set(10, this.hours);
            }
        }
        if (this.phase != null) {
            if (this.phase.equals("pm")) {
                calender.set(9, 1);
            } else {
                calender.set(9, 0);
            }
        }
        if (this.zone != null) {
            calender.setTimeZone(TimeZone.getTimeZone(this.zone.toUpperCase()));
        }
        if (this.day != -1) {
            calender.set(7, this.day + 1);
        }
        Date finalObj = calender.getTime();
        calender.setTime(currentDate);
        return finalObj;
    }

    private void parseDateFormat() {
        int leftIndex = 0;
        int traverseCounter = 0;
        while (leftIndex < this.dateData.length() - 1) {
            Object obj;
            if ((obj = this.parsedData.elementAt(traverseCounter++)) instanceof Field) {
                int fieldType = ((Field)obj).getFieldType();
                int fieldInternalIndex = ((Field)obj).getLocationIndex();
                int lengthType = this.getFieldLengthType(fieldType);
                int dataType = this.getFieldDataType(fieldType, fieldInternalIndex);
                String data = null;
                data = lengthType == 0 ? this.dateData.substring(leftIndex, leftIndex + formatRecoznizer[fieldType][fieldInternalIndex].length()) : this.getVariableData(this.dateData, leftIndex, dataType);
                this.setData(fieldType, fieldInternalIndex, data);
                leftIndex += data.length();
                continue;
            }
            leftIndex += obj.toString().length();
        }
    }

    private void parseFormat() {
        this.parsedData.removeAllElements();
        int leftIndex = 0;
        while (leftIndex < this.format.length() - 1) {
            Field fieldFound = this.getField(leftIndex);
            if (fieldFound == null) {
                this.parsedData.addElement(this.format.substring(leftIndex, this.format.length()));
                leftIndex = this.format.length();
                continue;
            }
            if (fieldFound.getLeftIndex() != leftIndex) {
                String delim = this.origionalData.substring(leftIndex, fieldFound.getLeftIndex());
                this.parsedData.addElement(delim);
            }
            this.parsedData.addElement(fieldFound);
            leftIndex = fieldFound.getLeftIndex() + formatRecoznizer[fieldFound.getFieldType()][fieldFound.getLocationIndex()].length();
        }
    }

    private int getMonthIndex(String data, int internalIndex) {
        if (formatRecoznizer[3][internalIndex].equals("mmm")) {
            return this.getIndex(MONTH_SHORT_FORMAT, data);
        }
        return this.getIndex(MONTH_FULL_FORMAT, data);
    }

    private int getDayIndex(String data, int internalIndex) {
        if (formatRecoznizer[5][internalIndex].equals("sdays")) {
            return this.getIndex(DAYS_VERY_SHORT_FORM, data);
        }
        if (formatRecoznizer[5][internalIndex].equals("days")) {
            return this.getIndex(DAYS_FULL_FORM, data);
        }
        return this.getIndex(DAYS_SHORT_FORM, data);
    }

    private int getIndex(String[] array, String item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].toLowerCase().equals(item.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private String getVariableData(String str, int leftIndex, int dataType) {
        StringBuffer buffer = new StringBuffer();
        for (int i = leftIndex; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ((dataType != 1 || !this.isNumber(ch)) && (dataType != 0 || !this.isAlphabate(ch))) break;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isAlphabate(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    private void reset() {
        this.parsedData.removeAllElements();
        this.date = -1;
        this.hours = -1;
        this.second = -1;
        this.month = -1;
        this.minutes = -1;
        this.zone = null;
        this.year = null;
        this.phase = null;
        this.day = -1;
    }

    private Field getField(int leftIndex) {
        int minimumIndex = Integer.MAX_VALUE;
        Field fieldFound = null;
        for (int i = 0; i < formatRecoznizer.length; ++i) {
            for (int j = 0; j < formatRecoznizer[i].length; ++j) {
                int index = -1;
                index = this.format.indexOf(formatRecoznizer[i][j], leftIndex);
                if (index == -1 || index >= minimumIndex) continue;
                fieldFound = new Field(i, index, j);
                minimumIndex = index;
            }
        }
        return fieldFound;
    }

    private class Field {
        int fieldType;
        int leftIndex;
        int locationIndex;

        public Field(int fieldType, int leftIndex, int locationIndex) {
            this.fieldType = fieldType;
            this.leftIndex = leftIndex;
            this.locationIndex = locationIndex;
        }

        int getFieldType() {
            return this.fieldType;
        }

        int getLeftIndex() {
            return this.leftIndex;
        }

        int getLocationIndex() {
            return this.locationIndex;
        }
    }
}

