/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.EffectsSerilize;
import com.appon.effectengine.Point;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class EPolygon
extends EShape {
    private int fillType;
    private int[] xPoints;
    private int[] yPoints;
    private int[] tmpXPoints;
    private int[] tmpYPoints;

    public EPolygon(int id) {
        super(id);
    }

    public EShape clone() {
        EPolygon arc = new EPolygon(-1);
        this.copyProperties(arc);
        arc.setFillType(this.getFillType());
        arc.setXPoints(this.getXPoints());
        arc.setYPoints(this.getYPoints());
        return arc;
    }

    public void setXPoints(int[] xPoints) {
        this.xPoints = xPoints;
    }

    public void setYPoints(int[] yPoints) {
        this.yPoints = yPoints;
    }

    public int[] getYPoints() {
        return this.yPoints;
    }

    public int[] getXPoints() {
        return this.xPoints;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public int[] getTmpXPoints() {
        return this.tmpXPoints;
    }

    public int[] getTmpYPoints() {
        return this.tmpYPoints;
    }

    public void paint(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        if (this.tmpXPoints == null || this.tmpXPoints.length != this.xPoints.length) {
            this.tmpXPoints = new int[this.xPoints.length];
        }
        if (this.tmpYPoints == null || this.tmpYPoints.length != this.yPoints.length) {
            this.tmpYPoints = new int[this.yPoints.length];
        }
        for (int i = 0; i < this.xPoints.length; ++i) {
            Point p = EffectUtil.pointToRotate;
            p.setPoints(this.xPoints[i], this.yPoints[i]);
            EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
            this.tmpXPoints[i] = p.getX() + _x;
            this.tmpYPoints[i] = p.getY() + _y;
        }
        if (this.getFillType() == 1 && this.getBgColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBgColor()));
            EffectUtil.fillPolygon(g, this.tmpXPoints, this.tmpYPoints);
        }
        if (this.getBorderColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBorderColor()));
            EffectUtil.drawPolygon(g, this.tmpXPoints, this.tmpYPoints, this.getBorderThickness());
        }
    }

    public String toString() {
        return "Poly: " + this.getId();
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.fillType = Util.readInt(bis, 1);
        EffectsSerilize.getInstance();
        this.xPoints = (int[])EffectsSerilize.deserialize(bis, null);
        EffectsSerilize.getInstance();
        this.yPoints = (int[])EffectsSerilize.deserialize(bis, null);
        bis.close();
        return null;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeInt(bos, this.fillType, 1);
        EffectsSerilize.getInstance();
        EffectsSerilize.serialize(this.xPoints, bos);
        EffectsSerilize.getInstance();
        EffectsSerilize.serialize(this.yPoints, bos);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public int getClassCode() {
        return 2017;
    }
}

